/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class BildEinstellungenGUI
extends JDialog {
    public static final long serialVersionUID = 1L;
    private LoBeT l;
    private BildEinstellungen e;
    private Debug d = new Debug(true);
    private boolean cancel = false;
    private boolean neu = false;
    private JPanel panel = new JPanel();
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel mainPanel = new JPanel();
    private JPanel bildPanel = new JPanel();
    private JTabbedPane textTab = new JTabbedPane();
    private JPanel seitenPanel = new JPanel();
    private JLabel hintergrundLabel = new JLabel("Hintergrundfarbe: ");
    private JLabel positionLabel = new JLabel("Position:");
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Abbrechen");
    private JButton hgButton = new JButton("Farbe w\u00e4hlen");
    private FarbPunkte hgIcon;
    private JCheckBox bildSeitenBehalten = new JCheckBox("Seitenverh\u00e4ltnis behalten");
    private JRadioButton originalgr = new JRadioButton("Originalgr\u00f6\u00dfe");
    private JRadioButton bildVeraendern = new JRadioButton("Gr\u00f6\u00dfe ver\u00e4ndern");
    private JRadioButton pixel = new JRadioButton("Pixel");
    private JRadioButton screen = new JRadioButton("Bildschirmgr\u00f6\u00dfe");
    private ButtonGroup bild1gr = new ButtonGroup();
    private ButtonGroup bild2gr = new ButtonGroup();
    private JComboBox position = new JComboBox();
    private Color[] Farben = new Color[2];
    private JTextField bildX = new JTextField(4);
    private JTextField bildY = new JTextField(4);

    public BildEinstellungenGUI(LoBeT loBeT, BildEinstellungen bildEinstellungen) {
        super(loBeT, "Bildeinstellungen", true);
        this.l = loBeT;
        this.setDefaultCloseOperation(0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - 200, dimension.height / 2 - 100);
        this.e = bildEinstellungen;
        this.init();
        this.create();
        this.getContentPane().add(this.panel);
        this.setVisible(true);
    }

    private void init() {
        this.Farben[1] = this.e.getBildH();
        this.originalgr.setSelected(this.e.getOriginal());
        this.bildVeraendern.setSelected(!this.e.getOriginal());
        this.pixel.setSelected(!this.e.getScreensize());
        this.screen.setSelected(this.e.getScreensize());
        this.bildSeitenBehalten.setSelected(this.e.getRahmen());
        this.bildX.setText("" + this.e.getPixelX());
        this.bildY.setText("" + this.e.getPixelY());
        this.position.addItem("oben");
        this.position.addItem("links");
        this.position.addItem("mitte");
        this.position.addItem("rechts");
        this.position.addItem("unten");
        this.position.setSelectedIndex(this.e.getPosition());
        this.bild1gr.add(this.bildVeraendern);
        this.bild1gr.add(this.originalgr);
        this.bild2gr.add(this.pixel);
        this.bild2gr.add(this.screen);
        this.hgIcon = new FarbPunkte(this.Farben[1]);
        this.hgButton.setIcon(this.hgIcon);
        this.Check();
    }

    private void create() {
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.mainPanel.setLayout(this.gridbag);
        this.bildPanel.setLayout(this.gridbag);
        this.seitenPanel.setLayout(this.gridbag);
        this.constr(0, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.hintergrundLabel, this.constraints);
        this.bildPanel.add(this.hintergrundLabel);
        this.constr(1, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.hgButton, this.constraints);
        this.bildPanel.add(this.hgButton);
        this.constr(0, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.positionLabel, this.constraints);
        this.bildPanel.add(this.positionLabel);
        this.constr(1, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.position, this.constraints);
        this.bildPanel.add(this.position);
        this.constr(0, 3, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.originalgr, this.constraints);
        this.bildPanel.add(this.originalgr);
        this.constr(0, 4, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.bildVeraendern, this.constraints);
        this.bildPanel.add(this.bildVeraendern);
        this.constr(0, 0, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.pixel, this.constraints);
        this.seitenPanel.add(this.pixel);
        this.constr(0, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.screen, this.constraints);
        this.seitenPanel.add(this.screen);
        this.constr(0, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.bildSeitenBehalten, this.constraints);
        this.seitenPanel.add(this.bildSeitenBehalten);
        this.constr(1, 0, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.bildX, this.constraints);
        this.seitenPanel.add(this.bildX);
        this.constr(2, 0, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.bildY, this.constraints);
        this.seitenPanel.add(this.bildY);
        this.seitenPanel.setBorder(new LineBorder(null, 1));
        this.constr(0, 5, 3, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.seitenPanel, this.constraints);
        this.bildPanel.add(this.seitenPanel);
        this.constr(0, 1, 5, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.bildPanel, this.constraints);
        this.mainPanel.add(this.bildPanel);
        this.constr(2, 2, 1, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.okButton, this.constraints);
        this.mainPanel.add(this.okButton);
        this.constr(4, 2, 1, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.cancelButton, this.constraints);
        this.mainPanel.add(this.cancelButton);
        this.okButton.addActionListener(new BildGUIActionAdapter(this));
        this.okButton.addKeyListener(new BildGUITastenAdapter(this));
        this.okButton.addMouseListener(new BildGUIMouseAdapter(this));
        this.cancelButton.addActionListener(new BildGUIActionAdapter(this));
        this.cancelButton.addKeyListener(new BildGUITastenAdapter(this));
        this.cancelButton.addMouseListener(new BildGUIMouseAdapter(this));
        this.hgButton.addActionListener(new BildGUIActionAdapter(this));
        this.hgButton.addKeyListener(new BildGUITastenAdapter(this));
        this.hgButton.addMouseListener(new BildGUIMouseAdapter(this));
        this.pixel.addMouseListener(new BildGUIMouseAdapter(this));
        this.pixel.addKeyListener(new BildGUITastenAdapter(this));
        this.originalgr.addMouseListener(new BildGUIMouseAdapter(this));
        this.originalgr.addKeyListener(new BildGUITastenAdapter(this));
        this.bildVeraendern.addMouseListener(new BildGUIMouseAdapter(this));
        this.bildVeraendern.addKeyListener(new BildGUITastenAdapter(this));
        this.screen.addMouseListener(new BildGUIMouseAdapter(this));
        this.screen.addKeyListener(new BildGUITastenAdapter(this));
        this.bildSeitenBehalten.addMouseListener(new BildGUIMouseAdapter(this));
        this.bildSeitenBehalten.addKeyListener(new BildGUITastenAdapter(this));
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    private void constr(int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void action(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.OK();
        } else if (object == this.cancelButton) {
            this.cancel = true;
            this.close();
        } else if (object == this.hgButton) {
            this.Farbewaehlen(1);
        }
    }

    private void OK() {
        this.e.setBildH(this.Farben[1]);
        this.e.setOriginal(this.originalgr.isSelected());
        this.e.setScreensize(this.screen.isSelected());
        this.e.setRahmen(this.bildSeitenBehalten.isSelected());
        this.e.setPosition(this.position.getSelectedIndex());
        try {
            this.e.setPixelX(Integer.parseInt(this.bildX.getText()));
            this.e.setPixelY(Integer.parseInt(this.bildY.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Keine g\u00fcltige Pixelgr\u00f6\u00dfe angegeben", "Einstellungsfehler", 0);
        }
        this.close();
    }

    public boolean cancel() {
        return this.cancel;
    }

    public boolean getNew() {
        return this.neu;
    }

    private void Farbewaehlen(int n) {
        Color color;
        if (n >= 0 && n < 8 && null != (color = JColorChooser.showDialog(this.l, "Farbe w\u00e4hlen", this.Farben[n]))) {
            this.Farben[n] = color;
            switch (n) {
                case 1: {
                    this.hgIcon.setFarbe(color);
                }
            }
        }
    }

    public void taste(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getKeyCode();
        Object object = keyEvent.getSource();
        if (n2 != 0) {
            if (n2 == 10) {
                this.OK();
            } else if (n2 == 27) {
                this.close();
            }
        }
    }

    private void Check() {
        if (this.originalgr.isSelected()) {
            this.pixel.setEnabled(false);
            this.screen.setEnabled(false);
            this.bildX.setEnabled(false);
            this.bildY.setEnabled(false);
            this.bildSeitenBehalten.setEnabled(false);
        } else if (this.pixel.isSelected()) {
            this.pixel.setEnabled(true);
            this.screen.setEnabled(true);
            this.bildX.setEnabled(true);
            this.bildY.setEnabled(true);
            this.bildSeitenBehalten.setEnabled(true);
        } else {
            this.pixel.setEnabled(true);
            this.screen.setEnabled(true);
            this.bildX.setEnabled(false);
            this.bildY.setEnabled(false);
            this.bildSeitenBehalten.setEnabled(true);
        }
    }

    public void mouse(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        this.Check();
    }
}

