/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class DiaShow
extends JDialog {
    public static final long serialVersionUID = 1L;
    private LoBeT l;
    private Daten daten;
    private Debug d = new Debug(true);
    private Einstellungen options;
    private BildEinstellungen diaE;
    private File[] dateien;
    private int wo = 0;
    private int max;
    private ImageObserver io;
    private Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    private SchirmBild sb;
    private Bild b;
    private DiaThread diat;
    private boolean pause;
    private boolean weiter;
    private boolean auto;
    private boolean nt;
    private NewstickerDiaThread ntt;
    private boolean schwarz;
    private byte[] mem;
    private boolean neu;
    private Container content;
    private Graphics comp2d;
    private BufferedImage leinwand;
    private BufferedImage bild;
    private BildschirmZeichnen zeichnen;
    private int x;
    private int y;

    private void datenUbertragen() {
        this.options = this.daten.getEinstellungen();
        this.diaE = this.options.getDiaEinstellungen();
    }

    public DiaShow(DiaThread diaThread, LoBeT loBeT, Daten daten, boolean bl, File[] fileArray) {
        super(loBeT, "LoBeT-DiaShow", true);
        this.sb = new SchirmBild(this.screen.width, this.screen.height, this.io);
        this.pause = true;
        this.weiter = true;
        this.auto = true;
        this.nt = true;
        this.schwarz = false;
        this.mem = new byte[5000000];
        this.neu = false;
        this.x = this.screen.width;
        this.y = this.screen.height;
        this.l = loBeT;
        this.daten = daten;
        this.dateien = fileArray;
        this.diat = diaThread;
        diaThread.ich(this);
        diaThread.start();
        this.datenUbertragen();
        this.max = fileArray.length;
        this.d = new Debug(bl);
        this.create();
        this.bild();
        this.setVisible(true);
    }

    public void create() {
        this.addKeyListener(new DiaShowTastenAdapter(this));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension);
        this.setUndecorated(true);
        this.zeichnen = new BildschirmZeichnen(dimension.width, dimension.height, this.l);
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.setResizable(false);
        this.content = this.getContentPane();
        this.content.add(this.zeichnen);
        this.setBackground(new Color(0, 0, 0));
        this.leinwand = new BufferedImage(this.x, this.y, 1);
        Graphics2D graphics2D = this.leinwand.createGraphics();
        graphics2D.setColor(new Color(0, 0, 0));
        graphics2D.fillRect(0, 0, this.x, this.y);
        this.setDefaultCloseOperation(0);
    }

    public void close() {
        this.weiter = false;
        this.pause = false;
        if (null != this.ntt) {
            this.ntt.close();
        }
        if (null != this.diat) {
            this.diat.ende();
        }
        this.zeichnen.close();
        this.leinwand.flush();
        if (null != this.bild) {
            this.bild.flush();
        }
        this.setVisible(false);
        this.dispose();
    }

    public void action(ActionEvent actionEvent) {
    }

    private void OK() {
        this.close();
    }

    public boolean getNew() {
        return this.neu;
    }

    private boolean veraendert() {
        this.neu = true;
        return this.neu;
    }

    private void hoch() {
        if (this.wo > 0) {
            this.pause = true;
            this.auto = false;
            --this.wo;
            this.bild();
        }
    }

    private void runter() {
        if (this.wo + 1 < this.max) {
            this.pause = true;
            this.auto = false;
            ++this.wo;
            this.bild();
        }
    }

    private void anfang() {
        this.pause = true;
        this.auto = false;
        this.wo = 0;
        this.bild();
    }

    private void ende() {
        this.pause = true;
        this.auto = false;
        this.wo = this.max - 1;
        this.bild();
    }

    private void bild() {
        this.d.out("Es geht los...");
        File file = this.dateien[this.wo];
        if (file.exists()) {
            this.d.out("Datei existiert");
            try {
                MediaTracker mediaTracker = new MediaTracker(this);
                BufferedImage bufferedImage = ImageIO.read(file);
                mediaTracker.addImage(bufferedImage, 1);
                try {
                    mediaTracker.waitForID(1);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Fehler w\u00e4hrend des Ladens eines Bildes.");
                    System.err.println("Bild " + file.getName() + " wird \u00fcbersprungen");
                    interruptedException.printStackTrace();
                    this.nextBild();
                }
                if (null != bufferedImage) {
                    this.d.out("Bild tats\u00e4chlich vorhanden");
                    this.sb.delBild();
                    this.sb.setBild(bufferedImage);
                    this.b = new Bild();
                    this.b.setBild(bufferedImage);
                    this.leinwand = new BufferedImage(this.x, this.y, 1);
                    Graphics2D graphics2D = this.leinwand.createGraphics();
                    graphics2D.setColor(this.diaE.getBildH());
                    graphics2D.fillRect(0, 0, this.x, this.y);
                    int n = this.diaE.getPosition();
                    int n2 = this.b.getSize().height;
                    int n3 = this.b.getSize().width;
                    this.d.out("Originalbildgr\u00f6\u00dfe: " + n3 + " " + n2);
                    this.d.out("Bildschirmgr\u00f6\u00dfe: " + this.x + " " + this.y);
                    double d = (double)n3 / (double)n2;
                    double d2 = (double)n2 / (double)n3;
                    this.d.out("Verh\u00e4ltnis yy: " + d);
                    this.d.out("Verh\u00e4ltnis xx: " + d2);
                    int n4 = 0;
                    int n5 = 0;
                    if (this.diaE.getOriginal()) {
                        switch (n) {
                            case 0: {
                                n5 = 0;
                                n4 = (this.x - n3) / 2;
                                break;
                            }
                            case 1: {
                                n4 = 0;
                                n5 = (this.y - n2) / 2;
                                break;
                            }
                            case 2: {
                                n4 = (this.x - n3) / 2;
                                n5 = (this.y - n2) / 2;
                                break;
                            }
                            case 3: {
                                n4 = this.x - n3;
                                n5 = (this.y - n2) / 2;
                                break;
                            }
                            case 4: {
                                n4 = (this.x - n3) / 2;
                                n5 = this.y - n2;
                            }
                        }
                    } else {
                        if (this.diaE.getRahmen()) {
                            this.d.out("Seitenverh\u00e4ltnis beibehalten");
                            if (this.diaE.getScreensize()) {
                                this.d.out("Bildschirmgr\u00f6\u00dfe");
                                if (n2 > n3) {
                                    n2 = this.y;
                                    n3 = (int)((double)this.y / d2);
                                } else {
                                    n3 = this.x;
                                    n2 = (int)((double)this.x / d);
                                }
                                this.d.out("Bildgr\u00f6\u00dfe: " + n3 + " " + n2);
                            } else {
                                this.d.out("Keine Bildschirmgr\u00f6\u00dfe");
                                if (n2 > n3) {
                                    n2 = this.diaE.getPixelY();
                                    n3 = (int)((double)this.diaE.getPixelY() / d2);
                                } else {
                                    n3 = this.diaE.getPixelX();
                                    n2 = (int)((double)this.diaE.getPixelX() / d);
                                }
                                this.d.out("Bildgr\u00f6\u00dfe: " + n3 + " " + n2);
                            }
                        } else {
                            this.d.out("Kein Seitenverh\u00e4ltnis");
                            if (this.diaE.getScreensize()) {
                                this.d.out("Bildschirmgr\u00f6\u00dfe");
                                n2 = this.y;
                                n3 = this.x;
                                this.d.out("Bildgr\u00f6\u00dfe: " + n3 + " " + n2);
                            } else {
                                this.d.out("keine Bildschirmgr\u00f6\u00dfe");
                                n3 = this.diaE.getPixelX();
                                n2 = this.diaE.getPixelY();
                                this.d.out("Bildgr\u00f6\u00dfe: " + n3 + " " + n2);
                            }
                        }
                        switch (n) {
                            case 0: {
                                n5 = 0;
                                n4 = (this.x - n3) / 2;
                                break;
                            }
                            case 1: {
                                n4 = 0;
                                n5 = (this.y - n2) / 2;
                                break;
                            }
                            case 2: {
                                n4 = (this.x - n3) / 2;
                                n5 = (this.y - n2) / 2;
                                break;
                            }
                            case 3: {
                                n4 = this.x - n3;
                                n5 = (this.y - n2) / 2;
                                break;
                            }
                            case 4: {
                                n4 = (this.x - n3) / 2;
                                n5 = this.y - n2;
                            }
                        }
                    }
                    graphics2D.drawImage(bufferedImage, n4, n5, n3, n2, this.zeichnen);
                    if (this.auto) {
                        this.zeichnen.maleBild(this.leinwand);
                        this.schwarz = false;
                    }
                } else {
                    this.d.out("Bild ist null!");
                    this.nextBild();
                }
            }
            catch (IOException iOException) {
                System.err.println("IO-Exception\nEs trat ein Fehler w\u00e4hrend des Schreibens der Datei (" + file.getAbsolutePath() + ") auf.");
                iOException.printStackTrace();
                int n = JOptionPane.showConfirmDialog(this, "W\u00e4hrend des Schreibens der Datei\n" + file.getAbsolutePath() + "\n trat ein Fehler auf.", "Fehler beim Schreiben der Datei:", -1, 0, null);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.mem = null;
                System.gc();
                System.err.println("java.lang.OutOfMemoryError...");
                System.err.println("... abgefangen ...");
                System.err.println("Diashow wird abgebrochen ...");
                JOptionPane.showMessageDialog(this, "Das Programm hat zuwenig Speicher. \nDie Diashow wird abgebrochen!", "Out of Memory - Error", 0);
                this.close();
            }
            this.repaint();
        } else {
            this.d.out("Bild existiert nicht!");
        }
        this.pause = false;
        this.diat.pausenklingel();
    }

    public void nextBild() {
        this.pause = true;
        if (this.auto) {
            this.d.out("Dia: next Bild");
            if (this.wo + 1 < this.max) {
                ++this.wo;
                this.bild();
            } else if (this.options.getEndlos()) {
                this.wo = 0;
                this.bild();
            } else {
                this.close();
            }
        }
    }

    public void taste(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getKeyCode();
        Object object = keyEvent.getSource();
        if (n2 != 0) {
            if (n2 == 10) {
                this.auto = true;
                this.nextBild();
            } else if (n2 == 27) {
                this.close();
            } else if (n2 == 40) {
                this.runter();
            } else if (n2 == 38) {
                this.hoch();
            } else if (n2 == 37) {
                this.hoch();
            } else if (n2 == 39) {
                this.runter();
            } else if (n2 == 32) {
                if (this.schwarz) {
                    this.zeichnen.maleBild(this.leinwand);
                    this.schwarz = false;
                    this.pause = false;
                } else {
                    this.zeichnen.setSchwarz();
                    this.schwarz = true;
                    this.pause = true;
                    this.auto = false;
                }
                this.repaint();
            } else if (n2 == 36) {
                this.anfang();
            } else if (n2 != 127) {
                if (n2 == 33) {
                    this.hoch();
                } else if (n2 == 34) {
                    this.runter();
                } else if (n2 == 35) {
                    this.ende();
                } else if (n2 == 120) {
                    this.d.out("F9");
                    if (this.nt) {
                        this.ntt = new NewstickerDiaThread(this.l, this, this.daten, 0, true);
                        this.nt = false;
                        this.ntt.start();
                    } else {
                        this.nt = true;
                        this.ntt.close();
                    }
                } else if (n2 == 122) {
                    this.d.out("F11");
                    if (this.nt) {
                        this.ntt = new NewstickerDiaThread(this.l, this, this.daten, 1, true);
                        this.nt = false;
                        this.ntt.start();
                    } else {
                        this.nt = true;
                        this.ntt.close();
                    }
                } else if (n2 == 123) {
                    this.d.out("F12");
                    if (this.nt) {
                        this.ntt = new NewstickerDiaThread(this.l, this, this.daten, 2, false);
                        this.nt = false;
                        this.ntt.start();
                    } else {
                        this.nt = true;
                        this.ntt.close();
                    }
                }
            }
        }
    }

    public boolean weiter() {
        return this.weiter;
    }

    public boolean pause() {
        return this.pause;
    }

    public void NewstickerEnde(boolean bl) {
        this.nt = bl;
        this.ntt = null;
    }

    public boolean NewstickerLauf() {
        return this.nt;
    }

    public void schwarzBlenden() {
        this.d.out("Schwarzblenden");
        if (!this.schwarz) {
            this.d.out("Ja, Schwarz");
            this.zeichnen.setSchwarz();
            this.schwarz = true;
            this.pause = true;
            this.auto = false;
            this.repaint();
        }
    }
}

