/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class HTML {
    private Debug d = new Debug(false);
    private boolean debug = false;
    private Daten daten;
    private ProgressBarNeu pbn;
    private File file;
    private String titel = "Liederliste";
    private final String VERSION = Start.showVersion();
    private final String[] buchstaben = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "z", "zz"};
    private String path;
    private String name;
    private Lied lied;
    private Vector liedVector;
    public static final int LIED = 0;
    private static final int maxSchirm = 5;
    private static final int maxZeile = 24;
    private int liedNr = 0;
    private FileOutputStream fos;
    private ObjectOutputStream oos;
    private FileInputStream fis;
    private ObjectInputStream ois;
    private BufferedWriter bw;
    private int[] statInt;
    private String[] statString;
    private int[] org;
    private long[] statLong;
    private int liedVectorSize;
    private String style = "style.css";
    private boolean styles = true;
    private boolean kommies = true;
    private long jetzt;
    private long wann;
    private boolean abWann = false;
    private String wannText = "";
    private boolean aufsteigend = true;
    String dateiInhalt = "";

    public HTML(Daten daten, ProgressBarNeu progressBarNeu, File file, boolean bl) throws IOException {
        this.d = new Debug(bl);
        this.daten = daten;
        this.style = daten.getEinstellungen().getStyle();
        this.styles = daten.getEinstellungen().getIfStyle();
        this.kommies = daten.getEinstellungen().getKommentare();
        this.pbn = progressBarNeu;
        this.file = file;
        this.debug = bl;
        this.jetzt = System.currentTimeMillis();
        this.abWann = daten.getEinstellungen().getEndStats();
        long l = daten.getEinstellungen().getEndStatsInt();
        switch (daten.getEinstellungen().getEndStatsTyp()) {
            case 0: {
                this.wann = this.jetzt - (l + 1L) * 1000L * 60L * 60L * 24L;
                this.wannText = "Die Statistik der letzten " + (l + 1L) + " Tage";
                if (l != 0L) break;
                this.wannText = "Die Statistik des letzten Tages";
                break;
            }
            case 1: {
                this.wann = this.jetzt - (l + 1L) * 1000L * 60L * 60L * 24L * 7L;
                this.wannText = "Die Statistik der letzten " + (l + 1L) + " Wochen";
                if (l != 0L) break;
                this.wannText = "Die Statistik der letzten Woche";
                break;
            }
            case 2: {
                this.wann = this.jetzt - (l + 1L) * 1000L * 60L * 60L * 24L * 30L;
                this.wannText = "Die Statistik der letzten " + (l + 1L) + " Monate";
                if (l != 0L) break;
                this.wannText = "Die Statistik des letzten Monats";
                break;
            }
            default: {
                this.wann = this.jetzt;
                this.wannText = "";
            }
        }
        this.liste();
        this.aufsteigend = daten.getEinstellungen().getAufsteigend();
        this.path = file.getPath();
        this.name = file.getName();
        this.pfadFinden();
        this.lieder();
        this.statistiken();
    }

    private void liste() throws IOException {
        this.liedVector = this.daten.getVector(0);
        this.liedVectorSize = this.liedVector.size();
        this.pbn.setMax(4 * this.liedVectorSize + 1);
        this.pbn.progress(0, "HTML Liste generieren");
        this.pbn.setIndeterminate(false);
        this.d.out("Datei (" + this.file.getName() + ") \u00f6ffnen");
        FileWriter fileWriter = new FileWriter(this.file);
        this.bw = new BufferedWriter(fileWriter);
        this.d.out("Lieder schreiben");
        this.vorspann(this.titel);
        this.bw.write("  <div class=\"Menu\">");
        this.bw.newLine();
        this.bw.write("   <P>");
        this.bw.newLine();
        this.bw.write("    <A href=\"#A\">A</A> <A href=\"#B\">B</A> <A href=\"#C\">C</A> <A href=\"#D\">D</A> <A href=\"#E\">E</A> <A href=\"#F\">F</A> <A href=\"#G\">G</A> <A href=\"#H\">H</A> <A href=\"#I\">I</A> <A href=\"#J\">J</A> <A href=\"#K\">K</A> <A href=\"#L\">L</A> <A href=\"#M\">M</A> <A href=\"#N\">N</A> <A href=\"#O\">O</A> <A href=\"#P\">P</A> <A href=\"#Q\">Q</A> <A href=\"#R\">R</A> <A href=\"#S\">S</A> <A href=\"#T\">T</A> <A href=\"#U\">U</A> <A href=\"#V\">V</A> <A href=\"#W\">W</A> <A href=\"#X\">X</A> <A href=\"#Y\">Y</A> <A href=\"#Z\">Z</A>");
        this.bw.newLine();
        this.bw.write("   </P>");
        this.bw.newLine();
        this.bw.write("   <P>");
        this.bw.newLine();
        this.bw.write("    <A href=\"Statistiken.html\">Statistiken</A>");
        this.bw.newLine();
        this.bw.write("   </P>");
        this.bw.newLine();
        this.bw.write("  </div><hr>");
        this.bw.newLine();
        this.bw.write("  <div class=\"Listen\">");
        this.bw.newLine();
        this.liederListen();
        this.bw.write("  </div>");
        this.bw.newLine();
        this.abspann();
        this.bw.flush();
        fileWriter.close();
    }

    private void liederListen() throws IOException {
        int n = 0;
        this.liedVector = this.daten.getVector(0);
        for (int i = 0; i < 26; ++i) {
            boolean bl;
            String string;
            this.bw.write("<A name=\"" + this.buchstaben[i] + "\"><H2>" + this.buchstaben[i] + "</H2></A>");
            this.bw.newLine();
            this.bw.write("<ul>");
            this.bw.newLine();
            this.lied = this.daten.getLied(n);
            int n2 = 0;
            if (this.lied.getKopie()) {
                string = this.lied.getOriginal();
                bl = false;
                while (!bl && n2 < this.liedVectorSize) {
                    if (string.equals(this.daten.getLied(n2).getTitel())) {
                        bl = true;
                        continue;
                    }
                    ++n2;
                }
                this.lied = this.daten.getLied(n);
            }
            if (null != this.lied) {
                while (this.lied.getTitel().compareTo(this.buchstaben[i + 1]) <= 0 && n < this.liedVectorSize) {
                    this.pbn.progress();
                    if (this.lied.getKopie()) {
                        this.bw.write("<LI><A href=" + n + ".html>" + this.lied.getTitel() + "</A> <A href=\"" + n2 + ".html\">(Original:  " + this.lied.getOriginal() + ")</A></LI>");
                    } else {
                        this.bw.write("<LI><A href=" + n + ".html>" + this.lied.getTitel() + "</A></LI>");
                    }
                    this.bw.newLine();
                    if (++n >= this.liedVector.size()) continue;
                    this.lied = this.daten.getLied(n);
                    n2 = 0;
                    if (!this.lied.getKopie()) continue;
                    string = this.lied.getOriginal();
                    bl = false;
                    while (!bl && n2 < this.liedVectorSize) {
                        if (string.equals(this.daten.getLied(n2).getTitel())) {
                            bl = true;
                            continue;
                        }
                        ++n2;
                    }
                    this.lied = this.daten.getLied(n);
                }
                this.bw.write("<br><A href=\"#Anfang\">Seitenanfang</A>");
                this.bw.newLine();
            }
            this.bw.write("</ul>");
            this.bw.newLine();
        }
    }

    private void lieder() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.pbn.progress("Lieder generieren");
        this.pbn.setIndeterminate(false);
        this.d.out("Lieder schreiben");
        for (int i = 0; i < this.liedVectorSize; ++i) {
            this.pbn.progress();
            File file = new File(this.path + i + ".html");
            this.d.out("Datei (" + file.getName() + ") schreiben");
            FileWriter fileWriter = new FileWriter(file);
            this.bw = new BufferedWriter(fileWriter);
            this.lied = this.daten.getLied(i);
            int n = 0;
            if (this.lied.getKopie()) {
                String string = this.lied.getOriginal();
                boolean bl4 = false;
                while (!bl4 && n < this.liedVectorSize) {
                    if (string.equals(this.daten.getLied(n).getTitel())) {
                        bl4 = true;
                        continue;
                    }
                    ++n;
                }
                this.lied = this.daten.getLied(i);
            }
            if (null != this.lied) {
                this.vorspann(this.lied.getTitel());
                this.bw.write("<div class=\"inhalt\">");
                this.bw.newLine();
                if (i > 0) {
                    this.bw.write(" <A href=\"" + (i - 1) + ".html\">&lt;</A> ");
                    this.bw.newLine();
                }
                this.bw.write(" <A href=\"" + this.name + "\">Inhaltsverzeichnis</A>");
                this.bw.newLine();
                if (i < this.liedVectorSize - 1) {
                    this.bw.write(" <A href=\"" + (i + 1) + ".html\">&gt;</A>");
                    this.bw.newLine();
                }
                this.bw.write("</div>");
                this.bw.newLine();
                this.bw.write("<hr>");
                this.bw.newLine();
                if (this.lied.getKopie()) {
                    this.bw.write("<P class=\"original\">Original: <A href=\"" + n + ".html\">" + this.lied.getOriginal() + "</A></P>");
                    this.bw.newLine();
                }
                this.bw.write("<div class=\"content\">");
                this.bw.write("<div class=\"lieder\">");
                this.bw.newLine();
                this.lied.setAuswahl();
                Strophe strophe = this.lied.getStrophe();
                bl2 = false;
                bl3 = false;
                for (int j = 1; j <= this.lied.getMaxStrophen(); ++j) {
                    int n2;
                    this.bw.write("<P class=\"textseite\">");
                    this.bw.newLine();
                    int n3 = 0;
                    if (strophe.getRefrain()) {
                        if (bl2) {
                            this.bw.write("<div class=\"refrainText\">");
                        } else {
                            this.bw.write("<div class=\"refrainText\"><div class=\"refrain\">Refrain:</div><br>");
                        }
                        ++n3;
                        bl2 = true;
                        this.bw.newLine();
                    }
                    if (strophe.getAnfang()) {
                        this.bw.write("<div class=\"stropheText\"><div class=\"strophe\">Strophe:</div><br>");
                        ++n3;
                        this.bw.newLine();
                    }
                    if (strophe.getBridge()) {
                        if (bl3) {
                            this.bw.write("<div class=\"bridgeText\">");
                        } else {
                            this.bw.write("<div class=\"bridgeText\"><div class=\"bridge\">Br\u00fccke:</div><br>");
                        }
                        ++n3;
                        this.bw.newLine();
                        bl3 = true;
                    }
                    for (n2 = 0; n2 < 24; ++n2) {
                        if (strophe.get(n2).equals("") || strophe.get(n2).equals(" ")) continue;
                        if (strophe.get(n2).charAt(0) == '#') {
                            this.bw.write("<span class=\"translation\">" + strophe.get(n2).substring(1) + "</span><br>");
                        } else {
                            this.bw.write(" " + strophe.get(n2) + "<br>");
                        }
                        this.bw.newLine();
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.bw.write("</div>");
                    }
                    strophe = this.lied.getNextStrophe();
                    this.bw.newLine();
                }
                this.bw.write("</div>");
                this.bw.write("<div class=\"rechte\"><P class=\"rechte\">");
                Kommentar kommentar = this.lied.getKommentar();
                bl = false;
                if (!kommentar.getTexter().getName().equals("") || !kommentar.getTexter().getVorname().equals("")) {
                    this.bw.write("Text: " + kommentar.getTexter().getVorname() + " " + kommentar.getTexter().getName());
                    this.bw.newLine();
                    this.bw.write("<br>");
                    this.bw.newLine();
                    bl = true;
                }
                if (!kommentar.getLiedmacher().getName().equals("") || !kommentar.getLiedmacher().getVorname().equals("")) {
                    this.bw.write("Melodie: " + kommentar.getLiedmacher().getVorname() + " " + kommentar.getLiedmacher().getName());
                    this.bw.newLine();
                    this.bw.write("<br>");
                    this.bw.newLine();
                    bl = true;
                }
                if (!kommentar.getTranslater().getName().equals("") || !kommentar.getTranslater().getVorname().equals("")) {
                    this.bw.write("\u00dcbersetzung: " + kommentar.getTranslater().getVorname() + " " + kommentar.getTranslater().getName());
                    this.bw.newLine();
                    this.bw.write("<br>");
                    this.bw.newLine();
                    bl = true;
                }
                if (kommentar.getJahr() != 0) {
                    this.bw.write("Copyright: " + kommentar.getJahr());
                    this.bw.newLine();
                    this.bw.write("<br>");
                    this.bw.newLine();
                    bl = true;
                }
                if (!kommentar.getVerlag().equals("")) {
                    this.bw.write("Verlag: " + kommentar.getVerlag());
                    this.bw.newLine();
                    this.bw.write("<br>");
                    this.bw.newLine();
                    bl = true;
                }
                if (this.kommies && !kommentar.getSonstiges().equals("")) {
                    if (bl) {
                        this.bw.write("<br>");
                    }
                    this.bw.write("Kommentar: " + kommentar.getSonstiges());
                    this.bw.newLine();
                    this.bw.write("<br>");
                    this.bw.newLine();
                    bl = true;
                }
                if (bl) {
                    this.bw.write("<br>");
                }
                this.bw.newLine();
                this.bw.write("</P></div></div>");
                this.abspann();
            }
            this.bw.flush();
            fileWriter.close();
        }
    }

    private void vorspann(String string) throws IOException {
        this.bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"   \"http://www.w3.org/TR/html4/strict.dtd\">");
        this.bw.newLine();
        this.bw.write("<HTML lang=\"de\">");
        this.bw.newLine();
        this.bw.write(" <HEAD>");
        this.bw.newLine();
        this.bw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-15\">");
        this.bw.newLine();
        this.bw.write("  <TITLE>" + string + "</TITLE>");
        this.bw.newLine();
        if (this.styles) {
            this.bw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.style + "\">");
            this.bw.newLine();
        }
        this.bw.write(" </HEAD>");
        this.bw.newLine();
        this.bw.write(" <BODY>");
        this.bw.newLine();
        this.bw.write("  <div class=\"Titel\">");
        this.bw.newLine();
        this.bw.write("   <H1><A name=\"Anfang\">" + string + "</A></H1>");
        this.bw.newLine();
        this.bw.write("  </div>");
        this.bw.newLine();
    }

    private void abspann() throws IOException {
        this.bw.write("  <div class=\"LoBeT\">");
        this.bw.newLine();
        this.bw.write("   <HR><P>Diese Seiten wurden erstellt mit dem <A href=\"http://www.sebamueller.de/LoBeT.html\">Lobpreis Beamer Texter</A> in der " + this.VERSION + "</P>");
        this.bw.newLine();
        this.bw.write("  </div>");
        this.bw.newLine();
        this.bw.write(" </BODY>");
        this.bw.newLine();
        this.bw.write("</HTML>");
        this.bw.newLine();
    }

    private void pfadFinden() {
        int n = this.path.lastIndexOf(File.separator);
        if (-1 != n) {
            this.path = this.path.substring(0, n) + File.separator;
        }
        this.d.out("Pfad: " + this.path);
    }

    private void statistiken() throws IOException {
        int n;
        this.statInt = new int[this.liedVector.size()];
        this.statString = new String[this.liedVector.size()];
        this.org = new int[this.liedVectorSize];
        this.statLong = new long[this.liedVector.size()];
        this.pbn.progress("Statistiken generieren");
        this.pbn.setIndeterminate(false);
        this.d.out("Statistiken schreiben");
        File file = new File(this.path + "Statistiken.html");
        this.d.out("Datei (" + file.getName() + ") schreiben");
        FileWriter fileWriter = new FileWriter(file);
        this.bw = new BufferedWriter(fileWriter);
        this.vorspann("Statistiken");
        this.bw.write("  <div class=\"inhalt\"><A href=\"" + this.name + "\">Inhaltsverzeichnis</A></div>");
        this.bw.newLine();
        this.bw.write("  <hr>");
        this.bw.newLine();
        this.bw.write("  <div class=\"statistik\">");
        this.bw.newLine();
        if (this.abWann) {
            this.bw.write("  <P>" + this.wannText + "</P>");
            this.bw.newLine();
        }
        for (n = 0; n < this.liedVectorSize; ++n) {
            this.statInt[n] = -1;
            this.statString[n] = "";
            this.org[n] = -1;
            this.statLong[n] = 0L;
        }
        int n2 = 0;
        this.d.out("liedVectorSize: " + this.liedVectorSize);
        for (n = 0; n < this.liedVectorSize; ++n) {
            int n3;
            this.pbn.progress();
            this.lied = this.daten.getLied(n);
            if (null == this.lied || this.lied.getKopie()) continue;
            int n4 = this.lied.getStatistiken();
            this.d.out("" + this.lied.getTimeStatistiken());
            if (this.aufsteigend) {
                for (n3 = 0; n3 < this.liedVectorSize && this.statInt[n3] <= n4 && this.statInt[n3] != -1; ++n3) {
                }
            } else {
                while (n3 < this.liedVectorSize && this.statInt[n3] >= n4 && this.statInt[n3] != -1) {
                    ++n3;
                }
            }
            if (n3 >= this.liedVectorSize) {
                n3 = this.liedVectorSize - 1;
            }
            if (this.statInt[n3] != -1) {
                this.verschieben(n3);
            }
            this.statInt[n3] = n4;
            this.statString[n3] = this.lied.getTitel();
            this.statLong[n3] = this.lied.getTimeStatistiken();
            this.org[n3] = n;
            if (n2 >= n4) continue;
            n2 = n4;
        }
        this.bw.write("   <table>");
        this.bw.newLine();
        this.d.out("Jetzt: " + this.jetzt);
        this.d.out("Wann:  " + this.wann);
        for (n = 0; n < this.liedVectorSize && this.statInt[n] != -1; ++n) {
            this.pbn.progress();
            if (this.abWann && (!this.abWann || this.statLong[n] <= this.wann)) continue;
            this.bw.write("    <tr>");
            this.bw.newLine();
            this.bw.write("     <td>" + this.statInt[n] + "</td><td><A href=\"" + this.org[n] + ".html\">" + this.statString[n] + "</A></td>");
            this.bw.newLine();
            this.bw.write("    </tr>");
            this.bw.newLine();
        }
        this.bw.write("   </table>");
        this.bw.newLine();
        this.bw.write("  </div>");
        this.bw.newLine();
        this.abspann();
        this.bw.flush();
        fileWriter.close();
    }

    private void verschieben(int n) {
        for (int i = this.liedVectorSize - 2; i >= n; --i) {
            this.statInt[i + 1] = this.statInt[i];
            this.statString[i + 1] = this.statString[i];
            this.org[i + 1] = this.org[i];
            this.statLong[i + 1] = this.statLong[i];
        }
    }
}

