/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PrinterGUI
extends JInternalFrame {
    public static final long serialVersionUID = 1L;
    public static final int LIED = 1;
    public static final int TEXT = 2;
    public static final int LIEDLISTE = 3;
    public static final int TEXTLISTE = 4;
    public static final int AKTLISTE = 5;
    public static final int ABLAUFPLAN = 6;
    final String sCrLf = System.getProperty("line.separator");
    final String sPrintFile = "PrintFile.ps";
    final String sErrNoPrintService = this.sCrLf + "Es ist kein passender Print-Service installiert.";
    private String titel = "";
    String s2ndParm = null;
    DocFlavor flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
    PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
    PrintService prservDflt = PrintServiceLookup.lookupDefaultPrintService();
    PrintService[] prservices = PrintServiceLookup.lookupPrintServices(this.flavor, this.aset);
    PrintService prserv = null;
    private Debug d = new Debug(false);
    private boolean debug = false;
    private JPanel mainPanel = new JPanel();
    private JPanel wasPanel = new JPanel();
    private JPanel druckPanel = new JPanel();
    private EmptyBorder border5 = new EmptyBorder(5, 5, 5, 5);
    private GridBagConstraints constraints;
    private GridBagLayout gridbag;
    private JLabel titelLabel = new JLabel("Drucken");
    private JLabel uSchriftLabel = new JLabel("\u00dcberschrift");
    private JLabel nSchriftLabel = new JLabel("normal");
    private JLabel sSizeLabel = new JLabel("Schriftgr\u00f6\u00dfe: ");
    private JLabel sArtLabel = new JLabel("Schriftart: ");
    private JLabel leerLabel = new JLabel("  ");
    private JButton okButton = new JButton("Drucken");
    private JButton cancelButton = new JButton("Abbrechen");
    private JButton aktuellButton = new JButton("Aktuell-Liste hinzuf\u00fcgen");
    private JButton helpButton = new JButton();
    private JButton pageButton = new JButton();
    private JButton prevButton = new JButton();
    private JComboBox uFontSize = new JComboBox();
    private JComboBox normalFontSize = new JComboBox();
    private JComboBox uFontArt = new JComboBox();
    private JComboBox normalFontArt = new JComboBox();
    private Daten daten;
    private LoBeT lobet;
    private Einstellungen einstellungen;
    private int typ;

    public PrinterGUI(LoBeT loBeT, Daten daten, boolean bl) {
        this.d = new Debug(bl);
        this.debug = bl;
        this.setTitle("Drucken");
        this.daten = daten;
        this.einstellungen = daten.getEinstellungen();
        this.lobet = loBeT;
        int n = daten.getEinstellungen().getSeitenFontSize();
        this.setBounds(0, 0, 480, 400);
        this.initGUI();
        this.init();
        this.create();
        this.setResizable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setClosable(true);
        this.setVisible(true);
    }

    public void init() {
        this.einstellungen = this.daten.getEinstellungen();
        switch (this.typ) {
            case 6: {
                this.titelLabel.setText("Ablauf drucken");
                break;
            }
            case 1: {
                this.titelLabel.setText("Lied drucken");
                break;
            }
            default: {
                this.titelLabel.setText("Etwas drucken");
            }
        }
        PrintSetupValues printSetupValues = this.einstellungen.getPrintSetupValues();
        this.uFontSize.setSelectedIndex(printSetupValues.getUeberschriftFontSize() - 1);
        this.normalFontSize.setSelectedIndex(printSetupValues.getNormalFontSize() - 1);
        this.uFontArt.setSelectedIndex(printSetupValues.getUeberschriftFontArt());
        this.normalFontArt.setSelectedIndex(printSetupValues.getNormalFontArt());
    }

    public void initGUI() {
        int n;
        this.okButton.addActionListener(new PrinterGUIActionAdapter(this));
        this.cancelButton.addActionListener(new PrinterGUIActionAdapter(this));
        this.helpButton.addActionListener(new PrinterGUIActionAdapter(this));
        this.prevButton.addActionListener(new PrinterGUIActionAdapter(this));
        this.pageButton.addActionListener(new PrinterGUIActionAdapter(this));
        for (n = 1; n < 151; ++n) {
            this.uFontSize.addItem("" + n);
            this.normalFontSize.addItem("" + n);
        }
        this.uFontSize.setSelectedIndex(13);
        this.normalFontSize.setSelectedIndex(11);
        TextEinstellungen textEinstellungen = this.einstellungen.getTextEinstellungen();
        for (n = 0; n < 6; ++n) {
            this.uFontArt.addItem(TextEinstellungen.fontNamen[n]);
            this.normalFontArt.addItem(TextEinstellungen.fontNamen[n]);
        }
        this.uFontArt.setSelectedIndex(4);
        this.normalFontArt.setSelectedIndex(4);
        this.setIcons(this.einstellungen.getIcons());
        this.setToolTips(this.einstellungen.getToolTips());
        this.RadioButtonsInit();
        this.aset.add(MediaSizeName.ISO_A4);
    }

    public void create() {
        this.setDefaultCloseOperation(1);
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.mainPanel.setLayout(this.gridbag);
        this.wasPanel.setLayout(this.gridbag);
        this.druckPanel.setLayout(this.gridbag);
        this.constr(0, 0, 2, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.titelLabel, this.constraints);
        this.wasPanel.add(this.titelLabel);
        this.constr(1, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.uSchriftLabel, this.constraints);
        this.wasPanel.add(this.uSchriftLabel);
        this.constr(2, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.leerLabel, this.constraints);
        this.wasPanel.add(this.leerLabel);
        this.constr(3, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.nSchriftLabel, this.constraints);
        this.wasPanel.add(this.nSchriftLabel);
        this.constr(0, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.sSizeLabel, this.constraints);
        this.wasPanel.add(this.sSizeLabel);
        this.constr(1, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.uFontSize, this.constraints);
        this.wasPanel.add(this.uFontSize);
        this.constr(3, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.normalFontSize, this.constraints);
        this.wasPanel.add(this.normalFontSize);
        this.constr(0, 3, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.sArtLabel, this.constraints);
        this.wasPanel.add(this.sArtLabel);
        this.constr(1, 3, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.uFontArt, this.constraints);
        this.wasPanel.add(this.uFontArt);
        this.constr(3, 3, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.normalFontArt, this.constraints);
        this.wasPanel.add(this.normalFontArt);
        this.constr(0, 0, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.helpButton, this.constraints);
        this.druckPanel.add(this.helpButton);
        this.constr(0, 1, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.pageButton, this.constraints);
        this.druckPanel.add(this.pageButton);
        this.constr(0, 2, 1, 1);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.prevButton, this.constraints);
        this.druckPanel.add(this.prevButton);
        this.constr(0, 0, 2, 4);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.wasPanel, this.constraints);
        this.mainPanel.add(this.wasPanel);
        this.constr(2, 0, 1, 3);
        this.constraints.fill = 1;
        this.gridbag.setConstraints(this.druckPanel, this.constraints);
        this.mainPanel.add(this.druckPanel);
        this.constr(1, 4, 1, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.okButton, this.constraints);
        this.mainPanel.add(this.okButton);
        this.constr(2, 4, 1, 1);
        this.constraints.fill = 0;
        this.gridbag.setConstraints(this.cancelButton, this.constraints);
        this.mainPanel.add(this.cancelButton);
        this.mainPanel.setBorder(new LineBorder(null, 1));
        this.wasPanel.setBorder(new LineBorder(null, 1));
        this.druckPanel.setBorder(new LineBorder(null, 1));
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    public void menuEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.drucken();
        } else if (object == this.cancelButton) {
            this.close();
        } else if (object == this.helpButton) {
            this.lobet.hilfe(6);
        } else if (object == this.pageButton) {
            this.pageSetup();
        }
    }

    public void taste(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getKeyCode();
        if (n2 != 0) {
            if (n2 == 10) {
                this.d.out("Enter gedr\u00fcckt!");
                this.drucken();
            } else if (n2 == 27) {
                this.close();
            }
        }
    }

    private void constr(int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
    }

    private void drucken() {
        boolean bl = false;
        try {
            if (null == this.prserv) {
                this.d.out("Kein PageSetup gemacht!");
                this.pageSetup();
            }
            if (null != this.prserv) {
                this.d.out("ASET: " + this.aset);
                this.d.out("Ausgewaehlter Print-Service:");
                this.d.out("\t\t\t" + this.prserv);
                this.printPrintServiceAttributesAndDocFlavors(this.prserv);
                System.out.print("create Printjob..");
                DocPrintJob docPrintJob = this.prserv.createPrintJob();
                this.einstellungen.setPrintSetupValues(new PrintSetupValues(this.uFontSize.getSelectedIndex() + 1, this.normalFontSize.getSelectedIndex() + 1, this.uFontArt.getSelectedIndex(), this.normalFontArt.getSelectedIndex()));
                SimpleDoc simpleDoc = new SimpleDoc(new LoBeTPrintableObject(this.typ, this.daten), this.flavor, null);
                this.d.out("Drucke");
                docPrintJob.print(simpleDoc, this.aset);
                this.d.out("Dingens ist erfolgreich gedruckt.");
                bl = true;
            }
        }
        catch (PrintException printException) {
            System.err.println(printException);
        }
        if (bl) {
            this.close();
        }
    }

    public void nachLaden() {
        this.init();
    }

    public void close() {
        this.setVisible(false);
    }

    public void open(int n) {
        this.typ = n;
        this.setVisible(false);
        this.init();
        try {
            this.setIcon(false);
        }
        catch (Exception exception) {
            System.err.println("Fehler beim Deiconifizieren der EinstellungenGUI");
            JOptionPane.showMessageDialog(this, "Fehler beim deiconifizieren!", "DeIconifizieren", 0);
        }
        this.setLocation(0, 0);
        this.setVisible(true);
    }

    private void setToolTips() {
        if (this.einstellungen.getToolTips()) {
            // empty if block
        }
    }

    private void RadioButtonsInit() {
    }

    private void pageSetup() {
        int n = -1;
        if (null == this.prservices || 0 >= this.prservices.length) {
            if (null != this.prservDflt) {
                System.err.println("Nur Default-Printer, da lookupPrintServices fehlgeschlagen.");
                this.prservices = new PrintService[]{this.prservDflt};
            } else {
                System.err.println(this.sErrNoPrintService);
            }
        }
        this.d.out("Print-Services:");
        for (int i = 0; i < this.prservices.length; ++i) {
            this.d.out("\t" + i + ":\t" + this.prservices[i] + (this.prservDflt != this.prservices[i] ? "" : " (Default)"));
        }
        if (0 <= n && n < this.prservices.length) {
            this.prserv = this.prservices[n];
        } else {
            if (!Arrays.asList(this.prservices).contains(this.prservDflt)) {
                this.prservDflt = null;
            }
            this.prserv = ServiceUI.printDialog(null, 50, 50, this.prservices, this.prservDflt, null, this.aset);
        }
    }

    private void setToolTips(boolean bl) {
        if (bl) {
            this.helpButton.setToolTipText("Hilfe zum Drucken");
            this.prevButton.setToolTipText("Druckvorschau");
            this.pageButton.setToolTipText("Druckeigenschaften");
        } else {
            this.helpButton.setToolTipText(null);
            this.prevButton.setToolTipText(null);
            this.pageButton.setToolTipText(null);
        }
    }

    private void setIcons(boolean bl) {
        if (bl) {
            this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/ContextualHelp24.gif")));
            this.prevButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/PrintPreview24.gif")));
            this.pageButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/PageSetup24.gif")));
        } else {
            this.helpButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/ContextualHelp16.gif")));
            this.prevButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/PrintPreview16.gif")));
            this.pageButton.setIcon(new ImageIcon(LoBeT.class.getResource("icons/PageSetup16.gif")));
        }
    }

    private void printPrintServiceAttributesAndDocFlavors(PrintService printService) {
        int n;
        String string = null;
        Attribute[] attributeArray = printService.getAttributes().toArray();
        DocFlavor[] docFlavorArray = printService.getSupportedDocFlavors();
        if (null != attributeArray && 0 < attributeArray.length) {
            for (n = 0; n < attributeArray.length; ++n) {
                System.out.println("\t\t\tPrintService-Attribute[" + n + "]: " + attributeArray[n].getName() + " = " + attributeArray[n]);
            }
        }
        if (null != docFlavorArray && 0 < docFlavorArray.length) {
            for (n = 0; n < docFlavorArray.length; ++n) {
                String string2 = docFlavorArray[n].getMimeType();
                if (null != string2 && !string2.equals(string)) {
                    System.out.println("\t\t\tPrintService-DocFlavor-Mime[" + n + "]: " + string2);
                }
                string = string2;
            }
        }
    }
}

