      import java.awt.Dimension;
      import java.awt.MediaTracker;
      import java.awt.image.BufferedImage;
      import java.io.PrintStream;
      import java.io.Serializable;
      import javax.swing.JFrame;
      
      public class Bild
        implements Serializable
      {
        public static final long serialVersionUID = 1L;
        private String Titel;
        private Kommentar kommentar;
        private BufferedImage bild;
        private BufferedImage kopie;
        private Dimension dim;
        private Dimension kopieDim;
        private BildDaten bildDaten;
        private boolean jpg = false;
        private BildEinstellungen bildE;
      
        public Bild()
        {
          this.kommentar = new Kommentar();
          this.Titel = "";
          int i = 0;
          this.bildE = new BildEinstellungen();
          this.dim = new Dimension(0, 0);
          this.kopieDim = this.dim;
        }
      
        public Bild(BildDaten paramBildDaten) {
          this.kommentar = paramBildDaten.getKommentar();
          this.dim = paramBildDaten.getDim();
          this.kopieDim = paramBildDaten.getKopie();
          this.Titel = paramBildDaten.getTitel();
          this.jpg = paramBildDaten.getJPG();
          this.bildE = paramBildDaten.getBildEinstellungen();
        }
      
        public void setTitel(String paramString) {
          this.Titel = paramString;
        }
      
        public String getTitel() {
          return this.Titel;
        }
      
        public void setKommentar(Kommentar paramKommentar) {
          this.kommentar = paramKommentar;
        }
      
        public Kommentar getKommentar() {
          return this.kommentar;
        }
      
        public void setJPG(boolean paramBoolean) {
          this.jpg = paramBoolean;
        }
      
        public boolean getJPG() {
          return this.jpg;
        }
      
        public BufferedImage getBild() {
          return this.kopie;
        }
      
        public void newSize(int paramInt1, int paramInt2) {
          MediaTracker localMediaTracker = new MediaTracker(new JFrame());
          if (null != this.bild)
          {
            this.kopie = this.bild.getSubimage(0, 0, paramInt1, paramInt2);
            localMediaTracker.addImage(this.kopie, 2);
            try {
              localMediaTracker.waitForID(2);
            } catch (InterruptedException localInterruptedException) {
              System.out.println("Bild.java:\n Methode newSize(int, int):\n  Fehler beim Kopieren des Bildes!");
            }
      
            this.kopieDim = new Dimension(this.kopie.getWidth(), this.kopie.getHeight());
          }
        }
      
        public void setBild(BufferedImage paramBufferedImage) {
          this.bild = paramBufferedImage;
      
          this.dim = new Dimension(paramBufferedImage.getWidth(), paramBufferedImage.getHeight());
          newSize(this.dim.width, this.dim.height);
        }
      
        public void setSize(Dimension paramDimension)
        {
        }
      
        public Dimension getSize()
        {
          return this.kopieDim;
        }
      
        public Dimension getOrgSize() {
          return this.dim;
        }
      
        public BildDaten getDaten() {
          this.bildDaten = new BildDaten(this.Titel, this.kommentar, this.dim, this.kopieDim, this.jpg, this.bildE);
          return this.bildDaten;
        }
      
        public void close() {
          this.bild.flush();
          this.kopie.flush();
        }
      
        protected void finalize() {
          this.bild.flush();
          this.kopie.flush();
          this.Titel = null;
          this.kommentar = null;
          this.bild = null;
          this.kopie = null;
          this.dim = null;
          this.kopieDim = null;
          this.bildDaten = null;
          this.bildE = null;
        }
      
        public void setBildEinstellungen(BildEinstellungen paramBildEinstellungen) {
          this.bildE = paramBildEinstellungen;
        }
      
        public BildEinstellungen getBildEinstellungen() {
          return this.bildE;
        }
      
        public void applyBildEinstellungen(BildEinstellungen paramBildEinstellungen)
        {
          this.bildE.setBildH(paramBildEinstellungen.getBildH());
          this.bildE.setOriginal(paramBildEinstellungen.getOriginal());
          this.bildE.setScreensize(paramBildEinstellungen.getScreensize());
          this.bildE.setRahmen(paramBildEinstellungen.getRahmen());
          this.bildE.setGross(paramBildEinstellungen.getGross());
          this.bildE.setKlein(paramBildEinstellungen.getKlein());
          this.bildE.setPosition(paramBildEinstellungen.getPosition());
          this.bildE.setPixelX(paramBildEinstellungen.getPixelX());
          this.bildE.setPixelY(paramBildEinstellungen.getPixelY());
        }
      }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     Bild
 * JD-Core Version:    0.6.0
 */