      import java.awt.Color;
      import java.awt.Container;
      import java.awt.Dimension;
      import java.awt.GridBagConstraints;
      import java.awt.GridBagLayout;
      import java.awt.Toolkit;
      import java.awt.event.ActionEvent;
      import java.awt.event.KeyEvent;
      import java.awt.event.MouseEvent;
      import javax.swing.ButtonGroup;
      import javax.swing.JButton;
      import javax.swing.JCheckBox;
      import javax.swing.JColorChooser;
      import javax.swing.JComboBox;
      import javax.swing.JDialog;
      import javax.swing.JLabel;
      import javax.swing.JOptionPane;
      import javax.swing.JPanel;
      import javax.swing.JRadioButton;
      import javax.swing.JTabbedPane;
      import javax.swing.JTextField;
      import javax.swing.border.LineBorder;
      
      public class BildEinstellungenGUI extends JDialog
      {
        public static final long serialVersionUID = 1L;
        private LoBeT l;
        private BildEinstellungen e;
        private Debug d = new Debug(true);
        private boolean cancel = false;
      
        private boolean neu = false;
      
        private JPanel panel = new JPanel();
        private GridBagLayout gridbag = new GridBagLayout();
        private GridBagConstraints constraints = new GridBagConstraints();
      
        private JPanel mainPanel = new JPanel();
        private JPanel bildPanel = new JPanel();
        private JTabbedPane textTab = new JTabbedPane();
        private JPanel seitenPanel = new JPanel();
      
        private JLabel hintergrundLabel = new JLabel("Hintergrundfarbe: ");
        private JLabel positionLabel = new JLabel("Position:");
      
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Abbrechen");
      
        private JButton hgButton = new JButton("Farbe wählen");
        private FarbPunkte hgIcon;
        private JCheckBox bildSeitenBehalten = new JCheckBox("Seitenverhältnis behalten");
      
        private JRadioButton originalgr = new JRadioButton("Originalgröße");
        private JRadioButton bildVeraendern = new JRadioButton("Größe verändern");
        private JRadioButton pixel = new JRadioButton("Pixel");
        private JRadioButton screen = new JRadioButton("Bildschirmgröße");
      
        private ButtonGroup bild1gr = new ButtonGroup();
        private ButtonGroup bild2gr = new ButtonGroup();
      
        private JComboBox position = new JComboBox();
      
        private Color[] Farben = new Color[2];
      
        private JTextField bildX = new JTextField(4);
        private JTextField bildY = new JTextField(4);
      
        public BildEinstellungenGUI(LoBeT paramLoBeT, BildEinstellungen paramBildEinstellungen) {
          super(paramLoBeT, "Bildeinstellungen", true);
          this.l = paramLoBeT;
          setDefaultCloseOperation(0);
          Dimension localDimension = Toolkit.getDefaultToolkit().getScreenSize();
          setLocation(localDimension.width / 2 - 200, localDimension.height / 2 - 100);
          this.e = paramBildEinstellungen;
          init();
          create();
          getContentPane().add(this.panel);
          setVisible(true);
        }
      
        private void init()
        {
          this.Farben[1] = this.e.getBildH();
      
          this.originalgr.setSelected(this.e.getOriginal());
          this.bildVeraendern.setSelected(!this.e.getOriginal());
          this.pixel.setSelected(!this.e.getScreensize());
          this.screen.setSelected(this.e.getScreensize());
          this.bildSeitenBehalten.setSelected(this.e.getRahmen());
      
          this.bildX.setText("" + this.e.getPixelX());
          this.bildY.setText("" + this.e.getPixelY());
      
          this.position.addItem("oben");
          this.position.addItem("links");
          this.position.addItem("mitte");
          this.position.addItem("rechts");
          this.position.addItem("unten");
      
          this.position.setSelectedIndex(this.e.getPosition());
      
          this.bild1gr.add(this.bildVeraendern);
          this.bild1gr.add(this.originalgr);
      
          this.bild2gr.add(this.pixel);
          this.bild2gr.add(this.screen);
      
          this.hgIcon = new FarbPunkte(this.Farben[1]);
          this.hgButton.setIcon(this.hgIcon);
      
          Check();
        }
      
        private void create()
        {
          this.gridbag = new GridBagLayout();
          this.constraints = new GridBagConstraints();
      
          this.mainPanel.setLayout(this.gridbag);
      
          this.bildPanel.setLayout(this.gridbag);
          this.seitenPanel.setLayout(this.gridbag);
      
          constr(0, 1, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.hintergrundLabel, this.constraints);
          this.bildPanel.add(this.hintergrundLabel);
      
          constr(1, 1, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.hgButton, this.constraints);
          this.bildPanel.add(this.hgButton);
      
          constr(0, 2, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.positionLabel, this.constraints);
          this.bildPanel.add(this.positionLabel);
      
          constr(1, 2, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.position, this.constraints);
          this.bildPanel.add(this.position);
      
          constr(0, 3, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.originalgr, this.constraints);
          this.bildPanel.add(this.originalgr);
      
          constr(0, 4, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.bildVeraendern, this.constraints);
          this.bildPanel.add(this.bildVeraendern);
      
          constr(0, 0, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.pixel, this.constraints);
          this.seitenPanel.add(this.pixel);
      
          constr(0, 1, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.screen, this.constraints);
          this.seitenPanel.add(this.screen);
      
          constr(0, 2, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.bildSeitenBehalten, this.constraints);
          this.seitenPanel.add(this.bildSeitenBehalten);
      
          constr(1, 0, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.bildX, this.constraints);
          this.seitenPanel.add(this.bildX);
      
          constr(2, 0, 1, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.bildY, this.constraints);
          this.seitenPanel.add(this.bildY);
      
          this.seitenPanel.setBorder(new LineBorder(null, 1));
      
          constr(0, 5, 3, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.seitenPanel, this.constraints);
          this.bildPanel.add(this.seitenPanel);
      
          constr(0, 1, 5, 1);
          this.constraints.fill = 1;
          this.gridbag.setConstraints(this.bildPanel, this.constraints);
          this.mainPanel.add(this.bildPanel);
      
          constr(2, 2, 1, 1);
          this.constraints.fill = 0;
          this.gridbag.setConstraints(this.okButton, this.constraints);
          this.mainPanel.add(this.okButton);
      
          constr(4, 2, 1, 1);
          this.constraints.fill = 0;
          this.gridbag.setConstraints(this.cancelButton, this.constraints);
          this.mainPanel.add(this.cancelButton);
      
          this.okButton.addActionListener(new BildGUIActionAdapter(this));
          this.okButton.addKeyListener(new BildGUITastenAdapter(this));
          this.okButton.addMouseListener(new BildGUIMouseAdapter(this));
          this.cancelButton.addActionListener(new BildGUIActionAdapter(this));
          this.cancelButton.addKeyListener(new BildGUITastenAdapter(this));
          this.cancelButton.addMouseListener(new BildGUIMouseAdapter(this));
      
          this.hgButton.addActionListener(new BildGUIActionAdapter(this));
          this.hgButton.addKeyListener(new BildGUITastenAdapter(this));
          this.hgButton.addMouseListener(new BildGUIMouseAdapter(this));
      
          this.pixel.addMouseListener(new BildGUIMouseAdapter(this));
          this.pixel.addKeyListener(new BildGUITastenAdapter(this));
      
          this.originalgr.addMouseListener(new BildGUIMouseAdapter(this));
          this.originalgr.addKeyListener(new BildGUITastenAdapter(this));
      
          this.bildVeraendern.addMouseListener(new BildGUIMouseAdapter(this));
          this.bildVeraendern.addKeyListener(new BildGUITastenAdapter(this));
      
          this.screen.addMouseListener(new BildGUIMouseAdapter(this));
          this.screen.addKeyListener(new BildGUITastenAdapter(this));
      
          this.bildSeitenBehalten.addMouseListener(new BildGUIMouseAdapter(this));
          this.bildSeitenBehalten.addKeyListener(new BildGUITastenAdapter(this));
      
          getContentPane().add(this.mainPanel);
          pack();
        }
      
        private void constr(int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
          this.constraints.gridx = paramInt1;
          this.constraints.gridy = paramInt2;
          this.constraints.gridwidth = paramInt3;
          this.constraints.gridheight = paramInt4;
        }
      
        public void close() {
          setVisible(false);
          dispose();
        }
      
        public void action(ActionEvent paramActionEvent) {
          Object localObject = paramActionEvent.getSource();
          if (localObject == this.okButton) {
            OK();
          } else if (localObject == this.cancelButton) {
            this.cancel = true;
            close();
          } else if (localObject == this.hgButton) {
            Farbewaehlen(1);
          }
        }
      
        private void OK()
        {
          this.e.setBildH(this.Farben[1]);
          this.e.setOriginal(this.originalgr.isSelected());
          this.e.setScreensize(this.screen.isSelected());
          this.e.setRahmen(this.bildSeitenBehalten.isSelected());
          this.e.setPosition(this.position.getSelectedIndex());
          try {
            this.e.setPixelX(Integer.parseInt(this.bildX.getText()));
            this.e.setPixelY(Integer.parseInt(this.bildY.getText()));
          }
          catch (NumberFormatException localNumberFormatException) {
            JOptionPane.showMessageDialog(this, "Keine gültige Pixelgröße angegeben", "Einstellungsfehler", 0);
          }
          close();
        }
      
        public boolean cancel() {
          return this.cancel;
        }
      
        public boolean getNew()
        {
          return this.neu;
        }
      
        private void Farbewaehlen(int paramInt) {
          if ((paramInt >= 0) && (paramInt < 8)) {
            Color localColor = JColorChooser.showDialog(this.l, "Farbe wählen", this.Farben[paramInt]);
            if (null != localColor) {
              this.Farben[paramInt] = localColor;
              switch (paramInt) {
              case 1:
                this.hgIcon.setFarbe(localColor);
              }
            }
          }
        }
      
        public void taste(KeyEvent paramKeyEvent)
        {
          int i = paramKeyEvent.getModifiers();
          int j = paramKeyEvent.getKeyChar();
          int k = paramKeyEvent.getKeyCode();
          Object localObject = paramKeyEvent.getSource();
      
          if (k != 0)
          {
            if (k == 10)
            {
              OK();
            } else if (k == 27)
              close();
          }
        }
      
        private void Check()
        {
          if (this.originalgr.isSelected()) {
            this.pixel.setEnabled(false);
            this.screen.setEnabled(false);
            this.bildX.setEnabled(false);
            this.bildY.setEnabled(false);
            this.bildSeitenBehalten.setEnabled(false);
          }
          else if (this.pixel.isSelected()) {
            this.pixel.setEnabled(true);
            this.screen.setEnabled(true);
            this.bildX.setEnabled(true);
            this.bildY.setEnabled(true);
            this.bildSeitenBehalten.setEnabled(true);
          } else {
            this.pixel.setEnabled(true);
            this.screen.setEnabled(true);
            this.bildX.setEnabled(false);
            this.bildY.setEnabled(false);
            this.bildSeitenBehalten.setEnabled(true);
          }
        }
      
        public void mouse(MouseEvent paramMouseEvent)
        {
          Object localObject = paramMouseEvent.getSource();
          Check();
        }
      }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     BildEinstellungenGUI
 * JD-Core Version:    0.6.0
 */