/*     */ import java.awt.Color;
/*     */ import java.awt.Font;
/*     */ import java.awt.FontMetrics;
/*     */ import java.awt.Graphics;
/*     */ import java.awt.Graphics2D;
/*     */ import java.awt.print.PageFormat;
/*     */ import java.awt.print.Printable;
/*     */ import java.awt.print.PrinterException;
/*     */ import java.io.PrintStream;
/*     */ import java.util.regex.Pattern;
/*     */ import java.util.regex.PatternSyntaxException;
/*     */ 
/*     */ public class LoBeTPrintableObject
/*     */   implements Printable
/*     */ {
/*   6 */   public int iResMul = 4;
/*   7 */   private int druckDatenTyp = 0;
/*     */   public static final int LIED = 1;
/*     */   public static final int TEXT = 2;
/*     */   public static final int LIEDLISTE = 3;
/*     */   public static final int TEXTLISTE = 4;
/*     */   public static final int AKTLISTE = 5;
/*     */   public static final int ABLAUFPLAN = 6;
/*     */   private String druckText;
/*     */   private Daten daten;
/*     */   private static final int SKALIERFAKTOR = 4;
/*     */   private String[] zeile;
/*  18 */   private int index = 0;
/*     */   private String titel;
/*     */   private int normalSize;
/*     */   private int headLineSize;
/*     */   private String normalArt;
/*     */   private String headLineArt;
/*     */   private AblaufPlan ablauf;
/*     */   private Einstellungen einstellungen;
/*     */   private PrintSetupValues psv;
/*     */ 
/*     */   public LoBeTPrintableObject(int paramInt, Daten paramDaten)
/*     */   {
/*  30 */     this.daten = paramDaten;
/*  31 */     this.einstellungen = paramDaten.getEinstellungen();
/*  32 */     TextEinstellungen localTextEinstellungen = this.einstellungen.getTextEinstellungen();
/*  33 */     this.druckDatenTyp = paramInt;
/*  34 */     this.ablauf = this.einstellungen.getAblaufPlan();
/*  35 */     this.psv = this.einstellungen.getPrintSetupValues();
/*  36 */     this.normalSize = this.psv.getNormalFontSize();
/*  37 */     this.headLineSize = this.psv.getUeberschriftFontSize();
/*  38 */     this.normalArt = TextEinstellungen.fontNamen[this.psv.getNormalFontArt()];
/*  39 */     this.headLineArt = TextEinstellungen.fontNamen[this.psv.getUeberschriftFontArt()];
/*  40 */     this.index = 0;
/*  41 */     switch (paramInt) {
/*     */     case 1:
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*  48 */       this.druckText = this.ablauf.getText();
/*  49 */       System.out.println(this.druckText);
/*  50 */       this.zeile = this.druckText.split("[\n]");
/*  51 */       System.out.println("Zeile= " + this.zeile.length);
/*  52 */       this.titel = "Ablaufplan";
/*  53 */       break;
/*     */     default:
/*  55 */       this.titel = "Kein Titel";
/*  56 */       this.normalSize = 12;
/*  57 */       this.headLineSize = 14;
/*  58 */       this.headLineArt = "Monospaced";
/*  59 */       this.normalArt = "Monospaced";
/*     */     }
/*     */   }
/*     */ 
/*     */   public LoBeTPrintableObject() {
/*  64 */     this.druckDatenTyp = 0;
/*     */   }
/*     */ 
/*     */   public int print(Graphics paramGraphics, PageFormat paramPageFormat, int paramInt) throws PrinterException
/*     */   {
/*  69 */     String str = "";
/*  70 */     int i = 0;
/*     */ 
/*  72 */     int j = 0;
/*  73 */     int k = 0;
/*  74 */     int m = 0;
/*     */ 
/*  76 */     int n = 0;
/*  77 */     int i1 = 0;
/*  78 */     int i2 = 0;
/*     */ 
/*  84 */     Object localObject = null;
/*  85 */     Graphics2D localGraphics2D = (Graphics2D)paramGraphics;
/*  86 */     localGraphics2D.scale(0.25D, 0.25D);
/*  87 */     int i3 = (int)paramPageFormat.getImageableY() * 4;
/*  88 */     int i4 = (int)paramPageFormat.getImageableX() * 4;
/*     */ 
/*  90 */     int i5 = (int)paramPageFormat.getImageableHeight() * 4;
/*  91 */     int i6 = (int)paramPageFormat.getImageableWidth() * 4;
/*     */ 
/*  94 */     Font localFont = new Font(this.headLineArt, 1, this.headLineSize * 4);
/*  95 */     localGraphics2D.setFont(localFont);
/*  96 */     FontMetrics localFontMetrics = localGraphics2D.getFontMetrics(localFont);
/*  97 */     k = i3 + this.headLineSize * 4 + localFontMetrics.getDescent();
/*  98 */     while (k < i5 + i3) {
/*  99 */       k += this.normalSize * 4;
/* 100 */       m++;
/*     */     }
/* 102 */     m--;
/* 103 */     System.out.println("probeZeilen: " + m);
/* 104 */     this.index = (paramInt * m);
/* 105 */     if (this.index > this.zeile.length) return 1;
/* 106 */     localGraphics2D.setColor(Color.black);
/*     */ 
/* 111 */     int i7 = localFontMetrics.stringWidth(this.titel);
/* 112 */     int i8 = i4 + i6 / 2 - i7 / 2;
/* 113 */     localGraphics2D.drawString(this.titel, i8, i3 + this.headLineSize * 4);
/* 114 */     i3 = i3 + this.headLineSize * 4 + localFontMetrics.getDescent();
/*     */     try
/*     */     {
/* 120 */       while ((i < m) && (this.index < this.zeile.length))
/*     */       {
/* 122 */         n = 0;
/* 123 */         i1 = 0;
/* 124 */         i2 = 0;
/* 125 */         str = this.zeile[this.index];
/*     */         try
/*     */         {
/*     */           String[] arrayOfString;
/*     */           int i9;
/* 127 */           if (Pattern.matches(".*<f>.*", this.zeile[this.index])) {
/* 128 */             arrayOfString = this.zeile[this.index].split("<f>");
/* 129 */             str = "";
/* 130 */             for (i9 = 0; i9 < arrayOfString.length; i9++)
/* 131 */               str = str + arrayOfString[i9];
/* 132 */             n = 1;
/*     */           }
/* 134 */           if (Pattern.matches(".*<i>.*", str)) {
/* 135 */             arrayOfString = str.split("<i>");
/* 136 */             str = "";
/* 137 */             for (i9 = 0; i9 < arrayOfString.length; i9++)
/* 138 */               str = str + arrayOfString[i9];
/* 139 */             i1 = 2;
/*     */           }
/* 141 */           if (Pattern.matches(".*<\\+>.*", str)) {
/* 142 */             arrayOfString = str.split("<\\+>");
/* 143 */             str = "";
/* 144 */             for (i9 = 0; i9 < arrayOfString.length; i9++)
/* 145 */               str = str + arrayOfString[i9];
/* 146 */             i2 = 2;
/*     */           }
/* 148 */           if (Pattern.matches(".*<->.*", str)) {
/* 149 */             arrayOfString = str.split("<->");
/* 150 */             str = "";
/* 151 */             for (i9 = 0; i9 < arrayOfString.length; i9++)
/* 152 */               str = str + arrayOfString[i9];
/* 153 */             i2 = -2;
/*     */           }
/*     */         } catch (PatternSyntaxException localPatternSyntaxException) {
/* 156 */           System.err.println("Patternexception in LoBeTPrintableObject");
/*     */         }
/* 158 */         localGraphics2D.setFont(new Font(this.normalArt, 0 + n + i1, (this.normalSize + i2) * 4));
/* 159 */         System.out.println("index: " + this.index + " zeile.length: " + this.zeile.length + " bold: " + n + " italic: " + i1);
/* 160 */         localGraphics2D.drawString(str, i4, i3 + (1 + i) * this.normalSize * 4);
/* 161 */         this.index += 1;
/* 162 */         i++;
/*     */       }
/* 164 */       System.out.println("zeilen: " + i);
/*     */     }
/*     */     catch (StringIndexOutOfBoundsException localStringIndexOutOfBoundsException) {
/* 167 */       System.out.println("Ausdruck beendet");
/*     */     }
/* 169 */     return j;
/*     */   }
/*     */ 
/*     */   private static double dbldgt(double paramDouble)
/*     */   {
/* 209 */     return Math.round(paramDouble * 10.0D) / 10.0D;
/*     */   }
/*     */ }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     LoBeTPrintableObject
 * JD-Core Version:    0.6.0
 */