/*     */ import java.awt.Dimension;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.awt.event.KeyEvent;
/*     */ import java.util.Vector;
/*     */ import java.util.regex.PatternSyntaxException;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JDialog;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JList;
/*     */ import javax.swing.JOptionPane;
/*     */ import javax.swing.JPanel;
/*     */ import javax.swing.JScrollPane;
/*     */ import javax.swing.JTextField;
/*     */ 
/*     */ public class NewstickerAuswahl extends JDialog
/*     */ {
/*     */   public static final long serialVersionUID = 1L;
/*   9 */   private JPanel panel = new JPanel();
/*     */ 
/*  11 */   private JButton okButton = new JButton("OK");
/*     */ 
/*  13 */   private JButton leerenButton = new JButton("Leeren");
/*  14 */   private JButton parseButton = new JButton("Parsen");
/*  15 */   private JButton addButton = new JButton("Hinzufügen");
/*  16 */   private JButton addOneButton = new JButton("Eintrag hinzufügen");
/*  17 */   private JButton allButton = new JButton("Alle hinzufügen");
/*  18 */   private JButton listeLeerenButton = new JButton("Liste leeren");
/*  19 */   private JButton delButton = new JButton("Eintrag löschen");
/*  20 */   private JButton hilfeButton = new JButton("Hilfe");
/*     */ 
/*  22 */   private JLabel leer = new JLabel(" ");
/*  23 */   private JLabel leer2 = new JLabel(" ");
/*     */ 
/*  25 */   private JTextField allnews = new JTextField(20);
/*  26 */   private JTextField news = new JTextField(10);
/*  27 */   private JTextField parser = new JTextField(5);
/*     */   private JList liste;
/*     */   private GridBagLayout gridbag;
/*     */   private GridBagConstraints constraints;
/*     */   private Vector<String> newsVector;
/*     */   private String text;
/*     */   private String muster;
/*     */   private LoBeT lobet;
/*     */   private JScrollPane ls;
/*     */ 
/*     */   public NewstickerAuswahl(LoBeT paramLoBeT, String paramString, Vector<String> paramVector)
/*     */   {
/*  45 */     super(paramLoBeT, "Newstickerauswahl", true);
/*  46 */     setDefaultCloseOperation(0);
/*  47 */     this.lobet = paramLoBeT;
/*  48 */     this.text = paramString;
/*  49 */     this.newsVector = paramVector;
/*  50 */     initGUI();
/*     */   }
/*     */ 
/*     */   public void initGUI() {
/*  54 */     addWindowListener(new NewsAuswahlActionAdapter(this));
/*     */ 
/*  56 */     setTitle("Newstickerauswahl");
/*  57 */     setBounds(100, 100, 400, 275);
/*     */ 
/*  59 */     this.liste = new JList();
/*  60 */     this.liste.setSelectionMode(0);
/*  61 */     this.liste.setListData(this.newsVector);
/*     */ 
/*  63 */     this.gridbag = new GridBagLayout();
/*  64 */     this.constraints = new GridBagConstraints();
/*  65 */     this.panel.setLayout(this.gridbag);
/*     */ 
/*  67 */     this.liste.addMouseListener(new NewsAuswahlMouseAdapter(this));
/*  68 */     this.liste.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  69 */     this.okButton.addActionListener(new NewsAuswahlActionAdapter(this));
/*  70 */     this.hilfeButton.addActionListener(new NewsAuswahlActionAdapter(this));
/*  71 */     this.hilfeButton.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  72 */     this.parseButton.addActionListener(new NewsAuswahlActionAdapter(this));
/*  73 */     this.parseButton.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  74 */     this.parser.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  75 */     this.addButton.addActionListener(new NewsAuswahlActionAdapter(this));
/*  76 */     this.addButton.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  77 */     this.allButton.addActionListener(new NewsAuswahlActionAdapter(this));
/*  78 */     this.allButton.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  79 */     this.leerenButton.addActionListener(new NewsAuswahlActionAdapter(this));
/*  80 */     this.leerenButton.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  81 */     this.listeLeerenButton.addActionListener(new NewsAuswahlActionAdapter(this));
/*  82 */     this.listeLeerenButton.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  83 */     this.addOneButton.addActionListener(new NewsAuswahlActionAdapter(this));
/*  84 */     this.addOneButton.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  85 */     this.delButton.addActionListener(new NewsAuswahlActionAdapter(this));
/*  86 */     this.delButton.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  87 */     this.news.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  88 */     this.okButton.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  89 */     this.allnews.addKeyListener(new NewsAuswahlTastenAdapter(this));
/*  90 */     this.allnews.setText(this.text);
/*  91 */     this.news.setText("");
/*  92 */     this.parser.setText(" \\+\\+\\+ ");
/*     */ 
/*  96 */     constr(0, 0, 3, 1);
/*  97 */     this.constraints.fill = 1;
/*  98 */     this.gridbag.setConstraints(this.allnews, this.constraints);
/*  99 */     this.panel.add(this.allnews);
/*     */ 
/* 101 */     constr(0, 1, 1, 1);
/* 102 */     this.constraints.fill = 1;
/* 103 */     this.gridbag.setConstraints(this.leerenButton, this.constraints);
/* 104 */     this.panel.add(this.leerenButton);
/*     */ 
/* 106 */     constr(1, 1, 1, 1);
/* 107 */     this.constraints.fill = 1;
/* 108 */     this.gridbag.setConstraints(this.parseButton, this.constraints);
/* 109 */     this.panel.add(this.parseButton);
/*     */ 
/* 111 */     constr(2, 1, 1, 1);
/* 112 */     this.constraints.fill = 1;
/* 113 */     this.gridbag.setConstraints(this.parser, this.constraints);
/* 114 */     this.panel.add(this.parser);
/*     */ 
/* 116 */     constr(0, 2, 2, 1);
/* 117 */     this.constraints.fill = 1;
/* 118 */     this.gridbag.setConstraints(this.news, this.constraints);
/* 119 */     this.panel.add(this.news);
/*     */ 
/* 121 */     constr(2, 2, 1, 1);
/* 122 */     this.constraints.fill = 1;
/* 123 */     this.gridbag.setConstraints(this.addButton, this.constraints);
/* 124 */     this.panel.add(this.addButton);
/*     */ 
/* 126 */     this.ls = new JScrollPane(this.liste);
/* 127 */     Dimension localDimension = new Dimension(200, 50);
/* 128 */     this.ls.setMinimumSize(localDimension);
/* 129 */     this.ls.setPreferredSize(new Dimension(400, 100));
/*     */ 
/* 131 */     constr(0, 3, 2, 8);
/* 132 */     this.constraints.fill = 1;
/* 133 */     this.gridbag.setConstraints(this.ls, this.constraints);
/* 134 */     this.panel.add(this.ls);
/*     */ 
/* 136 */     constr(2, 3, 1, 1);
/* 137 */     this.constraints.fill = 1;
/* 138 */     this.gridbag.setConstraints(this.addOneButton, this.constraints);
/* 139 */     this.panel.add(this.addOneButton);
/*     */ 
/* 141 */     constr(2, 4, 1, 1);
/* 142 */     this.constraints.fill = 1;
/* 143 */     this.gridbag.setConstraints(this.allButton, this.constraints);
/* 144 */     this.panel.add(this.allButton);
/*     */ 
/* 146 */     constr(2, 5, 1, 1);
/* 147 */     this.constraints.fill = 1;
/* 148 */     this.gridbag.setConstraints(this.leer, this.constraints);
/* 149 */     this.panel.add(this.leer);
/*     */ 
/* 151 */     constr(2, 6, 1, 1);
/* 152 */     this.constraints.fill = 1;
/* 153 */     this.gridbag.setConstraints(this.delButton, this.constraints);
/* 154 */     this.panel.add(this.delButton);
/*     */ 
/* 156 */     constr(2, 7, 1, 1);
/* 157 */     this.constraints.fill = 1;
/* 158 */     this.gridbag.setConstraints(this.listeLeerenButton, this.constraints);
/* 159 */     this.panel.add(this.listeLeerenButton);
/*     */ 
/* 161 */     constr(2, 8, 1, 1);
/* 162 */     this.constraints.fill = 1;
/* 163 */     this.gridbag.setConstraints(this.leer2, this.constraints);
/* 164 */     this.panel.add(this.leer2);
/*     */ 
/* 166 */     constr(2, 9, 1, 1);
/* 167 */     this.constraints.fill = 1;
/* 168 */     this.gridbag.setConstraints(this.hilfeButton, this.constraints);
/* 169 */     this.panel.add(this.hilfeButton);
/*     */ 
/* 171 */     constr(2, 10, 1, 1);
/* 172 */     this.constraints.fill = 1;
/* 173 */     this.gridbag.setConstraints(this.okButton, this.constraints);
/* 174 */     this.panel.add(this.okButton);
/*     */ 
/* 177 */     setContentPane(this.panel);
/* 178 */     pack();
/*     */ 
/* 180 */     setVisible(true);
/*     */   }
/*     */ 
/*     */   private void constr(int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
/* 184 */     this.constraints.gridx = paramInt1;
/* 185 */     this.constraints.gridy = paramInt2;
/* 186 */     this.constraints.gridwidth = paramInt3;
/* 187 */     this.constraints.gridheight = paramInt4;
/*     */   }
/*     */ 
/*     */   private void parse()
/*     */   {
/* 192 */     this.text = this.allnews.getText();
/* 193 */     this.muster = this.parser.getText();
/*     */     int i;
/* 194 */     if (this.muster.equals("")) {
/* 195 */       i = JOptionPane.showConfirmDialog(this, "Kein Muster vorhanden", "Parserproblem", -1, 2, null);
/*     */     }
/* 199 */     else if (this.text.equals("")) {
/* 200 */       i = JOptionPane.showConfirmDialog(this, "Kein Text vorhanden", "Parserproblem", -1, 2, null);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 206 */         String[] arrayOfString = this.text.split(this.muster);
/* 207 */         for (int j = 0; j < arrayOfString.length; j++)
/* 208 */           this.newsVector.add(arrayOfString[j]);
/*     */       } catch (PatternSyntaxException localPatternSyntaxException) {
/* 210 */         i = JOptionPane.showConfirmDialog(this, "Das Muster ist kein regulärer Ausdruck!", "Parserproblem", -1, 2, null);
/*     */       }
/*     */ 
/* 215 */       this.liste.setListData(this.newsVector);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void cancel() {
/* 220 */     close();
/*     */   }
/*     */ 
/*     */   public void close() {
/* 224 */     setVisible(false);
/*     */   }
/*     */ 
/*     */   public String getText()
/*     */   {
/* 229 */     return this.allnews.getText();
/*     */   }
/*     */ 
/*     */   private void OK() {
/* 233 */     close();
/*     */   }
/*     */ 
/*     */   public boolean ok() {
/* 237 */     return true;
/*     */   }
/*     */ 
/*     */   private void del()
/*     */   {
/* 242 */     if (!this.liste.isSelectionEmpty()) {
/* 243 */       int i = this.liste.getSelectedIndex();
/* 244 */       this.newsVector.remove(i);
/*     */     }
/* 246 */     this.liste.setListData(this.newsVector);
/*     */   }
/*     */ 
/*     */   public void auswahl()
/*     */   {
/* 251 */     this.text = this.allnews.getText();
/* 252 */     this.muster = this.parser.getText();
/* 253 */     if (!this.liste.isSelectionEmpty()) {
/* 254 */       int i = this.liste.getSelectedIndex();
/* 255 */       this.text = (this.text + (String)this.newsVector.get(i) + this.muster);
/*     */     }
/* 257 */     this.allnews.setText(this.text);
/* 258 */     this.liste.setListData(this.newsVector);
/*     */   }
/*     */ 
/*     */   private void leeren() {
/* 262 */     this.newsVector = new Vector(1, 1);
/* 263 */     this.liste.setListData(this.newsVector);
/*     */   }
/*     */ 
/*     */   private void allehinzu() {
/* 267 */     this.text = this.allnews.getText();
/* 268 */     this.muster = this.parser.getText();
/*     */ 
/* 270 */     for (int i = 0; i < this.newsVector.size(); i++)
/* 271 */       this.text = (this.text + (String)this.newsVector.get(i) + this.muster);
/* 272 */     this.allnews.setText(this.text);
/*     */   }
/*     */ 
/*     */   private void zurListehinzu()
/*     */   {
/* 277 */     String str = this.news.getText();
/* 278 */     if (str.length() >= 1)
/* 279 */       this.newsVector.add(str);
/* 280 */     this.news.setText("");
/* 281 */     this.liste.setListData(this.newsVector);
/*     */   }
/*     */ 
/*     */   private void felderLeeren() {
/* 285 */     this.allnews.setText("");
/* 286 */     this.news.setText("");
/* 287 */     this.parser.setText("");
/*     */   }
/*     */ 
/*     */   public void action(ActionEvent paramActionEvent) {
/* 291 */     Object localObject = paramActionEvent.getSource();
/* 292 */     if (localObject == this.okButton)
/* 293 */       OK();
/* 294 */     else if (localObject == this.leerenButton)
/* 295 */       felderLeeren();
/* 296 */     else if (localObject == this.parseButton)
/* 297 */       parse();
/* 298 */     else if (paramActionEvent.getID() == 201)
/* 299 */       close();
/* 300 */     else if (localObject == this.allButton)
/* 301 */       allehinzu();
/* 302 */     else if (localObject == this.listeLeerenButton)
/* 303 */       leeren();
/* 304 */     else if (localObject == this.addButton)
/* 305 */       zurListehinzu();
/* 306 */     else if (localObject == this.addOneButton)
/* 307 */       auswahl();
/* 308 */     else if (localObject == this.delButton)
/* 309 */       del();
/* 310 */     else if (localObject == this.hilfeButton)
/* 311 */       this.lobet.hilfe(9);
/*     */     else
/* 313 */       JOptionPane.showConfirmDialog(this, "Das ist noch nicht eingebaut", "allg. Versionsproblem", -1, 2, null);
/*     */   }
/*     */ 
/*     */   public void taste(KeyEvent paramKeyEvent)
/*     */   {
/* 321 */     int i = paramKeyEvent.getModifiers();
/* 322 */     int j = paramKeyEvent.getKeyChar();
/* 323 */     int k = paramKeyEvent.getKeyCode();
/* 324 */     Object localObject = paramKeyEvent.getSource();
/*     */ 
/* 326 */     if (k != 0)
/*     */     {
/* 328 */       if (k == 10)
/*     */       {
/* 330 */         if (localObject == this.okButton)
/* 331 */           OK();
/* 332 */         else if (localObject == this.news)
/* 333 */           zurListehinzu();
/*     */         else
/* 335 */           auswahl();
/*     */       }
/* 337 */       else if (k == 127)
/* 338 */         del();
/* 339 */       else if (k == 27)
/* 340 */         close();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     NewstickerAuswahl
 * JD-Core Version:    0.6.0
 */