/*     */ import java.awt.Container;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.awt.event.KeyEvent;
/*     */ import java.io.PrintStream;
/*     */ import java.util.regex.Pattern;
/*     */ import javax.swing.ButtonGroup;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JCheckBox;
/*     */ import javax.swing.JInternalFrame;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JOptionPane;
/*     */ import javax.swing.JPanel;
/*     */ import javax.swing.JRadioButton;
/*     */ import javax.swing.JTextField;
/*     */ import javax.swing.border.EmptyBorder;
/*     */ import javax.swing.border.LineBorder;
/*     */ 
/*     */ public class SuchenGUI extends JInternalFrame
/*     */ {
/*     */   public static final long serialVersionUID = 1L;
/*  11 */   private Debug d = new Debug(false);
/*  12 */   private boolean debug = false;
/*     */ 
/*  15 */   private JPanel mainPanel = new JPanel();
/*  16 */   private JPanel woPanel = new JPanel();
/*  17 */   private JPanel inPanel = new JPanel();
/*  18 */   private JPanel textPanel = new JPanel();
/*     */ 
/*  20 */   private EmptyBorder border5 = new EmptyBorder(5, 5, 5, 5);
/*     */   private GridBagConstraints constraints;
/*     */   private GridBagLayout gridbag;
/*  27 */   private JLabel leer = new JLabel(" ");
/*  28 */   private JLabel inLabel = new JLabel("Suchen in");
/*     */ 
/*  31 */   private JButton okButton = new JButton("Suchen");
/*  32 */   private JButton cancelButton = new JButton("Abbrechen");
/*     */ 
/*  35 */   private JCheckBox lied = new JCheckBox("Lieder");
/*  36 */   private JCheckBox text = new JCheckBox("Texte");
/*  37 */   private JCheckBox aktuell = new JCheckBox("Aktuell");
/*  38 */   private JCheckBox bild = new JCheckBox("Bilder");
/*  39 */   private JCheckBox schreibung = new JCheckBox("Gross/Kleinschreibung beachten");
/*     */ 
/*  42 */   private JRadioButton nurtitel = new JRadioButton("nur Titel");
/*  43 */   private JRadioButton nurtext = new JRadioButton("Titel und Text");
/*  44 */   private JRadioButton alles = new JRadioButton("alles");
/*     */ 
/*  47 */   private ButtonGroup woGroup = new ButtonGroup();
/*     */ 
/*  50 */   private JTextField textFeld = new JTextField(10);
/*     */   private Daten daten;
/*     */   private LoBeT lobet;
/*     */   private Einstellungen einstellungen;
/*     */   private Suchen suchen;
/*     */ 
/*     */   public SuchenGUI(LoBeT paramLoBeT, Daten paramDaten)
/*     */   {
/*  62 */     setTitle("Suchen");
/*  63 */     this.daten = paramDaten;
/*  64 */     this.lobet = paramLoBeT;
/*  65 */     this.einstellungen = paramDaten.getEinstellungen();
/*  66 */     initGUI();
/*  67 */     init();
/*  68 */     create();
/*  69 */     this.textFeld.requestFocus();
/*     */ 
/*  71 */     setBounds(150, 50, 300, 300);
/*  72 */     setResizable(false);
/*  73 */     setMaximizable(false);
/*  74 */     setIconifiable(true);
/*  75 */     setClosable(true);
/*  76 */     setVisible(true);
/*     */ 
/*  79 */     this.textFeld.requestFocus();
/*     */   }
/*     */ 
/*     */   public SuchenGUI(LoBeT paramLoBeT, Daten paramDaten, boolean paramBoolean)
/*     */   {
/*  84 */     this.d = new Debug(paramBoolean);
/*  85 */     this.debug = paramBoolean;
/*  86 */     setTitle("Suchen");
/*  87 */     this.daten = paramDaten;
/*  88 */     this.einstellungen = paramDaten.getEinstellungen();
/*  89 */     this.lobet = paramLoBeT;
/*  90 */     setBounds(150, 50, 300, 300);
/*  91 */     initGUI();
/*  92 */     init();
/*  93 */     create();
/*  94 */     this.textFeld.requestFocus();
/*     */ 
/*  96 */     setResizable(false);
/*  97 */     setMaximizable(false);
/*  98 */     setIconifiable(true);
/*  99 */     setClosable(true);
/* 100 */     setVisible(true);
/* 101 */     this.textFeld.requestFocus();
/*     */   }
/*     */ 
/*     */   public void init()
/*     */   {
/* 110 */     this.einstellungen = this.daten.getEinstellungen();
/*     */ 
/* 113 */     setToolTips();
/*     */   }
/*     */ 
/*     */   public void initGUI()
/*     */   {
/* 123 */     this.okButton.addActionListener(new SuchenActionAdapter(this));
/* 124 */     this.cancelButton.addActionListener(new SuchenActionAdapter(this));
/* 125 */     this.textFeld.addKeyListener(new SuchenTastenAdapter(this));
/* 126 */     RadioButtonsInit();
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/* 132 */     setDefaultCloseOperation(1);
/*     */ 
/* 134 */     this.gridbag = new GridBagLayout();
/* 135 */     this.constraints = new GridBagConstraints();
/*     */ 
/* 138 */     this.mainPanel.setLayout(this.gridbag);
/*     */ 
/* 140 */     this.inPanel.setLayout(this.gridbag);
/* 141 */     this.woPanel.setLayout(this.gridbag);
/*     */ 
/* 143 */     this.textPanel.setLayout(this.gridbag);
/*     */ 
/* 146 */     constr(0, 0, 2, 1);
/* 147 */     this.constraints.fill = 1;
/* 148 */     this.gridbag.setConstraints(this.inLabel, this.constraints);
/* 149 */     this.inPanel.add(this.inLabel);
/*     */ 
/* 151 */     constr(0, 0, 2, 1);
/* 152 */     this.constraints.fill = 1;
/* 153 */     this.gridbag.setConstraints(this.textFeld, this.constraints);
/* 154 */     this.textPanel.add(this.textFeld);
/*     */ 
/* 156 */     this.textFeld.requestFocus();
/*     */ 
/* 158 */     constr(0, 1, 1, 1);
/* 159 */     this.constraints.fill = 1;
/* 160 */     this.gridbag.setConstraints(this.lied, this.constraints);
/* 161 */     this.inPanel.add(this.lied);
/*     */ 
/* 163 */     constr(1, 1, 1, 1);
/* 164 */     this.constraints.fill = 1;
/* 165 */     this.gridbag.setConstraints(this.text, this.constraints);
/* 166 */     this.inPanel.add(this.text);
/*     */ 
/* 173 */     constr(2, 1, 1, 1);
/* 174 */     this.constraints.fill = 1;
/* 175 */     this.gridbag.setConstraints(this.bild, this.constraints);
/* 176 */     this.inPanel.add(this.bild);
/*     */ 
/* 179 */     constr(0, 0, 2, 1);
/* 180 */     this.constraints.fill = 1;
/* 181 */     this.gridbag.setConstraints(this.nurtitel, this.constraints);
/* 182 */     this.woPanel.add(this.nurtitel);
/*     */ 
/* 184 */     constr(0, 1, 1, 1);
/* 185 */     this.constraints.fill = 1;
/* 186 */     this.gridbag.setConstraints(this.nurtext, this.constraints);
/* 187 */     this.woPanel.add(this.nurtext);
/*     */ 
/* 189 */     constr(0, 2, 1, 1);
/* 190 */     this.constraints.fill = 1;
/* 191 */     this.gridbag.setConstraints(this.alles, this.constraints);
/* 192 */     this.woPanel.add(this.alles);
/*     */ 
/* 208 */     constr(0, 1, 1, 1);
/* 209 */     this.constraints.fill = 0;
/* 210 */     this.gridbag.setConstraints(this.okButton, this.constraints);
/* 211 */     this.textPanel.add(this.okButton);
/*     */ 
/* 213 */     constr(1, 1, 1, 1);
/* 214 */     this.constraints.fill = 0;
/* 215 */     this.gridbag.setConstraints(this.cancelButton, this.constraints);
/* 216 */     this.textPanel.add(this.cancelButton);
/*     */ 
/* 218 */     this.inPanel.setBorder(new LineBorder(null, 1));
/* 219 */     this.woPanel.setBorder(new LineBorder(null, 1));
/* 220 */     this.textPanel.setBorder(new LineBorder(null, 1));
/*     */ 
/* 229 */     constr(0, 0, 1, 1);
/* 230 */     this.constraints.fill = 1;
/* 231 */     this.gridbag.setConstraints(this.inPanel, this.constraints);
/* 232 */     this.mainPanel.add(this.inPanel);
/*     */ 
/* 234 */     constr(0, 1, 1, 1);
/* 235 */     this.constraints.fill = 1;
/* 236 */     this.gridbag.setConstraints(this.woPanel, this.constraints);
/* 237 */     this.mainPanel.add(this.woPanel);
/*     */ 
/* 239 */     constr(0, 2, 1, 1);
/* 240 */     this.constraints.fill = 1;
/* 241 */     this.gridbag.setConstraints(this.textPanel, this.constraints);
/* 242 */     this.mainPanel.add(this.textPanel);
/*     */ 
/* 244 */     this.woGroup.add(this.nurtitel);
/* 245 */     this.woGroup.add(this.nurtext);
/* 246 */     this.woGroup.add(this.alles);
/*     */ 
/* 248 */     getContentPane().add(this.mainPanel);
/* 249 */     pack();
/*     */   }
/*     */ 
/*     */   public void menuEvent(ActionEvent paramActionEvent)
/*     */   {
/* 258 */     String str = paramActionEvent.getActionCommand();
/* 259 */     Object localObject = paramActionEvent.getSource();
/* 260 */     if (localObject == this.okButton)
/* 261 */       speichern(true);
/* 262 */     else if (localObject == this.cancelButton)
/* 263 */       close();
/*     */   }
/*     */ 
/*     */   public void taste(KeyEvent paramKeyEvent)
/*     */   {
/* 268 */     int i = paramKeyEvent.getModifiers();
/* 269 */     int j = paramKeyEvent.getKeyChar();
/* 270 */     int k = paramKeyEvent.getKeyCode();
/*     */ 
/* 272 */     if (k != 0)
/*     */     {
/* 274 */       if (k == 10)
/*     */       {
/* 276 */         this.d.out("Enter gedrückt!");
/* 277 */         speichern(true);
/* 278 */       } else if (k == 27) {
/* 279 */         close();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void constr(int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*     */   {
/* 316 */     this.constraints.gridx = paramInt1;
/* 317 */     this.constraints.gridy = paramInt2;
/* 318 */     this.constraints.gridwidth = paramInt3;
/* 319 */     this.constraints.gridheight = paramInt4;
/*     */   }
/*     */ 
/*     */   private void speichern(boolean paramBoolean)
/*     */   {
/* 450 */     String str = this.textFeld.getText();
/* 451 */     if (Pattern.matches("[a-z|A-Z| ]*", str))
/* 452 */       str = ".*" + str + ".*";
/* 453 */     this.d.out("Suchtext: " + str);
/* 454 */     this.suchen = new Suchen(this.nurtitel.isSelected(), this.nurtext.isSelected(), this.alles.isSelected(), this.lied.isSelected(), this.text.isSelected(), this.bild.isSelected(), str);
/* 455 */     close();
/* 456 */     ProgressBarNeuThread localProgressBarNeuThread = new ProgressBarNeuThread(this.lobet, this.daten, this.suchen);
/* 457 */     localProgressBarNeuThread.run();
/*     */   }
/*     */ 
/*     */   public void close() {
/* 461 */     setVisible(false);
/*     */   }
/*     */ 
/*     */   public void open() {
/* 465 */     setVisible(false);
/* 466 */     init();
/*     */     try {
/* 468 */       setIcon(false);
/*     */     } catch (Exception localException) {
/* 470 */       System.err.println("Fehler beim Deiconifizieren der EinstellungenGUI");
/*     */ 
/* 472 */       JOptionPane.showMessageDialog(this, "Fehler beim deiconifizieren!", "DeIconifizieren", 0);
/*     */     }
/* 474 */     setLocation(150, 50);
/* 475 */     setVisible(true);
/*     */   }
/*     */ 
/*     */   private void setToolTips()
/*     */   {
/* 480 */     if (this.einstellungen.getToolTips());
/*     */   }
/*     */ 
/*     */   private void RadioButtonsInit()
/*     */   {
/* 490 */     this.lied.setEnabled(true);
/* 491 */     this.text.setEnabled(true);
/* 492 */     this.aktuell.setEnabled(true);
/* 493 */     this.bild.setEnabled(true);
/* 494 */     this.nurtext.setEnabled(true);
/* 495 */     this.nurtitel.setEnabled(true);
/* 496 */     this.alles.setEnabled(true);
/* 497 */     this.schreibung.setEnabled(false);
/* 498 */     this.schreibung.setSelected(true);
/* 499 */     this.lied.setSelected(true);
/*     */ 
/* 501 */     this.nurtext.setSelected(true);
/*     */   }
/*     */ }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     SuchenGUI
 * JD-Core Version:    0.6.0
 */