/*     */ import java.awt.Color;
/*     */ import java.awt.Container;
/*     */ import java.awt.Dimension;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Toolkit;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.awt.event.KeyEvent;
/*     */ import java.awt.event.MouseEvent;
/*     */ import javax.swing.ButtonGroup;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JCheckBox;
/*     */ import javax.swing.JColorChooser;
/*     */ import javax.swing.JComboBox;
/*     */ import javax.swing.JDialog;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JPanel;
/*     */ import javax.swing.JRadioButton;
/*     */ import javax.swing.JTabbedPane;
/*     */ 
/*     */ public class TextEinstellungenGUI extends JDialog
/*     */ {
/*     */   public static final long serialVersionUID = 1L;
/*     */   private LoBeT l;
/*     */   private TextEinstellungen e;
/*  11 */   private Debug d = new Debug(true);
/*  12 */   private boolean cancel = false;
/*     */ 
/*  14 */   private boolean neu = false;
/*     */ 
/*  16 */   private JPanel panel = new JPanel();
/*  17 */   private GridBagLayout gridbag = new GridBagLayout();
/*  18 */   private GridBagConstraints constraints = new GridBagConstraints();
/*     */ 
/*  21 */   private JPanel mainPanel = new JPanel();
/*  22 */   private JPanel liedPanel = new JPanel();
/*  23 */   private JTabbedPane textTab = new JTabbedPane();
/*  24 */   private JPanel liedStrophenPanel = new JPanel();
/*  25 */   private JPanel liedRefrainPanel = new JPanel();
/*  26 */   private JPanel liedBridgePanel = new JPanel();
/*     */ 
/*  30 */   private JLabel textFontLabel = new JLabel("Schriftart: ");
/*     */ 
/*  34 */   private JLabel textFontSizeLabel = new JLabel("Schriftgröße: ");
/*     */ 
/*  38 */   private JLabel textFarbeLabel = new JLabel("Schriftfarbe: ");
/*     */ 
/*  41 */   private JLabel textHintergrundLabel = new JLabel("Hintergrundfarbe: ");
/*     */ 
/*  45 */   private JButton okButton = new JButton("OK");
/*  46 */   private JButton cancelButton = new JButton("Abbrechen");
/*     */ 
/*  48 */   private JButton hgTextButton = new JButton("Farbe wählen");
/*  49 */   private JButton textFarbeButton = new JButton("Farbe wählen");
/*  50 */   private JButton schattenTextButton = new JButton("Farbe wählen");
/*     */   private FarbPunkte textIcon;
/*     */   private FarbPunkte textHGIcon;
/*     */   private FarbPunkte schattenTIcon;
/*  58 */   private JCheckBox textItalic = new JCheckBox("Kursiv");
/*     */ 
/*  62 */   private JCheckBox textBold = new JCheckBox("Fett");
/*     */ 
/*  65 */   private JCheckBox textKleiner = new JCheckBox("Verkleinern");
/*     */ 
/*  67 */   private JCheckBox schattenTextFarbeLabel = new JCheckBox("Rahmenfarbe: ");
/*     */ 
/*  70 */   private JRadioButton textZeileButton = new JRadioButton("nur Zeile");
/*  71 */   private JRadioButton textTextButton = new JRadioButton("ganzen Text");
/*     */ 
/*  73 */   private ButtonGroup textgrp = new ButtonGroup();
/*     */ 
/*  77 */   private JComboBox textFont = new JComboBox();
/*     */ 
/*  81 */   private JComboBox textFontSize = new JComboBox();
/*     */ 
/*  84 */   private Color[] Farben = new Color[3];
/*     */ 
/*     */   public TextEinstellungenGUI(LoBeT paramLoBeT, TextEinstellungen paramTextEinstellungen)
/*     */   {
/*  97 */     super(paramLoBeT, "Texteinstellungen", true);
/*  98 */     this.l = paramLoBeT;
/*  99 */     setDefaultCloseOperation(0);
/* 100 */     Dimension localDimension = Toolkit.getDefaultToolkit().getScreenSize();
/* 101 */     setLocation(localDimension.width / 2 - 200, localDimension.height / 2 - 100);
/* 102 */     this.e = paramTextEinstellungen;
/* 103 */     init();
/* 104 */     create();
/* 105 */     getContentPane().add(this.panel);
/* 106 */     setVisible(true);
/*     */   }
/*     */ 
/*     */   private void init()
/*     */   {
/* 113 */     this.Farben[0] = this.e.getTextF();
/* 114 */     this.Farben[1] = this.e.getTextH();
/* 115 */     this.Farben[2] = this.e.getRahmenFarbe();
/*     */ 
/* 117 */     this.textIcon = new FarbPunkte(this.Farben[0]);
/* 118 */     this.textHGIcon = new FarbPunkte(this.Farben[1]);
/* 119 */     this.schattenTIcon = new FarbPunkte(this.Farben[2]);
/* 120 */     this.textFarbeButton.setIcon(this.textIcon);
/* 121 */     this.hgTextButton.setIcon(this.textHGIcon);
/* 122 */     this.schattenTextButton.setIcon(this.schattenTIcon);
/*     */ 
/* 124 */     for (int i = 0; i < 6; i++) {
/* 125 */       this.textFont.addItem(TextEinstellungen.fontNamen[i]);
/*     */     }
/* 127 */     for (int i = 1; i < 151; i++) {
/* 128 */       this.textFontSize.addItem("" + i);
/*     */     }
/* 130 */     this.textZeileButton.setSelected(this.e.getTextZeile());
/* 131 */     this.textFont.setSelectedIndex(this.e.getTextFont(0));
/*     */ 
/* 133 */     this.textFontSize.setSelectedIndex(this.e.getTextSize(0) - 1);
/*     */ 
/* 135 */     this.textBold.setSelected(this.e.getTextBold(0));
/*     */ 
/* 137 */     this.textItalic.setSelected(this.e.getTextItalic(0));
/*     */ 
/* 139 */     this.schattenTextFarbeLabel.setSelected(this.e.getRahmen());
/*     */ 
/* 142 */     this.textKleiner.setSelected(this.e.getTextKleiner());
/* 143 */     this.textZeileButton.setSelected(this.e.getTextZeile());
/* 144 */     this.textTextButton.setSelected(!this.e.getTextZeile());
/* 145 */     if (this.textKleiner.isSelected()) {
/* 146 */       this.textZeileButton.setEnabled(true);
/* 147 */       this.textTextButton.setEnabled(true);
/*     */     } else {
/* 149 */       this.textZeileButton.setEnabled(false);
/* 150 */       this.textTextButton.setEnabled(false);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void create()
/*     */   {
/* 157 */     this.gridbag = new GridBagLayout();
/* 158 */     this.constraints = new GridBagConstraints();
/*     */ 
/* 161 */     this.mainPanel.setLayout(this.gridbag);
/*     */ 
/* 163 */     this.liedStrophenPanel.setLayout(this.gridbag);
/* 164 */     this.liedRefrainPanel.setLayout(this.gridbag);
/* 165 */     this.liedBridgePanel.setLayout(this.gridbag);
/*     */ 
/* 167 */     this.liedPanel.setLayout(this.gridbag);
/*     */ 
/* 171 */     constr(0, 1, 1, 1);
/* 172 */     this.constraints.fill = 1;
/* 173 */     this.gridbag.setConstraints(this.textHintergrundLabel, this.constraints);
/* 174 */     this.liedPanel.add(this.textHintergrundLabel);
/*     */ 
/* 176 */     constr(1, 1, 1, 1);
/* 177 */     this.constraints.fill = 1;
/* 178 */     this.gridbag.setConstraints(this.hgTextButton, this.constraints);
/* 179 */     this.liedPanel.add(this.hgTextButton);
/*     */ 
/* 182 */     constr(0, 2, 1, 1);
/* 183 */     this.constraints.fill = 1;
/* 184 */     this.gridbag.setConstraints(this.textFarbeLabel, this.constraints);
/* 185 */     this.liedPanel.add(this.textFarbeLabel);
/*     */ 
/* 187 */     constr(1, 2, 1, 1);
/* 188 */     this.constraints.fill = 1;
/* 189 */     this.gridbag.setConstraints(this.textFarbeButton, this.constraints);
/* 190 */     this.liedPanel.add(this.textFarbeButton);
/*     */ 
/* 192 */     constr(0, 3, 1, 1);
/* 193 */     this.constraints.fill = 1;
/* 194 */     this.gridbag.setConstraints(this.schattenTextFarbeLabel, this.constraints);
/* 195 */     this.liedPanel.add(this.schattenTextFarbeLabel);
/*     */ 
/* 197 */     constr(1, 3, 1, 1);
/* 198 */     this.constraints.fill = 1;
/* 199 */     this.gridbag.setConstraints(this.schattenTextButton, this.constraints);
/* 200 */     this.liedPanel.add(this.schattenTextButton);
/*     */ 
/* 202 */     constr(0, 4, 1, 1);
/* 203 */     this.constraints.fill = 1;
/* 204 */     this.gridbag.setConstraints(this.textKleiner, this.constraints);
/* 205 */     this.liedPanel.add(this.textKleiner);
/*     */ 
/* 207 */     constr(1, 4, 1, 1);
/* 208 */     this.constraints.fill = 1;
/* 209 */     this.gridbag.setConstraints(this.textZeileButton, this.constraints);
/* 210 */     this.liedPanel.add(this.textZeileButton);
/*     */ 
/* 212 */     constr(1, 5, 1, 1);
/* 213 */     this.constraints.fill = 1;
/* 214 */     this.gridbag.setConstraints(this.textTextButton, this.constraints);
/* 215 */     this.liedPanel.add(this.textTextButton);
/*     */ 
/* 217 */     constr(0, 6, 1, 1);
/* 218 */     this.constraints.fill = 1;
/* 219 */     this.gridbag.setConstraints(this.textFontLabel, this.constraints);
/* 220 */     this.liedPanel.add(this.textFontLabel);
/*     */ 
/* 222 */     constr(1, 6, 1, 1);
/* 223 */     this.constraints.fill = 1;
/* 224 */     this.gridbag.setConstraints(this.textFont, this.constraints);
/* 225 */     this.liedPanel.add(this.textFont);
/*     */ 
/* 227 */     constr(2, 6, 1, 1);
/* 228 */     this.constraints.fill = 1;
/* 229 */     this.gridbag.setConstraints(this.textBold, this.constraints);
/* 230 */     this.liedPanel.add(this.textBold);
/*     */ 
/* 232 */     constr(3, 6, 1, 1);
/* 233 */     this.constraints.fill = 1;
/* 234 */     this.gridbag.setConstraints(this.textItalic, this.constraints);
/* 235 */     this.liedPanel.add(this.textItalic);
/*     */ 
/* 237 */     constr(0, 7, 1, 1);
/* 238 */     this.constraints.fill = 1;
/* 239 */     this.gridbag.setConstraints(this.textFontSizeLabel, this.constraints);
/* 240 */     this.liedPanel.add(this.textFontSizeLabel);
/*     */ 
/* 242 */     constr(1, 7, 1, 1);
/* 243 */     this.constraints.fill = 1;
/* 244 */     this.gridbag.setConstraints(this.textFontSize, this.constraints);
/* 245 */     this.liedPanel.add(this.textFontSize);
/*     */ 
/* 249 */     constr(0, 1, 5, 1);
/* 250 */     this.constraints.fill = 1;
/* 251 */     this.gridbag.setConstraints(this.liedPanel, this.constraints);
/* 252 */     this.mainPanel.add(this.liedPanel);
/*     */ 
/* 254 */     constr(2, 2, 1, 1);
/* 255 */     this.constraints.fill = 0;
/* 256 */     this.gridbag.setConstraints(this.okButton, this.constraints);
/* 257 */     this.mainPanel.add(this.okButton);
/*     */ 
/* 259 */     constr(4, 2, 1, 1);
/* 260 */     this.constraints.fill = 0;
/* 261 */     this.gridbag.setConstraints(this.cancelButton, this.constraints);
/* 262 */     this.mainPanel.add(this.cancelButton);
/*     */ 
/* 264 */     this.okButton.addActionListener(new TextGUIActionAdapter(this));
/* 265 */     this.cancelButton.addActionListener(new TextGUIActionAdapter(this));
/*     */ 
/* 267 */     this.textFarbeButton.addActionListener(new TextGUIActionAdapter(this));
/* 268 */     this.hgTextButton.addActionListener(new TextGUIActionAdapter(this));
/* 269 */     this.schattenTextButton.addActionListener(new TextGUIActionAdapter(this));
/*     */ 
/* 271 */     this.textKleiner.addMouseListener(new TextGUIMouseAdapter(this));
/* 272 */     this.textKleiner.addKeyListener(new TextGUITastenAdapter(this));
/*     */ 
/* 274 */     this.textgrp.add(this.textZeileButton);
/* 275 */     this.textgrp.add(this.textTextButton);
/*     */ 
/* 277 */     getContentPane().add(this.mainPanel);
/* 278 */     pack();
/*     */   }
/*     */ 
/*     */   private void constr(int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
/* 282 */     this.constraints.gridx = paramInt1;
/* 283 */     this.constraints.gridy = paramInt2;
/* 284 */     this.constraints.gridwidth = paramInt3;
/* 285 */     this.constraints.gridheight = paramInt4;
/*     */   }
/*     */ 
/*     */   public void close() {
/* 289 */     setVisible(false);
/* 290 */     dispose();
/*     */   }
/*     */ 
/*     */   public void action(ActionEvent paramActionEvent) {
/* 294 */     Object localObject = paramActionEvent.getSource();
/* 295 */     if (localObject == this.okButton)
/* 296 */       OK();
/* 297 */     else if (localObject == this.cancelButton)
/* 298 */       close();
/* 299 */     else if (localObject == this.textFarbeButton)
/* 300 */       Farbewaehlen(0);
/* 301 */     else if (localObject == this.hgTextButton)
/* 302 */       Farbewaehlen(1);
/* 303 */     else if (localObject == this.schattenTextButton)
/* 304 */       Farbewaehlen(2);
/*     */   }
/*     */ 
/*     */   private void OK()
/*     */   {
/* 311 */     this.e.setTextKleiner(this.textKleiner.isSelected());
/* 312 */     this.e.setTextZeile(this.textZeileButton.isSelected());
/* 313 */     this.e.setTextFont(0, this.textFont.getSelectedIndex());
/*     */ 
/* 315 */     this.e.setFontSize(0, this.textFontSize.getSelectedIndex() + 1);
/*     */ 
/* 317 */     this.e.setBold(0, this.textBold.isSelected());
/*     */ 
/* 319 */     this.e.setItalic(0, this.textItalic.isSelected());
/*     */ 
/* 321 */     this.e.setTextF(this.Farben[0]);
/* 322 */     this.e.setTextH(this.Farben[1]);
/* 323 */     this.e.setRahmenFarbe(this.Farben[2]);
/* 324 */     this.e.setRahmen(this.schattenTextFarbeLabel.isSelected());
/* 325 */     close();
/*     */   }
/*     */ 
/*     */   public boolean cancel() {
/* 329 */     return this.cancel;
/*     */   }
/*     */ 
/*     */   public boolean getNew()
/*     */   {
/* 334 */     return this.neu;
/*     */   }
/*     */ 
/*     */   private void Farbewaehlen(int paramInt) {
/* 338 */     if ((paramInt >= 0) && (paramInt < 8)) {
/* 339 */       Color localColor = JColorChooser.showDialog(this.l, "Farbe wählen", this.Farben[paramInt]);
/* 340 */       if (null != localColor) {
/* 341 */         this.Farben[paramInt] = localColor;
/* 342 */         switch (paramInt) {
/*     */         case 0:
/* 344 */           this.textIcon.setFarbe(localColor);
/* 345 */           break;
/*     */         case 1:
/* 347 */           this.textHGIcon.setFarbe(localColor);
/* 348 */           break;
/*     */         case 2:
/* 350 */           this.schattenTIcon.setFarbe(localColor);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void taste(KeyEvent paramKeyEvent)
/*     */   {
/* 359 */     int i = paramKeyEvent.getModifiers();
/* 360 */     int j = paramKeyEvent.getKeyChar();
/* 361 */     int k = paramKeyEvent.getKeyCode();
/* 362 */     Object localObject = paramKeyEvent.getSource();
/*     */ 
/* 364 */     if (k != 0)
/*     */     {
/* 366 */       if (k == 10)
/*     */       {
/* 369 */         OK();
/* 370 */       } else if (k == 27)
/* 371 */         close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void CheckBoxen(Object paramObject)
/*     */   {
/* 378 */     if (paramObject == this.textKleiner) {
/* 379 */       this.d.out("CheckBox textKleiner");
/* 380 */       if (this.textKleiner.isSelected()) {
/* 381 */         this.textZeileButton.setEnabled(true);
/* 382 */         this.textTextButton.setEnabled(true);
/*     */       } else {
/* 384 */         this.textZeileButton.setEnabled(false);
/* 385 */         this.textTextButton.setEnabled(false);
/*     */       }
/* 387 */       if (this.textKleiner.isSelected()) {
/* 388 */         this.d.out("textKleiner is Selected und wird ausgeschaltet");
/* 389 */         this.textKleiner.setSelected(false);
/*     */       } else {
/* 391 */         this.d.out("textKleiner is not Selected und wird angeschaltet");
/* 392 */         this.textKleiner.setSelected(true);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void mouse(MouseEvent paramMouseEvent) {
/* 398 */     Object localObject = paramMouseEvent.getSource();
/*     */ 
/* 400 */     if (localObject == this.textKleiner)
/* 401 */       if (this.textKleiner.isSelected()) {
/* 402 */         this.textZeileButton.setEnabled(true);
/* 403 */         this.textTextButton.setEnabled(true);
/*     */       } else {
/* 405 */         this.textZeileButton.setEnabled(false);
/* 406 */         this.textTextButton.setEnabled(false);
/*     */       }
/*     */   }
/*     */ }

/* Location:           /tmp/basti/LoBeT.jar
 * Qualified Name:     TextEinstellungenGUI
 * JD-Core Version:    0.6.0
 */