       import java.io.BufferedWriter;
       import java.io.File;
       import java.io.FileInputStream;
       import java.io.FileOutputStream;
       import java.io.IOException;
       import java.io.ObjectInputStream;
       import java.io.ObjectOutputStream;
       import java.io.OutputStreamWriter;
       import java.util.Vector;
       
       public class XMLExport
       {
         private Debug d = new Debug(false);
         private boolean debug = false;
         private Daten daten;
         private ProgressBarNeu pbn;
         private File file;
         private String titel = "Liederliste";
         private final String VERSION = Start.showVersion();
         private final String xmlVersion = "1.0";
         private final String[] buchstaben = { "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "z", "zz" };
         private String path;
         private String name;
         private Lied lied;
         private Text text;
         private Vector liedVector;
         private Vector textVector;
         private Vector aktVector;
         public static final int LIED = 0;
         private static final int maxSchirm = 5;
         private static final int maxZeile = 24;
         private int liedNr = 0;
         private FileOutputStream fos;
         private ObjectOutputStream oos;
         private FileInputStream fis;
         private ObjectInputStream ois;
         private BufferedWriter bw;
         String dateiInhalt = "";
       
         public XMLExport(Daten paramDaten, ProgressBarNeu paramProgressBarNeu, File paramFile, boolean paramBoolean) throws IOException
         {
           d = new Debug(paramBoolean);
           daten = paramDaten;
           pbn = paramProgressBarNeu;
           file = paramFile;
           debug = paramBoolean;
           //schreiben();
         }
       
         public void schreiben() throws IOException
         {
           
           liedVector = daten.getVector(0);
           textVector = daten.getVector(1);
           aktVector = daten.getVector(3);
           Strophe localStrophe;
           
           pbn.setMax(liedVector.size() + textVector.size() + 1);
           pbn.progress(0, "XML-Daten generieren");
           pbn.setIndeterminate(false);
           d.out("Datei (" + file.getName() + ") öffnen");
       
           fos = new FileOutputStream(file);
           bw = new BufferedWriter(new OutputStreamWriter(fos, "UTF-8"));
           d.out("XML schreiben");
           vorspann();
       
           bw.newLine();
           bw.write("<LiederUndTexteDokument version=\"1.0\">");
           bw.newLine();
           
           
           
           if ((daten.getEinstellungen().getXMLlied()) && (liedVector.size() > 0)) {
             bw.write("  <Lieder>");
             bw.newLine();
       
             for (int j = 0; j < liedVector.size(); j++) {
               pbn.progress();
               lied = daten.getLied(j);
               if (null == lied)
                 continue;
               bw.write("    <Lied>");
               bw.newLine();
       
               bw.write("      <Titel>");
               bw.write(entity(lied.getTitel()));
               bw.write("</Titel>");
               bw.newLine();
               if (lied.getKopie()) {
                 bw.write("      <Original>");
                 bw.write(entity(lied.getOriginal()));
                 bw.write("</Original>");
                 bw.newLine();
               }
               bw.write("      <Statistik>");
               bw.write("" + lied.getStatistiken());
               bw.write("</Statistik>");
               bw.newLine();
               bw.write("      <WannStatistik>");
               bw.write("" + lied.getTimeStatistiken());
               bw.write("</WannStatistik>");
               bw.newLine();
               lied.setAuswahl();
               localStrophe = lied.getStrophe();
               for (int k = 0; k < lied.getMaxStrophen(); k++) {
                 bw.write("      <Liedseite>");
                 bw.newLine();
                 if (localStrophe.getAnfang()) {
                   bw.write("        <Anfang>YES</Anfang>");
                   bw.newLine();
                 }
                 if (localStrophe.getRefrain()) {
                   bw.write("        <Refrain>YES</Refrain>");
                   bw.newLine();
                 }
                 if (localStrophe.getBridge()) {
                   bw.write("        <Bridge>YES</Bridge>");
                   bw.newLine();
                 }
       
                 int maxVolleZeile = 0;
                 for (int m = 0; m < maxZeile; m++)
                   if (localStrophe.get(m).length() > 1)
                     maxVolleZeile = m;
                 for (int m = 0; m <= maxVolleZeile; m++)
                 {
                   bw.write("        <Zeile>");
                   bw.write(entity(localStrophe.get(m)));
                   bw.write("</Zeile>");
                   bw.newLine();
                 }
       
                 bw.write("      </Liedseite>");
                 bw.newLine();
                 localStrophe = lied.getNextStrophe();
               }
               kommentare(lied.getKommentar());
               bw.write("    </Lied>");
               bw.newLine();
             }
       
             bw.write("  </Lieder>");
             bw.newLine();
           }
       
           if ((daten.getEinstellungen().getXMLtext()) && (textVector.size() > 0)) {
             bw.write("  <Texte>");
             bw.newLine();
       
             for (int j = 0; j < textVector.size(); j++) {
               pbn.progress();
               text = daten.getText(j);
               if (null != text) {
                 bw.write("    <Text>");
                 bw.newLine();
       
                 bw.write("      <Titel>");
                 bw.write(entity(text.getTitel()));
                 bw.write("</Titel>");
                 bw.newLine();
                 text.setAuswahl();
                 localStrophe = text.getText();
                 for (int k = 0; k < text.getMaxText(); k++) {
                   bw.write("      <Textseite>");
                   bw.newLine();
                   int maxVolleZeile = 0;
                   for (int m = 0; m < maxZeile; m++)
                     if (localStrophe.get(m).length() > 1)
                       maxVolleZeile = m;
                   for (int m = 0; m <= maxVolleZeile; m++) {
                     bw.write("        <Zeile>");
                     bw.write(entity(localStrophe.get(m)));
                     bw.write("</Zeile>");
                     bw.newLine();
                   }
                   bw.write("      </Textseite>");
                   bw.newLine();
                   localStrophe = text.getNextText();
                 }
                 kommentare(text.getKommentar());
                 bw.write("    </Text>");
                 bw.newLine();
               }
             }
       
             bw.write("  </Texte>");
             bw.newLine();
           }
          
           if ((daten.getEinstellungen().getXMLakt()) && (!daten.getEinstellungen().getXMLlied()) && (!daten.getEinstellungen().getXMLtext()) && (liedVector.size() > 0) && (aktVector.size() > 0))
           {
             boolean j = false; //Lied suchen = ls
             boolean k = false; //Suche Lied in Aktuell
             int m = 0;
             int n = 0;
             while (!j && (m < aktVector.size())) {
               if (daten.getAkt(m).getTyp() == Daten.LIED)
                 j = true;
               m++;
             }
             if (j) {
               bw.write("  <Lieder>");
               bw.newLine();
               for (m = 0; m < liedVector.size(); m++) {
                 pbn.progress();
                 lied = daten.getLied(m);
       
                 k = false;
                 n = 0;
                 while (!k && (n < aktVector.size())) {
                   if (lied == daten.getAkt(n).getLied())
                     k = true;
                   n++;
                 }
                 if ( k == false || (null == lied))
                   continue;
                 bw.write("    <Lied>");
                 bw.newLine();
       
                 bw.write("      <Titel>");
                 bw.write(entity(lied.getTitel()));
                 bw.write("</Titel>");
                 bw.newLine();
                 if (lied.getKopie()) {
                   bw.write("      <Original>");
                   bw.write(entity(lied.getOriginal()));
                   bw.write("</Original>");
                   bw.newLine();
                 }
                 bw.write("      <Statistik>");
                 bw.write("" + lied.getStatistiken());
                 bw.write("</Statistik>");
                 bw.newLine();
                 bw.write("      <WannStatistik>");
                 bw.write("" + lied.getTimeStatistiken());
                 bw.write("</WannStatistik>");
                 bw.newLine();
                 lied.setAuswahl();
                 localStrophe = lied.getStrophe();
                 for (n = 0; n < lied.getMaxStrophen(); n++) {
                   bw.write("      <Liedseite>");
                   bw.newLine();
                   if (localStrophe.getAnfang()) {
                     bw.write("        <Anfang>YES</Anfang>");
                     bw.newLine();
                   }
                   if (localStrophe.getRefrain()) {
                     bw.write("        <Refrain>YES</Refrain>");
                     bw.newLine();
                   }
                   if (localStrophe.getBridge()) {
                     bw.write("        <Bridge>YES</Bridge>");
                     bw.newLine();
                   }
       
                   int maxVolleZeile = 0;
                   for (int i1 = 0; i1 < maxZeile; i1++)
                     if (localStrophe.get(i1).length() > 1)
                       maxVolleZeile = i1;
                   for (int i1 = 0; i1 <= maxVolleZeile; i1++)
                   {
                     bw.write("        <Zeile>");
                     bw.write(entity(localStrophe.get(i1)));
                     bw.write("</Zeile>");
                     bw.newLine();
                   }
       
                   bw.write("      </Liedseite>");
                   bw.newLine();
                   localStrophe = lied.getNextStrophe();
                 }
                 kommentare(lied.getKommentar());
                 bw.write("    </Lied>");
                 bw.newLine();
               }
       
               bw.write("  </Lieder>");
               bw.newLine();
             }
           }
       
           if ((daten.getEinstellungen().getXMLakt()) && (!daten.getEinstellungen().getXMLlied()) && (!daten.getEinstellungen().getXMLtext()) && (textVector.size() > 0) && (aktVector.size() > 0))
           {
             boolean j = true;
             boolean k = true;
             int m = 0;
             int n = 0;
             while ( !j && (m < aktVector.size())) {
               if (daten.getAkt(m).getTyp() == Daten.TEXT)
                 j = true;
               m++;
             }
             if (j) {
               bw.write("  <Texte>");
               bw.newLine();
               for (m = 0; m < textVector.size(); m++) {
                 pbn.progress();
                 text = daten.getText(m);
       
                 k = false;
                 n = 0;
                 while (!k && (n < aktVector.size())) {
                   if (text == daten.getAkt(n).getText())
                     k = true;
                   n++;
                 }
                 if (k && text != null) {
                   bw.write("    <Text>");
                   bw.newLine();
       
                   bw.write("      <Titel>");
                   bw.write(entity(text.getTitel()));
                   bw.write("</Titel>");
                   bw.newLine();
                   text.setAuswahl();
                   localStrophe = text.getText();
                   for (n = 0; n < text.getMaxText(); n++) {
                     bw.write("      <Textseite>");
                     bw.newLine();
                     int maxVolleZeile = 0;
                     for (int i1 = 0; i1 < maxZeile; i1++)
                       if (localStrophe.get(i1).length() > 1)
                         maxVolleZeile = i1;
                     for (int i1 = 0; i1 <= maxVolleZeile; i1++) {
                       bw.write("        <Zeile>");
                       bw.write(entity(localStrophe.get(i1)));
                       bw.write("</Zeile>");
                       bw.newLine();
                     }
                     bw.write("      </Textseite>");
                     bw.newLine();
                     localStrophe = text.getNextText();
                   }
                   kommentare(text.getKommentar());
                   bw.write("    </Text>");
                   bw.newLine();
                 }
               }
               bw.write("  </Texte>");
               bw.newLine();
             }
           }
       
           bw.write("</LiederUndTexteDokument>");
           bw.newLine();
       
           bw.flush();
           fos.flush();
           fos.close();
         }
       
         private void vorspann()
           throws IOException
         {
           bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
           bw.newLine();
           bw.write("<!-- Geschrieben von LoBeT " + VERSION + " -->");
           bw.newLine();
           bw.write("<!DOCTYPE LiederUndTexteDokument [");
           bw.newLine();
           bw.write("  <!ELEMENT LiederUndTexteDokument (Lieder?, Texte?)>");
           bw.newLine();
           bw.write("    <!ATTLIST LiederUndTexteDokument version CDATA \"\">");
           bw.newLine();
           bw.write("    <!ELEMENT Lieder (Lied*)>");
           bw.newLine();
           bw.write("      <!ELEMENT Lied (Titel, Original?, Statistik, WannStatistik, Liedseite+, Kommentare)>");
           bw.newLine();
           bw.write("        <!ELEMENT Titel (#PCDATA)>");
           bw.newLine();
           bw.write("        <!ELEMENT Original (#PCDATA)>");
           bw.newLine();
           bw.write("        <!ELEMENT Statistik (#PCDATA)>");
           bw.newLine();
           bw.write("        <!ELEMENT WannStatistik (#PCDATA)>");
           bw.newLine();
           bw.write("        <!ELEMENT Liedseite (Anfang?, Refrain?, Bridge?, Translate?, Zeile+)>");
           bw.newLine();
           bw.write("          <!ELEMENT Anfang (#PCDATA)>");
           bw.newLine();
           bw.write("          <!ELEMENT Refrain (#PCDATA)>");
           bw.newLine();
           bw.write("          <!ELEMENT Bridge (#PCDATA)>");
           bw.newLine();
           bw.write("          <!ELEMENT Translate (#PCDATA)>");
           bw.newLine();
           bw.write("          <!ELEMENT Zeile (#PCDATA)>");
           bw.newLine();
           bw.write("        <!ELEMENT Kommentare (Textautor, Melodie, Uebersetzer, Copyright, Verlag, Kommentar, Version)>");
           bw.newLine();
           bw.write("          <!ELEMENT Textautor (Vorname, Name)>");
           bw.newLine();
           bw.write("            <!ELEMENT Vorname (#PCDATA)>");
           bw.newLine();
           bw.write("            <!ELEMENT Name (#PCDATA)>");
           bw.newLine();
           bw.write("          <!ELEMENT Melodie (Vorname, Name)>");
           bw.newLine();
           bw.write("          <!ELEMENT Uebersetzer (Vorname, Name)>");
           bw.newLine();
           bw.write("          <!ELEMENT Copyright (#PCDATA)>");
           bw.newLine();
           bw.write("          <!ELEMENT Verlag (#PCDATA)>");
           bw.newLine();
           bw.write("          <!ELEMENT Kommentar (#PCDATA)>");
           bw.newLine();
           bw.write("          <!ELEMENT Version (#PCDATA)>");
           bw.newLine();
           bw.write("    <!ELEMENT Texte (Text*)>");
           bw.newLine();
           bw.write("      <!ELEMENT Text (Titel, Textseite+, Kommentare)>");
           bw.newLine();
           bw.write("        <!ELEMENT Textseite (Zeile+)>");
           bw.newLine();
           bw.write("]>");
           bw.newLine();
         }
       
         private void pfadFinden() {
           int i = path.lastIndexOf(File.separator);
           if (-1 != i)
             path = (path.substring(0, i) + File.separator);
           d.out("Pfad: " + path);
         }
       
         private void kommentare(Kommentar paramKommentar) throws IOException {
           bw.write("      <Kommentare>");
           bw.newLine();
           bw.write("        <Textautor>");
           bw.newLine();
           bw.write("          <Vorname>");
           bw.write(entity(paramKommentar.getTexter().getVorname()));
           bw.write("</Vorname>");
           bw.newLine();
           bw.write("          <Name>");
           bw.write(entity(paramKommentar.getTexter().getName()));
           bw.write("</Name>");
           bw.newLine();
           bw.write("        </Textautor>");
           bw.newLine();
           bw.write("        <Melodie>");
           bw.newLine();
           bw.write("          <Vorname>");
           bw.write(entity(paramKommentar.getLiedmacher().getVorname()));
           bw.write("</Vorname>");
           bw.newLine();
           bw.write("          <Name>");
           bw.write(entity(paramKommentar.getLiedmacher().getName()));
           bw.write("</Name>");
           bw.newLine();
           bw.write("        </Melodie>");
           bw.newLine();
           bw.write("        <Uebersetzer>");
           bw.newLine();
           bw.write("          <Vorname>");
           bw.write(entity(paramKommentar.getTranslater().getVorname()));
           bw.write("</Vorname>");
           bw.newLine();
           bw.write("          <Name>");
           bw.write(entity(paramKommentar.getTranslater().getName()));
           bw.write("</Name>");
           bw.newLine();
           bw.write("        </Uebersetzer>");
           bw.newLine();
           bw.write("        <Copyright>");
           bw.write("" + paramKommentar.getJahr());
           bw.write("</Copyright>");
           bw.newLine();
           bw.write("        <Verlag>");
           bw.write(entity(paramKommentar.getVerlag()));
           bw.write("</Verlag>");
           bw.newLine();
           bw.write("        <Kommentar>");
           bw.write(entity(paramKommentar.getSonstiges()));
           bw.write("</Kommentar>");
           bw.newLine();
           bw.write("        <Version>");
           bw.write("" + paramKommentar.getVersion());
           bw.write("</Version>");
           bw.newLine();
           bw.write("      </Kommentare>");
           bw.newLine();
         }
       
         private String entity(String paramString) {
           String str = "";
       
           for (int i = 0; i < paramString.length(); i++) {
             char c = paramString.charAt(i);
             if (c == '<')
               str = str + "&lt;";
             else if (c == '>')
               str = str + "&gt;";
             else if (c == '&')
               str = str + "&amp;";
             else if (c == '\'')
               str = str + "&apos;";
             else if (c == '"')
               str = str + "&quot;";
             else str = str + c;
           }
           return str;
         }
       }
