import javax.swing.*;

public class DateblockData extends Thread{
	private Buchhalter bh;
	private JFrame f;
	private DateiDaten links, rechts;
	private long Endzeit = System.currentTimeMillis();
  private long Startzeit = System.currentTimeMillis();
  private OrgaTimer timer;
  private int zeileG, zifferG = 0;//G für Global

	public DateblockData(Buchhalter bh, JFrame f, DateiDaten links, DateiDaten rechts){
		super();
		this.bh = bh;
		this.f = f;
		this.links = links;
		this.rechts = rechts;
		timer = new OrgaTimer(this);
	}
	
	@Override public void run(){
		/*
			Wir lassen vorher (noch einmal) testen, ob alles stimmt.
			Und erst dann gehen wir mit der Arbeit los.
		*/
		Startzeit = System.currentTimeMillis();
		TestData td = new TestData(bh, f, links, rechts);
		td.bitteAntworten(this);
		td.start();
		timer.start();
		stups();
	}
	
	public void allesGut(){
		/*
			Yeah! Wir haben Antwort erhalten.
			Los gehts! Jetzt sind wir drann.
		*/		

		sucheDatumsblock();
		
		ende();
	}
		
	
	public void sucheDatumsblock(){
		/*
			Wir suchen alle Zeilen links, welche das gleiche Datum haben mit den Zeilen 
			rechts, mit demselben Datum. Wenn die Summe aller links und aller rechts gleich ist,
			dann werden alle diese Zeilen gelöst.
		
		*/
		int maxZeilenl = links.getZeilen();
		int maxZeilenr = rechts.getZeilen();
		int datuml = links.getWahlDatum();
		int datumr = rechts.getWahlDatum();
		int sollL = links.getWahlSoll();
		int sollR = rechts.getWahlSoll();
		int habenL = links.getWahlHaben();
		int habenR = rechts.getWahlHaben();
		int ziffer = 0;
		int suche = 0;
		boolean nurSollL = (links.getWahlHaben() == -1);
		boolean nurSollR = (rechts.getWahlHaben() == -1);
		boolean treffer = false;
		int[] fundsachenL = new int[maxZeilenl];
		int[] fundsachenR = new int[maxZeilenr];
		int summeL, summeR = 0;

		
		
		
		//Status setzen:
		bh.setMaxVergleich(true, maxZeilenl);
		bh.setStatusVergleich(true, 0);

		//Für den Statusbalken laufen wir einmal durch die Datei links
		for(int i = 0; i < maxZeilenl; i++){
			zeileG = i;
			//Zeile i ist die Zeile, aus der wir das aktuelle Datum holen
			//das machen wir nur, wenn der Status noch unverändert ist:
			boolean weiter = true;
			if(i > 0)
				if(links.istGleichesDatum(i, datuml, links.getText(i-1, datuml)))
					weiter = false;//Gleiches Datum, wie letzte Prüfung
			if(weiter && links.status(i) == 0){
				//Neuer Schleifendurchlauf, deswegen müssen wir erst einmal alle Fundsachen loswerden:
				for(int j = 0; j < maxZeilenl; j++)
							fundsachenL[j] = 0;
				for(int j = 0; j < maxZeilenr; j++)
							fundsachenR[j] = 0;
				summeL = 0;
				summeR = 0;
		
				//Jetzt finden wir alle Zeilen links, die das gleich Datum haben.
				for(int j = 0; j < maxZeilenl; j++){
					if(links.status(j) == 0 && links.istDatum(j,datuml)){
						if(links.istGleichesDatum(i, datuml, links.getText(j, datuml))){
							//GLEICHES DATUM!!!
							fundsachenL[j] = 1;
							summeL = summeL + links.getBuchwert(j);
						}
					}				
				}
				
				//Jetzt finden wir alle Zeilen rechts, die das gleiche Datum haben.
				for(int j = 0; j < maxZeilenr; j++){
					if(rechts.status(j) == 0 && rechts.istDatum(j,datumr)){
						if(links.istGleichesDatum(i, datuml, rechts.getText(j, datumr))){
							//GLEICHES DATUM!!!
							fundsachenR[j] = 1;
							summeR = summeR + rechts.getBuchwert(j);
						}
					}				
				}
				
				//System.out.println(""+i+" Summe links und rechts: "+links.getText(i, datuml)+" "+summeL+" "+summeR);
				
				//Schaun wir mal:
				if(summeL == summeR){
					//Yea! Stimmt!
					ziffer = links.getNextZiffer();
					zifferG = ziffer;
					for(int j = 0; j < maxZeilenr; j++){
						if(fundsachenR[j] != 0){
							rechts.setZiffer(j,ziffer);
							rechts.setStatus(j,DateiDaten.status_GEFUNDEN);
						}
					}
					
					for(int j = 0; j < maxZeilenl; j++){
						if(fundsachenL[j] != 0){
							links.setZiffer(j,ziffer);
							links.setStatus(j,DateiDaten.status_GEFUNDEN);
						}
					}
					
				}
				
			}
			bh.setStatusVergleich(true, i);
		}
				
		bh.setStatusVergleich(true, maxZeilenl);
		bh.progressIntermediate(false, false);
	}
	
	public void stups(){
  	Endzeit = System.currentTimeMillis();
  	bh.setTime(false, Endzeit-Startzeit);
  	bh.setZeilenZiffer(zeileG+1, zifferG);
  }
  
  public void ende(){
  	timer.ende();
  	bh.setZeilenZiffer(zeileG+1, zifferG);
  }
}

