import javax.swing.table.AbstractTableModel;
import java.text.DecimalFormat;

class DateiDatenTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 1L;
	private boolean DEBUG = false;
	private String[] columnNames;
	private int column, row = 0;
	private int visibleZeilen = 0;
	private int genauigkeit = 100;
	private String genautext = "";
	private boolean visible = true;
	private boolean switchvisible = false;
	private DecimalFormat nf = new DecimalFormat();
	
	private DateiDaten daten;
	private DateiDaten unvisibledaten;
  
	public void setData(DateiDaten daten){
		this.daten = daten;
		column = daten.getSpalten()+4;//+ Zeile + Ausziffern + Status + Saldo
		columnNames = new String[column];
		row = daten.getZeilen();
		//Setze Spaltennamen:
		for(int i = 4; i < column; i++)
			columnNames[i] = ""+(i-3);
		columnNames[0] = "Zeile";	
		columnNames[1] = "Status";
		columnNames[2] = "#";
		columnNames[3] = "Saldo";
	}
      
	public int getColumnCount() {
		return columnNames.length;
	}

	public int getRowCount() {
		if(switchvisible && !visible)
			return visibleZeilen;
		else 
			return row;
	}

	public String getColumnName(int col) {
		return columnNames[col];
	}

	public Object getValueAt(int row, int col) {
		if(switchvisible && !visible){
			if(row >= 0 && row < this.row && col >= 0 && col < column){
				if(col == 0){
					return (unvisibledaten.getZeile(row)+1);
				} else if(col == 1){
					return unvisibledaten.getStatus(row);
				} else if(col == 2){
					return unvisibledaten.getZiffer(row);
				} else if(col == 3){
					return intToString(unvisibledaten.getSaldo(row));
				} else {
					return unvisibledaten.getText(row, col-4);
				}
			} 
		} else {
			if(row >= 0 && row < this.row && col >= 0 && col < column){
				if(col == 0){
					return (row+1);
				} else if(col == 1){
					return daten.getStatus(row);
				} else if(col == 2){
					return daten.getZiffer(row);
				} else if(col == 3){
					return intToString(daten.getSaldo(row));
				} else {
					return daten.getText(row, col-4);
				}
			}
		} 
		return "";
	}

  /*
   * JTable uses this method to determine the default renderer/ editor for
   * each cell. If we didn't implement this method, then the last column
   * would contain text ("true"/"false"), rather than a check box.
   */
  //public Class getColumnClass(int c) {
  //  return getValueAt(0, c).getClass();
  //}

  /*
   * Don't need to implement this method unless your table's editable.
   */
	public boolean isCellEditable(int row, int col) {
	//Note that the data/cell address is constant,
	//no matter where the cell appears onscreen.
		if(visible){
			if (col < 3) {
				return true;
			} else {
				return false;
			}
		}
		return false;
	}

  /*
   * Don't need to implement this method unless your table's data can
   * change.
   */
	public void setValueAt(Object value, int row, int col) {
		int i = 0;
		if (DEBUG) {
			System.out.println("Setting value at " + row + "," + col
				+ " to " + value + " (an instance of "
				+ value.getClass() + ")");
		}
	
		if(row >= 0 && row < this.row && col >= 0 && col < column){
			if(col == 0){
				//Nichts, da Zeilennummer
			} else if(col == 1){
				try{
					i = (Integer.parseInt((String)value));
				} catch (NumberFormatException nfe){
					i = 0;
				}
				daten.setStatus(row, i);
			} else if(col == 2){
				try{
					i = (Integer.parseInt((String)value));
				} catch (NumberFormatException nfe){
					i = 0;
				}
				daten.setZiffer(row, i);
			} else {
				//So ginge das. Wir wollen nur nicht die Werte verändern.
				//daten.einlesen(row,col-3,(String)value);
			}
		}

    
		fireTableCellUpdated(row, col);

		if (DEBUG) {
			System.out.println("New value of data:");
			printDebugData();
		}
	}

	private void printDebugData() {
		int numRows = getRowCount();
		int numCols = getColumnCount();

		for (int i = 0; i < numRows; i++) {
			System.out.print("  row " + i + ":");
			/*for (int j = 0; j < numCols; j++) {
				System.out.print("  " + data[i][j]);
			}*/
			System.out.println();
		}
		System.out.println("--------------------------");
	}
  
	public void switchVisible(){
		System.out.println("Switch Visible");
		if(visible){
			visible = false;
			switchvisible = true;
			visibleZeilen = daten.getVisibleZeilen();
			int visibleSpalten = daten.getSpalten();
			unvisibledaten = new DateiDaten(visibleZeilen, visibleSpalten);
			System.out.println("Anzahl visible Zeilen: "+visibleZeilen);
			int wo = 0;
			for(int i = 0; i < visibleZeilen; i++){
				while(wo < daten.getZeilen() && daten.status(wo) != 0){
					//System.out.print("Wo: "+wo+" ");
					wo++;
				}
				//System.out.println("Wo: "+wo+" ");
				//System.out.println();
				for (int j = 0; j < visibleSpalten; j++){
					unvisibledaten.einlesen(i,j,daten.getText(wo, j));
					//System.out.print(" "+daten.getText(wo, j));
				}
				unvisibledaten.setZeile(wo, i);
				//System.out.println("unvisibledaten.setZeile("+wo+", "+i+");");
				wo++;
			}
			daten.setInvinsible(unvisibledaten);
		} else {
			visible = true;
		}
	}
  
	public boolean isVisible(){
		return visible;
	}
	
	public String tausender(int zahl){
		String tausender = ""+nf.format(zahl);
		return tausender;
	}
	
	public String intToString(int wert){
		int genauigkei = genauigkeit;//Sonst nur Ärger
		boolean unterNull = (wert < 0);
		int betrag = wert;
		String text = "";
		if(unterNull)
			betrag = -wert;
		else
			betrag = wert;
  	
		if(betrag == 1) genauigkei = genauigkeit -1;
		text = ""+tausender(betrag/genauigkei);
					
					
		String genautext = "";
		int genau = genauigkei;
		String vortext = "";//0en zwischen Komma und Wert sonst:(0,005) -> (0,5)
		if(betrag == 0){
			text = "0,00";
		} else {
			int nullgenau = genauigkei/betrag;
			if ((nullgenau == 0) && (betrag-(betrag/genauigkei)*genauigkei > 0))
   			nullgenau = genauigkei/(betrag-(betrag/genauigkei)*genauigkei);
			while(nullgenau > 10){
				vortext = vortext + "0";
				nullgenau = nullgenau / 10;
			}
	
			while(genau > 10){
				genautext = genautext + "0";
				genau = genau / 10;
			}
	
			if((betrag % genauigkei) != 0){
				text = text + ","+vortext+ (betrag % genauigkei);
			}	else 
				text = text + ","+genautext+"0"; 
			if(unterNull)
				text = "-"+text;
		}
		//System.out.println("Wert: "+wert+" Text: "+text);
		return text;
	}

}

