import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.io.File;
import java.io.PrintStream;
import javax.swing.*;

public class DateiOrganisator extends Thread{
	private Buchhalter bh;
	private JFrame f;
	private File file;
	private boolean links;
	private int ladeWas = 0;
	private int semikolon = 0;
	private int zeilen = 0;
	private boolean fehler = false;
	private DateiDaten daten;
	private boolean keinDatum = false;
	private boolean keinSoll = false;
	private boolean ignoreFirst = false;
	private int fehlerzeile = 0;
	private boolean datev = false;
	private Vector<String> konten = new Vector<String>();
	private Vector<String> sortkonten = new Vector<String>();
	private String encodingEingabe = "";

	
	public DateiOrganisator(Buchhalter bh, JFrame f, File file, int ladeWas, boolean ignoreFirst, String encodingEingabe){
		super();
		this.bh = bh;
		this.f = f;
		this.file = file;
		this.ladeWas = ladeWas;
		if(Buchhalter.TABLINKS == ladeWas) links = true;
		this.ignoreFirst = ignoreFirst;
		//System.out.println("Ignore Seniore: "+ignoreFirst+" "+ignoreFirst);
		this.encodingEingabe = encodingEingabe;
	}
	
	@Override public void run(){
		//Semikolon und Zeilen zählen
		try{
			//FileReader fr = new FileReader(file);
			//BufferedReader br = new BufferedReader(fr);
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file), encodingEingabe));
			String zeile;
			fehler = false;
			boolean notFirst = !ignoreFirst;
			boolean ersteZeile = true;
			boolean zweiteZeile = true;
			int jahr = 2020;
			String konto ="";
			String gegen ="";
			String wunsch ="";
			boolean hurenkind = false;
			int counter = 0;
			boolean drinn = false;
			char c=';';// das zu zählende Zeichen
			char d='"';// Das Anführungszeichen als Einschluss
			boolean weiter = true;
  	  
  	  
			while( !fehler && (zeile = br.readLine()) != null ){
				//System.out.println("Zeile: ->"+zeile+"<-");
				if(ersteZeile){
					datev = pruefeDatev(zeile);
					if(datev){
						notFirst = false;
					}
					ersteZeile = false;
				} else {
					if(datev && zweiteZeile){
						notFirst = false;
						zweiteZeile = false;
					}
				}
				if(notFirst){
					counter = 0;
					drinn = false;
					weiter = true;
					while(weiter){
						for(int i=0; i < zeile.length();i++){
							//Jetzt überprüfen, ob "AH;bb";12;13; ein Semikolon mehr produziert
							if(zeile.charAt(i)==d){
								if(drinn)
									drinn = false;
								else
									drinn = true;
							}
							if(!drinn && (zeile.charAt(i)==c)) counter++;
						}
						if(drinn && (zeile = br.readLine()) != null ){
							//Dann haben wir noch einen Zeilenumbruch im Text
							//Hier würden wir schnell zeilegesamt = zeilegesamt +zeile schreiben
						} else {
							weiter = false;
						} 
					}
					if(0 == semikolon)
						semikolon = counter;
					else {
						if(semikolon != counter){
							//Abbruch: Semikolonanzahl ungleich
							fehler = true;
							fehlerzeile = zeilen; 
							System.out.println("Fehler in Zeile: "+fehlerzeile+" Semikolon: "+semikolon+" Counter: "+counter);
						} else {
							if(datev){
								String[] split = zeile.split(";");
								konten.addElement(split[6]);
								konten.addElement(split[7]);
							}
						}
					}
					zeilen++;
				}
				notFirst = true;
			}
			br.close();
  	  
  	  
			if(fehler){
				bh.endeDatei(links);
				JOptionPane.showMessageDialog(f, "Es gab einen Fehler in der Zeile:"+(zeilen)+"\n\nUnterschiedliche Anzahl Semikolon!", "Inputfehler", JOptionPane.WARNING_MESSAGE);
			}
			//System.out.println("Zeilen: "+zeilen+"\nSemikolonen: "+semikolon);
  	  
			if(!fehler && zeilen > 0 && semikolon > 0){
				if(datev){
				sortiereVector();
				int antwort = kontoDialog();
  	  	
				wunsch = sortkonten.elementAt(antwort);
				}
				//if(ignoreFirst) Bug, da sonst 2x abgezogen wird.
				//	zeilen--;
				if(Buchhalter.TABLINKS == ladeWas || Buchhalter.TABRECHTS == ladeWas){
					bh.setMaxVergleich(links, zeilen);
					bh.setStatusVergleich(links, 0);
					bh.progressIntermediate(links, false);
				}
				switch(ladeWas){
					case Buchhalter.TABLINKS:
					case Buchhalter.TABRECHTS:
						bh.setMaxVergleich(links, zeilen);
						bh.setStatusVergleich(links, 0);
						bh.progressIntermediate(links, false);
						break;
					case Buchhalter.TABSALDO:
						bh.setMaxVergleich(Buchhalter.TABSALDO, zeilen);
						bh.setStatusVergleich(Buchhalter.TABSALDO, 0);
						bh.progressIntermediate(Buchhalter.TABSALDO, false);
						break;
				}
  	  	
				daten = new DateiDaten(zeilen, semikolon+1);
  	  	
				//JETZT GEHT ES LOS:
				//fr = new FileReader(file);
				//br = new BufferedReader(fr);
				br = new BufferedReader(new InputStreamReader(new FileInputStream(file), encodingEingabe));
				int zeilennummer = 0;
				notFirst = !ignoreFirst;
				//System.out.println("ignore First: notFirst:: "+ignoreFirst+" "+notFirst);
				ersteZeile = true;
				zweiteZeile = true;
				boolean zusammengesetzt = false;
				String zeilegesamt = "";
				while( !fehler && (zeile = br.readLine()) != null ){
					//System.out.println("Zeile: ->"+zeile+"<-");
					counter = 0;
					zeilegesamt = zeile;
					weiter = true;
					while(weiter){
						for(int i=0; i < zeile.length();i++){
							//Jetzt überprüfen, ob "AH;bb";12;13; ein Semikolon mehr produziert
							if(zeile.charAt(i)==d){
								if(drinn)
									drinn = false;
								else
									drinn = true;
							}
							if(!drinn && (zeile.charAt(i)==c)) counter++;
						}
						if(drinn && (zeile = br.readLine()) != null ){
							//Dann haben wir noch einen Zeilenumbruch im Text
							//Hier würden wir schnell zeilegesamt = zeilegesamt +zeile schreiben
							zeilegesamt = zeilegesamt + zeile;
							zusammengesetzt = true;
						} else {
							weiter = false;
						} 
					}
					if(zusammengesetzt){
						zeile = zeilegesamt;
					}
					/*
					System.out.println("Zeilegesamt: ->"+zeile+"<-");
					System.out.println("Zeilen von weit: "+zeilen);
					System.out.println("Counter: "+counter);
					*/
					//Ab sofort immer von Hand!
					String[] split = zeile.split(";");
					zusammengesetzt = true;
					
					
					if(zusammengesetzt){
						zusammengesetzt = false;
					//if(split.length != counter){
								
						//Siehe oben. Split muss zusammengesetzt werden.
						split = new String[counter+1];
						int rein = 0;
						int raus = 0;
						int ohneRein = 0;
						int wo = 0;//Welcher String
						boolean wardrinn = false;
						for(int i=0; i < zeile.length();i++){
							//Jetzt überprüfen, ob "AH;bb";12;13; ein Semikolon mehr produziert
							if(zeile.charAt(i)==d){
								if(drinn){
									drinn = false;
									raus = i;
								} else {
									//Wir kommen rein
									drinn = true;
									rein = i;
									wardrinn = true;
								}
							}
							if(!drinn && (zeile.charAt(i)==c)) {
								if(wo < counter){
									if(wardrinn){
										if(rein+1>raus)
											split[wo] = "";
										else
											split[wo] = zeile.substring(rein+1,raus);
									
									} else {
										split[wo] = zeile.substring(ohneRein,i);
									}
									wo++;
								}
								ohneRein = i+1;
								wardrinn = false;
							}
							//System.out.println("Wo: "+wo+" Raus: "+raus+" Rein\": "+rein+" ohneRein: "+ohneRein+" Länge: "+zeile.length());
						}
						if(ohneRein < zeile.length()){
							if(zeile.charAt(ohneRein) == d)
								split[wo] = zeile.substring(ohneRein+1,zeile.length()-1);
							else
								split[wo] = zeile.substring(ohneRein,zeile.length());
						}
					} else {
						for(int i = 0; i < split.length; i++){
							if(split[i].length() > 0){
								if(split[i].charAt(0)==d && split[i].charAt(split[i].length()-1)==d){
									if(split[i].length() > 2)
										split[i] = split[i].substring(1,split[i].length()-1);
									else 
										split[i] = "";
								}
							}
						}
					}
					
					
					
					
					
					
					
					
					
					
					
					if(datev){
						if(ersteZeile){
							if(datev){
								notFirst = false;
								try{
									jahr = Integer.parseInt(split[14].substring(0,4));
									//System.out.println("Jahr; "+jahr);
								} catch (NumberFormatException e){
									jahr = 2020;
								}
							}
							ersteZeile = false;
						} else {
							if(zweiteZeile){
								notFirst = false;
								zweiteZeile = false;
							} else {
	  	 					
								//Gewünschtes Konto
								konto = split[6];
								gegen = split[7];
								//wunsch = "1201";
								if(wunsch.equals(konto) || wunsch.equals(gegen)){
									//Alles gut
									hurenkind = false;
	  	 					
									//Datum anpassen
									String tag = split[9].substring(0,2);
									String monat = split[9].substring(2,4);
									//System.out.println("Split 9: "+split[9]+" -- "+tag+"."+monat+"."+jahr);
									split[9] = tag+"."+monat+"."+jahr;
		  	 					
									//Betrag anpassen
									String betrag = split[0];
									String sollHaben = split[1];
									if((wunsch.equals(gegen) && (sollHaben.equals("\"S\""))) || (wunsch.equals(konto) && (sollHaben.equals("\"H\""))))
										split[0] = "-"+betrag;
										//else
										//	System.out.println("SollHaben: "+sollHaben+" "+split[0]);
								} else {
									//Kein gewünschtes Konto vorhanden
									hurenkind = true;
								}
							}
						}
					}
					if(notFirst && !hurenkind){
						//System.out.println("Zeilennummer: "+zeilennummer+ " split.length: "+split.length);
						/*
						for(int i = 0; i < split.length; i++){
							System.out.println("["+i+"] "+split[i]);
						}
						*/
						daten.einlesen(zeilennummer, split);
						if(datev){
		  	  		
						} else {
							keinDatum = !daten.istDatum(zeilennummer);
							keinSoll = !daten.istSollHaben(zeilennummer);
						}
						zeilennummer++;
					}
//	  			  	if(notFirst)
					notFirst = true;
					bh.setStatusVergleich(ladeWas, zeilennummer);
					//bh.setStatusVergleich(links, zeilennummer);
				}
				if(ignoreFirst)
					bh.setStatusVergleich(ladeWas, (zeilennummer+1));
				//DateiDatenModell erstellen
				daten.setDatev(datev, zeilennummer);
				DateiDatenTableModel ddm = new DateiDatenTableModel();
				ddm.setData(daten);
				bh.setDateiDatenModel(ladeWas, links, ddm, daten);
				br.close();
			} else {
				System.out.println("kein BH!");
				if(!fehler)
					JOptionPane.showMessageDialog(f, "Keine Zeilen oder Spalten\nZeile: "+zeilen+"\nSpalten: "+semikolon, "Inputfehler", JOptionPane.WARNING_MESSAGE);
				fehler = true;
			}
			if(keinDatum){
				JOptionPane.showMessageDialog(f, "Nicht alle Zeilen enthalten ein Datum", "Inputfehler", JOptionPane.WARNING_MESSAGE);
			}
  	  
			bh.endeDatei(links);
		} catch (IOException ioex){
			ioex.printStackTrace();
			//JOptionPane.showMessageDialog(null, "Buchhalter.jar\nvon\nSebastian Müller\n\nhttp://sebamueller.de/programme/buchhalter\n\nVersion: ");
			JOptionPane.showMessageDialog(f, "Es gab einen Fehler bei der Datei:\n"+file.getAbsolutePath(), "Dateifehler", JOptionPane.ERROR_MESSAGE);
		} catch (Exception e){
			e.printStackTrace();
			System.err.println("Es gab einen Fehler bei der Datei:\n"+file.getAbsolutePath()+"\n"+e.toString()+"\n"+e.getMessage());
			JOptionPane.showMessageDialog(f, "Es gab einen Fehler bei der Datei:\n"+file.getAbsolutePath()+"\n"+e.toString(), "Dateifehler", JOptionPane.ERROR_MESSAGE);
		}
		bh.setMaxVergleich(links, 100);
		bh.setStatusVergleich(links, 100);
		bh.progressIntermediate(links, false);
	}
	
	private boolean pruefeDatev(String zeile){
		boolean datev = false;
		datev = "\"EXTF\"".equals(zeile.substring(0,6));
		if(datev)
			System.out.println("JAAA, es ist DATEV!");
		return datev;
	}
	
	private void sortiereVector(){
		int max = konten.size();
		String[] konto = new String[max];
		
//		for(int i = 0; i < konten.size(); i++)
//				System.out.println("konten["+i+"]: "+konten.elementAt(i));
		
		String text = "";
		try{
			konto[0] = konten.firstElement();
			for(int i = 1; i < max; i++){
				boolean einzigartig = true;
				int j = 0;
				text = konten.elementAt(i);
				while(einzigartig && j < i){
					if(text.equals(konto[j])){
						einzigartig = false;
						//System.out.println("Falsch: "+text+" "+konto[j]);
					}
					j++;
				}
				if(einzigartig){
					//jetzt einsortieren
					//sortkonten = new Vector<String>();
					//System.out.println("richtig: "+text+" "+konto[j]);
					if(sortkonten.isEmpty()){
						sortkonten.addElement(text);
						//System.out.println("erster: "+text+" "+konto[j]);
					} else {
						//System.out.println("quatsch: "+text+" "+konto[j]);
						boolean hinten = true;
						for(int k = 0; k < sortkonten.size(); k++)
							//if(sortkonten.elementAt(k).compareTo(text)>0){
							if(Integer.parseInt(sortkonten.elementAt(k)) > Integer.parseInt(text)){
								sortkonten.insertElementAt(text,k);
								k = sortkonten.size();
								hinten = false;
							}
							if(hinten)
								sortkonten.addElement(text);
					}
					konto[i] = text;
				} else {
					konto[i] = "";
				}
			}
//			for(int i = 0; i < sortkonten.size(); i++)
//				System.out.println("Sortkonten["+i+"]: "+sortkonten.elementAt(i));
		} catch (ArrayIndexOutOfBoundsException e){
			System.err.println("Schwerer Fehler: Außerhalb des Vectors!\nMax: "+max);
		} catch (NumberFormatException nfe){
			System.err.println("Schwerer Fehler: Konto nicht als Integer darstellbar!");
		}
	}
	
	private int kontoDialog(){
		String text = "";
		int antwort = 0;
		String[] possibilities = new String[sortkonten.size()];
		for(int i = 0; i < sortkonten.size(); i++)
			possibilities[i] = new String(sortkonten.elementAt(i));
		text = (String)JOptionPane.showInputDialog(
                    f,
                    "Auswahl des Kontos:",
                    "Customized Dialog",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    possibilities,
                    "ham");

		if ((text != null) && (text.length() > 0)) {
			for(int i =0; i < sortkonten.size(); i++)
				if(sortkonten.elementAt(i).equals(text))
					antwort = i;
		} else {
			System.out.println("Keine Auswahl ist auch eine Auswahl");
			antwort = 0;
		}	
		return antwort;
	}
	
}

