import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.io.File;
import java.io.PrintStream;
import javax.swing.*;

public class DatevOrganisator extends Thread{
	private Buchhalter bh;
	private JFrame f;
	private File[] selectedFiles;
	private String dateiName = "";
	private int anzahlFiles = 0;
//	private boolean links;
	private int semikolon = 0;
	private int zeilen = 0;
	private String zeile = "";
	private int maxZeilen = 0;
	private boolean fehler = false;
	private DatevDaten daten;
	private int fehlerzeile = 0;
	private boolean datev = false;
	private Vector<String> konten = new Vector<String>();
	private Vector<String> sortkonten = new Vector<String>();
	private boolean fullOn = false;//Debugausgabe
	
	//Daten:
	//private int jahr, monat, tag;
	private int betrag;
	private int soll;
	private int haben;
	private String beleg1;
	private String beleg2;
	private short tag;
	private short monat;
	private short jahr;
	private String text;
	private boolean sollHaben;
	private Buchung buchung;
	private String encoding = "";

	
	public DatevOrganisator(Buchhalter bh, JFrame f, File[] selectedFiles, String encoding){
		super();
		this.bh = bh;
		this.f = f;
		this.selectedFiles = selectedFiles;
		this.encoding = encoding;
	}
	
	@Override public void run(){
		daten = null;
		//Semikolon und Zeilen zählen
		anzahlFiles = selectedFiles.length;
		int lastzeile = 0;
		String[] split;
		if(fullOn)
			System.out.println("Anzahl Dateien: "+anzahlFiles);
		bh.datevProgressIntermediate(false);
		bh.setDatevMax(anzahlFiles);
		try{
			for(int filezaehler = 0; filezaehler < anzahlFiles; filezaehler++){
				//Wir gehen Schritt für Schritt durch alle Dateien.
				bh.setDatevStatus(filezaehler);
				dateiName = selectedFiles[filezaehler].getAbsolutePath();
				//FileReader fr = new FileReader(selectedFiles[filezaehler]);
				//BufferedReader br = new BufferedReader(fr);
				BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(selectedFiles[filezaehler]), encoding));

				//Zuerst alle Zeilen und Semikolonnen zählen
				char c=';';// das zu zählende Zeichen
				char d='"';// Das Anführungszeichen als Einschluss
				char s='S';// 
				int counter = 0;
				zeilen = 0;
				maxZeilen = 0;
				boolean drinn = false;
				boolean peterMaffay = false;//Kein Problem
				while( !fehler && (zeile = br.readLine()) != null ){
					peterMaffay = true;
					counter = 0;
					drinn = false;
					for(int i=0; i < zeile.length();i++){
						//Jetzt überprüfen, ob "AH;bb";12;13; ein Semikolon mehr produziert
						if(zeile.charAt(i)==d){
							if(drinn)
								drinn = false;
							else
								drinn = true;
						}
						if(!drinn && (zeile.charAt(i)==c)) counter++;
					}
					if(zeilen < 1){
						//Datev Zeile 1 interessiert noch nicht.
						
						if(fullOn)
							System.out.println(""+dateiName+" Zeile: "+zeilen+"; Semikolon: "+counter);
						
					} else {
						//Zeile 2 sind die Überschriften, ab Zeile 3 sind die Daten vorhanden
						if(0 == semikolon)
							semikolon = counter;
						else {
							if(semikolon != counter){
								
								
								//Abbruch: Semikolonanzahl ungleich
								fehler = true;
								fehlerzeile = zeilen; 
								System.err.println(""+dateiName+" Fehler in Zeile: "+fehlerzeile+" Semikolon: "+semikolon+" Counter: "+counter);
								JOptionPane.showMessageDialog(f, "Es gab einen Fehler bei der Datei:\n"+dateiName+"\nFehler in Zeile: "+fehlerzeile+" Semikolon: "+semikolon+" Counter: "+counter, "Dateifehler", JOptionPane.ERROR_MESSAGE);
								semikolon = counter;
							} 
						}
					}
					zeilen++;
					maxZeilen++;
				}
				if(fullOn)
					System.out.println(""+dateiName+" Zeilen: "+zeilen+" "+semikolon);
				br.close();
				//fr.close();
				if(!peterMaffay)
					fehler = true;
				
				if(!fehler){
					/*
						Damit wissen wir, dass kein Fehler passiert ist.
						Wenn also mehr Semikolonnen auftauchen als gewünscht, dann
						sind diese escaped.
					*/
					//Datenfelder anlegen.
					boolean weiter = true;
					daten = new DatevDaten(daten, zeilen-1);//Überschriften bitte nicht
					
					//fr = new FileReader(selectedFiles[filezaehler]);
					//br = new BufferedReader(fr);
					br = new BufferedReader(new InputStreamReader(new FileInputStream(selectedFiles[filezaehler]), encoding));
					//Jetzt gehen wir durch die Datei
					zeilen = 0;
					while( !fehler && (zeile = br.readLine()) != null ){
						//115 Semikolonnen sind ok für eine Zeile
						
						if(zeilen == 0){
							split = zeile.split(";");
							jahr = Short.parseShort(split[12].substring(0,4));
							//System.out.println("Jahr: "+jahr);
						} else {
							split = zeile.split(";");
							//System.err.println("Split.length: "+ split.length);
							if(split.length != 114){
								
								//Siehe oben. Split muss zusammengesetzt werden.
								split = new String[114];
								int rein = 0;
								int raus = 0;
								int ohneRein = 0;
								int wo = 0;//Welcher String
								boolean wardrinn = false;
								for(int i=0; i < zeile.length();i++){
									//Jetzt überprüfen, ob "AH;bb";12;13; ein Semikolon mehr produziert
									if(zeile.charAt(i)==d){
										if(drinn){
											drinn = false;
											raus = i;
										} else {
											//Wir kommen rein
											drinn = true;
											rein = i;
											wardrinn = true;
										}
									}
									if(!drinn && (zeile.charAt(i)==c)) {
										if(wo < 114){
											if(wardrinn){
												if(rein+1>raus)
													split[wo] = "";
												else
													split[wo] = zeile.substring(rein+1,raus);
											
											} else {
												split[wo] = zeile.substring(ohneRein,i);
											}
											wo++;
										}
										ohneRein = i+1;
										wardrinn = false;
									}
								}
							} else {
								for(int i = 0; i < split.length; i++){
									if(split[i].length() > 0){
										if(split[i].charAt(0)==d && split[i].charAt(split[i].length()-1)==d){
											if(split[i].length() > 2)
												split[i] = split[i].substring(1,split[i].length()-1);
											else 
												split[i] = "";
										}
									}
								}
							}
							
							if(fullOn){
								if(zeilen > 1 && zeilen < 4)
									for(int i = 0; i < 114; i++)
										System.out.println("split["+i+"]= \""+split[i]+"\"");
							}
							
							if(zeilen > 1){
								betrag = daten.stringToInt(split[0]);
								if(split[6] == "")//Konto
									soll = 0;
								else
									soll = Integer.parseInt(split[6]);
								if(split[7] == "")//Gegenkonto
									haben = 0;
								else 
									haben = Integer.parseInt(split[7]);
								beleg1 = split[10];
								beleg2 = split[11];
								if(split[9].length() < 4)
									split[9] = "0"+split[9];//Da hat wohl jemand mit Excel gespielt
								tag = Short.parseShort(split[9].substring(0,2));
								monat = Short.parseShort(split[9].substring(2,4));
								text = split[13];
								if(split[1].charAt(0)==s)
									sollHaben = true;
								else
									sollHaben = false;
								//Wenn alles klappt:				
								//Buchung(int betrag, short soll, short haben, String beleg1, String beleg2, short tag, short monat, short jahr, String text, boolean sollHaben){
								if(fullOn){
									if(zeilen > 1 && zeilen < 4){
										if(sollHaben)
											System.out.println("Zeile: "+zeilen+" B:"+betrag+" S/H: S K:"+soll+" H:"+haben+" B1: "+beleg1+" B2: "+beleg2+"\nTag: "+tag+" Monat: "+monat+" Jahr: "+jahr+"\n"+text);
										else 
											System.out.println("Zeile: "+zeilen+" B:"+betrag+" S/H: H K:"+soll+" H:"+haben+" B1: "+beleg1+" B2: "+beleg2+"\nTag: "+tag+" Monat: "+monat+" Jahr: "+jahr+"\n"+text);
									}
								}
								//Soll = Konto Haben = Gegenkonto H-> Konto im Haben -> Soll = im Haben  S-> Konto im Soll -> im Soll
								buchung = new Buchung(betrag, soll, haben, beleg1, beleg2, tag, monat, jahr, text, sollHaben);
								daten.setBuchung(buchung);
							}
						}
						zeilen++;
					}
				
					br.close();
					//fr.close();
				}
				
				semikolon = 0;
			}			
		} catch (IOException ioex){
			ioex.printStackTrace();
			JOptionPane.showMessageDialog(f, "Es gab einen Fehler bei der Datei:\n"+dateiName, "Dateifehler", JOptionPane.ERROR_MESSAGE);
		} catch (Exception e){
			System.err.println("Es gab einen Fehler bei der Datei:\n"+dateiName+"\n"+e.toString()+"\n"+e.getMessage());
			e.printStackTrace();
			JOptionPane.showMessageDialog(f, "Es gab einen Fehler bei der Datei:\n"+dateiName+"\n"+e.toString(), "Dateifehler", JOptionPane.ERROR_MESSAGE);
		}

		bh.datevProgressIntermediate(true);
		bh.setDatevStatus(anzahlFiles);
		if(!fehler){
			daten.kontieren();
			bh.datevGeladen(daten);
		}
		bh.datevProgressIntermediate(false);
	}
	
	private boolean pruefeDatev(String zeile){
		boolean datev = false;
		datev = "\"EXTF\"".equals(zeile.substring(0,6));
		System.out.println("JAAA, es ist DATEV!");
		return datev;
	}
	
	private void sortiereVector(){
		int max = konten.size();
		String[] konto = new String[max];
		
//		for(int i = 0; i < konten.size(); i++)
//				System.out.println("konten["+i+"]: "+konten.elementAt(i));
		
		String text = "";
		try{
			konto[0] = konten.firstElement();
			for(int i = 1; i < max; i++){
				boolean einzigartig = true;
				int j = 0;
				text = konten.elementAt(i);
				while(einzigartig && j < i){
					if(text.equals(konto[j])){
						einzigartig = false;
						System.out.println("Falsch: "+text+" "+konto[j]);
					}
					j++;
				}
				if(einzigartig){
					//jetzt einsortieren
					//sortkonten = new Vector<String>();
					//System.out.println("richtig: "+text+" "+konto[j]);
					if(sortkonten.isEmpty()){
						sortkonten.addElement(text);
						//System.out.println("erster: "+text+" "+konto[j]);
					} else {
						//System.out.println("quatsch: "+text+" "+konto[j]);
						boolean hinten = true;
						for(int k = 0; k < sortkonten.size(); k++)
							//if(sortkonten.elementAt(k).compareTo(text)>0){
							if(Integer.parseInt(sortkonten.elementAt(k)) > Integer.parseInt(text)){
								sortkonten.insertElementAt(text,k);
								k = sortkonten.size();
								hinten = false;
							}
							if(hinten)
								sortkonten.addElement(text);
					}
					konto[i] = text;
				} else {
					konto[i] = "";
				}
			}
//			for(int i = 0; i < sortkonten.size(); i++)
//				System.out.println("Sortkonten["+i+"]: "+sortkonten.elementAt(i));
		} catch (ArrayIndexOutOfBoundsException e){
			System.err.println("Schwerer Fehler: Außerhalb des Vectors!\nMax: "+max);
		} catch (NumberFormatException nfe){
			System.err.println("Schwerer Fehler: Konto nicht als Integer darstellbar!");
		}
	}
	
	private int kontoDialog(){
		String text = "";
		int antwort = 0;
		String[] possibilities = new String[sortkonten.size()];
		for(int i = 0; i < sortkonten.size(); i++)
			possibilities[i] = new String(sortkonten.elementAt(i));
		text = (String)JOptionPane.showInputDialog(
                    f,
                    "Auswahl des Kontos:",
                    "Customized Dialog",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    possibilities,
                    "ham");

		if ((text != null) && (text.length() > 0)) {
			for(int i =0; i < sortkonten.size(); i++)
				if(sortkonten.elementAt(i).equals(text))
					antwort = i;
		} else {
    	System.out.println("Keine Auswahl ist auch eine Auswahl");
    	antwort = 0;
		}	
		return antwort;
	}
	
}

