import javax.swing.*;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.*;

public class EncodingSelector {

	JComboBox<String> comboBoxEingabe;
	JComboBox<String> comboBoxAusgabe;
	List<String> finalEncodingList;
	private int encodingEingabeNumber = 0;
	private int encodingAusgabeNumber = 0;
	private int maxEncoding = 4;//Die Standardvier sind auf jeden Fall dabei



	public EncodingSelector(){
		//Now
		// Die bevorzugten Encodings
		List<String> preferredEncodings = Arrays.asList("UTF-8", "UTF-16", "windows-1252", "ISO-8859-1");

		// Alle verfügbaren Encodings abrufen
		Map<String, Charset> allCharsets = Charset.availableCharsets();

		// Die restlichen Encodings filtern und alphabetisch sortieren
		List<String> remainingEncodings = new ArrayList<>(allCharsets.keySet());
		remainingEncodings.removeAll(preferredEncodings);
		Collections.sort(remainingEncodings);

		// Kombinieren: bevorzugte zuerst, dann die restlichen
		finalEncodingList = new ArrayList<>();
		for (String enc : preferredEncodings) {
		    if (allCharsets.containsKey(enc)) {
				finalEncodingList.add(enc);
		    }
		}
		finalEncodingList.addAll(remainingEncodings);
		maxEncoding = finalEncodingList.size();

		// GUI anzeigen
		comboBoxEingabe = new JComboBox<>(finalEncodingList.toArray(new String[0]));
		comboBoxAusgabe = new JComboBox<>(finalEncodingList.toArray(new String[0]));


    	/* //Easy
		Map<String, Charset> encodings = Charset.availableCharsets();
		JComboBox<String> comboBox = new JComboBox<>(encodings.keySet().toArray(new String[0]));

		int result = JOptionPane.showConfirmDialog(null, comboBox, "Wähle ein Encoding", JOptionPane.OK_CANCEL_OPTION);
		if (result == JOptionPane.OK_OPTION) {
			String selectedEncoding = (String) comboBox.getSelectedItem();
			System.out.println("Gewähltes Encoding: " + selectedEncoding);

			// Beispiel: Datei mit gewähltem Encoding öffnen
			try (BufferedReader reader = new BufferedReader(
				    new InputStreamReader(new FileInputStream("datei.txt"), selectedEncoding))) {
				String line;
				while ((line = reader.readLine()) != null) {
				    System.out.println(line);
				}
			} catch (Exception e) {
				e.printStackTrace();
		    }
		}
		*/
	}

    public JComboBox<String> getEingabeEncodingComboBox(){
    	return comboBoxEingabe;
	}

	public JComboBox<String> getAusgabeEncodingComboBox(){
    	return comboBoxAusgabe;
	}

	public void setEingabeEncoding(int i){
		if(i >= 0 && i < maxEncoding)
			encodingEingabeNumber = i;
	}

	public String getEingabeEncoding(){
		return finalEncodingList.get(encodingEingabeNumber);
	}

	public void setAusgabeEncoding(int i){
		if(i >= 0 && i < maxEncoding)
			encodingAusgabeNumber = i;
	}

	public String getAusgabeEncoding(){
		return finalEncodingList.get(encodingAusgabeNumber);
	}
}
