public class Konto{
	private int nummer = 0;
	private int maxBuchungen = 1000;
	private int id = 0;
	private Buchung[] primanota = new Buchung[maxBuchungen];//Reale Buchungen
	private int[] salden = new int[maxBuchungen];// fortlaufender Saldo real negativ
	private int[] index = new int[maxBuchungen];//Indexnummer der Buchung wird nicht in der Buchung gespeichert.
	private String name = "";
	private int kategorie = 0;//Nummer beim Laden
	private int susaSoll = 0;
	private int susaHaben = 0;
	private int ab = 0;//Anfangsbestand
	private int eb = 0;//Endbestand
	
	
	public Konto(int nummer){
		if(nummer >= 0)
			this.nummer = nummer;
		salden[0] = 0;
	}
	
	
	public void neueBuchung(Buchung buch, int ind){
		if(id > maxBuchungen-2){
			datenErhoehen();
		}
		int saldo = 0;
		if(id > 0)
			saldo = salden[id-1];
		primanota[id] = buch;
		index[id] = ind;
		/*
		if(buch.getBetrag() == 300000 && nummer == 1360)
			System.out.print(buch.writeXML());
		*/
		boolean paranoid = false;
		if(primanota[id].getSoll() == nummer){//Soll = Wir sind Konto
			if(primanota[id].getSollHaben()){//Konto soll im Soll sein
				saldo = saldo + buch.getBetrag();
				susaSoll = susaSoll + buch.getBetrag();
				if(paranoid)
					System.out.println("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
				paranoid = true;
			} else {
				if(paranoid)
					System.out.println("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
				paranoid = true;
				saldo = saldo - buch.getBetrag();//Konto soll im Haben sein
				susaHaben = susaHaben + buch.getBetrag();
			}
			/*if(buch.getBetrag() == 300000 && nummer == 1360)
				System.out.println(" SOLL  "+id);*/
		} else if(primanota[id].getHaben() == nummer){//Haben = Wir sind Gegenkonto
			if(primanota[id].getSollHaben()){//Konto soll im Soll sein, Gegenkonto im Haben
				if(paranoid)
					System.out.println("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
				paranoid = true;
				saldo = saldo - buch.getBetrag();
				susaHaben = susaHaben + buch.getBetrag();
			} else {
				if(paranoid)
					System.out.println("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
				paranoid = true;
				saldo = saldo + buch.getBetrag();//Konto soll im Haben sein, Gegenkonto im Soll
				susaSoll = susaSoll + buch.getBetrag();
			}
			/*
			saldo = saldo - buch.getBetrag();
			susaHaben = susaHaben + buch.getBetrag();
			if(buch.getBetrag() == 300000 && nummer == 1360)
				System.out.println(" HABEN  "+id);*/
		}
		salden[id] = saldo;
		id++;
	}
	
	private void neuerSaldo(int anfangsbestand){
		int saldo = anfangsbestand;
		susaSoll = 0;
		susaHaben = 0;
		//Durch alle Salden rennen und neuen Werte ermitteln
		for(int i = 0; i < id; i++){
			if(primanota[i].getSoll() == nummer){
				if(primanota[i].getSollHaben()){
					saldo = saldo + primanota[i].getBetrag();
					susaSoll = susaSoll + primanota[i].getBetrag();
				} else {
					saldo = saldo - primanota[i].getBetrag();
					susaHaben = susaHaben + primanota[i].getBetrag();
				}
			} else if(primanota[i].getHaben() == nummer){
				if(primanota[i].getSollHaben()){
					saldo = saldo - primanota[i].getBetrag();
					susaHaben = susaHaben + primanota[i].getBetrag();
				} else {
					saldo = saldo + primanota[i].getBetrag();
					susaSoll = susaSoll + primanota[i].getBetrag();
				}
			}
			salden[i] = saldo;
		}
		
	}
			
	public int getZeile(int zeile){
		int raus = 0;
		if(zeile >= 0 && zeile < id)
			raus = zeile;
		return raus;
	}
	
	private void datenErhoehen(){
		//Kopierfeld 
		Buchung[] tausch = new Buchung[maxBuchungen];
		System.arraycopy(primanota, 0, tausch, 0, maxBuchungen);
		primanota = new Buchung[maxBuchungen + 1000];
		System.arraycopy(tausch, 0, primanota, 0, maxBuchungen);
		
		
		//Salden müssen noch erhöht werden.
		int[] tauschSalden = new int[maxBuchungen];
		System.arraycopy(salden, 0, tauschSalden, 0, maxBuchungen);
		salden = new int[maxBuchungen + 1000];
		System.arraycopy(tauschSalden, 0, salden, 0, maxBuchungen);
		
		int[] tauschIndex = new int[maxBuchungen];
		System.arraycopy(index, 0, tauschIndex, 0, maxBuchungen);
		index = new int[maxBuchungen + 1000];
		System.arraycopy(tauschIndex, 0, index, 0, maxBuchungen);
		
		maxBuchungen = maxBuchungen + 1000;
	}
		
	public String getBuchungsString(){
		String raus = "Konto: "+nummer+"\nid: "+id;//+"\nMaxBuchungen: "+maxBuchungen;
		for(int i = 0; i < id; i++){
			if(primanota[i].getSoll() == nummer){
				raus = raus + "\n"+primanota[i].getDatum().toString()+"\t| + "+primanota[i].getBetrag()+"\t| "+salden[i];
			} else if(primanota[i].getHaben() == nummer){
				raus = raus + "\n"+primanota[i].getDatum().toString()+"\t| - "+primanota[i].getBetrag()+"\t| "+salden[i];
			}
		}
		return raus;
	}
	
	public int getMaxBuchung(){
		return maxBuchungen;
	}
	
	public int getMaxID(){
		return id;
	}
	
	public int getRowCount(){
		int raus = id;
		return raus;
	}
		
	public int getSoll(int zeile){
		int raus = 0;
		if(zeile >= 0 && zeile < id){
			if(primanota[zeile].getSollHaben()){
				if(primanota[zeile].getSoll() == nummer){
					raus = primanota[zeile].getBetrag();
				} else {
					raus = 0;
				}
				
			} else {
				if(primanota[zeile].getHaben() == nummer){
					raus = primanota[zeile].getBetrag();
				} else {
					raus = 0;
				}
			}
		}
		return raus;
	}
	
	public int getHaben(int zeile){
		int raus = 0;
		if(zeile >= 0 && zeile < id){
			if(primanota[zeile].getSollHaben()){
				if(primanota[zeile].getHaben() == nummer){
					raus = primanota[zeile].getBetrag();
				} else {
					raus = 0;
				}
				
			} else {
				if(primanota[zeile].getSoll() == nummer){
					raus = primanota[zeile].getBetrag();
				} else {
					raus = 0;
				}
			}
		}
		return raus;
	}
	
	public Datum getDatum(int zeile){
		Datum raus = new Datum();
		if(zeile >= 0 && zeile < id)
			raus = primanota[zeile].getDatum();
		return raus;
	}
		
	public int gegen(int zeile){
		int raus = 0;
		if(zeile >= 0 && zeile < id){
			if(primanota[zeile].getHaben() == nummer)
				raus = primanota[zeile].getSoll();
			if(primanota[zeile].getSoll() == nummer)
				raus = primanota[zeile].getHaben();
		}
		return raus;
	}
	
	public String getBeleg1(int zeile){
		String raus = "";
		if(zeile >= 0 && zeile < id)
			raus = primanota[zeile].getBeleg1();
		return raus;
	}
	
	public String getBeleg2(int zeile){
		String raus = "";
		if(zeile >= 0 && zeile < id)
			raus = primanota[zeile].getBeleg2();
		return raus;
	}
	
	public String getBuchungstext(int zeile){
		String raus = "";
		if(zeile >= 0 && zeile < id)
			raus = primanota[zeile].getText();
		return raus;
	}
		
	public int getSaldo(int zeile){
		int raus = 0;
		if(zeile >= 0 && zeile < id)
			raus = salden[zeile];
		return raus;	
	}
	
	public int getSaldo(){
		//Letzten Saldo rausgeben
		return salden[id-1];
	}
	
	public void setName(String name){
		if(null != name)
			this.name = name;
	}

	public String getName(){
		return name;
	}
			
	public int getNummer(){
		return nummer;
	}
	
	public int getSuSaHaben(){
		return susaHaben;
	}
	
	public int getSuSaSoll(){
		return susaSoll;
	}
	
	public int getIndex(int ind){
		int raus = 0;
		if(ind >= 0 && ind < maxBuchungen)
			raus = index[ind];
		return raus;
	}
	
	public void setAnfangsbestand(int anfang){
		ab = anfang;
		neuerSaldo(ab);
	}
	
	public int getAnfangsbestand(){
		return ab;
	}
	
}
