import java.util.*;
import java.lang.Math.*;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.BufferedOutputStream;
import javax.swing.*;
import java.io.*;
import java.io.PrintStream;
import javax.swing.*;


public class LadenSummeFinden extends Thread{
	private File file;
	Buchhalter bh;
	JFrame f;
	private String suche = "";
	private String abweichung = "";
	private String[] eingabe;
	private int maxZeilen = 0;
	private boolean fehler = false;
	
	public LadenSummeFinden (Buchhalter bh, JFrame f, File file){
		this.bh = bh;
		this.f = f;
		this.file = file;
	}
	
	@Override public void run(){
		//Semikolon und Zeilen zählen
		try{
			FileReader fr = new FileReader(file);
			BufferedReader br = new BufferedReader(fr);
			String zeile;
			fehler = false;
			while( !fehler && (zeile = br.readLine()) != null ){
				maxZeilen++;
			}
			fr.close();
			fr = new FileReader(file);
			br = new BufferedReader(fr);
			int zeilennummer = 0;
			bh.setStatusMax(maxZeilen);
			eingabe = new String[maxZeilen-2];
			while( !fehler && (zeile = br.readLine()) != null ){
				if(zeilennummer == 0){
					suche = zeile;
				} else {
					if(zeilennummer == 1){
						abweichung = zeile;
					} else {
						String[] split = zeile.split(";");
						eingabe[zeilennummer-2] = split[0];//Nur die erste Spalte
					}
				}
				zeilennummer++;
				bh.setStatus(zeilennummer);
			}
			bh.setFindeSumme(suche, abweichung, eingabe);
			
		} catch (IOException ioex){
			ioex.printStackTrace();
			//JOptionPane.showMessageDialog(null, "Buchhalter.jar\nvon\nSebastian Müller\n\nhttp://sebamueller.de/programme/buchhalter\n\nVersion: ");
			JOptionPane.showMessageDialog(f, "Es gab einen Fehler bei der Datei:\n"+file.getAbsolutePath(), "Dateifehler", JOptionPane.ERROR_MESSAGE);
		} catch (Exception e){
			JOptionPane.showMessageDialog(f, "Es gab einen Fehler bei der Datei:\n"+file.getAbsolutePath()+"\n"+e.toString(), "Dateifehler", JOptionPane.ERROR_MESSAGE);
			e.printStackTrace();
		}
	}
	
	/*
	private void exportieren(File file, SummandenTableModel stm){
		int spalten = stm.getColumnCount();
		int zeilen = stm.getRowCount();
		int status = 0;
		bh.setStatusMax(zeilen);
		bh.setStatus(status);
		FileOutputStream fos;
		BufferedWriter bw;
		try
		{
			fos = new FileOutputStream(file);
			bw = new BufferedWriter(new OutputStreamWriter(fos, "UTF-8"));
			for(int j = 0; j < spalten; j++){
					bw.write((String)stm.getColumnName(j));
					bw.write(";");
			}
			bh.setStatus(++status);
			bw.newLine();
			for(int i = 0; i < zeilen; i++){
				bh.setStatus(++status);
				for(int j = 0; j < spalten; j++){
					if(i < daten.getMaxData())
						bw.write(bh.intToString(bh.stringToInt((String)stm.getValueAt(i,j))));
					else 
						bw.write((String)stm.getValueAt(i,j));
					bw.write(";");
				}
				bw.newLine();
			}
			bw.flush();
			fos.flush();
			fos.close();
		} catch (FileNotFoundException fnfe){
		} catch (Exception e ) { 
			System.err.println(e);
		} finally {
		}
	
		bh.ladenSpeichernFertig();
	}
	*/
}