import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;

@SuppressWarnings("serial")
public class MySFCellRenderer extends DefaultTableCellRenderer{

	Color colorw = new Color(230,230,230);// grau unselectiert
	Color colorw2 = new Color(220,240,240);// grau nie selectiert
	Color colorw3 = new Color(200,200,240);// grau ja selectiert
	Color colorg1 = new Color(230,240,230);// grün nie selectiert
	Color colorg2 = new Color(200,240,200);// grün ja selectiert
	Color colorg3 = new Color(180,220,180);// grün nie selectiert
	Color colorg4 = new Color(160,220,160);// grün ja selectiert
        Color color1 = new Color(240,0,0);//Rot
        Color color2 = new Color(240,100,200);
        Color color3 = new Color(240,240,0);//Gelb
        Color color4 = new Color(100,100,0);
        Color color5 = new Color(150,150,240);//Blau
        Color color6 = new Color(230,230,240);
        
	boolean[] nie;
	boolean[] gut;
	boolean[] duplikat;
	int maxDaten = 0;
	int maxSpalten = 0;
        
	public MySFCellRenderer(int maxDaten, int maxSpalten){
		super();
		if(maxDaten >= 0){
			this.maxDaten = maxDaten;
			nie = new boolean[maxDaten];
			for(int i = 0; i < maxDaten; i++){
				nie[i] = true;
				
			}
		}
		if(maxSpalten >= 0)
			this.maxSpalten = maxSpalten + 1;//Plus Eingabespalte
			gut = new boolean[maxSpalten+1];
			duplikat = new boolean[maxSpalten+1];
			for(int i = 0; i < maxSpalten+1; i++){
				gut[i] = false;
				duplikat[i] = false;
			}
	}
	
	public void setNie(int x, boolean ja){
		if(x >= 0 && x < maxDaten){
			nie[x] = ja;
		}
	}
	
	public void setWerte(int x, boolean guti, boolean dupli, boolean negDupli){
		if(x > 0 && x < maxSpalten){
			this.gut[x-1] = guti;
			this.duplikat[x-1] = dupli;
		}
	}
	
	public void print(){
		System.out.println("Niewerte:");
		for(int i = 0; i < maxDaten; i++){
			if(nie[i])
				System.out.println("["+i+"]: 1");
			else
				System.out.println("["+i+"]: 0");
		}
	}
        
	@Override
	public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
		JLabel label = new JLabel("");
		JTextField textfield = new JTextField(10);
			//textfield = (JTextField)super.getTableCellRendererComponent(table, obj, isSelected,hasFocus, row, column);
			label = (JLabel)super.getTableCellRendererComponent(table, obj, isSelected,hasFocus, row, column);
		/*
			if(isSelected)
				label.setBackground(Color.GRAY);
			else 
				label.setBackground(color1);
				//label.setBackground(Color.WHITE);
			textfield.setBackground(label.getBackground());
			
			if(hasFocus){
				return label;
				//return textfield;
			} else {
				return label;
			}
		*/
		if(isSelected){
			//Selektiert
			if(row >= 0 && row < maxDaten){
				label.setBackground(Color.RED);
				if(nie[row])
					label.setBackground(colorw2);
				else
					label.setBackground(colorw3);
			}
			if(row >= maxDaten){
				label.setBackground(Color.WHITE);
			}
		} else {
			//Normal, nicht selektiert
			if(column >= 0 && column < maxSpalten){
				if(gut[column]){
					if(duplikat[column]){
						if(row >= 0 && row < maxDaten){
							label.setBackground(Color.RED);
							if(nie[row])
								label.setBackground(colorw);
							else
								label.setBackground(colorg1);
						}
					} else {
						if(row >= 0 && row < maxDaten){
							label.setBackground(Color.RED);
							if(nie[row])
								label.setBackground(colorw);
							else
								label.setBackground(colorg2);
						}
					}
				} else {
					if(row >= 0 && row < maxDaten){
						label.setBackground(Color.RED);
						if(nie[row])
							label.setBackground(colorw);
						else
							label.setBackground(Color.WHITE);
					}
				}
				if(row >= maxDaten){
					label.setBackground(Color.WHITE);
				}
			} else {
				label.setBackground(Color.WHITE);
			}
				
		}
		//return textfield;	
		label.setHorizontalAlignment (JLabel.RIGHT);
		return label;
	}
	

}
