import java.util.*;
import java.lang.Math.*;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.BufferedOutputStream;


public class SuSaExportThread extends Thread{	
	private Buchhalter bh;
	private File file;
	private SuSaTableModel stm;

	public SuSaExportThread(Buchhalter bh, File file, SuSaTableModel stm){
		super();
		this.bh = bh;
		this.file = file;
		this.stm = stm;
	}
	
	@Override public void run(){
		exportieren();
	}
  	
	public void exportieren(){
		int spalten = stm.getColumnCount();
		int zeilen = stm.getRowCount();
		int status = 0;
		bh.setDatevMax(zeilen);
		bh.setDatevStatus(status);
		FileOutputStream fos;
		BufferedWriter bw;
		try
		{
			fos = new FileOutputStream(file);
			bw = new BufferedWriter(new OutputStreamWriter(fos, "UTF-8"));
			for(int j = 0; j < spalten; j++){
					bw.write((String)stm.getColumnName(j));
					bw.write(";");
			}
			bh.setDatevStatus(++status);
			bw.newLine();
			for(int i = 0; i < zeilen; i++){
				bh.setDatevStatus(++status);
				for(int j = 0; j < spalten; j++){
					bw.write((String)stm.getValueAt(i,j));
					/*
					if(i < daten.getMaxData())
						bw.write(bh.intToString(bh.stringToInt((String)stm.getValueAt(i,j))));
					else 
						bw.write((String)stm.getValueAt(i,j));
					*/
					bw.write(";");
				}
				bw.newLine();
			}
			bw.flush();
			fos.flush();
			fos.close();
		} catch (FileNotFoundException fnfe){
		} catch (Exception e ) { 
			System.err.println(e);
		} finally {
		}
	
		//bh.ladenSpeichernFertig();
	}
	
}
