import java.util.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.image.*;

public class BildschirmZeichnen extends JPanel{
	public static final long serialVersionUID = 1L;
	private String s = "xyz";
	private int sx,sy;
	private int bx0 =0, by0=0, bx, by;
	private BufferedImage bild;
	private BufferedImage schwarzBild;
	private boolean schwarz = false;
	private Bildschirm bs;
	private Color background = Color.black;


	public BildschirmZeichnen(int x, int y, Bildschirm bs){
		super();
		Graphics2D g;
		sx = x; //Sreengroesse
		sy = y;
		bx = x;
		by = y;
		this.bs = bs;
		MediaTracker mT = new MediaTracker(new JFrame());



		schwarzBild = new BufferedImage(sx, sy, BufferedImage.TYPE_INT_RGB);
		g = schwarzBild.createGraphics();
		//g.setColor(Color.black);
		g.setColor(bs.getBackgroundColor());
		g.fillRect(0,0, sx, sy);
		mT.addImage(schwarzBild, 2);
		try {
			mT.waitForID(2);
		} catch (InterruptedException ie){
				System.err.println("MediaTrackerFehler:\nFehler beim Einlesen der Bilder");
				ie.printStackTrace();
				JOptionPane.showMessageDialog(null,
							"MediaTrackerFehler\n\nFehler beim Einlesen der Bilder.",
							"Fehler bei Datei \u00f6ffnen", JOptionPane.ERROR_MESSAGE);
		}
		bild = schwarzBild;
		mT.addImage(bild, 1);
		try {
			mT.waitForID(1);
		} catch (InterruptedException ie){
				System.err.println("MediaTrackerFehler:\nFehler beim Einlesen der Bilder");
				ie.printStackTrace();
				JOptionPane.showMessageDialog(null,
							"MediaTrackerFehler\n\nFehler beim Einlesen der Bilder.",
							"Fehler bei Datei \u00f6ffnen", JOptionPane.ERROR_MESSAGE);
		}
	}

	public void setSchwarz(){
		//Schwarzer Bildschirm
		if (schwarz)
			schwarz = false;
		else
			schwarz = true;
	}

	public void maleBild(BufferedImage bild){
		bild.flush();
		//this.bild.flush();
		schwarz = false;
		MediaTracker mT = new MediaTracker(new JFrame());
		this.bild = bild;
		mT.addImage(bild, 1);
		try {
			mT.waitForID(1);
		} catch (InterruptedException ie){
				System.err.println("MediaTrackerFehler:\nFehler beim Einlesen der Bilder");
				ie.printStackTrace();
				JOptionPane.showMessageDialog(null,
							"MediaTrackerFehler\n\nFehler beim Einlesen der Bilder.",
							"Fehler bei Datei \u00f6ffnen", JOptionPane.ERROR_MESSAGE);
		}
	}

	public void close(){
		schwarzBild.flush();
		bild.flush();
	}



	/*public void paintComponent(Graphics g){
		Graphics comp2d = (Graphics2D)g;
		int x,y;

		comp2d.setColor(Color.black);
		Font f = new Font("Monospaced", Font.BOLD, 40);
		FontMetrics fm = getFontMetrics(f);
		comp2d.setFont(f);
		x = 100;
		y = 100;
		comp2d.drawString("100", x, y);
	}*/

	//public void paint(Graphics g){

	public void paintComponent(Graphics g){
		Graphics comp2d = (Graphics2D)g;

		//comp2d.clearRect(0,0,sx,sy);
		if (schwarz){
			comp2d.drawImage(schwarzBild, bx0,by0, bx, by, bs);
		} else {
			comp2d.setColor(bs.getBackgroundColor());
			comp2d.fillRect(0,0, sx, sy);
			comp2d.drawImage(bild, bx0,by0, bx, by, bs);
		}
		//Toolkit.sync();

		//comp2d.setBackground(e.getTextH());
		//g.fillRect(0,0,d.width,d.height);

		/*//comp2d.setBackground(e.getTextH());//Color.black);
		comp2d.clearRect(0,0,sx,sy);
		//comp2d.setColor(e.getTextF());//Color.white);
		comp2d.setColor(Color.black);
		Font f = new Font("Monospaced", Font.BOLD, 80);
		FontMetrics fm = getFontMetrics(f);
		comp2d.setFont(f);
		x = 100;
		y = 100;
		comp2d.drawString("100", x, y); */
	}

	public void update(Graphics g){
		paint(g);
	}

	public void setBackground(Color background){
		if(null == background)
			this.background = Color.black;
		else
			this.background = background;
	}
}
