import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.io.File;
import java.io.PrintStream;
import javax.swing.*;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.DefaultListSelectionModel;
//import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Calendar;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;



public class Countdown implements Runnable{
	//Einstellungen
	private final String VERSION = Start.VERSION;//Major, Minor, Bugfix, Build
	private int status = 0; //0 programm geladen, 1 eingelesen, 2 gestartet
	private Log log;
	private String textspeicher = "";
	public static final int STATUS_LOAD = 0;
	public static final int STATUS_GELESEN = 1;
	public static final int STATUS_BILD = 2;
	public static final int STATUS_START = 3;

	public static final int ALLES = Bildschirm.ALLES;
	public static final int OBEN  = Bildschirm.OBEN;
	public static final int UNTEN = Bildschirm.UNTEN;
	public static final int PANIC = Bildschirm.PANIC;
	public static final int UHRZEIT = Bildschirm.UHRZEIT;
	public static final int PLUS = Bildschirm.PLUS;
	public static final int MINUS = Bildschirm.MINUS;
	public static final int PSTART = Bildschirm.PSTART;

	private int bildStatus = 0;
	private final int BILD_STATUS_NULL = 0;
	private final int BILD_STATUS_AN = 1;
	private final int BILD_STATUS_AUS = 2;
	private Color farbe = Color.white;
	private Color hgfarbe = Color.black;


	private boolean decorate = true;//Dekoration vom Fenster
	private int maxBild = 1;

	//GUI-Datenwerte
	private JFrame f;
	private File file;

	private JPanel tisch;
	//private JDesktopPane desktop;
	private JPanel desktop;
	JTextArea textfeld;
	JTextArea nachrichtenfeld;
	JTextArea importTF;

	/*
	Date aktuell;
	Date[] planzeit;
	*/

	GregorianCalendar aktuell;
	GregorianCalendar[] planzeit; //Zeit, wann losgehen sollte
	GregorianCalendar[] endzeit;  //aktuelle Zeit, wann Countdown abläuft

	String[] resolution;
	Rectangle[] bounds;


	Daten daten;
	Bildschirm bs;

	//### JTabbedPane tabpane = new JTabbedPane ###

	private JTabbedPane tabpane = new JTabbedPane(JTabbedPane.TOP,JTabbedPane.SCROLL_TAB_LAYOUT );
	private JPanel tabEingabe = new JPanel();
	private JPanel tabLive = new JPanel();
	private JPanel tabCountdown = new JPanel();
	private JPanel tabImport = new JPanel();


	//### T O O L B A R ###

	private JToolBar bar = new JToolBar();
	private JToolBar nachrichtenbar = new JToolBar();
	private JToolBar untenbar = new JToolBar();
	private JToolBar cdbar = new JToolBar();
	private JToolBar importBar = new JToolBar();

	private JButton einlesenButton = new JButton("Einlesen");
	private JButton bildButton  = new JButton("Bild");
	private JButton startButton = new JButton("Start");
	private JButton preButton = new JButton("Zurück");
	private JButton nextButton = new JButton("Nächster");
	private JButton pauseButton = new JButton("Pause");
	private JButton endeButton = new JButton("Ende");
	//private JButton schirmButton = new JButton("Schirm");
	private JCheckBox autoCB = new JCheckBox("auto");
	private JCheckBox dekoCB = new JCheckBox("Deko");
	private JCheckBox lateCB = new JCheckBox("Verspätung anzeigen");
	private JComboBox<String> schirmCBB;// = new JCheckBox(resolution);
	private JButton decorateButton = new JButton("Leiste");

	private JButton untenButton = new JButton("unten");
	private JButton obenButton = new JButton("oben");
	private JButton allesButton = new JButton("alles");
	private JButton panicButton = new JButton("Panic at the Disco");
	private JButton uhrButton = new JButton("Nur Uhrzeit");
	private JButton farbButton = new JButton("VG Farbe wählen");
	private JButton farbHGButton = new JButton("HG Farbe wählen");

	private JButton plusButton = new JButton("Plus eine Minute");
	private JButton minusButton = new JButton("Minus eine Minute");
	private JButton pStartButton = new JButton("Programmstart");

	//### P R O G R E S S B A R ###
	//private JProgressBar progressBar;

	//### Extra Countdown ###
	private JLabel titleCountdown = new JLabel("Extra Countdown");
	private JButton resetCDButton = new JButton("Reset");
	private JButton startCDButton = new JButton("Start");
	private JButton pauseCDButton = new JButton("Pause");
	private JButton stopCDButton = new JButton("Stop");
	private JButton endeCDButton = new JButton("Ende");
	private JButton importButton = new JButton("Import von Churchtools");

	private JCheckBox autoCDCB = new JCheckBox("Autorepeat");
	private JComboBox<String> stundeCB = new JComboBox<>();
	private JComboBox<String> minuteCB = new JComboBox<>();
	private JComboBox<String> sekundeCB = new JComboBox<>();
	private JPanel countdownPanel = new JPanel();

	//### Logging ###
	private final static String[] loglevel = {"aus","alle","fehler","warnung","info","config","l1","l2","l3"};

	public static void main(String[] args ) {
		//Start
		SwingUtilities.invokeLater(new Countdown(args));
	}

	public Countdown(String[] args){
		int lognum = -1;//Kein Logging
		switch(args.length){
			/*
				Entweder Keine Angabe, dann neu Starten,
				oder eine Angabe, dann Loglevel oder Dateinamen
				oder zwei, dann Loglevel und Dateiname
			*/
			case 0:
					//Alles Normal
					break;
			case 1:
					String lof = args[0];//levelOrFile
					for(int i = 0; i < 8; i++)
						if(lof.equals(loglevel[i]))
							lognum = i;
					if(lognum == -1){
					//Es gibt eine Datei
						log = new Log(0);
						file = new File(lof);
						System.out.println("Starten fertig...");
						datenLaden(file);
					} else {
					//Es gibt keine Datei, aber einen Loglevel
						//physiomat = new Physiomat(lognum);
						log = new Log(lognum);
						System.out.println("Logginglevel: "+loglevel[lognum]);
					}
					break;
			case 2:
					//Loglevel und Dateinamen!!!
					lof = args[0];//levelOrFile

					for(int i = 0; i < 8; i++)
						if(lof.equals(loglevel[i]))
							lognum = i;
					if(lognum == -1){
					//Fehler!!!
						//ausgabe();
					} else {
						log = new Log(lognum);
						file = new File(args[1]);
						datenLaden(file);
					}
						break;
			default:
				//ausgabe();
		}
		if(null == log)
			log = new Log(0);
	}

	public void run(){
		schirm();
		initGUI();
	}

	public Countdown(){

	}

	public void initGUI(){
		schirmCBB = new JComboBox<String>(resolution);
		f = new JFrame( "Countdown ("+VERSION+")" );
		f.setDefaultCloseOperation( JFrame.DO_NOTHING_ON_CLOSE);//EXIT_ON_CLOSE );
		f.setSize( 800, 600 );

		MenuActionAdapter listener = new MenuActionAdapter(this);
		f.addWindowListener(listener);

		JPanel obenPanel = new JPanel();
		JPanel untenPanel = new JPanel();

		tabpane = new JTabbedPane(JTabbedPane.TOP,JTabbedPane.SCROLL_TAB_LAYOUT );
		tabEingabe = new JPanel();
		tabLive = new JPanel();
		tabCountdown = new JPanel();

		tabpane.addTab("Eingabe", tabEingabe);
		tabpane.addTab("Live", tabLive);
		tabpane.addTab("Countdown", tabCountdown);
		tabpane.addTab("Import Churchtools", tabImport);

		JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, obenPanel, untenPanel);
		splitPane.setOneTouchExpandable(true);
		splitPane.setDividerLocation(0.99);

		textfeld = new JTextArea(15,50);
		importTF = new JTextArea(15,50);

		textfeld.setLineWrap(false);
		importTF.setLineWrap(false);
		//Zeilenumbrüche erfolgen nur nach ganzen Wörtern
		textfeld.setWrapStyleWord(false);
		importTF.setWrapStyleWord(false);
		//Ein JScrollPane, der das Textfeld beinhaltet, wird erzeugt
		JScrollPane scrollpane = new JScrollPane(textfeld);
		JScrollPane importScrollpane = new JScrollPane(importTF);
		//Scrollpane wird unserem Panel hinzugefügt
		textfeld.setText("#255 255 255 0 0 0\n15:00 Bandprobe\n16:15 Briefing*Alle\n16:57 Countdown\n17:03 Opener*Band\n17:06 Begrüßung*Moderation\n17:11 Lobiblock I*Band\n17:30 Predigt*Ben\n17:50 Lobiblock II*Band\n18:05 Gebet+Vater Unser*Moderation\n18:10 Ansagen*Bla-Blue-Blub\n18:15 Kollekte\n18:17 Segen*Ben\n18:20 Ende");
		if(textspeicher.length() > 0)
			textfeld.setText(textspeicher);
		//textfeld.setText("02:30 Bandprobe\n02:40 Briefing\n02:50 Countdown\n03:03 Opener\n17:06 Begrüßung*Moderation\n17:11 Lobiblock I*Band\n17:30 Predigt*Ben\n17:50 Lobiblock II*Band\n18:05 Gebet+Vater Unser*Moderation\n18:10 Ansagen*Bla-Blue-Blub\n18:15 Kollekte\n18:17 Segen*Ben\n18:20 Ende");
		//Font localFont = new Font("Monospaced", 0, fontSize);
		textfeld.setFont(new Font("Monospaced", 0, 20));
		importTF.setFont(new Font("Monospaced", 0, 20));
		//obenPanel.add(textfeld);
		//obenPanel.add(scrollpane);
		tabEingabe.add(scrollpane);
		//tabImport.add(importScrollpane);//weiter unten im Block
		//obenPanel.add(tabpane);

		//*************
		//   untenPanel
		//*************
		nachrichtenfeld = new JTextArea(4,50);
		nachrichtenfeld.setLineWrap(false);
		//Zeilenumbrüche erfolgen nur nach ganzen Wörtern
		nachrichtenfeld.setWrapStyleWord(false);
		//Ein JScrollPane, der das Textfeld beinhaltet, wird erzeugt
		JScrollPane scrollpaneUnten = new JScrollPane(nachrichtenfeld);
		//Scrollpane wird unserem Panel hinzugefügt
		nachrichtenfeld.setText("Hier könnte Ihre Werbung stehen.");

		nachrichtenbar.add(farbButton);
		nachrichtenbar.add(farbHGButton);
		nachrichtenbar.add(obenButton);
		nachrichtenbar.add(untenButton);
		nachrichtenbar.add(allesButton);
		nachrichtenbar.add(panicButton);
		nachrichtenbar.add(uhrButton);

		//untenPanel.setLayout(new java.awt.BorderLayout());
		//untenPanel.add("Center", scrollpaneUnten);
		//untenPanel.add("North", nachrichtenbar);

		untenbar.add(plusButton);
		untenbar.add(minusButton);
		untenbar.add(pStartButton);
		untenbar.add(lateCB);

		tabLive.setLayout(new java.awt.BorderLayout());
		tabLive.add("Center", scrollpaneUnten);
		tabLive.add("North", nachrichtenbar);
		tabLive.add("South", untenbar);


		cdbar.add(resetCDButton);
		cdbar.add(startCDButton);
		cdbar.add(pauseCDButton);
		cdbar.add(stopCDButton);
		cdbar.add(endeCDButton);
		cdbar.add(autoCDCB);

		for(int i = 0; i < 24; i++)
			stundeCB.addItem(Daten.zweiDigit(i));
		for(int i = 0; i < 60; i++)
			minuteCB.addItem(Daten.zweiDigit(i));
		for(int i = 0; i < 60; i++)
			sekundeCB.addItem(Daten.zweiDigit(i));
		stundeCB.setSelectedIndex(0);
		minuteCB.setSelectedIndex(0);
		sekundeCB.setSelectedIndex(30);

		JPanel zeitenPanel = new JPanel();
		zeitenPanel.add(stundeCB);
		zeitenPanel.add(minuteCB);
		zeitenPanel.add(sekundeCB);
		countdownPanel.setLayout(new BoxLayout(countdownPanel, BoxLayout.PAGE_AXIS));
		countdownPanel.add(titleCountdown);
		countdownPanel.add(zeitenPanel);
		tabCountdown.setLayout(new java.awt.BorderLayout());
		tabCountdown.add("Center", countdownPanel);
		tabCountdown.add("North", cdbar);


		//******************
		//  ImportPanel
		//******************

		importBar.add(importButton);

		tabImport.setLayout(new java.awt.BorderLayout());
		tabImport.add("Center", importScrollpane);
		tabImport.add("North", importBar);



		//desktop = new JDesktopPane();
		desktop = new JPanel();
		desktop.add(tabpane);
		//desktop.add(splitPane);
		//desktop.add(obenPanel);

		//JToolBar
		bar.add(einlesenButton);
		bar.add(bildButton);
		bar.addSeparator();
		bar.add(startButton);
		bar.addSeparator();
		bar.add(preButton);
		bar.add(nextButton);
		bar.addSeparator();
		bar.add(pauseButton);
		bar.addSeparator();
		bar.add(endeButton);
		bar.addSeparator();
		bar.add(autoCB);
		bar.addSeparator();
		//bar.add(decorateButton);
		bar.add(dekoCB);
		bar.add(schirmCBB);


		tisch = new JPanel();

		tisch.setLayout(new java.awt.BorderLayout());
		tisch.add("Center", desktop);
		tisch.add("North", bar);
		f.getContentPane().add(tisch);
		f.setVisible( true );

		bildButton.addActionListener(new ButtonActionListener(this));
		einlesenButton.addActionListener(new ButtonActionListener(this));
		startButton.addActionListener(new ButtonActionListener(this));
		preButton.addActionListener(new ButtonActionListener(this));
		nextButton.addActionListener(new ButtonActionListener(this));
		pauseButton.addActionListener(new ButtonActionListener(this));
		endeButton.addActionListener(new ButtonActionListener(this));
		decorateButton.addActionListener(new ButtonActionListener(this));

		farbButton.addActionListener(new ButtonActionListener(this));
		farbHGButton.addActionListener(new ButtonActionListener(this));
		untenButton.addActionListener(new ButtonActionListener(this));
		obenButton.addActionListener(new ButtonActionListener(this));
		allesButton.addActionListener(new ButtonActionListener(this));
		panicButton.addActionListener(new ButtonActionListener(this));
		uhrButton.addActionListener(new ButtonActionListener(this));

		plusButton.addActionListener(new ButtonActionListener(this));
		minusButton.addActionListener(new ButtonActionListener(this));
		pStartButton.addActionListener(new ButtonActionListener(this));

		resetCDButton.addActionListener(new ButtonActionListener(this));
		startCDButton.addActionListener(new ButtonActionListener(this));
		pauseCDButton.addActionListener(new ButtonActionListener(this));
		stopCDButton.addActionListener(new ButtonActionListener(this));
		endeCDButton.addActionListener(new ButtonActionListener(this));

		importButton.addActionListener(new ButtonActionListener(this));

		lateCB.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                lateStateChange();
            }});

		farbButton.setIcon(new FarbPunkte(Color.white));
		farbHGButton.setIcon(new FarbPunkte(Color.black));

		bildButton.setEnabled(false);
		startButton.setEnabled(false);
		preButton.setEnabled(false);
		nextButton.setEnabled(false);
		pauseButton.setEnabled(false);
		endeButton.setEnabled(false);
		schirmCBB.setEnabled(false);
		decorateButton.setEnabled(false);
		autoCB.setSelected(true);
		autoCB.setEnabled(false);
		dekoCB.setSelected(false);
		autoCB.setEnabled(true);

		untenButton.setEnabled(false);
		obenButton.setEnabled(false);
		allesButton.setEnabled(false);
		panicButton.setEnabled(false);
		uhrButton.setEnabled(false);

		plusButton.setEnabled(false);
		minusButton.setEnabled(false);
		pStartButton.setEnabled(false);
		lateCB.setEnabled(false);

		resetCDButton.setEnabled(false);
		startCDButton.setEnabled(false);
		pauseCDButton.setEnabled(false);
		stopCDButton.setEnabled(false);
		endeCDButton.setEnabled(false);

		importButton.setEnabled(true);

		schirmCBB.setSelectedIndex(maxBild);
	}

	public void lateStateChange(){
		if(null != daten){
			if(lateCB.isSelected())
				daten.lateChange(true);
			else
				daten.lateChange(false);
		}
	}

	public void action(ActionEvent e){
			Object action = e.getSource();
			if(action == einlesenButton) {
				einlesen();
			} else if(action == bildButton) {
				bild();
			} else if(action == endeButton) {
				ende();
			} else if(action == decorateButton){
				decorate();
			} else if(action == nextButton){
				next();
			} else if(action == startButton){
				start();
			} else if(action == preButton){
				pre();
			} else if(action == pauseButton){
				pause();
			} else if(action == obenButton){
				bnd(OBEN);
			} else if(action == plusButton){
				bnd(PLUS);
			} else if(action == minusButton){
				bnd(MINUS);
			} else if(action == untenButton){
				bnd(UNTEN);
			} else if(action == pStartButton){
				bnd(PSTART);
			}	else if(action == allesButton){
				bnd(ALLES);
			} else if(action == panicButton){
				bnd(PANIC);
			} else if(action == uhrButton){
				bnd(UHRZEIT);
			} else if(action == farbButton){
				farbeWaehlen();
			} else if(action == farbHGButton){
				backfarbeWaehlen();
			} else if(action == resetCDButton){
				resetCountdown();
			} else if(action == startCDButton){
				startExtraCountdown();
			} else if(action == pauseCDButton){
				if(daten != null)
					daten.pauseExtraCountdown();
				else
					System.out.println("Keine Daten!");
			} else if(action == stopCDButton){
				autoCDCB.setSelected(false);
				if(daten != null)
					daten.stopExtraCountdown();
			} else if(action == endeCDButton){
				bs.resetCountdown(false);
			} else if(action == importButton){
				importChurchtools();
			}
	}

	private void resetCountdown(){
		if(daten != null)
			daten.setExtraCountdown(stundeCB.getSelectedIndex(), minuteCB.getSelectedIndex(), sekundeCB.getSelectedIndex());
		bs.resetCountdown(true);
	}

	private void startExtraCountdown(){
		if(daten != null)
			daten.setExtraCountdown(stundeCB.getSelectedIndex(), minuteCB.getSelectedIndex(), sekundeCB.getSelectedIndex());
		bs.starteExtraCountdown();
	}

	private void decorate(){
		if(decorate)
			decorate = false;
		else
			decorate = true;
		bs.decorate(decorate);
	}

	private void ende(){
		bs.setVisible(false);
		bs.ende();
		status = STATUS_BILD;
		status();
		bildStatus = BILD_STATUS_AUS;
	}

	private void next(){
		bs.next();
		autoCB.setSelected(false);
	}

	private void pre(){
		bs.pre();
		autoCB.setSelected(false);
	}

	private void pause(){
		daten.pause();
		autoCB.setSelected(false);
	}

	private void bild(){
		switch(bildStatus){
			case BILD_STATUS_NULL:
				//Status ändern
				status = STATUS_BILD;
				status();
				int index = schirmCBB.getSelectedIndex();
				bs = new Bildschirm(this, bounds[index], dekoCB.isSelected(), log);
				bs.setColor(farbe, hgfarbe);
				SwingUtilities.invokeLater(bs);
				bildStatus = BILD_STATUS_AN;
				untenButton.setEnabled(true);
				obenButton.setEnabled(true);
				allesButton.setEnabled(true);
				panicButton.setEnabled(true);
				uhrButton.setEnabled(true);
				plusButton.setEnabled(true);
				minusButton.setEnabled(true);
				pStartButton.setEnabled(true);
				lateCB.setEnabled(true);
				resetCDButton.setEnabled(true);
				startCDButton.setEnabled(true);
				pauseCDButton.setEnabled(true);
				stopCDButton.setEnabled(true);
				endeCDButton.setEnabled(true);
				importButton.setEnabled(true);
				break;
			case BILD_STATUS_AN:
				bs.setVisible(false);
				bildStatus = BILD_STATUS_AUS;
				untenButton.setEnabled(false);
				obenButton.setEnabled(false);
				allesButton.setEnabled(false);
				panicButton.setEnabled(false);
				uhrButton.setEnabled(false);
				plusButton.setEnabled(false);
				minusButton.setEnabled(false);
				pStartButton.setEnabled(false);
				lateCB.setEnabled(false);
				resetCDButton.setEnabled(false);
				startCDButton.setEnabled(false);
				pauseCDButton.setEnabled(false);
				stopCDButton.setEnabled(false);
				endeCDButton.setEnabled(false);
				importButton.setEnabled(false);
				break;
			case BILD_STATUS_AUS:
				index = schirmCBB.getSelectedIndex();
				/*bs = new Bildschirm(this, bounds[index], dekoCB.isSelected(), log);
				SwingUtilities.invokeLater(bs);
				bildStatus = BILD_STATUS_AN;*/
				bs.setLocation(bounds[index]);
				bs.setVisible(true);
				bildStatus = BILD_STATUS_AN;
				untenButton.setEnabled(true);
				obenButton.setEnabled(true);
				allesButton.setEnabled(true);
				panicButton.setEnabled(true);
				uhrButton.setEnabled(true);
				plusButton.setEnabled(true);
				minusButton.setEnabled(true);
				pStartButton.setEnabled(true);
				lateCB.setEnabled(true);
				resetCDButton.setEnabled(true);
				startCDButton.setEnabled(true);
				pauseCDButton.setEnabled(true);
				stopCDButton.setEnabled(true);
				endeCDButton.setEnabled(true);
				importButton.setEnabled(true);
				break;
		}
	}

	private void status(){
		switch(status){
			case STATUS_GELESEN :
				bildButton.setEnabled(true);
				importButton.setEnabled(true);
				einlesenButton.setEnabled(true);
				if(bildStatus == BILD_STATUS_NULL)
					startButton.setEnabled(false);
				else
					startButton.setEnabled(true);
				//startButton.setEnabled(false);
				preButton.setEnabled(false);
				nextButton.setEnabled(false);
				pauseButton.setEnabled(false);
				endeButton.setEnabled(false);
				schirmCBB.setEnabled(true);
				autoCB.setEnabled(true);
				plusButton.setEnabled(false);
				minusButton.setEnabled(false);
				pStartButton.setEnabled(false);
				lateCB.setEnabled(false);
				resetCDButton.setEnabled(false);
				startCDButton.setEnabled(false);
				pauseCDButton.setEnabled(false);
				stopCDButton.setEnabled(false);
				endeCDButton.setEnabled(false);

				break;
			case STATUS_START :
				einlesenButton.setEnabled(false);
				importButton.setEnabled(false);
				startButton.setEnabled(false);
				preButton.setEnabled(true);
				nextButton.setEnabled(true);
				pauseButton.setEnabled(true);
				endeButton.setEnabled(true);
				schirmCBB.setEnabled(false);
				decorateButton.setEnabled(true);
				plusButton.setEnabled(true);
				minusButton.setEnabled(true);
				pStartButton.setEnabled(true);
				lateCB.setEnabled(true);
				resetCDButton.setEnabled(true);
				startCDButton.setEnabled(true);
				pauseCDButton.setEnabled(true);
				stopCDButton.setEnabled(true);
				endeCDButton.setEnabled(true);
				break;
			case STATUS_BILD :
				einlesenButton.setEnabled(true);
				importButton.setEnabled(true);
				startButton.setEnabled(true);
				preButton.setEnabled(true);
				nextButton.setEnabled(true);
				pauseButton.setEnabled(true);
				endeButton.setEnabled(true);
				schirmCBB.setEnabled(false);
				decorateButton.setEnabled(true);
				dekoCB.setEnabled(false);
				plusButton.setEnabled(true);
				minusButton.setEnabled(true);
				pStartButton.setEnabled(true);
				lateCB.setEnabled(true);
				resetCDButton.setEnabled(true);
				startCDButton.setEnabled(true);
				pauseCDButton.setEnabled(true);
				stopCDButton.setEnabled(true);
				endeCDButton.setEnabled(true);
				break;
		}
	}

	private void start(){
		if(einlesen()){
			status = STATUS_START;
			status();
			bs.setDaten(daten);
			bs.start();
			daten.setAuto(autoCB.isSelected());
		}
	}

	private boolean einlesen(){
		boolean ok = true;
		String text = textfeld.getText();
		String farben = "";
		aktuell = new GregorianCalendar();
		int[] farbPunkte = new int[6];

		String[] zeilen = text.split("\n");

		if((zeilen.length > 2) && (text.substring(0,1).equals("#"))) {
			int lang = zeilen[0].length();
			//System.out.println("Lang: "+lang);
			text = text.substring(lang+1, text.length());
			farben = zeilen[0];
			String[] farbtext = farben.split(" ");
			if(farbtext.length == 6){
				for(int i = 0; i < 6; i++){
					farbPunkte[i] = 0;
					try{
						if(i == 0)
							farbPunkte[0] = Integer.parseInt(farbtext[0].substring(1,farbtext[0].length()));
						else
							farbPunkte[i] = Integer.parseInt(farbtext[i].substring(0,farbtext[i].length()));
					} catch (NumberFormatException e){
						farbPunkte[i] = 0;
					}
					if(farbPunkte[i] > 255) farbPunkte[i] = 255;
					if(farbPunkte[i] < 0) farbPunkte[i] = 0;
				}
				System.out.println("" +farbPunkte[0]+", "+farbPunkte[1]+", "+farbPunkte[2]+"; "+farbPunkte[3]+", "+farbPunkte[4]+", "+farbPunkte[5]);
				farbe = new Color(farbPunkte[0], farbPunkte[1], farbPunkte[2]);
				hgfarbe = new Color(farbPunkte[3], farbPunkte[4], farbPunkte[5]);
				farbButton.setIcon(new FarbPunkte(farbe));
				farbHGButton.setIcon(new FarbPunkte(hgfarbe));
			}
		}
		zeilen = text.split("\n");
		/*
		for(int i = 0; i < zeilen.length; i++)
			System.out.println("-"+zeilen[i]+"-");
			*/

		log.info("Anzahl Zeilen: "+zeilen.length);
		int jahr = aktuell.get(GregorianCalendar.YEAR);
		int monat = aktuell.get(GregorianCalendar.MONTH);
		int tag =  aktuell.get(GregorianCalendar.DAY_OF_MONTH);
		int stunde = 0;
		int minute = 0;



		if(zeilen.length > 1){

			daten = new Daten(zeilen.length, log);
			if(daten.einlesen(text)){
				status = STATUS_GELESEN;
				status();
			} else {
				ok = false;
			}
		} else {
			System.err.println("Nicht genügend Daten vorhanden.");
			errText("Nicht genügend Daten vorhanden.");
			ok = false;
		}
		return ok;
	}

	private void importChurchtools(){
		/*
			Ersetze alle Tabs durch ;
			Alles vor Uhrzeit wegwerfen
			Zeile mit Uhrzeit wegwerfen
			Text zwischen den dem ersten und dem zweiten Semikolon entfernen
			Zeile ohne Uhrzeiten, welche von Zeilen ohne Uhrzeiten gefolgt werden, wegwerfen
			Doppelte/mehrere Leerzeichen durch eines ersetzen
			Wenn eine Textzeile keine Uhrzeit hat, dann die Uhrzeiten darunter zusammenfassen/
			die Zeilen bis zur nächsten Überschrift entfernen, erste Uhrzeit bleibt aber bestehen
			Texte ohne Uhrzeiten in die Zeile darunter einsetzen
			Erstes Semikolon in der Zeile durch Leerzeichen ersetzen
			Zweites Semikolon pro Zeile in Sternchen ersetzen

		*/
		//Ersetze alle Tabs durch ;
		String text = importTF.getText();
		text = text + "\nEnde\n23:59	0:01	Ende\n";
		text = text.replace("\t", ";");

		//Ersetze alle dopppelten Leerzeichen durch ein einziges:
		text = text.replaceAll(" +", " ");
		text = text.replaceAll(" ;", ";");

		//Egal, welches letzte Zeichen vorhanden ist, die letzte Zeile ist leer.
		//text = "00:00;00:01;Start\n"+ text + "\n23:59;00:01;Ende;;;\n";


		//Alles vor Uhrzeit wegwerfen:
		String[] zeilen = text.split("\n");
		boolean weiter = true;
		boolean gefunden = false;
		int max = zeilen.length;
		if(max < 1) weiter = false;

		int index = 0;
		int index2 = 0;
		while(weiter){

			if(zeilen[index].startsWith("Uhrzeit")){
				weiter = false;
				gefunden = true;
			} else {
				index++;
			}
			if(index >= max)
				weiter = false;
		}

		if(gefunden){
			text = "";
			for(int i = index+1; i < max; i++)
				text = text+zeilen[i]+"\n";
		}

		//Text zwischen dem ersten und dem zweiten Semikolon entfernen:
		zeilen = text.split("\n");
		int erstesSemikolon = -1;
		int zweitesSemikolon = -1;
		for(int i = 0; i < zeilen.length; i++){
			erstesSemikolon = zeilen[i].indexOf(';');
			zweitesSemikolon = zeilen[i].indexOf(';', erstesSemikolon + 1);
			if (erstesSemikolon != -1 && zweitesSemikolon != -1) {
	    		zeilen[i] = zeilen[i].substring(0, erstesSemikolon) +" "+ zeilen[i].substring(zweitesSemikolon+1);
			} else {
				//Egal, da keine Uhrzeit vorhanden
    			//zeilen[i] = "Hihi: "+zeilen[i];
			}
		}
		text = "";
		for(int i = 0; i < zeilen.length; i++)
			text = text+zeilen[i]+"\n";

		//Zeile ohne Uhrzeiten, welche von Zeilen ohne Uhrzeiten gefolgt werden, wegwerfen
		zeilen = text.split("\n");
		String neuText = "";
		int plus = 0;
		int j = 0;
		int i = 0;
		String substring = "";
		//for(int i = 0; i < zeilen.length-1; i++){
		while(i < zeilen.length-1){
			substring = "";
				if(zeilen[i].length() > 3)
					substring = zeilen[i].substring(2,3);
				else
					substring = zeilen[i];
			if (zeilen[i].length() > 0 && substring.equals(":")) {
				//Eine Zeile mit einer Uhrzeit
	    		neuText = neuText + zeilen[i] + "\n";
			} else {
				substring = "";
				if(zeilen[i+1].length() > 3)
					substring = zeilen[i+1].substring(2,3);
				else
					substring = zeilen[i+1];
				if(substring.equals(":")) {
					//Wir haben eine Überschrift gefunden
					//neuText = neuText + "Überschrift gefunden:" + zeilen[i] +"\n";
					erstesSemikolon = zeilen[i+1].indexOf(';');
					if(zeilen[i+1].length() > 6)
						substring = zeilen[i+1].substring(0,6);
					else
						substring = zeilen[i+1];
					if(-1 == erstesSemikolon){
						//Kompletten Text ersetzen:

						neuText = neuText + substring + zeilen[i] + "\n";
					} else {
						neuText = neuText + substring + zeilen[i] + "*" + zeilen[i+1].substring(erstesSemikolon+1)+"\n";
					}
					j = i+2;
					weiter = true;
					if(j >= zeilen.length)
						weiter = false;
					while (weiter){
						if(zeilen[j].length() > 3)
							substring = zeilen[j].substring(2,3);
						else
							substring = zeilen[j];
						if(substring.equals(":"))
							j++;
						else
							weiter = false;
						if(j >= zeilen.length)
							weiter = false;
					}
					//neuText = neuText + " i: "+i+" j: "+j+ "\n";
					if(j < zeilen.length)
						i = j-1;
				} else {
					//Überflüssiger Text, kann weg
					//Kein neuText benutzen
					//neuText = neuText + "2: " + zeilen[i] +"\n";
				}
			}
			i++;
		}


		//text = text + "\n\n" + neuText;
		text = neuText;
		//for(int i = 0; i < zeilen.length; i++)
		//	text = text+zeilen[i]+"\n";

		//Letzte Semikolon entfernen
		zeilen = text.split("\n");

		//text = text + "\n\n";
		text = "";

		for(i = 0; i < zeilen.length; i++){
			if(zeilen[i].indexOf(';') >= 0){
				zeilen[i] = zeilen[i].substring(0,zeilen[i].indexOf(';')) + "*"+zeilen[i].substring(zeilen[i].indexOf(';')+1);
				zeilen[i] = zeilen[i].replaceAll(";;", "");
				zeilen[i] = zeilen[i].replaceAll("\\*$", "");
				zeilen[i] = zeilen[i].replaceAll("\\*;", "");
				zeilen[i] = zeilen[i].replaceAll(" $", "");
			}
			text = text + zeilen[i] + "\n";
		}


		//text = "Unsinn!";
		textfeld.setText(text);
	}

	private void schirm(){
		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice gs[] = ge.getScreenDevices();

		resolution = new String[gs.length];
		bounds = new Rectangle[gs.length];
		String text;

		//for (GraphicsDevice screen : gs) {

		for(int i = 0; i < gs.length; i++){
			GraphicsDevice screen = gs[i];

			text = ""+screen.getDefaultConfiguration().getBounds();
			text = text.substring(18,text.length());
			bounds[i] = screen.getDefaultConfiguration().getBounds();

			resolution[i] = text;
			System.out.print(text+"|");
			System.out.println(screen.getDefaultConfiguration().getBounds()+"|");
		}

		maxBild = gs.length-1;
		/*
			java.awt.Rectangle[x=0,y=0,width=1366,height=768]
			java.awt.Rectangle[x=1366,y=0,width=1920,height=1080]
		*/
	}

	public boolean getAuto(){
		return autoCB.isSelected();
	}

	public boolean getAutoExtra(){
		return autoCDCB.isSelected();
	}

	private void bnd(int bnd){
		//Der Bundesnachrichtendienst für die Direktnachrichten auf den Schirm.
		switch(bnd){
			case ALLES:
				bs.bnd(nachrichtenfeld.getText(), ALLES);
				break;
			case OBEN:
				bs.bnd(nachrichtenfeld.getText(), OBEN);
				break;
			case UNTEN:
				bs.bnd(nachrichtenfeld.getText(), UNTEN);
				break;
			case PANIC:
				bs.bnd("", PANIC);
				break;
			case UHRZEIT:
				bs.bnd("", UHRZEIT);
				break;
			case PLUS:
				bs.plusminus(true);
				autoCB.setSelected(false);
				break;
			case MINUS:
				bs.plusminus(false);
				autoCB.setSelected(false);
				break;
			case PSTART:
				//Starte das normale Programm. Alle Verzögerungen werden nun angezeigt.
				daten.pStart();
				break;
		}
	}

	public void datenLaden(File file){
		FileReader fr = null;
		String result = null; // Default-Wert, falls etwas nicht klappen sollte
		try {
			fr = new FileReader(file);
			final char[] temp = new char[(int) file.length()];
			fr.read(temp);
			result = new String(temp);
		} catch (IOException exc) {
			// nichts zu tun, wir geben einfach den default-Wert zurück
		} finally { // auf jeden Fall den FileReader schließen, falls einer existiert
			try {
				if (fr != null) {
					fr.close();
				}
			} catch (Exception ignore) {
			}
		}
		if(null != result){
			int[] farbPunkte = new int[6];
			String farben = "";
			String text = result;
			String original = result;
			String[] zeilen = text.split("\n");
			if((zeilen.length > 2) && (text.substring(0,1).equals("#"))) {
				int lang = zeilen[0].length();
				//System.out.println("Lang: "+lang);
				text = text.substring(lang+1, text.length());
				farben = zeilen[0];
				String[] farbtext = farben.split(" ");
				if(farbtext.length == 6){
					for(int i = 0; i < 6; i++){
						farbPunkte[i] = 0;
						try{
							if(i == 0)
								farbPunkte[0] = Integer.parseInt(farbtext[0].substring(1,farbtext[0].length()));
							else
								farbPunkte[i] = Integer.parseInt(farbtext[i].substring(0,farbtext[i].length()));
						} catch (NumberFormatException e){
							farbPunkte[i] = 0;
						}
						if(farbPunkte[i] > 255) farbPunkte[i] = 255;
						if(farbPunkte[i] < 0) farbPunkte[i] = 0;
					}
					System.out.println("" +farbPunkte[0]+", "+farbPunkte[1]+", "+farbPunkte[2]+"; "+farbPunkte[3]+", "+farbPunkte[4]+ ", "+farbPunkte[5]);
					farbe = new Color(farbPunkte[0], farbPunkte[1], farbPunkte[2]);
					hgfarbe = new Color(farbPunkte[3], farbPunkte[4], farbPunkte[5]);
					farbButton.setIcon(new FarbPunkte(farbe));
					farbHGButton.setIcon(new FarbPunkte(hgfarbe));
				}
				result = text;
			}

			Daten test = new Daten(0, log);
			System.out.println("Text:\n"+result);
			if(test.einlesen(result))
				textspeicher = original;
		}
	}

	public void menuEvent(ActionEvent e) {
		//Nücht, wir haben keine Menüevents
	}

	public void shutdown(){
		if(log !=null)
				log.logEnde();
		System.exit(0);
	}

	private void farbeWaehlen(){
		Color localColor = JColorChooser.showDialog(f, "Farbe wählen", farbe);
		farbButton.setIcon(new FarbPunkte(localColor));
		farbe = localColor;
		if(null != bs)
			bs.setColor(farbe, hgfarbe);
	}

	private void backfarbeWaehlen(){
		Color localColor = JColorChooser.showDialog(f, "Farbe wählen", farbe);
		farbHGButton.setIcon(new FarbPunkte(localColor));
		hgfarbe = localColor;
		if(null != bs)
			bs.setColor(farbe, hgfarbe);
	}

	public void errText(String text){
		if(null != text) nachrichtenfeld.append("Fehlermeldung:\n"+text+"\n");
	}

	public synchronized void errorMessageBord(Exception e){
		// Konvertiere Stack-Trace in einen String
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		e.printStackTrace(pw);
		String stackTrace = sw.toString();
		// Setze den String in das JTextArea
		errText(stackTrace);
	}



}

class ButtonActionListener implements ActionListener{
	Countdown cd;

	public ButtonActionListener(Countdown cd){
		this.cd = cd;
	}

	public void actionPerformed(ActionEvent e){
		cd.action(e);
	}
}

// Listener-Klasse f\u00fcr JMenuItem-Events
class MenuActionAdapter extends WindowAdapter implements ActionListener {
	Countdown obj;

	MenuActionAdapter(Countdown obj) {
		super();//Vielleicht kann dies weggelassen werden?
		this.obj = obj;
	}

	public void actionPerformed(ActionEvent e) {
		obj.menuEvent(e);
	}

	// Um die Anwendung beenden zu k\u00f6nnen
	public void windowClosing(WindowEvent e) {
		obj.shutdown();
	}
}
