import javax.swing.*;
import java.awt.Rectangle;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;

import java.util.GregorianCalendar;


	public class Bildschirm extends JFrame implements Runnable{
	public static final int ALLES   = 0;
	public static final int OBEN    = 1;
	public static final int UNTEN   = 2;
	public static final int PANIC   = 3;
	public static final int UHRZEIT = 4;
	public static final int PLUS    = 5;
	public static final int MINUS   = 6;
	public static final int PSTART   = 7;

	private boolean panic = false;
	private boolean isUhrzeit = false;
	private boolean isCountdown = false;
	private boolean startCountdown = false;
	private Log log;
	private Color background = Color.black;
	private Color foreground = Color.white;
	private Color warnColor  = Color.red;

  	private Countdown cd;
  	private Rectangle bounds;

  	private Daten daten;
  	private Ping ping;

    private Container content;
    private Graphics comp2d;
    private Graphics2D g;
    private int width, height = 0;
    private BufferedImage leinwand;
    private BildschirmZeichnen zeichnen;

    private int x, y = 0;
    private String fontString, fontStringU;
    private int fontBold, fontsize, fontBoldU, fontsizeU;
    private FontMetrics fm;
    private Font f;
    private Font fb;//Font bold
    private int pos, h, w, tx, ty, maxlength, z, zz, anfang, fontSize, rechtsU;

	private String uhrzeit = "";
	private String countdown = "";
	private boolean deko = true;
	private int bnd = 0;
	private String nachrichtentext = "";
	private long bnd_now =0l;

  	public Bildschirm(Countdown cd, Rectangle bounds, boolean deko, Log log){
  		super("Bildschirm");
  		this.cd = cd;
  		this.bounds = bounds;
  		this.setSize(bounds.width, bounds.height);
  		this.width = bounds.width;
  		this.height = bounds.height;
  		this.deko = deko;
  		if(null!= log)
  			this.log = log;
  		else
  			log = new Log(0);
  		/*
  		setLocation(bounds.x, bounds.y);
  		setUndecorated(false);
  		content = getContentPane();
  		setBackground(new Color(0, 0, 0));
  		leinwand = new BufferedImage(width, height, 1);
  		Graphics2D localGraphics2D1 = leinwand.createGraphics();
  		localGraphics2D1.setColor(new Color(0, 0, 0));
  		localGraphics2D1.fillRect(0, 0, width, height);
  		zeichnen = new BildschirmZeichnen(width, height, this);
  		//setResizable(false);
  		content = getContentPane();
  		content.add(zeichnen);
  		setVisible(true);
  		*/
  	}

  	public void setLocation(Rectangle bounds){
		this.bounds = bounds;
		this.setLocation(bounds.x, bounds.y);
		this.setSize(bounds.width, bounds.height);
		validate();
  	}

  	public void run(){
  		setLocation(bounds.x, bounds.y);
  		setUndecorated(!deko);
  		content = getContentPane();
  		setBackground(background);
  		leinwand = new BufferedImage(width, height, 1);
  		Graphics2D localGraphics2D1 = leinwand.createGraphics();
  		localGraphics2D1.setColor(background);
  		localGraphics2D1.fillRect(0, 0, width, height);
  		zeichnen = new BildschirmZeichnen(width, height, this);
  		//setResizable(false);
  		content = getContentPane();
  		content.add(zeichnen);
  		setVisible(true);
  	}

  	public void decorate(boolean decorate){
  		/*
  		setVisible(false);
  		if(decorate)
  			setUndecorated(false);
  		else
  			setUndecorated(true);
  		setVisible(true);
  		*/
  		System.out.println("Größe Fenster: "+getContentPane().getSize());
  	}

  	public void setDaten(Daten daten){
  		this.daten = daten;
  	}



  	public void getMaze(){
  		x = this.getContentPane().getWidth();
  		y = this.getContentPane().getHeight();
  		//System.out.println("Maße: "+x+":"+y+"\nBildschirm: "+width+":"+height);
  		if(x==width && y == height){
  		} else {
	  		this.getContentPane().remove(zeichnen);
  			zeichnen = new BildschirmZeichnen(x, y, this);
  			zeichnen.setBackground(background);
  			this.getContentPane().add(zeichnen);
				this.getContentPane().invalidate();
				this.getContentPane().validate();
				width = x;
				height = y;
			}
	}

	private void maleUhrzeit(Graphics2D g, String uhrzeit){
		fontsize = 1000;
		boolean big = true;
		int platz_x = x/2-10;
		int platz_y = y/3-10;
		int stringw = 0;
		int stringh = 0;
		if(isUhrzeit || isCountdown){
			platz_x = x-10;
			platz_y = y-10;
			while (big && fontsize > 0){
				f = new Font("Dialog", Font.PLAIN, fontsize);
				g.setFont(f);
				fm = g.getFontMetrics();
				stringw = fm.stringWidth(uhrzeit);
				stringh = fm.getMaxAscent();
				if(stringw > platz_x || stringh > platz_y)
					fontsize--;
				else
					big = false;
			}
			f = new Font("Dialog", Font.PLAIN, fontsize);
			stringw = fm.stringWidth(uhrzeit);
			stringh = fm.getMaxAscent();
			int rest = (y-10-fm.getMaxAscent());
			int starty = y-5;
			int startylinie = starty - (platz_y - stringh);
			int testx = (x-stringw);
			int testy = starty;
			int testAscent = (fm.getAscent()-(fm.getAscent()));
			startylinie = starty - (platz_y - stringh);
			//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
			g.setFont(f);
			g.drawString(uhrzeit, 5, startylinie);// | Text   | -> |  Text  |
  		} else {
			while (big && fontsize > 0){
				f = new Font("Dialog", Font.PLAIN, fontsize);
				g.setFont(f);
				fm = g.getFontMetrics();
				stringw = fm.stringWidth(uhrzeit);
				//stringh = fm.getHeight();
				stringh = fm.getMaxAscent();
				if(stringw > platz_x || stringh > platz_y)
					fontsize--;
				else
					big = false;
			}
			f = new Font("Dialog", Font.PLAIN, fontsize);
			stringw = fm.stringWidth(uhrzeit);
			stringh = fm.getMaxAscent();
			int rest = (y/3-10-fm.getMaxAscent())/2;
			int starty = 2*y/3-5;
			int startylinie = starty - (platz_y - stringh)/2;
			int testx = (x/2-stringw)/2;
			int testy = starty;
			int testAscent = (fm.getAscent()-(fm.getAscent()/5));
			startylinie = starty - (platz_y - testAscent)/2;
			//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
			g.setFont(f);
			g.drawString(uhrzeit, x/2+(x/2-stringw)/2, startylinie);// | Text   | -> |  Text  |
		}
  		//Test:
  		//g.setColor(new Color(0,255,0));
  		/*g.drawLine( testx+10, 0, testx+10, testy);
  		g.drawLine( testx+20, 0, testx+20, startylinie);
  		g.drawLine( testx+30, 0, testx+30, startylinie-fm.getHeight());
  		g.drawLine( testx+40, 0, testx+40, startylinie-fm.getAscent());
  		g.drawLine( testx+50, 0, testx+50, startylinie-fm.getMaxAscent());
  		g.drawLine( testx+60, 0, testx+60, startylinie-(fm.getAscent()-(fm.getAscent()/5)));*/
  		//g.drawLine( testx, testAscent, x, testAscent);
  	}

  	private void maleCountdown(Graphics2D g, String uhrzeit){
  		//Bitte mit Farbe!
  		fontsize = 1000;
  		boolean big = true;
  		int platz_x = x/2-10;
  		int platz_y = y/3-10;
  		int stringw = 0;
  		int stringh = 0;
  		while (big && fontsize > 0){
  			f = new Font("Dialog", Font.PLAIN, fontsize);
  			g.setFont(f);
  			fm = g.getFontMetrics();
  			stringw = fm.stringWidth(uhrzeit);
  			stringh = fm.getHeight();
  			//stringh = fm.getMaxAscent();
  			if(stringw > platz_x || stringh > platz_y)
  				fontsize--;
  			else
  				big = false;
  		}
  		f = new Font("Dialog", Font.PLAIN, fontsize);
  		stringw = fm.stringWidth(uhrzeit);
  		//stringh = fm.getMaxAscent();
  		stringh = fm.getHeight();
  		int rest = (y/3-10-stringh)/2;
  		int starty = 2*y/3-5;
  		int startylinie = starty - (platz_y - stringh)/2;

  		int testx = (x/2-stringw)/2;
  		int testy = starty;
  		int testAscent = (fm.getAscent()-(fm.getAscent()/5));
  		startylinie = starty - (platz_y - testAscent)/2;

  		//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
  		g.setFont(f);
  		g.setColor(foreground);
  		zeichnen.setBackground(background);
  		if(daten.mitFarbe())
  			g.setColor(new Color(255,255,0));
  		if(daten.rot())
  			g.setColor(new Color(255,0,0));
  		g.drawString(uhrzeit, (x/2-stringw)/2, startylinie);// | Text   | -> |  Text  |
  		//Test:
  		//g.setColor(new Color(0,255,0));

  		/*g.drawLine( testx+10, 0, testx+10, testy);
  		g.drawLine( testx+20, 0, testx+20, startylinie);
  		g.drawLine( testx+30, 0, testx+30, startylinie-fm.getHeight());
  		g.drawLine( testx+40, 0, testx+40, startylinie-fm.getAscent());
  		g.drawLine( testx+50, 0, testx+50, startylinie-fm.getMaxAscent());
  		g.drawLine( testx+60, 0, testx+60, startylinie-(fm.getAscent()-(fm.getAscent()/5)));*/
  		//g.drawLine( testx, testAscent, x, testAscent);
  	}

  	private void maleJetzt(Graphics2D g, String was, String wer){
  		//Bitte mit Farbe!
  		String jetzt = "Jetzt:";
  		fontsize = 1000;
  		boolean big = true;
  		int platz_x = x/2-10;
  		int platz_y = y/9-10;
  		int stringw = 0;
  		int stringh = 0;
  		int stringw_jetzt = 0;
  		while (big && fontsize > 0){
  			f = new Font("Dialog", Font.PLAIN, fontsize);
  			g.setFont(f);
  			fm = g.getFontMetrics();
  			stringw = fm.stringWidth(jetzt);
  			//stringh = fm.getHeight();
  			stringh = fm.getMaxAscent();
  			if(stringw > platz_x || stringh > platz_y)
  				fontsize--;
  			else
  				big = false;
  		}
  		f = new Font("Dialog", Font.PLAIN, fontsize);
  		stringw = fm.stringWidth(jetzt);
  		stringw_jetzt = stringw;
  		stringh = fm.getMaxAscent();
  		//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
  		g.setFont(f);
  		g.setColor(foreground);
  		if(daten.mitFarbe())
  			g.setColor(new Color(255,255,0));
  		if(daten.rot())
  			g.setColor(new Color(255,0,0));
  		g.drawString(jetzt, 10, y/9-(y/9-stringh));// | Text   | -> |  Text  |

  		//WAS
  		fontsize = 1000;
  		big = true;
  		int start = 10+stringw_jetzt+10;
  		platz_x = x-10-start;
  		platz_y = y/6-10;
  		stringw = 0;
  		stringh = 0;

  		while (big && fontsize > 0){
  			f = new Font("Dialog", Font.PLAIN, fontsize);
  			g.setFont(f);
  			fm = g.getFontMetrics();
  			stringw = fm.stringWidth(was);
  			stringh = fm.getHeight();
  			//stringh = fm.getMaxAscent();
  			if(stringw > platz_x || stringh > platz_y)
  				fontsize--;
  			else
  				big = false;
  		}
  		f = new Font("Dialog", Font.PLAIN, fontsize);
  		stringw = fm.stringWidth(was);
  		//stringh = fm.getMaxAscent();
  		stringh = fm.getHeight();
  		//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
  		g.setFont(f);
  		g.drawString(was, start, y/6-(y/6-stringh)-fm.getDescent()-1);// | Text   | -> |  Text  |
  		//g.drawLine(start, (y/6-(y/6-stringh)-10), (start+stringw), (y/6-(y/6-stringh)-10));
  		//g.drawLine(start, (y/6-(y/6-stringh)-stringh), (start+stringw), (y/6-(y/6-stringh)-stringh));

  		//WER
  		fontsize = 1000;
  		big = true;
  		platz_x = x-10-start;
  		platz_y = y/6-10;
  		stringw = 0;
  		stringh = 0;
  		while (big && fontsize > 0){
  			f = new Font("Dialog", Font.PLAIN, fontsize);
  			g.setFont(f);
  			fm = g.getFontMetrics();
  			stringw = fm.stringWidth(wer);
  			//stringh = fm.getHeight();
  			stringh = fm.getMaxAscent();
  			if(stringw > platz_x || stringh > platz_y)
  				fontsize--;
  			else
  				big = false;
  		}
  		f = new Font("Dialog", Font.PLAIN, fontsize);
  		stringw = fm.stringWidth(wer);
  		stringh = fm.getMaxAscent();
  		//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
  		g.setFont(f);
  		g.drawString(wer, start, 2*y/6-(y/6-stringh)-fm.getDescent());// | Text   | -> |  Text  |
  	}

  	private void malePlus(Graphics2D g, String zeit){
  		fontsize = 1000;
  		boolean big = true;
  		int platz_x = x-4;
  		int platz_y = y/9-10;
  		int stringw = 0;
  		int stringh = 0;
  		int stringw_jetzt = 0;
  		while (big && fontsize > 0){
  			f = new Font("Dialog", Font.PLAIN, fontsize);
  			g.setFont(f);
  			fm = g.getFontMetrics();
  			stringw = fm.stringWidth(zeit);
  			//stringh = fm.getHeight();
  			stringh = fm.getMaxAscent();
  			if(stringw > platz_x || stringh > platz_y)
  				fontsize--;
  			else
  				big = false;
  		}
  		f = new Font("Dialog", Font.PLAIN, fontsize);
  		stringw = fm.stringWidth(zeit);
  		stringw_jetzt = stringw;
  		stringh = fm.getMaxAscent();
  		//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
  		g.setFont(f);
  		g.setColor(new Color(255,0,0));
  		g.drawString(zeit, 10, 8*y/9+stringh);
  	}

  	private void maleDanach(Graphics2D g, String was, String wer){
  		//Bitte mit Farbe!
  		String jetzt = "Danach:";
  		fontsize = 1000;
  		boolean big = true;
  		int platz_x = x-4;
  		int platz_y = y/9-10;
  		int stringw = 0;
  		int stringh = 0;
  		int stringw_jetzt = 0;
  		while (big && fontsize > 0){
  			f = new Font("Dialog", Font.PLAIN, fontsize);
  			g.setFont(f);
  			fm = g.getFontMetrics();
  			stringw = fm.stringWidth(jetzt);
  			//stringh = fm.getHeight();
  			stringh = fm.getMaxAscent();
  			if(stringw > platz_x || stringh > platz_y)
  				fontsize--;
  			else
  				big = false;
  		}
  		f = new Font("Dialog", Font.PLAIN, fontsize);
  		stringw = fm.stringWidth(jetzt);
  		stringw_jetzt = stringw;
  		stringh = fm.getMaxAscent();
  		//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
  		g.setFont(f);
  		g.setColor(foreground);
  		if(daten.mitFarbe())
  			g.setColor(new Color(255,255,0));
  		if(daten.rot())
  			g.setColor(new Color(255,0,0));
  		g.drawString(jetzt, 10, 2*y/3+stringh);// | Text   | -> |  Text  |
		g.drawString(daten.endzeit(), 10, 2*y/3+stringh+stringh);// | Text   | -> |  Text  |
		//Hier Progressanzeige in digital
		//g.drawString(""+daten.getProzess(), 10, 2*y/3+stringh+stringh+stringh);// | Text   | -> |  Text  |
  		//WAS
  		fontsize = 1000;
  		big = true;
  		int start = 10+stringw_jetzt+10;
  		platz_x = x-10-start;
  		platz_y = y/6-4;
  		stringw = 0;
  		stringh = 0;

  		while (big && fontsize > 0){
  			f = new Font("Dialog", Font.PLAIN, fontsize);
  			g.setFont(f);
  			fm = g.getFontMetrics();
  			stringw = fm.stringWidth(was);
  			stringh = fm.getHeight();
  			//stringh = fm.getMaxAscent();
  			if(stringw > platz_x || stringh > platz_y)
  				fontsize--;
  			else
  				big = false;
  		}
  		f = new Font("Dialog", Font.PLAIN, fontsize);
  		stringw = fm.stringWidth(was);
  		//stringh = fm.getMaxAscent();
  		stringh = fm.getHeight();
  		//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
  		g.setFont(f);
  		g.drawString(was, start, 2*y/3+stringh-fm.getDescent()-1);// | Text   | -> |  Text  |
  		//g.drawLine(start, (y/6-(y/6-stringh)-10), (start+stringw), (y/6-(y/6-stringh)-10));
  		//g.drawLine(start, (y/6-(y/6-stringh)-stringh), (start+stringw), (y/6-(y/6-stringh)-stringh));
  		/*g.drawLine(start, 2*y/3+stringh-fm.getDescent()-1, start, (2*y/3+stringh-fm.getDescent()-1)-(fm.getHeight()));//Links Hoch
  		g.drawLine(start, 2*y/3+stringh-fm.getDescent()-1, start+stringw, (2*y/3+stringh-fm.getDescent()-1));//unten
  		g.drawLine(start+stringw, 2*y/3+stringh-fm.getDescent()-1, start+stringw, (2*y/3+stringh-fm.getDescent()-1));//rechts hoch
  		g.drawLine(start, 2*y/3+stringh-fm.getDescent()-1-(fm.getMaxAscent()), start+stringw, 2*y/3+stringh-fm.getDescent()-1-(fm.getMaxAscent()));//oben*/

  		//WER
  		fontsize = 1000;
  		big = true;
  		platz_x = x-10-start;
  		platz_y = y/6-4;
  		stringw = 0;
  		stringh = 0;
  		while (big && fontsize > 0){
  			f = new Font("Dialog", Font.PLAIN, fontsize);
  			g.setFont(f);
  			fm = g.getFontMetrics();
  			stringw = fm.stringWidth(wer);
  			//stringh = fm.getHeight();
  			stringh = fm.getMaxAscent();
  			if(stringw > platz_x || stringh > platz_y)
  				fontsize--;
  			else
  				big = false;
  		}
  		f = new Font("Dialog", Font.PLAIN, fontsize);
  		stringw = fm.stringWidth(wer);
  		stringh = fm.getMaxAscent();
  		//System.out.println("Höhe: "+stringh+" Platz: "+platz_y);
  		g.setFont(f);
  		g.drawString(wer, start, y-fm.getDescent());// | Text   | -> |  Text  |
  		/*g.drawLine(start, y-fm.getDescent(), start+stringw, (y-fm.getDescent())-(fm.getHeight()));//Durchstreichen
  		g.drawLine(start, y-fm.getDescent()-fm.getMaxAscent(), start+stringw, y-fm.getDescent()-fm.getMaxAscent());//obere Linie*/
  	}

	public void drawMaze(){
		getMaze();
		Graphics2D g;
		leinwand = new BufferedImage(x, y, BufferedImage.TYPE_INT_RGB);
		g = leinwand.createGraphics();
		g.setColor(background);
		g.fillRect(0,0, x, y);
		g.setColor(foreground);
		long bnd_Zeit = new GregorianCalendar().getTimeInMillis()- bnd_now;
		if((!panic && !isUhrzeit && !isCountdown) && (bnd_Zeit > 10000 || bnd == OBEN || bnd == UNTEN)){ //Keine Nachricht nach 10 Sekunden mehr!!!
			g.drawLine(0,(y/3), x, (y/3));
			g.drawLine(0,(y/3+1), x, (y/3+1));
			g.drawLine(0,2*y/3, x, (2*y/3));
			g.drawLine(0,2*y/3+1, x, (2*y/3)+1);
			g.drawLine(x/2,y/3, x/2, 2*y/3);
			g.drawLine(x/2+1,y/3, x/2+1, 2*y/3);
			g.setColor(warnColor);
			if(daten.getProzess() < 500){
				g.drawLine(x/2,y/3, x/2, 2*y/3);
				g.drawLine(x/2+1,y/3, x/2+1, 2*y/3);
			}
			g.drawLine(0,(y/3), (int)(x-x*daten.getProzess()/1000), (y/3));
			g.drawLine(0,(y/3)+1, (int)(x-x*daten.getProzess()/1000), (y/3)+1);
			g.drawLine(0,(y/3)+2, (int)(x-x*daten.getProzess()/1000), (y/3)+2);
			g.drawLine(0,(2*y/3), (int)(x-x*daten.getProzess()/1000), (2*y/3));
			g.drawLine(0,(2*y/3)+1, (int)(x-x*daten.getProzess()/1000), (2*y/3)+1);
			g.drawLine(0,(2*y/3)+1, (int)(x-x*daten.getProzess()/1000), (2*y/3)+1);
			g.setColor(foreground);
		}
		if(bnd_Zeit > 10000){
			if(daten!= null){
				if(!panic && !isUhrzeit && !isCountdown){
					uhrzeit = daten.aktuelleUhrzeit();
					maleUhrzeit(g, uhrzeit);
					countdown = daten.getCountdown();
					maleCountdown(g, countdown);
					maleJetzt(g, daten.was(true), daten.wer(true));
					maleDanach(g, daten.was(false), daten.wer(false));
					if(daten.zuLangsam())
						malePlus(g, daten.wievielZuLangsam());
				} else {
					if(isUhrzeit){
						uhrzeit = daten.aktuelleUhrzeit();
						maleUhrzeit(g, uhrzeit);
					}
					if(isCountdown){
						uhrzeit = daten.getExtraCountdown();
						maleUhrzeit(g, uhrzeit);
					}
				}
			} else {
				System.err.println("Keine Daten!");
			}
		} else {
			switch(bnd){
				case ALLES:
					bndAlles(g);
					break;
				case OBEN:
					if(daten!= null){
						uhrzeit = daten.aktuelleUhrzeit();
						maleUhrzeit(g, uhrzeit);
						countdown = daten.getCountdown();
						maleCountdown(g, countdown);
						//maleJetzt(g, daten.was(true), daten.wer(true));
						bndJetzt(g);
						maleDanach(g, daten.was(false), daten.wer(false));
					} else {
						System.err.println("Keine Daten!");
					}
					break;
				case UNTEN:
					if(daten!= null){
						uhrzeit = daten.aktuelleUhrzeit();
						maleUhrzeit(g, uhrzeit);
						countdown = daten.getCountdown();
						maleCountdown(g, countdown);
						maleJetzt(g, daten.was(true), daten.wer(true));
						//maleDanach(g, daten.was(false), daten.wer(false));
						bndDanach(g);
					} else {
						System.err.println("Keine Daten!");
					}
					break;
				case UHRZEIT:
						//bndUhrzeit(g); //Nicht nötig, wie Panic
					break;
			}
		}

		zeichnen.maleBild(leinwand);
	}

  	private void bndAlles(Graphics2D g){
  		String jetzt = "Danach:";
  		fontsize = 1000;
  		boolean big = true;
  		int platz_x = x;
  		int platz_y = y;
  		int start_x = 0;
  		int start_y = 0;
  		int stringw = 0;
  		int stringh = 0;
  		int stringw_jetzt = 0;

  		String[] zeilen = nachrichtentext.split("\n");
			log.fine("Anzahl Zeilen BND: "+zeilen.length);
			String textzeile = "";
			int anzahl = zeilen.length;
			int max = getmaxZeile(nachrichtentext);
			log.fine("größte Zeile: "+max);
			jetzt = zeilen[max];
			if(anzahl > 0){
			while (big && fontsize > 0){
				f = new Font("Dialog", Font.PLAIN, fontsize);
				g.setFont(f);
				fm = g.getFontMetrics();
				stringw = fm.stringWidth(jetzt);
				//stringh = fm.getHeight();
				stringh = fm.getMaxAscent();
				if(stringw > platz_x || (stringh*anzahl) > platz_y)
					fontsize--;
				else
					big = false;
			}
			f = new Font("Dialog", Font.PLAIN, fontsize);
			g.setFont(f);
			fm = g.getFontMetrics();
			stringh = fm.getMaxAscent();
			for(int i = 0; i < anzahl; i++)
				g.drawString(zeilen[i], 0, start_y+stringh*(i+1));
			//g.fillRect(start_x, start_y, x, y);
		}
	}

  	private void bndDanach(Graphics2D g){
  		//Bitte mit Farbe!
  		String jetzt = "Danach:";
  		fontsize = 1000;
  		boolean big = true;
  		int platz_x = x;
  		int platz_y = y/3;
  		int start_x = 0;
  		int start_y = 2*y/3;
  		int stringw = 0;
  		int stringh = 0;
  		int stringw_jetzt = 0;

  		String[] zeilen = nachrichtentext.split("\n");
			log.fine("Anzahl Zeilen BND: "+zeilen.length);
			String textzeile = "";
			int anzahl = zeilen.length;
			int max = getmaxZeile(nachrichtentext);
			log.fine("größte Zeile: "+max);
			jetzt = zeilen[max];
			if(anzahl > 0){
	  		while (big && fontsize > 0){
	  			f = new Font("Dialog", Font.PLAIN, fontsize);
	  			g.setFont(f);
	  			fm = g.getFontMetrics();
	  			stringw = fm.stringWidth(jetzt);
	  			//stringh = fm.getHeight();
	  			stringh = fm.getMaxAscent();
	  			if(stringw > platz_x || (stringh*anzahl) > platz_y)
	  				fontsize--;
	  			else
	  				big = false;
	  		}
	  		f = new Font("Dialog", Font.PLAIN, fontsize);
	  		g.setFont(f);
	  		fm = g.getFontMetrics();
	  		stringh = fm.getMaxAscent();
	  		for(int i = 0; i < anzahl; i++)
		  		g.drawString(zeilen[i], 0, start_y+stringh*(i+1));
	  		//g.fillRect(start_x, start_y, x, y);
  		}
  	}

  	private void bndJetzt(Graphics2D g){
  		//Bitte mit Farbe!
  		String jetzt = "Danach:";
  		fontsize = 1000;
  		boolean big = true;
  		int platz_x = x;
  		int platz_y = y/3;
  		int start_x = 0;
  		int start_y = 2*y/3;
  		int stringw = 0;
  		int stringh = 0;
  		int stringw_jetzt = 0;

  		String[] zeilen = nachrichtentext.split("\n");
			log.fine("Anzahl Zeilen BND: "+zeilen.length);
			String textzeile = "";
			int anzahl = zeilen.length;
			int max = getmaxZeile(nachrichtentext);
			log.fine("größte Zeile: "+max);
			jetzt = zeilen[max];
			if(anzahl > 0){
	  		while (big && fontsize > 0){
	  			f = new Font("Dialog", Font.PLAIN, fontsize);
	  			g.setFont(f);
	  			fm = g.getFontMetrics();
	  			stringw = fm.stringWidth(jetzt);
	  			//stringh = fm.getHeight();
	  			stringh = fm.getMaxAscent();
	  			if(stringw > platz_x || (stringh*anzahl) > platz_y)
	  				fontsize--;
	  			else
	  				big = false;
	  		}
	  		f = new Font("Dialog", Font.PLAIN, fontsize);
	  		g.setFont(f);
	  		fm = g.getFontMetrics();
	  		stringh = fm.getMaxAscent();
	  		for(int i = 0; i < anzahl; i++)
		  		g.drawString(zeilen[i], 0, stringh*(i+1));
	  		//g.fillRect(start_x, start_y, x, y);
  		}

  	}

  	public int getmaxZeile(String text){
  		String[] zeilen = nachrichtentext.split("\n");
  		int max = 0;
  		int zeile = 0;
  		for(int i = 0; i < zeilen.length; i++){
  			if(zeilen[i].length() > max){
  				max = zeilen[i].length();
  				zeile = i;
  			}
  		}
  		return zeile;
  	}

	public void next(){
		panic = false;
		isCountdown = false;
		daten.next();
		drawMaze();
		this.repaint();
  	}

  	public void pre(){
  		panic = false;
  		isCountdown = false;
		daten.pre();
		drawMaze();
		this.repaint();
  	}

  	public void plusminus(boolean plusminus){
  		panic = false;
  		isCountdown = false;
		daten.plusminus(plusminus);
		drawMaze();
		this.repaint();
  	}

  	public void start(){
  		daten.start(this);
   		drawMaze();
			this.repaint();
			ping = new Ping(this);
			ping.start();
  	}

	public void ping(){
		drawMaze();
		this.repaint();
	}

  	public void ende(){
  		ping.pleaseStop();
  	}

  	public boolean getAuto(){
  		return cd.getAuto();
  	}

  	public boolean getAutoExtra(){
  		return cd.getAutoExtra();
  	}

  	public void setColor(Color farbe, Color hgFarbe){
  		foreground = farbe;
  		background = hgFarbe;
  		if(null != zeichnen){
  			zeichnen.setBackground(hgFarbe);
  		}
  	}

  	public void resetCountdown(boolean start){
  		if(start)
			isCountdown = true;
		else
			isCountdown = false;
		startCountdown = false;
  	}

  	public void starteExtraCountdown(){
  		isCountdown = true;
  		if(daten != null){
  			daten.starteExtraCountdown(startCountdown);
  		}
  		startCountdown = true;
  	}

  	public Color getBackgroundColor(){
  		return background;
  	}

  	public Color getForegroundColor(){
  		return foreground;
  	}

  	public void bnd(String text, int bnd){
		this.bnd = bnd;
		if(UHRZEIT != bnd){
			if(PANIC != bnd){
				if(null != text){
					bnd_now = new GregorianCalendar().getTimeInMillis();
					nachrichtentext = text;
					panic = false;
				}
			} else {
				if(panic){
					panic = false;
					bnd_now = new GregorianCalendar().getTimeInMillis()-10000;
				} else {
					panic = true;
				}
			}
		} else {
			if(isUhrzeit){
				isUhrzeit = false;
				bnd_now = new GregorianCalendar().getTimeInMillis()-10000;
			} else {
				isUhrzeit = true;
			}
		}
	}

	public void errText(String text){
		cd.errText(text);
	}
}
