import java.util.logging.*;
import java.io.*;

public class Log{
	private final static String[] loglevel = {"aus","alle","fehler","warnung","info","config","l1","l2","l3"};
	private boolean log = false;
	private static final int numLogFiles = 100;//Maximale Logfiles
	private static final int MAXSAVETIME = 300000;//5000 = 5 Sekunden 60000 300000 = 5 Minuten
	private int level = 0;
	private static Logger logger;
	private Handler file_handler;
	private java.util.logging.Formatter klartext;
	private final String pattern = ".Log-Countdown-%g.log"; 
	private final int limit = 10485760;//=10MB; 

	public Log(int lognum){
		if(lognum > -1 && lognum < 9)
			level = lognum;
		logStart();
	}
	
	public void severe(String text){
		logger.severe(text);
	}
	public void warning(String text){
		logger.warning(text);
	}
	public void info(String text){
		logger.info(text);
	}
	public void config(String text){
		logger.config(text);
	}
	public void fine(String text){
		logger.fine(text);
	}
	public void finer(String text){
		logger.finer(text);
	}
	public void finest(String text){
		logger.finest(text);
	}



	private void logStart(){
	/*
		Für die Umleitung der System.err und System.out 
		http://blogs.sun.com/nickstephen/entry/java_redirecting_system_out_and
	*/
		try{
			logger = Logger.getLogger("de.sebamueller.Countdown");
			Logger rootLog = Logger.getLogger("");//
			if(level != -1){
				switch(level){
					case 0 : rootLog.setLevel(Level.OFF);break;
					case 1 : rootLog.setLevel(Level.ALL);break;
					case 2 : rootLog.setLevel(Level.SEVERE);break;
					case 3 : rootLog.setLevel(Level.WARNING);break;
					case 4 : rootLog.setLevel(Level.INFO);break;
					case 5 : rootLog.setLevel(Level.CONFIG);break;
					case 6 : rootLog.setLevel(Level.FINE);break;
					case 7 : rootLog.setLevel(Level.FINER);break;
					case 8 : rootLog.setLevel(Level.FINEST);break;
				}
			}

			file_handler = new FileHandler(pattern, limit, numLogFiles); 
			
			klartext = new SimpleFormatter();
			file_handler.setFormatter(klartext);
			logger.addHandler(file_handler);
			
			//file_handler.setLevel(Level.ALL);
			
			System.err.print("Warnung: Der Stream wird in die Logdatei umgeleitet!\nWarning: Errorstream is piped in .Log-Countdown-0.log\n");
			
			// preserve old stdout/stderr streams in case they might be useful      
			PrintStream stdout = System.out;                                       
			PrintStream stderr = System.err;                                       

			// now rebind stdout/stderr to logger                                  
			LoggingOutputStream los;                                               
			los = new LoggingOutputStream(logger, StdOutErrLevel.STDOUT);          
			System.setOut(new PrintStream(los, true));                             

			los= new LoggingOutputStream(logger, StdOutErrLevel.STDERR);           
			System.setErr(new PrintStream(los, true));            


			
			//System.err.print("Fehler!!!\n");
			//System.out.print("Ausgabe!!!\n");
			

			/*
			http://berrendorf.inf.h-brs.de/lehre/ss03/vups1/Seminar/3_LoggingInJava.pdf
			Level:
			SEVERE (höchste Dringlichkeit)
			WARNING
			INFO
			CONFIG
			FINE
			FINER
			FINEST (niedrigste Dringlichkeit)
			
			
			logger.severe("my severe message"); 
			logger.warning("my warning message"); 
			logger.info("my info message"); 
			logger.config("my config message"); 
			logger.fine("my fine message"); 
			logger.finer("my finer message"); 
			logger.finest("my finest message"); 
			
			
			* upon startup, use CONFIG to log configuration parameters
			* during normal operation, use INFO to log high-level "heartbeat" information
			* when bugs or critical conditions occur, use SEVERE
			* debugging information might default to FINE, with FINER and FINEST used occasionally, according to taste.
			
			// This method should be used when an exception is encounted 
				try { 
					// Test with an exception 
					throw new IOException(); 
				} catch (Throwable e){ 
				// Log the exception 
					logger.log(Level.SEVERE, "Uncaught exception", e); 
				} 
				
				// When a method is throwing an exception, this method should be used 
					Exception ex = new IllegalStateException(); 
					logger.throwing(this.getClass().getName(), "myMethod", ex); 
					
				// Programmablaufeingriff möglichst minimieren:
					if (logger.isLoggable(Level.FINEST)) { logger.finest("count: "+count); } 
					
					
					http://www.exampledepot.com/egs/java.util.logging/LogExcept.html
					http://www.exampledepot.com/egs/java.util.logging/pkg.html
			*/
			//logger.addHandler(file_handler);//Neuer Filehandler, hier kann also auch etwas auf die Konsole ausgegeben werden
			/*if(logger.getLevel()!=null)
				logger.info("Loglevel:"+logger.getLevel());
			else
				logger.warning("Übergeordneter Level!!!");
			*/
			logger.setUseParentHandlers(false);
			logger.config("Start des Programmes Countdown "+Start.VERSION+"\nMaschinendaten:\n-----------------------\nSpeicherverbrauch     : "+Runtime.getRuntime().totalMemory()+"\nFreier Speicher       : "+Runtime.getRuntime().freeMemory()+"\nMaximaler Speicher    : "+Runtime.getRuntime().maxMemory()+"\nAnzahl der Prozessoren: "+Runtime.getRuntime().availableProcessors()+"\n");

			/*
			logger.severe("my severe message"); 
			logger.warning("my warning message"); 
			logger.info("my info message"); 
			logger.config("my config message"); 
			logger.fine("my fine message"); 
			logger.finer("my finer message"); 
			logger.finest("my finest message"); 
			*/

			/*
			//Veraltete Logdateifunktion
			file = new File(logname);
			fos = new FileOutputStream(file, true);
			bw = new BufferedWriter(new OutputStreamWriter(fos,"UTF-8"));
			bw.write("Maschinendaten:\n");
			bw.write("-----------------------\n");
			bw.write("Speicherverbrauch     : "+Runtime.getRuntime().totalMemory()+"\n");
			bw.write("Freier Speicher       : "+Runtime.getRuntime().freeMemory()+"\n");
			bw.write("Maximaler Speicher    : "+Runtime.getRuntime().maxMemory()+"\n");
			bw.write("Anzahl der Prozessoren: "+Runtime.getRuntime().availableProcessors()+"\n");
			*/
		} catch (java.io.IOException e){
			log = false;
			e.printStackTrace();
		}
	}
	
	public void logEnde(){
		/*
		log = false;
		try{
			bw.flush();
			fos.flush();
			fos.close();
		} catch (java.io.IOException e){
			e.printStackTrace();
		}
		*/
		logger.info("Logging wird beendet");
	}
}
