import java.util.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
import java.awt.datatransfer.*;
import java.util.logging.*;

public class AusruestungFenster extends JInternalFrame{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	private int raum = 0;
	private int zukunftRaum = 0;
	private Date zukunftRaumDate = new Date();
	
	private int strom = 0;
	private int zukunftStrom = 0;
	private Date zukunftStromDate = new Date();
	
	private Daten daten;
	
	private JPanel tisch;
	private JLabel leer = new JLabel(" ");
	private JLabel leer2 = new JLabel(" ");
	private JLabel raumLabel = new JLabel("Räume ");
	private JLabel zukunftRaumLabel = new JLabel(" in Zukunft ");
	private JLabel zukunftRaumDatumLabel = new JLabel(" ab wann");
	private JComboBox raumCB = new JComboBox();
	private JComboBox raumZCB = new JComboBox();
	private DateComboBox raumDatum = new DateComboBox(new Date());//
	
	private JLabel stromLabel = new JLabel("Geräte ");
	private JLabel zukunftStromLabel = new JLabel(" in Zukunft ");
	private JLabel zukunftStromDatumLabel = new JLabel(" ab wann");
	private JComboBox geratCB = new JComboBox();
	private JComboBox geratZCB = new JComboBox();
	private DateComboBox geratDatum = new DateComboBox(new Date());//
	
	private JButton ok = new JButton("OK");
	private JButton cancel = new JButton("Abbrechen");
	
	static void addComponent( Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height) 
	{ 
		GridBagConstraints gbc = new GridBagConstraints(); 
		gbc.fill = GridBagConstraints.BOTH; 
		gbc.gridx = x; gbc.gridy = y; 
		gbc.gridwidth = width; gbc.gridheight = height; 
		gbc.weightx = 1.0; gbc.weighty = 1.0; 
		gbl.setConstraints( c, gbc ); 
		cont.add( c ); 
	} 
	
	public AusruestungFenster(Daten daten){
		super();
		this.setTitle("Ausrüstung");
		this.setBounds(0,0,380,160);
		this.setResizable(true);
		this.setMaximizable(true);
		this.setIconifiable(true);
		this.setClosable(true);
		setDefaultCloseOperation(HIDE_ON_CLOSE);
		this.daten = daten;
		logger.finest("Ausrüstungsfenster fast fertig");
		initGui();
	}
	
	private void initGui(){
		Container c = this.getContentPane(); 
		GridBagLayout gbl = new GridBagLayout(); 
		c.setLayout( gbl ); 
		tisch = new JPanel(gbl);
		
		addComponent( tisch, gbl, raumLabel, 0, 0, 1, 1);
		addComponent( tisch, gbl, zukunftRaumLabel, 1, 0, 1, 1);
		addComponent( tisch, gbl, zukunftRaumDatumLabel, 2, 0, 1, 1);
		addComponent( tisch, gbl, raumCB, 0, 1, 1, 1);
		addComponent( tisch, gbl, raumZCB, 1, 1, 1, 1);
		addComponent( tisch, gbl, raumDatum, 2, 1, 1, 1);
		addComponent( tisch, gbl, leer, 0, 2, 3, 1);
		
		addComponent( tisch, gbl, stromLabel, 0, 3, 1, 1);
		addComponent( tisch, gbl, zukunftStromLabel, 1, 3, 1, 1);
		addComponent( tisch, gbl, zukunftStromDatumLabel, 2, 3, 1, 1);
		addComponent( tisch, gbl, geratCB, 0, 4, 1, 1);
		addComponent( tisch, gbl, geratZCB, 1, 4, 1, 1);
		addComponent( tisch, gbl, geratDatum, 2, 4, 1, 1);
		addComponent( tisch, gbl, leer2, 0, 5, 3, 1);
		
		addComponent( tisch, gbl, ok, 0, 6, 1, 1);
		addComponent( tisch, gbl, cancel, 1, 6, 1, 1);
		
		ok.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				//Speichern
				if(logger.isLoggable(Level.FINEST)) { logger.finest("Ausrüstung OK\n"+raumCB.getSelectedIndex()+" "+raumZCB.getSelectedIndex()+"::"+raumDatum.getDate()+"\n"+geratCB.getSelectedIndex()+" "+geratZCB.getSelectedIndex()+"::"+geratDatum.getDate()); }
				Ausrustung raum = new Ausrustung(raumCB.getSelectedIndex(), raumZCB.getSelectedIndex(), raumDatum.getDate());
				Ausrustung strom = new Ausrustung(geratCB.getSelectedIndex(), geratZCB.getSelectedIndex(), geratDatum.getDate());
				daten.setAusrustung(raum, strom);
				setVisible(false);
				update();
			} 
		} );
		
		cancel.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				setVisible(false); 
				update();
			} 
		} );
		
		for(int i = 0; i <= daten.maxRaume; i++){
			raumCB.addItem(""+i);
			raumZCB.addItem(""+i);
		}
		
		for(int i = 0; i <= daten.maxStrom; i++){
			geratCB.addItem(""+i);
			geratZCB.addItem(""+i);
		}
		update();
		this.getContentPane().add(tisch);
	}
	
	public void zeigen(){
		update();
		this.setVisible(false);
		try {
			this.setIcon(false);
		} catch (Exception e) {
			JOptionPane.showMessageDialog(this, "Fehler beim deiconifizieren!", "DeIconifizieren", JOptionPane.ERROR_MESSAGE);
			logger.warning("Fehler beim deiconifizieren");
		}
		this.setVisible(true);
	}
	
	public void update(){
		Ausrustung aRaum = daten.getRaeume();
		Ausrustung aGerat = daten.getGeraete();
		raumCB.setSelectedIndex(aRaum.getWert());
		raumZCB.setSelectedIndex(aRaum.getZukunft());
		raumDatum.setDate(aRaum.getDatum());
		
		geratCB.setSelectedIndex(aGerat.getWert());
		geratZCB.setSelectedIndex(aGerat.getZukunft());
		geratDatum.setDate(aGerat.getDatum());
	}
}
