import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;

//Vom Javabuch "Java in 21 Tagen"

public class CountTag extends DefaultHandler {

    public int patientenAnzahl;
    public int therapeutenAnzahl;
    public int terminAnzahl;
    public static final String strPatient = "Patient";
    public static final String strTherapeut = "Therapeut";
    public static final String strTermin = "Termin";

    CountTag(File input) {
        //File input = new File(xmlFile);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try {
            SAXParser sax = factory.newSAXParser();
            CountTagHandler cth = new CountTagHandler(strPatient);
            sax.parse(input, cth);
            patientenAnzahl = cth.count;
            //System.out.println("The " + cth.tag + " tag appears "
            //    + cth.count + " times.");           
        } catch (ParserConfigurationException pce) {
            System.out.println("Could not create that parser.");
            System.out.println(pce.getMessage());
        } catch (SAXException se) {
            System.out.println("Problem with the SAX parser.");
            System.out.println(se.getMessage());
        } catch (IOException ioe) {
            System.out.println("Error reading file.");
            System.out.println(ioe.getMessage());
        }
        factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try {
            SAXParser sax = factory.newSAXParser();
            CountTagHandler cth = new CountTagHandler(strTherapeut);
            sax.parse(input, cth);
            therapeutenAnzahl = cth.count;
            //System.out.println("The " + cth.tag + " tag appears "
            //    + cth.count + " times.");           
        } catch (ParserConfigurationException pce) {
            System.out.println("Could not create that parser.");
            System.out.println(pce.getMessage());
        } catch (SAXException se) {
            System.out.println("Problem with the SAX parser.");
            System.out.println(se.getMessage());
        } catch (IOException ioe) {
            System.out.println("Error reading file.");
            System.out.println(ioe.getMessage());
        }
        factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try {
            SAXParser sax = factory.newSAXParser();
            CountTagHandler cth = new CountTagHandler(strTermin);
            sax.parse(input, cth);
            terminAnzahl = cth.count;
            //System.out.println("The " + cth.tag + " tag appears "
            //    + cth.count + " times.");           
        } catch (ParserConfigurationException pce) {
            System.out.println("Could not create that parser.");
            System.out.println(pce.getMessage());
        } catch (SAXException se) {
            System.out.println("Problem with the SAX parser.");
            System.out.println(se.getMessage());
        } catch (IOException ioe) {
            System.out.println("Error reading file.");
            System.out.println(ioe.getMessage());
        }
    }
    
}

class CountTagHandler extends DefaultHandler {
    String tag;
    int count = 0;

    CountTagHandler(String tagName) {
        super();
        tag = tagName;
    }

    public void startElement(String uri, String localName,
        String qName, Attributes attributes) {
    
        if (qName.equals(tag))
            count++;
    }
}
