import java.text.SimpleDateFormat;
import java.util.*;
import java.util.zip.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
//import com.sun.image.codec.jpeg.*;
import java.util.regex.*;
import java.util.logging.*;
//import java.util.zip.ZipEntry;


public class Daten implements Serializable{
	public static final long serialVersionUID = 1L;
	private static final int ende = 300;//734;//Anzahl der Tage, heute ist immer Tag (734/2)=367
	public static final int maxTherapeuten = 10;//Anzahl der möglichen Therapeuten
	public static final int testpat = 10;//Test für maximale Patienten
	public static final int maxRaume = 20;//Maximale Räume für die Behandlungen
	public static final int maxStrom = 20;//Maximale Strom- und Ultraschallgeräte
	private static final int numLogFiles = 100;//Maximale Logfiles
	private static final int MAXSAVETIME = 300000;//5000 = 5 Sekunden 60000 300000 = 5 Minuten
	public static final int EINTRAG = 0;
	public static final int THERAPEUT = 1;
	public static final int PATIENT = 2;
	//public static final String[] uhrzeit = new String[86];
	public final static String[] UHRZEIT = new String[86];

	//Logging
	//public static final String logname = "Logdatei";
	//public static final String logname2 = "Logdatei2";
	private int loglevel = 0;
	private static Logger logger;
	private Handler file_handler;
	private java.util.logging.Formatter klartext;
	//file_handler = new FileHandler(logname2, true);
	// Create a file handler that uses 3 logfiles, 
	// each with a limit of 1Mbyte 
	private final String pattern = ".Log-Physio-%g.log"; 
	private final int limit = 10485760;//=10MB; 
	private long dateiversion = 0;
	private boolean[] ichMacheNichts = {true, true, true};
	
	//private Debug d = new Debug(false);
	private boolean debug = false;
	private File file;
	private FileOutputStream fos;// = new FileOutputStream(file);
	private BufferedWriter bw;// = new BufferedWriter(new OutputStreamWriter(fos,"UTF-8"));

	private byte[] mem=new byte[5000000];
	private boolean memBaer = false;
	private Physiomat physiomat;
	private KalenderFenster kalenderfenster;
	private PatientenFenster patientenfenster;
	private TherapeutenFenster therapeutenfenster;
	private Termin[][][][] termine;
	private Vector<Therapeut> therapeuten = new Vector<Therapeut>(1,1);//Aber maximal ($maxTherapeuten) Therapeuten!!!
	private Vector<Patient> patienten   = new Vector<Patient>(100,10);
	private int theraNummer = 0;//Identität (wofür?)
	private int thera = 0;//Ausgewählter Therapeut für andere Sichtbar.

	private int wochenstart = -1;//Spalte des Wochenstarts
	private int tagesSpalte = -1;//Spalte aus Tagesansicht
	private Calendar wochenAnfangsTag = Calendar.getInstance();
	private int druckweite = 600;

	private boolean log = false;
	private boolean noInit = true;
	private boolean saveUpdate = false;
	
	private long saveZeit = System.currentTimeMillis();
	
	private Ausrustung raeume = new Ausrustung(1,1,new Date());//Ein Raum braucht er schon
	private Ausrustung geraete = new Ausrustung();//Aber nicht zwingend Geräte

	public Daten(int loglevel, Physiomat p){
		this.loglevel = loglevel;
		physiomat = p;
	}
	
	public static int getMaximalTherapeuten(){
		return maxTherapeuten;
	}

	public void init(File file){
		log = true;
		logStart();
		logger.fine("Betrete init");
		int j = 0;
		for(int i = 7; i < 10; i++){
			UHRZEIT[j++]="0"+i+":00";
			UHRZEIT[j++]="0"+i+":10";
			UHRZEIT[j++]="0"+i+":20";
			UHRZEIT[j++]="0"+i+":30";
			UHRZEIT[j++]="0"+i+":40";
			UHRZEIT[j++]="0"+i+":50";
		}
		for(int i = 10; i < 21; i++){
			UHRZEIT[j++]=""+i+":00";
			UHRZEIT[j++]=""+i+":10";
			UHRZEIT[j++]=""+i+":20";
			UHRZEIT[j++]=""+i+":30";
			UHRZEIT[j++]=""+i+":40";
			UHRZEIT[j++]=""+i+":50";
		}
		UHRZEIT[j++]="21:00";
		
		termine = new Termin[ende][86][maxTherapeuten][2];
		physiomat.setStatusBar(ende+testpat, "Initialisieren", "initialisiere Terminkalender", "");
		//System.out.println("jojo");
		int tag = 0;//Tag
		int uhr = 0;//Uhrzeit
		int ther = 0;//Therapeut
		int tp = 0;//normaler Termin und Packung
		int i = 0;
		//therapeuten.add(new Therapeut());//Dummy für den NEU-Eintrag
		try{
			for(tag= 0; tag < ende; tag++)
			for(uhr = 0; uhr < 86; uhr++)//Zehnminutentaktung
			for(ther = 0; ther < maxTherapeuten; ther++)//Therapeuten
			for(tp=0; tp < 2; tp++){//Pakungstermin
				//if(uhr < 1 || uhr > 49)//49-79
					termine[tag][uhr][ther][tp] = new Termin();//(0, new Patient(), "Test "+tag, true, true, true, true, "wichtig: "+ther);//Autor("Test "+test, "Toast "+test, test);
				//physiomat.setStatusBar(tag);
				//else {
					//termine[tag][uhr][ther][tp] = new Termin(Termin.FREI);
				//}
				if(tag!=0)
					physiomat.setStatusBar(tag, ""+(100*tag/(ende+testpat))+"%");
				//physiomat.setStatusBar(1, ""+(int)(ende/tag));
						//System.out.println("Autor: "+test);
			}
			/*
				Lege Testweise noch testpat Patienten an.
			*/
			
			for(i= 0; i < testpat; i++){
				patienten.add(new Patient(""+i, "Meier"));
				physiomat.setStatusBar(ende+i, ""+(100*(ende+i)/(ende+testpat))+"%");
			}
			physiomat.setStatusBar(ende+i, ""+(100*(ende+i)/(ende+testpat))+"%");
			patienten.removeAllElements();
			kalenderfenster = physiomat.getKalenderFenster();
			patientenfenster = physiomat.getPatientenFenster();
			therapeutenfenster = physiomat.getTherapeutenFenster();
			boolean offnenKlappte = false;
			if(file != null)
				offnenKlappte = open(file);
			else
				offnenKlappte = open();
			saveZeit = System.currentTimeMillis();
			Thread nt = new Thread(){ public void run(){
				long ms = System.currentTimeMillis();
				try {
					Thread.sleep(MAXSAVETIME);
				} catch (InterruptedException e){
					logger.warning("Unterbrechung in sleep()");
				}
				threadSave(ms);
				} };
			nt.start();
			if(offnenKlappte)
				setUpdate();
			physiomat.setStatus(Physiomat.START);
		} catch (OutOfMemoryError oome){
			mem = null;
			//logger.warning("Zuwenig Speicher!");
			logger.severe("Zuwenig Speicher!\nMaschinendaten:\n-----------------------\nSpeicherverbrauch     : "+Runtime.getRuntime().totalMemory()+"\nFreier Speicher       : "+Runtime.getRuntime().freeMemory()+"\nMaximaler Speicher    : "+Runtime.getRuntime().maxMemory()+"\nMaximale Termine: "+ende+"\nPatienten: "+i+"-"+patienten.size()+"\nmaximale Therapeuten: "+maxTherapeuten+"\n");
			System.gc();
			System.err.println("java.lang.OutOfMemoryError...");
			System.err.println("... abgefangen ...");
			System.err.println("Zuwenig Speicher für die Kalenderfunktion");
			System.err.println("Programm wird beendet ...");
			JOptionPane.showMessageDialog(physiomat,
				"Das Programm hat bei der Initialisierung erkannt,\ndass nicht genügend Speicher vorhanden ist.\nBitte weisen Sie dem Programm\ndurch die Angabe \"-Xmx400m\"\nmindestens 400MB an RAM zu.",
				"Zuwenig RAM-Speicher.", 
				JOptionPane.ERROR_MESSAGE, null);
			new File(".physiomat/.lauf").delete();
			System.exit(-1);
		}
		physiomat.setStatusBar(100, "", "Fertig.", "100%");
		physiomat.setStatusBar(100);
		physiomat.nachInit();
		noInit = false;
		kalenderfenster.drueckeKnopf();
	}

	public int getTheraNummer(){
		return theraNummer;
	}

	public int getAndAddTheraNummer(){
		return ++theraNummer;
	}

	public void addTherapeuten(Therapeut t){
		therapeuten.add(t);
		//Hinzufügen des Therapeuten zum Kalender
		//macht nun die Updatefunktion global
		//kalenderfenster.addTherapeuten(t);
	}

	public void setTherapeuten(int index, Therapeut t){
		therapeuten.set(index, t);
	}

	public Therapeut getTherapeut(int index){
		Therapeut t = new Therapeut();
		if(index >= 0 && index < therapeuten.size()){
			t = therapeuten.get(index);
		}
		return t;
	}
	
	public Patient getPatient(int index){
		Patient p = new Patient();
		if(index >= 0 && index < patienten.size()){
			p = patienten.get(index);
		}
		return p;
	}
	
	public int getTerminPatient(Patient p){
		int wert = -1;//Nicht gefunden
		for(int i = 0; i < patienten.size(); i++)
			if(getPatient(i) == p)
				wert = i;
		return wert;
	}
	
	public int getMaxTherapeuten(){
		return therapeuten.size();
	}
	
	public int getMaxPatienten(){
		return patienten.size();
	}

	public void delTherapeuten(int index){
		logger.finest("Index: "+index);
		therapeuten.remove(index);
	}
	
	public void addPatient(Patient p){
		/*
		Alphabetisch sortieren
		Sortiert wird nach Nachname und Vorname. Wenn dann immer noch zwei denselben Vor- und Zunamen haben, dann
		werden sie hintereinander eingefügt.
		*/
		if(logger.isLoggable(Level.FINEST)) { logger.finest("Betrete Methode"); }
		String name = p.getNachname();
		String vorname = p.getVorname();
		int z = 0;
		if(patienten.size() == 0){
			if(logger.isLoggable(Level.FINEST)) { logger.finest("Erster Eintrag: "+vorname+" "+name) ; } 
			patienten.add(p);
		} else {
			//(Patient)patienten.get(0)
			while((z < patienten.size()) && (name.compareTo((patienten.get(z)).getNachname())>0))
				z++;
			if(z >= patienten.size()){
				patienten.add(p);//Hinten ranhängen
				if(logger.isLoggable(Level.FINEST)) { logger.finest("Hinten ran: "+vorname+" "+name) ; } 
			} else {
				/*
					Hier ranhängen.
					Vorher überprüfen, ob wir hier reinpassen.
				*/
				if(vorname.compareTo((patienten.get(z)).getVorname())<0){
					if(logger.isLoggable(Level.FINEST)) { logger.finest("if(vorname.compareTo(((Patient)patienten.get(z)).getVorname())<0)");} 
					patienten.add(z,p);
				} else {
					if(logger.isLoggable(Level.FINEST)) { logger.finest(vorname+">"+(patienten.get(z)).getVorname()); } 
					while((z < patienten.size()) && (name.compareTo((patienten.get(z)).getNachname())==0) && (vorname.compareTo((patienten.get(z)).getVorname())>=0))//Hier ändern, falls neue mit gleichen Namen eher vorne statt hinten
						z++;
					if(z >= patienten.size()){
						patienten.add(p);//Hinten ranhängen
						if(logger.isLoggable(Level.FINEST)) { logger.finest("Doch noch hinten ran");}
					} else {
						patienten.add(z,p);
						if(logger.isLoggable(Level.FINEST)) { logger.finest("An Stelle "+z);}
					}
				}
			}
		}
		if(z >= patienten.size())
			z = patienten.size()-1;
		patientenfenster.update(z);
	}

	public boolean pruefePatient(Patient p){
		/*
			Gehe die komplette Liste durch und Prüfe,
			ob ein Patient mit diesem Patienten gleich ist.
		*/
		if(logger.isLoggable(Level.FINEST)) { logger.finest("Patentenprüfung");}
		boolean gut = true;
		if(patienten.size()>0){
			int i = 0;
			while (i < patienten.size()){
				if(p.equals(patienten.get(i))){
					gut = false;
					logger.fine("Patient gibt es schon!!!");
					return false;
				}
				i++;
			}
		}
		return gut;
	}

	public void editPatient(Patient p){
		/*
			Finde gleichen Patienten und dann füge die Eigenschaften dieses Patienten hinzu.
			Auf keinen Fall die History überschreiben!!! Nur ergänzen!!!
		*/
		logger.fine("Patient wird editiert");
		boolean gut = true;
		if(patienten.size()>0){
			int i = 0;
			while((i < patienten.size()) && gut){
				if(p.equals(patienten.get(i))){
					gut = false;
					logger.fine("Patient gefunden.");
					Patient pat = patienten.get(i);
					pat.add(p);
				}
				i++;
			}
		} else {
			if(logger.isLoggable(Level.FINEST)) { logger.finest("Patient wurde hinten angehangen");}
			addPatient(p);
		}
	}

	public void savePatient(Patient p, int wo){
		patienten.remove(wo);
		//Falls Name geändert, neu einsortieren:
		String name = p.getNachname();
		String vorname = p.getVorname();
		int z = 0;
		while((z < patienten.size()) && (name.compareTo((patienten.get(z)).getNachname())>0))
				z++;
		if(z >= patienten.size()){
			patienten.add(p);//Hinten ranhängen
			if(logger.isLoggable(Level.FINEST)) { logger.finest("Hinten ran: "+vorname+" "+name) ; } 
		} else {
			/*
				Hier ranhängen.
				Vorher überprüfen, ob wir hier reinpassen.
			*/
			if(vorname.compareTo((patienten.get(z)).getVorname())<0)
				patienten.add(z,p);
			else {
				if(logger.isLoggable(Level.FINEST)) { logger.finest(vorname+">"+(patienten.get(z)).getVorname()) ; } 
				while((z < patienten.size()) && (name.compareTo((patienten.get(z)).getNachname())==0) && (vorname.compareTo((patienten.get(z)).getVorname())>=0))//Hier ändern, falls neue mit gleichen Namen eher vorne statt hinten
					z++;
				if(z >= patienten.size())
					patienten.add(p);//Hinten ranhängen
				else
					patienten.add(z,p);
			}
		}
		//patienten.add(wo,p);Nur ohne Prüfung
	}
	
	public void setUpdate(){
		//Alle Fenster, in denen Updates erfolgen müssen, werden informiert.
		therapeutenfenster.update();
		kalenderfenster.updateWoche();
		kalenderfenster.update();
		patientenfenster.update();
		saveUpdate = true;
		physiomat.setStatus(Physiomat.UNSAVE);
	}
	
	public void setUnsave(){
		saveUpdate = true;
		physiomat.setStatus(Physiomat.UNSAVE);
	}

	public int getMaxTage(){
		return ende;
	}
	
	public void log(String ausgabe){
		/*
		if(log){
			//System.out.print(ausgabe);
			long time = System.currentTimeMillis();
			SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
			String uhrzeit = sdf.format(new Date(time));
			try{
				bw.write(uhrzeit+" "+ausgabe);
				bw.newLine();
				bw.flush();
			} catch (java.io.IOException e){
				ausgabe = ausgabe+"\nFehler beim Schreiben in die Logdatei\n";
				e.printStackTrace();
				System.err.print(ausgabe);
			}
		}
		*/
		logger.warning("Hier greift jemand auf eine veraltete Logfunktion zu!");
	}
	
	private void logStart(){
	/*
		Für die Umleitung der System.err und System.out 
		http://blogs.sun.com/nickstephen/entry/java_redirecting_system_out_and
	*/
		try{
			logger = Logger.getLogger("de.sebamueller.Physiomat");
			Logger rootLog = Logger.getLogger("");//
			if(loglevel != -1){
				switch(loglevel){
					case 0 : rootLog.setLevel(Level.OFF);break;
					case 1 : rootLog.setLevel(Level.ALL);break;
					case 2 : rootLog.setLevel(Level.SEVERE);break;
					case 3 : rootLog.setLevel(Level.WARNING);break;
					case 4 : rootLog.setLevel(Level.INFO);break;
					case 5 : rootLog.setLevel(Level.CONFIG);break;
					case 6 : rootLog.setLevel(Level.FINE);break;
					case 7 : rootLog.setLevel(Level.FINER);break;
					case 8 : rootLog.setLevel(Level.FINEST);break;
				}
			}

			file_handler = new FileHandler(pattern, limit, numLogFiles); 
			
			klartext = new SimpleFormatter();
			file_handler.setFormatter(klartext);
			logger.addHandler(file_handler);
			
			//file_handler.setLevel(Level.ALL);
			
			System.err.print("Warnung: Der Stream wird in die Logdatei umgeleitet!\nWarning: Errorstream is piped in .Log-Physio-0.log\n");
			
			// preserve old stdout/stderr streams in case they might be useful      
			PrintStream stdout = System.out;                                       
			PrintStream stderr = System.err;                                       

			// now rebind stdout/stderr to logger                                  
			LoggingOutputStream los;                                               
			los = new LoggingOutputStream(logger, StdOutErrLevel.STDOUT);          
			System.setOut(new PrintStream(los, true));                             

			los= new LoggingOutputStream(logger, StdOutErrLevel.STDERR);           
			System.setErr(new PrintStream(los, true));            


			
			//System.err.print("Fehler!!!\n");
			//System.out.print("Ausgabe!!!\n");
			

			/*
			http://berrendorf.inf.h-brs.de/lehre/ss03/vups1/Seminar/3_LoggingInJava.pdf
			Level:
			SEVERE (höchste Dringlichkeit)
			WARNING
			INFO
			CONFIG
			FINE
			FINER
			FINEST (niedrigste Dringlichkeit)
			
			
			logger.severe("my severe message"); 
			logger.warning("my warning message"); 
			logger.info("my info message"); 
			logger.config("my config message"); 
			logger.fine("my fine message"); 
			logger.finer("my finer message"); 
			logger.finest("my finest message"); 
			
			
			* upon startup, use CONFIG to log configuration parameters
			* during normal operation, use INFO to log high-level "heartbeat" information
			* when bugs or critical conditions occur, use SEVERE
			* debugging information might default to FINE, with FINER and FINEST used occasionally, according to taste.
			
			// This method should be used when an exception is encounted 
				try { 
					// Test with an exception 
					throw new IOException(); 
				} catch (Throwable e){ 
				// Log the exception 
					logger.log(Level.SEVERE, "Uncaught exception", e); 
				} 
				
				// When a method is throwing an exception, this method should be used 
					Exception ex = new IllegalStateException(); 
					logger.throwing(this.getClass().getName(), "myMethod", ex); 
					
				// Programmablaufeingriff möglichst minimieren:
					if (logger.isLoggable(Level.FINEST)) { logger.finest("count: "+count); } 
					
					
					http://www.exampledepot.com/egs/java.util.logging/LogExcept.html
					http://www.exampledepot.com/egs/java.util.logging/pkg.html
			*/
			//logger.addHandler(file_handler);//Neuer Filehandler, hier kann also auch etwas auf die Konsole ausgegeben werden
			/*if(logger.getLevel()!=null)
				logger.info("Loglevel:"+logger.getLevel());
			else
				logger.warning("Übergeordneter Level!!!");
			*/
			logger.setUseParentHandlers(false);
			logger.config("Start des Programmes Physiomat "+physiomat.VERSION+"\nMaschinendaten:\n-----------------------\nSpeicherverbrauch     : "+Runtime.getRuntime().totalMemory()+"\nFreier Speicher       : "+Runtime.getRuntime().freeMemory()+"\nMaximaler Speicher    : "+Runtime.getRuntime().maxMemory()+"\nAnzahl der Prozessoren: "+Runtime.getRuntime().availableProcessors()+"\nMaximale Termine: "+ende+"\nmaximale Patienten: "+patienten.size()+"-"+testpat+"\nmaximale Therapeuten: "+maxTherapeuten+"\n");

			/*
			logger.severe("my severe message"); 
			logger.warning("my warning message"); 
			logger.info("my info message"); 
			logger.config("my config message"); 
			logger.fine("my fine message"); 
			logger.finer("my finer message"); 
			logger.finest("my finest message"); 
			*/

			/*
			//Veraltete Logdateifunktion
			file = new File(logname);
			fos = new FileOutputStream(file, true);
			bw = new BufferedWriter(new OutputStreamWriter(fos,"UTF-8"));
			bw.write("Maschinendaten:\n");
			bw.write("-----------------------\n");
			bw.write("Speicherverbrauch     : "+Runtime.getRuntime().totalMemory()+"\n");
			bw.write("Freier Speicher       : "+Runtime.getRuntime().freeMemory()+"\n");
			bw.write("Maximaler Speicher    : "+Runtime.getRuntime().maxMemory()+"\n");
			bw.write("Anzahl der Prozessoren: "+Runtime.getRuntime().availableProcessors()+"\n");
			*/
		} catch (java.io.IOException e){
			log = false;
			e.printStackTrace();
		}
	}
	
	public void logEnde(){
		/*
		log = false;
		try{
			bw.flush();
			fos.flush();
			fos.close();
		} catch (java.io.IOException e){
			e.printStackTrace();
		}
		*/
		logger.info("Logging wird beendet");
	}
	
	public int getSpalte(Date zeit){
		/*
			Gegeben ist ein Datum, ausgeliefert wird das Feld, welches in
			termine eingegeben werden muss.
			Wenn das Datum ausserhalb ist, dann wird eine -1 zurückgegeben.
			heute ist immer Tag (734/2)=367
		*/
		int wert = -1;
		if(noInit)
			return -1;
		
		Calendar von = Calendar.getInstance();
		Calendar bis = Calendar.getInstance();
		Calendar klick = Calendar.getInstance();
		von.setTime(stripTime(new Date()));
		bis.setTime(stripTime(new Date()));
		int zeitrahmen = (getMaxTage()/2);//=heute
		von.add(Calendar.DATE, -zeitrahmen);
		bis.add(Calendar.DATE, zeitrahmen);
		klick.setTime(zeit);
		
		long klickms = klick.getTime().getTime();
		long vonms   = von.getTime().getTime();
		long bisms   = bis.getTime().getTime();
		
		//getTime()
		//bis.add(Calendar.DATE, +5);
		int vorher = tage(klick.getTime(), von.getTime());//Wenn >0, dann ausserhalb
		int nachher = tage(bis.getTime(), klick.getTime());//Wenn >0, dann ausserhalb
		int tage = tage(von.getTime(), klick.getTime());
		//if(logger.isLoggable(Level.FINEST)) { logger.finest("Zeitberechnung:\nvorher: "+vorher+"\nnachher: "+nachher+"\nTag: "+tage); }
		if((klickms < vonms) || (bisms < klickms)){
			wert = -1;
		} else {
			//(int)((myGregorianCalendar1.getTimeInMillis() - myGregorianCalendar2.getTimeInMillis()) / 86400000);
			wert = tage;
		}
		return wert;
	}
	
	public static int tage(Date von, Date bis) {
	//Zählt die Tage zwischen zwei Daten
		int tage = 0;
		Calendar start = new GregorianCalendar();
		start.setTime(von);
		Calendar ende = new GregorianCalendar();
		ende.setTime(bis);
		//tage = (int)(ende.getTimeInMillis() - start.getTimeInMillis())/(24*60*60*1000);
		
		long diffMillis = ende.getTimeInMillis() - start.getTimeInMillis();
		//long diffDays = diffMillis/(24*60*60*1000);
		long diffDays = diffMillis/(86400000);

		tage = (int)diffDays;

		
		return tage;
	}
	
	public Ausrustung getRaeume(){
		return raeume;
	}
	
	public Ausrustung getGeraete(){
		return geraete;
	}
	
	public void setAusrustung(Ausrustung raeume, Ausrustung geraete){
		this.raeume = raeume;
		this.geraete = geraete;
	}
	
	public Termin getTermin(int tag, int uhr, int ther, int tp){
		if((tag < 0)||(tag >= ende) || (uhr < 0) || (uhr > 85) || (ther < 0) || (ther >= maxTherapeuten) || (tp < 0) || (tp > 1))
			return new Termin();
		else 
			return termine[tag][uhr][ther][tp];
	}
	
	public void setTermin(int tag, int uhr, int ther, int tp, Termin termin){
		logger.finest("Betreten");
		if((tag < 0)||(tag >= ende) || (uhr < 0) || (uhr > 85) || (ther < 0) || (ther >= maxTherapeuten) || (tp < 0) || (tp > 1)){
			logger.warning("Neuer Termin geht nicht!\nTag: "+tag+" <0|>="+ende+"\nUhr: "+uhr+" <0|>85\nTherapeut: "+ther+" <0|>= "+maxTherapeuten+"\nPackung: "+tp+" <0|>1");
		}else {
			termine[tag][uhr][ther][tp] = termin;
			//logger.finest("Neuer Termin erfolgreich eingetragen");
		}
	}
	
	public void setaktivenTherapeuten(int thera){
		this.thera = thera;
	}
	
	public int getAktivenTherapeuten(){
		return thera;
	}
	
	public Date getLastDay(){
		/*
			Gibt das Datum der letzten Spalte zurück
		*/
		int lastSpalte = ende;
		int heuteSpalte = ende/2;
		Calendar c = Calendar.getInstance();
		c.setTime(stripTime(new Date()));
		c.add(Calendar.DATE, lastSpalte-heuteSpalte);
		return stripTime(c.getTime());
	}

	public Date getFirstDay(){
		/*
			Gibt das Datum der ersten (0.) Spalte zurück
		*/
		int lastSpalte = ende;
		int zeitraum = ende/2;
		Calendar c = Calendar.getInstance();
		c.setTime(stripTime(new Date()));
		c.add(Calendar.DATE, -zeitraum);
		return stripTime(c.getTime());
	}
	
	public Date getDate(int spalte){
		/*
			Liefert zu einer Spalte das Datum zurück.
			Wenn spalte < 0 oder spalte > ende, dann ist das datum größer oder kleiner dem Wertebereich aber gültig.
		*/
		Date firstDay = getFirstDay();
		//firstDay = new Date(firstDay.getTime()+5000);
		//int heuteSpalte = (int)ende/2;
		Calendar c = Calendar.getInstance();
		c.setTime(firstDay);
		c.add(Calendar.DATE, (spalte+1));
		logger.finest("Datum: "+c.getTime());
		return stripTime(c.getTime());
	}

	public void setWochenAnfang(Calendar cal){
		//Wochenanfang setzen,
		//so dass nur noch wochenanfang plus Spalte = Terminliste
		wochenstart = getSpalte(cal.getTime());//= -1, falls ausserhalb
		wochenAnfangsTag.setTime(cal.getTime());
	}

	public void setWochenTag(Calendar cal){
		//Extra den Tag setzen.
		tagesSpalte = getSpalte(cal.getTime());//= -1, falls ausserhalb
	}

	public int getWochenAnfang(){
		return wochenstart;
	}

	public int getWochenTag(){
		return tagesSpalte;
	}

	public Calendar getWochenStartTag(){
		return wochenAnfangsTag;
	}

	public String getMaxWochenStunden(int therapeut){
		//aktuelle Woche
		int mws = 0;
		int j = 0;
		int i = wochenstart; 
		int art;
		Termin termin;
		if(therapeut >= 0 && therapeut < maxTherapeuten){
			while(j < 7){
				if(i < ende)
					for(int k=0; k < 86; k++){
						termin = getTermin(i, k, therapeut, 0);
						art = termin.getArt();
						if(art == Termin.FREI || art == Termin.PATIENT || art == Termin.KURS)// || art == Termin.ANMELDUNG)
							mws++;
					}
				i++;
				j++;
			}
		}
		int vorne = mws/6;
		int hinten = mws-vorne*6;
		switch (hinten){
			case 0 : hinten = 0;break;
			case 1 : hinten = 16;break;
			case 2 : hinten = 33;break;
			case 3 : hinten = 5;break;
			case 4 : hinten = 66;break;
			case 5 : hinten = 83;break;
		}
		return ""+vorne+"."+hinten;
	}

	public String getWochenStunden(int therapeut){
		//aktuelle Woche
		int mws = 0;
		int j = 0;
		int i = wochenstart; 
		int art;
		Termin termin;
		if(therapeut >= 0 && therapeut < maxTherapeuten){
			while(j < 7){
				if(i < ende)
					for(int k=0; k < 86; k++){
						termin = getTermin(i, k, therapeut, 0);
						art = termin.getArt();
						if(art == Termin.PATIENT || art == Termin.KURS)// || art == Termin.ANMELDUNG)
							mws++;
					}
				i++;
				j++;
			}
		}
		int vorne = mws/6;
		int hinten = mws-vorne*6;
		switch (hinten){
			case 0 : hinten = 0;break;
			case 1 : hinten = 16;break;
			case 2 : hinten = 33;break;
			case 3 : hinten = 5;break;
			case 4 : hinten = 66;break;
			case 5 : hinten = 83;break;
		}
		return ""+vorne+"."+hinten;
	}
	
	public String getAlleWochenStunden(int therapeut){
		//aktuelle Woche
		int mws = 0;
		int j = 0;
		int i = wochenstart; 
		int art;
		Termin termin;
		if(therapeut >= 0 && therapeut < maxTherapeuten){
			while(j < 7){
				if(i < ende)
					for(int k=0; k < 86; k++){
						termin = getTermin(i, k, therapeut, 0);
						art = termin.getArt();
						if(art == Termin.PATIENT || art == Termin.KURS || art == Termin.ANMELDUNG)
							mws++;
					}
				i++;
				j++;
			}
		}
		int vorne = mws/6;
		int hinten = mws-vorne*6;
		switch (hinten){
			case 0 : hinten = 0;break;
			case 1 : hinten = 16;break;
			case 2 : hinten = 33;break;
			case 3 : hinten = 5;break;
			case 4 : hinten = 66;break;
			case 5 : hinten = 83;break;
		}
		return ""+vorne+"."+hinten;
	}


	public void save(){
		/*
			Speichern in der Standarddatei ~/pdaten.pmt
		*/
		saveZeit = System.currentTimeMillis();
		Thread nt = new Thread(){ public void run(){
				long ms = System.currentTimeMillis();
				try {
					Thread.sleep(MAXSAVETIME);
				} catch (InterruptedException e) {
					logger.warning("Unterbrechung in sleep()");
				}
				threadSave(ms);
				} };
		nt.start();
		if(ichMacheNichts[EINTRAG] && ichMacheNichts[PATIENT] && ichMacheNichts[THERAPEUT]){
			FileOutputStream fos;
			ObjectOutputStream oos;
			FileInputStream fis;
			ObjectInputStream ois;
	
			int read = 0;
			int maxC = (patienten.size()+therapeuten.size()+(ende*therapeuten.size()))*2;
			int pos = 0;
			FileInputStream in;
			byte[] data = new byte[1024];
			ZipOutputStream out;
			ZipEntry entry;
			
			logger.info("Speichere Daten in .physiomat/.pdaten_"+dateiversion+".pmt\n"+maxC);
			String ausgabe = "Keine Fehler";
			File f = new File("pdaten.xml");
			physiomat.setStatusBar(maxC, "Speichern", "Version: "+dateiversion+"", "");
			try{
				/*
					Unterverzeichnis erstellen, damit nicht alles im Hauptverzeichnis steht
				*/
				File verzeichnis = new File(".physiomat");
				if(!verzeichnis.exists()){
					logger.info("Verzeichnis "+verzeichnis.getAbsolutePath()+ " existiert noch nicht.");
					if(!verzeichnis.mkdirs())
						logger.info("Verzeichnis "+verzeichnis.getAbsolutePath()+ " konnte nicht angelegt werden.");
				} else {
					logger.info("Verzeichnis "+verzeichnis.getAbsolutePath()+ " existiert schon.");
				}
			
				XMLExport xx = new XMLExport(this, f, 0, maxC);
				pos = xx.getPos();
				out = new ZipOutputStream(new FileOutputStream(new File(".physiomat/.pdaten_"+dateiversion+".pmt")));
				out.setMethod(ZipOutputStream.DEFLATED);//Komprimieren
				entry = new ZipEntry(f.getName());
				in = new FileInputStream(f);
				out.putNextEntry(entry);
				while((read = in.read(data, 0, 1024)) != -1)
					out.write(data, 0, read);
				out.closeEntry(); // Neuen Eintrag abschlie\u00dfen
				in.close();
				out.close();
				f.delete();
				saveUpdate = false;
				physiomat.setStatus(Physiomat.GELADEN);
			} catch (java.io.IOException e){
				e.printStackTrace();
				ausgabe = "Fehler beim Abspeichern des Backups!!!";
			}
			//logger.finest("Speicherwert:\n"+patienten.size()+"\n"+therapeuten.size()+"\n"+(ende*therapeuten.size())+"\n===\n"+(patienten.size()+therapeuten.size()+(ende*therapeuten.size())+1));

			logger.info("Speichere Daten in "+(new File(".physiomat/.pdaten.pmt")).getAbsolutePath());
			f = new File("pdaten.xml");
			try{
				XMLExport xx = new XMLExport(this, f, pos, maxC);
				out = new ZipOutputStream(new FileOutputStream(new File(".physiomat/.pdaten.pmt")));
				out.setMethod(ZipOutputStream.DEFLATED);//Komprimieren
				entry = new ZipEntry(f.getName());
				in = new FileInputStream(f);
				out.putNextEntry(entry);
				while((read = in.read(data, 0, 1024)) != -1)
					out.write(data, 0, read);
				out.closeEntry(); // Neuen Eintrag abschlie\u00dfen
				in.close();
				out.close();
				f.delete();
			} catch (java.io.IOException e){
				e.printStackTrace();
				ausgabe = "Fehler beim Abspeichern!!!";
			}
			//physiomat.setStatusBar(patienten.size()+therapeuten.size()+(ende*therapeuten.size())+1, ausgabe);
			//logger.finest("Speicherwert:\n"+patienten.size()+"\n"+therapeuten.size()+"\n"+(ende*therapeuten.size())+"\n===\n"+(patienten.size()+therapeuten.size()+(ende*therapeuten.size())+1));
			dateiversion++;
			physiomat.setUnstable(false);
		}
	}
	
	public void save(File datei){
		/*
			Speichern in der Standarddatei ~/pdaten.pmt
		*/
		saveZeit = System.currentTimeMillis();
		Thread nt = new Thread(){ public void run(){
				long ms = System.currentTimeMillis();
				try {
					Thread.sleep(MAXSAVETIME);
				} catch (InterruptedException e) {
					logger.warning("Unterbrechung in sleep()");
				}
				threadSave(ms);
				} };
		nt.start();
		FileOutputStream fos;
		ObjectOutputStream oos;
		FileInputStream fis;
		ObjectInputStream ois;

		int read = 0;
		int maxC = (patienten.size()+therapeuten.size()+(ende*therapeuten.size()))*3;
		int pos = 0;
		FileInputStream in;
		byte[] data = new byte[1024];
		ZipOutputStream out;
		ZipEntry entry;
		
		logger.info("Speichere Daten in .pdaten_"+dateiversion+".pmt\n"+maxC);
		String ausgabe = "Keine Fehler";
		File f = new File("pdaten.xml");
		physiomat.setStatusBar(maxC, "Speichern", "Version: "+dateiversion+"", "");
		try{
			File verzeichnis = new File(".physiomat");
			if(!verzeichnis.exists()){
				verzeichnis.mkdirs();
			}
			XMLExport xx = new XMLExport(this, f, 0, maxC);
			pos = xx.getPos();
			out = new ZipOutputStream(new FileOutputStream(new File(".physiomat/.pdaten_"+dateiversion+".pmt")));
			out.setMethod(ZipOutputStream.DEFLATED);//Komprimieren
			entry = new ZipEntry(f.getName());
			in = new FileInputStream(f);
			out.putNextEntry(entry);
			while((read = in.read(data, 0, 1024)) != -1)
				out.write(data, 0, read);
			out.closeEntry(); // Neuen Eintrag abschlie\u00dfen
			in.close();
			out.close();
			f.delete();
			saveUpdate = false;
			physiomat.setStatus(Physiomat.GELADEN);
		} catch (java.io.IOException e){
			e.printStackTrace();
			ausgabe = "Fehler beim Abspeichern des Backups!!!";
		}
		//logger.finest("Speicherwert:\n"+patienten.size()+"\n"+therapeuten.size()+"\n"+(ende*therapeuten.size())+"\n===\n"+(patienten.size()+therapeuten.size()+(ende*therapeuten.size())+1));
		
		logger.info("Speichere Daten in "+(new File(".physiomat/.pdaten.pmt")).getAbsolutePath());
		f = new File("pdaten.xml");
		try{
			XMLExport xx = new XMLExport(this, f, pos, maxC);
			pos = xx.getPos();
			out = new ZipOutputStream(new FileOutputStream(new File(".physiomat/.pdaten.pmt")));
			out.setMethod(ZipOutputStream.DEFLATED);//Komprimieren
			entry = new ZipEntry(f.getName());
			in = new FileInputStream(f);
			out.putNextEntry(entry);
			while((read = in.read(data, 0, 1024)) != -1)
				out.write(data, 0, read);
			out.closeEntry(); // Neuen Eintrag abschlie\u00dfen
			in.close();
			out.close();
			f.delete();
		} catch (java.io.IOException e){
			e.printStackTrace();
			ausgabe = "Fehler beim Abspeichern!!!";
		}

		logger.info("Speichere Daten in "+datei.getAbsolutePath());
		f = new File("pdaten.xml");
		try{
			XMLExport xx = new XMLExport(this, f, pos, maxC);
			out = new ZipOutputStream(new FileOutputStream(datei));
			out.setMethod(ZipOutputStream.DEFLATED);//Komprimieren
			entry = new ZipEntry(f.getName());
			in = new FileInputStream(f);
			out.putNextEntry(entry);
			while((read = in.read(data, 0, 1024)) != -1)
				out.write(data, 0, read);
			out.closeEntry(); // Neuen Eintrag abschlie\u00dfen
			in.close();
			out.close();
			f.delete();
		} catch (java.io.IOException e){
			e.printStackTrace();
			ausgabe = "Fehler beim Abspeichern!!!";
		}
		//physiomat.setStatusBar(patienten.size()+therapeuten.size()+(ende*therapeuten.size())+1, ausgabe);
		//logger.finest("Speicherwert:\n"+patienten.size()+"\n"+therapeuten.size()+"\n"+(ende*therapeuten.size())+"\n===\n"+(patienten.size()+therapeuten.size()+(ende*therapeuten.size())+1));
		dateiversion++;
		physiomat.setUnstable(false);
	}

	public boolean open(){
		/*
			Lade Standarddatei. Verschiebe eine Kopie nach .pdaten_JahrMonatTagStundeMinuteSekunde.pmt
			(Nur solange Testphase läuft. Sonst rotiere 10 Dateien)
		*/
		File file = new File(".physiomat/.pdaten.pmt");
		File ob = null;
		ZipFile zip;
		ZipEntry entry;
		Enumeration zFE;
		byte[] data = new byte[1024];
		int wieviel = 0;
		if(null != file){
			try {
				logger.info("Versuche Datei ("+file.getAbsolutePath()+") zu öffnen");
				//zip = new ZipFile(file.getName());
				zip = new ZipFile(file);
				logger.info("Datei ("+file.getName()+") geöffnet");
				zFE = zip.entries();
				while (zFE.hasMoreElements()){
					entry = (ZipEntry) zFE.nextElement();
					wieviel++;
				}
				zip.close();
				zip = new ZipFile(file);
				zFE = zip.entries();
				//XMLdatei auslesen:
				entry = (ZipEntry) zFE.nextElement();
				String currentEntry = entry.getName();
				//logger.info("
				//File destFile = new File(file.getPath()+currentEntry);
				File destFile = new File(file.getAbsolutePath()+currentEntry);
				ob = destFile;
				logger.info("Auspacken:\nDatei: "+ob.getAbsolutePath());

				if (!entry.isDirectory()){
					BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
					int currentByte;

					// write the current file to disk
					FileOutputStream fos = new FileOutputStream(destFile);
					BufferedOutputStream dest = new BufferedOutputStream(fos, 1024);

					// read and write until last byte is encountered
					while ((currentByte = is.read(data, 0, 1024)) != -1){
						dest.write(data, 0, currentByte);
					}
					dest.flush();
					dest.close();
					is.close();
				}
				CountTag ct;
				ct = new CountTag(ob);
				int maxCount = ct.patientenAnzahl+ct.therapeutenAnzahl+ct.terminAnzahl;
				logger.info("Analysiere XML-Datei:\nMaxmium: "+maxCount+"\nPatienten: "+ct.patientenAnzahl+"\nTherapeuten: "+ct.therapeutenAnzahl+"\nTermine: "+ct.terminAnzahl);
				physiomat.setStatusBar(maxCount, "Laden", "", "");
				physiomat.setStatusBar(0);
				XMLDaten xmlDaten = new XMLDaten(this, ob, maxCount);
				ob.delete();
				nachBearbeitung();
			} catch (java.util.zip.ZipException ze){
				//ze.printStackTrace();
				logger.warning("Zip-Datei konnte nicht geöffnet werden\n"+ze.getMessage());//+"\n"+ze.getStackTrace);
				physiomat.setUnstable(false);
				return false;
			} catch (java.io.FileNotFoundException fnfe){
				logger.info("Datei pdaten.pmt nicht gefunden, erstmaliger Start!");
				physiomat.setUnstable(false);
				return false;
			} catch (java.io.IOException ioe){
				ioe.printStackTrace();
				physiomat.setUnstable(false);
				return false;
			}
			/*
				Untersuche nun die Termine auf Doppelbelegung (Eine Stunde Kurs = sechs Einheiten)
			*/
		} else {
			/*
				Mache nüscht, weil die Datei gibts nicht.
			*/
			physiomat.setUnstable(false);
			return false;
		}
		physiomat.setUnstable(false);
		return true;
	}
	
	public void threadSave(long ms){
		if(saveUpdate){
			if(ms >= saveZeit){
				logger.info("Speichere selber");
				save();
			}
		} else {
			Thread nt = new Thread(){ public void run(){
				long ms = System.currentTimeMillis();
				try {
					Thread.sleep(MAXSAVETIME);
				} catch (InterruptedException e) {
					logger.warning("Unterbrechung in sleep()");
				}
				threadSave(ms);
				} };
			nt.start();
		}
		physiomat.testeZeit();
			
	}

	public void setStatusBar(int x){
		physiomat.setStatusBar(x);
	}
	
	public void setStatusBar(int x, String text){
		physiomat.setStatusBar(x, text);
	}
	
	public void setStatusBar(String x){
		physiomat.setStatusBar(x);
	}
	
	public long getDateiversion(){
		return dateiversion;
	}
	
	public void setDateiversion(long x){
		dateiversion = x+1;
	}

	public static Date stripTime(Date dt){
		java.util.Date dtStripped = null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(dt);
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH);
		int day = cal.get(Calendar.DAY_OF_MONTH);
		
		Calendar calStripped = Calendar.getInstance();
		calStripped.clear();
		calStripped.set(year, month, day);
		
		return calStripped.getTime(); 
	}
	
	public void nachBearbeitung(){
		logger.info("Nachbearbeitung\nMaximale Therapeuten: "+maxTherapeuten+"\nAnzahl der Tage: "+ende);
		int maxCounter = maxTherapeuten*ende;
		physiomat.setStatusBar(maxCounter, "Nachbearbeitung", "", "");
		physiomat.setStatusBar(0);
		int counter = 0;
		Termin t1, t2;
		for(int i = 0; i < maxTherapeuten; i++)
			for(int spalte = 0; spalte < ende; spalte++){
				setStatusBar(++counter, ""+counter*100/maxCounter+"%");
				for(int j = 0; j < 85; j++){
					//Spalte NORMAL
					t1 = getTermin(spalte, j, i, 0);
					t2 = getTermin(spalte, j+1, i, 0);
					if(t1.getArt() != Termin.FREI && t1.getArt() != Termin.KEINEARBEITSZEIT && t1.getID() == t2.getID() && t1.getArt() == t2.getArt()){
					//if(t1.getArt() != Termin.KEINEARBEITSZEIT){
						logger.finest("Termin mit gleicher ID gefunden. ID: "+t1.getID()+" "+t2.getID());
						setTermin(spalte,j+1,i,0,t1);
						t1.setZeit(t1.getVonZeit(), t2.getBisZeit());
					} 
					//Spalte PACKUNG
					t1 = getTermin(spalte, j, i, 1);
					t2 = getTermin(spalte, j+1, i, 1);
					if(t1.getArt() != Termin.FREI && t1.getArt() != Termin.KEINEARBEITSZEIT && t1.getID() == t2.getID() && t1.getArt() == t2.getArt()){
					//if(t1.getArt() != Termin.KEINEARBEITSZEIT){
						logger.finest("Termin mit gleicher ID gefunden. ID: "+t1.getID()+" "+t2.getID());
						setTermin(spalte,j+1,i,1,t1);
						t1.setZeit(t1.getVonZeit(), t2.getBisZeit());
					}
				}
				//Und jetzt noch einmal aber mit der Beachtung der Packungspatienten und Therapiepatienten
			/*
			*/
				
				for(int j = 0; j < 85; j++){
					t1 = getTermin(spalte, j, i, 1);
					t2 = getTermin(spalte, j+1, i, 0);
					if(t1.getArt() != Termin.FREI && t1.getArt() != Termin.KEINEARBEITSZEIT && t1.getID() == t2.getID() && t1.getArt() == t2.getArt()){
					//if(t1.getArt() != Termin.KEINEARBEITSZEIT){
						logger.finest("Termin mit gleicher ID gefunden. ID: "+t1.getID()+" "+t2.getID());
						setTermin(spalte,j+1,i,0,t1);
						t1.setZeit(t1.getVonZeit(), t2.getBisZeit());
					} 
				}
				
				/*
					Und noch einmal, weil sich die Referenzen geändert haben
				*/
				for(int j = 0; j < 85; j++){
					//Spalte NORMAL
					t1 = getTermin(spalte, j, i, 0);
					t2 = getTermin(spalte, j+1, i, 0);
					if(t1.getArt() != Termin.FREI && t1.getArt() != Termin.KEINEARBEITSZEIT && t1.getID() == t2.getID() && t1.getArt() == t2.getArt()){
					//if(t1.getArt() != Termin.KEINEARBEITSZEIT){
						logger.finest("Termin mit gleicher ID gefunden. ID: "+t1.getID()+" "+t2.getID());
						setTermin(spalte,j+1,i,0,t1);
						t1.setZeit(t1.getVonZeit(), t2.getBisZeit());
					} 
					//Spalte PACKUNG braucht nicht mehr, denn die ist schon sortiert
					/*
					t1 = getTermin(spalte, j, i, 1);
					t2 = getTermin(spalte, j+1, i, 1);
					if(t1.getArt() != Termin.FREI && t1.getArt() != Termin.KEINEARBEITSZEIT && t1.getID() == t2.getID() && t1.getArt() == t2.getArt()){
					//if(t1.getArt() != Termin.KEINEARBEITSZEIT){
						logger.finest("Termin mit gleicher ID gefunden. ID: "+t1.getID()+" "+t2.getID());
						setTermin(spalte,j+1,i,1,t1);
						t1.setZeit(t1.getVonZeit(), t2.getBisZeit());
					}
					*/
				}
			}
		
		/*
			Hier startet noch eine neue Routine, die prüft, ob es Konflikte gibt.
			Also, sind auch nur soviele Räume in Benutzung, wie vorgesehen?
			Werden Pausenzeiten eingehalten, wenn nein, welche hinzuschreiben oder Warnung ausgeben!
		*/
		logger.fine("Nachbearbeitung fertig!");
	}
	public void nichtSpeichern(int x){
		/*
			Eintrag, Patientenfenster oder TherapeutenFenster sind gerade offen.
		*/
		ichMacheNichts[x] = false;
	}
	
	public void speichernErlaubt(int x){
		ichMacheNichts[x] = true;
	}
	
	public int findeTermine(int index){
		int gefunden = 0;
		int max = therapeuten.size()*ende*86*2;
		int count = 0;
		physiomat.setStatusBar(max, "Suche Patienten im Kalender", "", "");
		Patient p = getPatient(index);//getTerminPatient(index);
		Patient p2;
		Termin t;
		for(int thera = 0; thera < therapeuten.size(); thera++)
			for(int spalte = 0; spalte < ende; spalte++)
				for(int zeile = 0; zeile < 86; zeile++)
					for(int packung = 0; packung < 2; packung++){
						physiomat.setStatusBar(count++, ""+(100*count/(max))+"%");
						t = getTermin(spalte, zeile, thera, packung);
						p2= t.getPatient();
						if(p2 == p)
							gefunden++;
					}
		return gefunden;
	}
	
	public int delPatient(int index){
		int gefunden = 0;
		int max = therapeuten.size()*ende*86*2;
		int count = 0;
		physiomat.setStatusBar(max, "Lösche Patienten im Kalender", "", "");
		Patient p = getPatient(index);//getTerminPatient(index);
		Patient p2;
		Termin t;
		for(int thera = 0; thera < therapeuten.size(); thera++)
			for(int spalte = 0; spalte < ende; spalte++)
				for(int zeile = 0; zeile < 86; zeile++)
					for(int packung = 0; packung < 2; packung++){
						physiomat.setStatusBar(count++, ""+(100*count/(max))+"%");
						t = getTermin(spalte, zeile, thera, packung);
						p2= t.getPatient();
						if(p2 == p){
							gefunden++;
							t = new Termin(Termin.FREI);
							setTermin(spalte, zeile, thera, packung, t);
						}
					}
		//Zum Schluss, entferne den Patienten
		patienten.removeElementAt(index);
		setUpdate();
		return gefunden;
	}
	
	public boolean open(File file){
		/*
			Die Datei existiert und kann eingelesen werden. Wir löschen alle Daten aus dem Speicher und fangen damit neu an.
		*/
		logger.info("Lösche alte Daten und schmeisse alle Referenzen weg");
		int max = maxTherapeuten*ende*86*2;
		int count = 0;
		physiomat.setStatusBar(max, "Bereinige Daten im Programm", "", "");
		for(int tag= 0; tag < ende; tag++)
			for(int uhr = 0; uhr < 86; uhr++)//Zehnminutentaktung
				for(int ther = 0; ther < maxTherapeuten; ther++)//Therapeuten
					for(int tp=0; tp < 2; tp++){//Pakungstermin
						termine[tag][uhr][ther][tp] = new Termin();
						physiomat.setStatusBar(count++, ""+(100*count/(max))+"%");
					}
		therapeuten = new Vector<Therapeut>(1,1);//Aber maximal ($maxTherapeuten) Therapeuten!!!
		patienten   = new Vector<Patient>(100,10);
		
		raeume = new Ausrustung(1,1,new Date());//Ein Raum braucht er schon
		geraete = new Ausrustung();//Aber nicht zwingend Geräte
		
		logger.info("Hole Müllauto");
		System.gc();
		
		logger.info("Starte Prozedur Öffnen");
		File ob = null;
		ZipFile zip;
		ZipEntry entry;
		Enumeration zFE;
		byte[] data = new byte[1024];
		int wieviel = 0;
		if(null != file){
			try {
				logger.info("Versuche Datei ("+file.getAbsolutePath()+") zu öffnen");
				//zip = new ZipFile(file.getName());
				zip = new ZipFile(file);
				logger.info("Datei ("+file.getName()+") geöffnet");
				zFE = zip.entries();
				while (zFE.hasMoreElements()){
					entry = (ZipEntry) zFE.nextElement();
					wieviel++;
				}
				zip.close();
				zip = new ZipFile(file);
				zFE = zip.entries();
				//XMLdatei auslesen:
				entry = (ZipEntry) zFE.nextElement();
				String currentEntry = entry.getName();
				//logger.info("
				//File destFile = new File(file.getPath()+currentEntry);
				File destFile = new File(file.getAbsolutePath()+currentEntry);
				ob = destFile;
				logger.info("Auspacken:\nDatei: "+ob.getAbsolutePath());

				if (!entry.isDirectory()){
					BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
					int currentByte;

					// write the current file to disk
					FileOutputStream fos = new FileOutputStream(destFile);
					BufferedOutputStream dest = new BufferedOutputStream(fos, 1024);

					// read and write until last byte is encountered
					while ((currentByte = is.read(data, 0, 1024)) != -1){
						dest.write(data, 0, currentByte);
					}
					dest.flush();
					dest.close();
					is.close();
				}
				CountTag ct;
				ct = new CountTag(ob);
				int maxCount = ct.patientenAnzahl+ct.therapeutenAnzahl+ct.terminAnzahl;
				logger.info("Analysiere XML-Datei:\nMaxmium: "+maxCount+"\nPatienten: "+ct.patientenAnzahl+"\nTherapeuten: "+ct.therapeutenAnzahl+"\nTermine: "+ct.terminAnzahl);
				physiomat.setStatusBar(maxCount, "Laden", "", "");
				physiomat.setStatusBar(0);
				XMLDaten xmlDaten = new XMLDaten(this, ob, maxCount);
				ob.delete();
				nachBearbeitung();
			} catch (java.util.zip.ZipException ze){
				//ze.printStackTrace();
				logger.warning("Zip-Datei konnte nicht geöffnet werden\n"+ze.getMessage());//+"\n"+ze.getStackTrace);
				physiomat.setUnstable(false);
				return false;
			} catch (java.io.FileNotFoundException fnfe){
				logger.info("Datei pdaten.pmt nicht gefunden, erstmaliger Start!");
				physiomat.setUnstable(false);
				return false;
			} catch (java.io.IOException ioe){
				ioe.printStackTrace();
				physiomat.setUnstable(false);
				return false;
			}
			/*
				Untersuche nun die Termine auf Doppelbelegung (Eine Stunde Kurs = sechs Einheiten)
			*/
		} else {
			/*
				Mache nüscht, weil die Datei gibts nicht.
			*/
			physiomat.setUnstable(false);
			return false;
		}
		setUpdate();
		physiomat.setUnstable(false);
		physiomat.setStatus(Physiomat.GELADEN);
		return true;
	}
	
	public void findeAlteTermine(int index){
		int gefunden = 0;
		int max = therapeuten.size()*ende*86;
		int count = 0;
		physiomat.setStatusBar(max, "Suche Patiententermine im Kalender", "", "");
		logger.info("Suche Patiententermine im Kalender");
		Patient p = getPatient(index);//getTerminPatient(index);
		Patient p1;
		Patient p2;
		Termin t1 = new Termin();
		Termin t2 = new Termin();
		Termin old1 = new Termin();
		Termin old2 = new Termin();
		String text = "";
		for(int thera = 0; thera < therapeuten.size(); thera++)
			for(int spalte = 0; spalte < ende; spalte++)
				for(int zeile = 0; zeile < 86; zeile++){
					physiomat.setStatusBar(count++, ""+(100*count/(max))+"%");
					t1 = getTermin(spalte, zeile, thera, 0);
					t2 = getTermin(spalte, zeile, thera, 1);
					p1= t1.getPatient();
					p2= t2.getPatient();
					//Zuerst, wenn t1 == old1 oder t2 == old2 oder t1 == old2, dann tue nichts!
					if(t1 == old1 || t2 == old2 || t1 == old2){
						;//Tue nichts
					} else {
						if(p2 == p){
							//Packungspatient ist gleich, Termin gefunden, Text schreiben.
							int von = t2.getVonZeit();
							int bis = t2.getBisZeit();
							Calendar calR = Calendar.getInstance();
							calR.setTime(getDate(spalte));
							int year = calR.get(Calendar.YEAR);
							int month = calR.get(Calendar.MONTH)+1;
							int day = calR.get(Calendar.DAY_OF_MONTH);
							
							text = text + day+"."+month+"."+year+" um "+UHRZEIT[von]+" bis "+UHRZEIT[bis]+" bei "+(getTherapeut(thera).getVorname())+" "+(getTherapeut(thera).getNachname())+"\n";
							old2 = t2;
						}
						if(p1 == p){
							//Behandlungspatient ist gleich, Termin gefunden, Text schreiben.
							int von = t1.getVonZeit();
							int bis = t1.getBisZeit();
							Calendar calR = Calendar.getInstance();
							calR.setTime(getDate(spalte));
							int year = calR.get(Calendar.YEAR);
							int month = calR.get(Calendar.MONTH)+1;
							int day = calR.get(Calendar.DAY_OF_MONTH);
							text = text + day+"."+month+"."+year+" um "+UHRZEIT[von]+" bis "+UHRZEIT[bis]+" bei "+(getTherapeut(thera).getVorname())+" "+(getTherapeut(thera).getNachname())+"\n";
							old1 = t1;
						}
					}
				}
		p.addTermin(text);
	}
	
	public Physiomat getPhysiomat(){
		return physiomat;
	}
	
	public int getStartZeit(Date datum){
		int wert = 1;
		/*
		Aktiver Therapeut und seine Startzeit an diesem Tage.
		*/
		int thera = getAktivenTherapeuten();
		int spalte = getSpalte(datum);
		int start = 0;
		boolean weiter = true;
		while(start < 86 && weiter){			
			start++;
			Termin t = getTermin(spalte, start, thera, 0);
			if(t.getArt()!=Termin.FREI && t.getArt()!=Termin.KEINEARBEITSZEIT)
				weiter = false;
			t = getTermin(spalte, start, thera, 1);
			if(t.getArt()!=Termin.FREI && t.getArt()!=Termin.KEINEARBEITSZEIT)
				weiter = false;
		}
		return start;
	}
	
	public int getEndZeit(Date datum){
		/*
		Aktiver Therapeut und seine Startzeit an diesem Tage.
		*/
		int thera = getAktivenTherapeuten();
		int spalte = getSpalte(datum);
		int ende = 86;
		boolean weiter = true;
		while(ende > 0 && weiter){			
			Termin t = getTermin(spalte, ende, thera, 0);
			if(t.getArt()!=Termin.FREI && t.getArt()!=Termin.KEINEARBEITSZEIT)
				weiter = false;
			t = getTermin(spalte, ende, thera, 1);
			if(t.getArt()!=Termin.FREI && t.getArt()!=Termin.KEINEARBEITSZEIT)
				weiter = false;
			if(weiter)
				ende--;
		}
		return ende;
	}
	
	public int getDruckweite(){
		return druckweite;
	}
	
	public void setDruckweite(int x){
		if(x>0 && x < 1000)
			druckweite = x;
	}
}
