import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import java.text.MessageFormat;
//import javax.swing.table.JTableHeader;
import java.awt.event.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
//import java.awt.Toolkit;
import java.awt.datatransfer.*;
import java.beans.PropertyChangeListener;
import java.util.logging.*;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;


//import com.pallas.swing.date.DateComboBox;

public class KalenderFenster extends JInternalFrame{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	
	JTable dieWoche;//
	JTable derTag;
	JTable alleTag;//
	JTable dieKurse;//
	Physiomat physiomat;
	private Daten daten;
	Date altesWochenDatum = new Date();
	Date altesTTagDatum = new Date();
	private boolean update = false;
	private boolean iupdate = false;//Intern
	private MeinWTableModel mtm;
	private MeinKTableModel mktm;
	private MeinTTableModel mttm;
	private MeinATableModel matm;
	private MeinTDruckTableModel mtdtm;
	private MyTableCellRenderer mtcr;// = new MyTableCellRenderer();
	private MyKursTableCellRenderer mtcr2;
	//private MyTableCellRenderer mtcr;// = new MyTableCellRenderer();
	private MyTagesTableCellRenderer mttcr;
	private MyAlleTableCellRenderer matcr;
	private int aktuellerTherapeut = 0;
	private int vorAktuellerTherapeut = 0;

	static void addComponent( Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty ) { 
		GridBagConstraints gbc = new GridBagConstraints(); 
		gbc.fill = GridBagConstraints.BOTH; 
		gbc.gridx = x; gbc.gridy = y; 
		gbc.gridwidth = width; gbc.gridheight = height; 
		gbc.weightx = weightx; gbc.weighty = weighty; 
		gbl.setConstraints( c, gbc ); 
		cont.add( c ); 
	} 
	
	static void addComponent( Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height) 
	{ 
		GridBagConstraints gbc = new GridBagConstraints(); 
		gbc.fill = GridBagConstraints.BOTH; 
		gbc.gridx = x; gbc.gridy = y; 
		gbc.gridwidth = width; gbc.gridheight = height; 
		gbc.weightx = 1.0; gbc.weighty = 1.0; 
		gbl.setConstraints( c, gbc ); 
		cont.add( c ); 
	} 

	private JTabbedPane jt = new JTabbedPane();
	//private JPanel patientensicht = new JPanel();
	private JPanel therapeutWoche = new JPanel();
	private JPanel therapeutWochenPanel = new JPanel();
	private JPanel therapeutTag = new JPanel();
	private JPanel therapeutTagPanel = new JPanel();
	private JPanel aTherapeutTag = new JPanel();
	private JPanel aTherapeutTagPanel = new JPanel();
	private JPanel patientenTag = new JPanel();//Anzeige aller Patienten nach Uhrzeit. Maximal doppelte Spaltenanzahl von Therapeutenanzahl.
	private JPanel kursWochenPanel = new JPanel();//Anzeige aller Kurse einer Woche
	private JPanel kursWoche = new JPanel();//Anzeige aller Kurse einer Woche
	
	
	
	//Therapeut Woche:
	private JLabel wochenLabel = new JLabel("Woche:");//Von Bis
	private JLabel wochenKursLabel = new JLabel("Woche:");//Von Bis
	private JLabel wochenStundenLabel = new JLabel("Wochenstunden:");
	private JComboBox tcbox = new JComboBox();//Therapeutencombobox
	private JComboBox pcbox = new JComboBox();//Patientencombobox
	private JComboBox bcbox = new JComboBox();//Behandlungscombobox
	private JComboBox zcbox = new JComboBox();//Zeitcombobox
	private GridBagLayout gridbag = new GridBagLayout();
	private GridBagConstraints constraints = new GridBagConstraints();
	private DateComboBox dcb = new DateComboBox(new Date());
	private JButton wochev = new JButton("<");
	private JButton wochen = new JButton(">");
	private JButton vorTag = new JButton("<");
	private JButton nachTag = new JButton(">");
	private JButton vorAlle = new JButton("<");
	private JButton nachAlle = new JButton(">");
	private JButton vorKurs = new JButton("<");
	private JButton nachKurs = new JButton(">");
	private JSplitPane twsp;
	private JButton heuteWoche = new JButton("Heute");
	private JButton druckTag = new JButton("Drucken");

	//Therapeut Tag:
	private JLabel tTagLabel = new JLabel("Datum:");
	private JComboBox ttcbox = new JComboBox();//Therapeutencombobox
	private DateComboBox dtcb = new DateComboBox(new Date());
	private JSplitPane ttsp;
	private JButton heuteTag = new JButton("Heute");
	
	//alle Therapeuten:
	private JLabel aTagLabel = new JLabel("Datum:");
	private JLabel aWochentag = new JLabel();
	private JLabel tagWochentag = new JLabel();
	private DateComboBox adcb = new DateComboBox(new Date());
	private JSplitPane atsp;
	private JButton aHeuteTag = new JButton("Heute");
	
	//alle Kurse:
	private JLabel KTagLabel = new JLabel("Datum:");
	private JLabel KWochentag = new JLabel();
	private DateComboBox kdcb = new DateComboBox(new Date());
	private JSplitPane ktsp;
	private JButton kHeuteTag = new JButton("Heute");
	
	private JLabel pTagLabel = new JLabel("Datum:");

	public KalenderFenster(Daten daten) {
		super();
		this.setTitle("Kalender");
		this.setBounds(0,0,900,450);
		this.setResizable(true);
		this.setMaximizable(true);
		this.setIconifiable(true);
		this.daten = daten;
		initGUI();

		//Test: Macht dann später die Datei
		/*tcbox.addItem("Daniel");
		tcbox.addItem("Angie");
		tcbox.addItem("Franziska");
		tcbox.addItem("Stefanie");
		tcbox.addItem("Angela");

		ttcbox.addItem("Daniel");
		ttcbox.addItem("Angie");
		ttcbox.addItem("Franziska");
		ttcbox.addItem("Stefanie");
		ttcbox.addItem("Angela");
		*/

		this.setClosable(true);
		setDefaultCloseOperation(HIDE_ON_CLOSE);
		GregorianCalendar cal = new GregorianCalendar();//Calendar.getInstance();//new GregorianCalendar(new Date());
		//cal.setTime(new Date());//aktuelles Datum
/*		System.out.println("Stunde: "+cal.get(Calendar.HOUR_OF_DAY));//5
		System.out.println("Jahr:   "+cal.get(Calendar.YEAR));
		System.out.println("Monat: "+cal.get(Calendar.MONTH));
		System.out.println("Tag: "+cal.get(Calendar.DAY_OF_MONTH));
		System.out.println("Tag Des Jahres: "+cal.get(Calendar.DAY_OF_YEAR));
		System.out.println("Woche: "+cal.get(Calendar.WEEK_OF_YEAR));
*/		
		/*Feldbezeichner
Calendar.* 	Minimalwert 	Maximalwert 	Erklärung
ERA 	0 (BC) 	1 (AD) 	Datum vor oder nach Christus
YEAR 	1 	5000000 	Jahr
MONTH 	0 	11 	Monat (nicht von 1–12!)
DAY_OF_MONTH
alternativ DATE 	1 	31 	Tag
WEEK_OF_YEAR 	1 	54 	Woche
WEEK_OF_MONTH 	1 	6 	Woche des Monats
DAY_OF_YEAR 	1 	366 	Tag des Jahres
DAY_OF_WEEK 	1 	7 	Tag der Woche
](1 = Sonntag, 7 = Samstag)
DAY_OF_WEEK_IN_MONTH 	-1 	6 	Tag der Woche im Monat
HOUR 	0 	12 	Stunde von 12
HOUR_OF_DAY 	0 	23 	Stunde von 24
MINUTE 	0 	59 	Minute
SECOND 	0 	59 	Sekunden
MILLISECOND 	0 	999 	Millisekunden
AM_PM 	0 	1 	vor 12, nach 12
ZONE_OFFSET 	-12*60*60*1000 	12*60*60*1000 	Zeitzonenabweichung in Millisekunden
DST_OFFSET 	0 	1*60*60*1000 	Sommerzeitabweichung in Millisekunden 

public void actionPerformed(ActionEvent e){
   try{
      SwingUtilities.invokeLater(new Runnable(){
         public void run() { 
            // Hier aufgeführter Code wird erst nach dem GUI-Update ausgeführt.
         }
      });
   }catch (Exception ex){
      ex.printStackTrace();
   }
}*/
	}
	
	public void ende(){
		setVisible(false);
	}
	
	public void zeigen(){
		logger.info("Zeige Kalenderfenster");
		this.setVisible(false);
		try {
			this.setIcon(false);
		} catch (Exception e) {
			JOptionPane.showMessageDialog(this, "Fehler beim deiconifizieren!", "DeIconifizieren", JOptionPane.ERROR_MESSAGE);
		}
		this.setVisible(true);
	}
	
	public void updateGUI()
	{
		/*
			Neu Schreiben der Comboboxen der Therapeuten, Patienten, Wochenstunden, möglichst in einem neuen Thread
		*/
		;
	}
	
	public void initGUI(){
		Container c = this.getContentPane(); 
		GridBagLayout gbl = new GridBagLayout(); 
		GridBagLayout gbl3 = new GridBagLayout(); 
		c.setLayout(new BoxLayout(c, BoxLayout.Y_AXIS)); 
		
		kursWochenPanel.setLayout(gbl3);
		
		mtm = new MeinWTableModel(daten);
		mtm.setDaten(daten);
		//dieWoche  = new JTable(dataW, columnNamesW);
		dieWoche  = new JTable(mtm);
		dieWoche.getTableHeader().setReorderingAllowed( false ); 
		dieWoche.setColumnSelectionAllowed( false ); 
		dieWoche.setRowSelectionAllowed( false );
		dieWoche.setModel(mtm);
		//dieWoche.setBorder(new EtchedBorder());
		//dieWoche.
		ToolTipManager.sharedInstance().unregisterComponent(dieWoche);
		ToolTipManager.sharedInstance().unregisterComponent(dieWoche.getTableHeader());
		mtcr = new MyTableCellRenderer(daten);
		dieWoche.setDefaultRenderer(Object.class, mtcr);
		//JTableHeader th = dieWoche.getTableHeader();
		//th.setDefaultRenderer(new MyHeaderRenderer());
		dieWoche.getTableHeader().setDefaultRenderer(new MyHeaderRenderer());
		dieWoche.addMouseListener(new MouseAdapter()
		{
			public void mouseClicked(MouseEvent e){
				Point p = e.getPoint();
				int row = dieWoche.rowAtPoint(p);
				int column = dieWoche.columnAtPoint(p);
				mtcr.setZeile(-1);
				if(e.getClickCount() == 2){
					if(e.getButton() == e.BUTTON1){
						edit(row, column);
					} else {
						mtcr.setZeile(row);
					}
				}	else if(e.getButton() != e.BUTTON1){ //if(e.getClickCount() == 3){
					//Zeile selektiert
					mtcr.setZeile(row);
				}
				
				dieWoche.updateUI();
			}
		});
		dieWoche.setFocusTraversalKeysEnabled(true);
		dieWoche.addKeyListener(new KeyAdapter()
		{
			public void keyPressed(KeyEvent k){
				//Point p = k.getPoint();
				int row = dieWoche.getSelectedRow();//rowAtPoint(p);
				int column = dieWoche.getSelectedColumn();//columnAtPoint(p);
				mtcr.setZeile(-1);
				if(k.getKeyCode() ==  KeyEvent.VK_SPACE){
					edit(row, column);
				} else if(k.getKeyCode() ==  KeyEvent.VK_SHIFT){
					mtcr.setZeile(row);
				}
				dieWoche.updateUI();
				dieWoche.getColumnModel().getColumn(0).setMaxWidth(90);
			}
		});
		
		//dieWoche.setDefaultRenderer(String.class, new MyTableCellRenderer());
		
		
		/*
		ColorTableCellRenderer ctr=new ColorTableCellRenderer();
		for(int i=0;i < 13; i++)
			dieWoche.getColumnModel().getColumn(i).setCellRenderer(ctr);
		ctr.setColor(3,3,Color.RED);
		*/
		dieWoche.updateUI();
		
		//derTag  = new JTable(dataT, columnNamesT);
		mttm = new MeinTTableModel(daten);
		derTag  = new JTable(mttm);
		derTag.getTableHeader().setReorderingAllowed( false ); 
		derTag.setColumnSelectionAllowed( false ); 
		derTag.setRowSelectionAllowed( false );
		mttcr = new MyTagesTableCellRenderer(daten);
		derTag.setDefaultRenderer(Object.class, mttcr);
		derTag.getTableHeader().setDefaultRenderer(new MyHeaderRenderer());

		ToolTipManager.sharedInstance().unregisterComponent(derTag);
		ToolTipManager.sharedInstance().unregisterComponent(derTag.getTableHeader());
		derTag.addMouseListener(new MouseAdapter()
		{
			public void mouseClicked(MouseEvent e){
				Point p = e.getPoint();
				int row = derTag.rowAtPoint(p);
				int column = derTag.columnAtPoint(p);
				mttcr.setZeile(-1);
				if(e.getClickCount() == 2){
					if(e.getButton() == e.BUTTON1){
						editTag(row, column);
					} else {
						mttcr.setZeile(row);
					}
				}	else if(e.getButton() != e.BUTTON1){ //if(e.getClickCount() == 3){
					//Zeile selektiert
					mttcr.setZeile(row);
				}
				
				derTag.updateUI();
			}
		});
		derTag.setFocusTraversalKeysEnabled(true);
		derTag.addKeyListener(new KeyAdapter()
		{
			public void keyPressed(KeyEvent k){
				//Point p = k.getPoint();
				int row = derTag.getSelectedRow();//rowAtPoint(p);
				int column = derTag.getSelectedColumn();//columnAtPoint(p);
				if(k.getKeyCode() ==  KeyEvent.VK_SPACE){
					editTag(row, column);
					//updateWoche();
				} else if(k.getKeyCode() ==  KeyEvent.VK_SHIFT){
					mttcr.setZeile(row);
				}
				derTag.updateUI();
			}
		});
		
		derTag.getColumnModel().getColumn(0).setMaxWidth(90);

		matm = new MeinATableModel(daten);
		alleTag  = new JTable(matm);
		alleTag.getColumnModel().getColumn(0).setMaxWidth(90);
//		alleTag.getTableHeader().setDefaultRenderer(new MyHeaderRenderer());
//		alleTag.getTableHeader().setReorderingAllowed( false ); 
//		alleTag.setColumnSelectionAllowed( false ); 
//		alleTag.setDefaultRenderer(Object.class, matcr);
//		alleTag.setRowSelectionAllowed( false );


//		alleTag  = new JTable(matm);
/*		alleTag.getTableHeader().setReorderingAllowed( false ); 
		alleTag.setColumnSelectionAllowed( false ); 
		alleTag.setRowSelectionAllowed( false );
		//mttcr = new MyTagesTableCellRenderer(daten);*/
		matcr = new MyAlleTableCellRenderer(daten);
		alleTag.setDefaultRenderer(Object.class, matcr);
		alleTag.getTableHeader().setDefaultRenderer(new MyHeaderRenderer());

		ToolTipManager.sharedInstance().unregisterComponent(alleTag);
		ToolTipManager.sharedInstance().unregisterComponent(alleTag.getTableHeader());
		
		alleTag.addMouseListener(new MouseAdapter()
		{
			public void mouseClicked(MouseEvent e){
				Point p = e.getPoint();
				int row = alleTag.rowAtPoint(p);
				int column = alleTag.columnAtPoint(p);
				matcr.setZeile(-1);
				if(e.getClickCount() == 2){
					if(e.getButton() == e.BUTTON1){
						editAlle(row, column);
					} else {
						matcr.setZeile(row);
					}
				}	else if(e.getButton() != e.BUTTON1){ //if(e.getClickCount() == 3){
					//Zeile selektiert
					matcr.setZeile(row);
				}
				
				alleTag.updateUI();
			}
		});
		alleTag.setFocusTraversalKeysEnabled(true);
		alleTag.addKeyListener(new KeyAdapter()
		{
			public void keyPressed(KeyEvent k){
				//Point p = k.getPoint();
				int row = alleTag.getSelectedRow();//rowAtPoint(p);
				int column = alleTag.getSelectedColumn();//columnAtPoint(p);
				if(k.getKeyCode() ==  KeyEvent.VK_SPACE){
					editAlle(row, column);
					//updateWoche();
				} else if(k.getKeyCode() ==  KeyEvent.VK_SHIFT){
					matcr.setZeile(row);
				}
				alleTag.updateUI();
			}
		});
		
		therapeutWoche.setLayout(new BoxLayout(therapeutWoche, BoxLayout.Y_AXIS));
		therapeutWochenPanel.setLayout(gbl);
		therapeutTag.setLayout(new BoxLayout(therapeutTag, BoxLayout.Y_AXIS));
		
		mktm = new MeinKTableModel(daten);
		mktm.setDaten(daten);
		//dieWoche  = new JTable(dataW, columnNamesW);
		dieKurse  = new JTable(mtm);
		dieKurse.getTableHeader().setReorderingAllowed( false ); 
		dieKurse.setColumnSelectionAllowed( false ); 
		dieKurse.setRowSelectionAllowed( false );
		dieKurse.setModel(mktm);
		//dieWoche.setBorder(new EtchedBorder());
		//dieWoche.
		ToolTipManager.sharedInstance().unregisterComponent(dieKurse);
		ToolTipManager.sharedInstance().unregisterComponent(dieKurse.getTableHeader());
		mtcr2 = new MyKursTableCellRenderer(daten);
		dieKurse.setDefaultRenderer(Object.class, mtcr2);
		//JTableHeader th = dieWoche.getTableHeader();
		//th.setDefaultRenderer(new MyHeaderRenderer());
		dieKurse.getTableHeader().setDefaultRenderer(new MyHeaderRenderer());
		dieKurse.addMouseListener(new MouseAdapter()
		{
			public void mouseClicked(MouseEvent e){
				Point p = e.getPoint();
				int row = dieKurse.rowAtPoint(p);
				int column = dieKurse.columnAtPoint(p);
				mtcr2.setZeile(-1);
				if(e.getClickCount() == 2){
					if(e.getButton() == e.BUTTON1){
						//edit(row, column);
					} else {
						mtcr2.setZeile(row);
					}
				}	else if(e.getButton() != e.BUTTON1){ //if(e.getClickCount() == 3){
					//Zeile selektiert
					mtcr2.setZeile(row);
				}
				
				dieKurse.updateUI();
			}
		});
		dieKurse.setFocusTraversalKeysEnabled(true);
		dieKurse.addKeyListener(new KeyAdapter()
		{
			public void keyPressed(KeyEvent k){
				//Point p = k.getPoint();
				int row = dieKurse.getSelectedRow();//rowAtPoint(p);
				int column = dieKurse.getSelectedColumn();//columnAtPoint(p);
				mtcr2.setZeile(-1);
				if(k.getKeyCode() ==  KeyEvent.VK_SPACE){
					//edit(row, column);
				} else if(k.getKeyCode() ==  KeyEvent.VK_SHIFT){
					mtcr2.setZeile(row);
				}
				dieKurse.updateUI();
				dieKurse.getColumnModel().getColumn(0).setMaxWidth(90);
			}
		});
		
		JScrollPane scrollW = new JScrollPane( dieWoche );
		JScrollPane scrollT = new JScrollPane( derTag );
		JScrollPane scrollA = new JScrollPane( alleTag );
		JScrollPane scrollK = new JScrollPane( dieKurse );
		//dieWoche.setFillsViewportHeight(true);//Warum? Keine Änderung gesehen
		addComponent( therapeutWochenPanel, gbl, tcbox, 0, 0, 3, 1);
		tcbox.setPreferredSize(new Dimension(50, 20));
		addComponent( therapeutWochenPanel, gbl, wochenStundenLabel, 3, 0, 3, 1);
		addComponent( therapeutWochenPanel, gbl, wochenLabel, 0, 1, 1, 1);
		/*addComponent( therapeutWochenPanel, gbl, pcbox, 0, 2, 1, 1);
		addComponent( therapeutWochenPanel, gbl, bcbox, 1, 2, 1, 1);
		addComponent( therapeutWochenPanel, gbl, zcbox, 2, 2, 1, 1);*/
		addComponent( therapeutWochenPanel, gbl, wochev, 0, 2, 1, 1);
		addComponent( therapeutWochenPanel, gbl, dcb, 1, 2, 1, 1);
		addComponent( therapeutWochenPanel, gbl, wochen, 2, 2, 1, 1);
		addComponent( therapeutWochenPanel, gbl, heuteWoche, 3, 2, 1, 1);
		//addComponent( therapeutWoche, gbl, scroll, 0, 4, 3, 1);
		
		dcb.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				if((dcb.getDate() != null) && ( dcb.getDate() != altesWochenDatum)){
					updateWoche();
					altesWochenDatum = dcb.getDate();
					if(!iupdate){
						iupdate=true;
						nochNicht("Noch nicht fertig: \n" + dcb.getDate());
						//dcb.setDate(cal.getTime());
						dtcb.setDate(dcb.getDate());
						adcb.setDate(dcb.getDate());
						kdcb.setDate(dcb.getDate());
						testeZeitrahmen(dcb.getDate());
						iupdate=false;
					}
				}
			} 
		} );
		
		heuteWoche.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				/* zuerst
				dcb.setDate(new Date());
				testeZeitrahmen(dcb.getDate());
				*/
				dcb.setDate(new Date());
				Date d = dcb.getDate();
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
			} 
		} );
		
		wochev.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				Date d = dcb.getDate();
				//long ms = d.getTime()-604800000L;
				//dcb.setDate(new Date(ms));
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				cal.add(Calendar.DATE, -7);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
			} 
		} );
		
		wochen.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				Date d = dcb.getDate();
				//long ms = d.getTime()+604800000L;
				//dcb.setDate(new Date(ms));
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				cal.add(Calendar.DATE, +7);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
			} 
		} );
		
		
		for(int i = 1; i < 13; i++)
			zcbox.addItem(""+i+"0");
		
		tcbox.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				//if(iupdate){
					//Nur aktualisieren, nichts benachrichtigen!
				//}
				if(!update && !iupdate){
					update=true;
					iupdate=true;
					//Dinge erledigen, für neuen Therapeuten
					//Therapeuten bei ttcbox auswählen:
					ttcbox.setSelectedItem(tcbox.getSelectedItem());
					logger.info("\n tcbox: "+tcbox.getSelectedItem()+"\nttcbox: "+ttcbox.getSelectedItem());
					aktuellerTherapeut = tcbox.getSelectedIndex();
					daten.setaktivenTherapeuten(aktuellerTherapeut);
					updateDaten();
					iupdate=false;
					update=false;
				}
			} 
		} );
		
	
		//Therapeutentag:

		addComponent( therapeutTagPanel, gbl, ttcbox, 0, 0, 1, 1);
		addComponent( therapeutTagPanel, gbl, tagWochentag, 1, 0, 1, 1);
		addComponent( therapeutTagPanel, gbl, vorTag, 2, 0, 1, 1);
		addComponent( therapeutTagPanel, gbl, dtcb, 3, 0, 1, 1);
		addComponent( therapeutTagPanel, gbl, nachTag, 4, 0, 1, 1);
		addComponent( therapeutTagPanel, gbl, heuteTag, 5, 0, 1, 1);
		addComponent( therapeutTagPanel, gbl, druckTag, 6, 0, 1, 1);
		
		druckTag.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				try{
					Therapeut th = daten.getTherapeut(daten.getAktivenTherapeuten());
					Date d = dtcb.getDate();
					Calendar cal = Calendar.getInstance();
					cal.setTime(d);
					String text = th.getVorname()+" "+th.getNachname()+" : "+cal.get(Calendar.DAY_OF_MONTH)+"."+(cal.get(Calendar.MONTH)+1)+".";
					MessageFormat headerFormat = new MessageFormat(""+text);
					MessageFormat footerFormat = new MessageFormat("Seite {0}");
					mtdtm = new MeinTDruckTableModel(daten, d);
					mtdtm.setDatum(cal);
					MyTagesDruckTableCellRenderer druckcr = new MyTagesDruckTableCellRenderer(daten);
					derTag.setDefaultRenderer(Object.class, druckcr);
					derTag.setModel(mtdtm);
					derTag.getColumnModel().getColumn(0).setMaxWidth(60);
					derTag.updateUI();
					derTag.getColumnModel().getColumn(0).setMaxWidth(60);
					Rectangle rang = getBounds();
					int x = (int)rang.getX();
					int y = (int)rang.getY();
					int b = (int)rang.getWidth();
					int h = (int)rang.getHeight();
					setBounds(x,y,daten.getDruckweite(),h);//600
					derTag.doLayout();
					//Printable printable = mediaTable.getPrintable(derTag.PrintMode.FIT_WIDTH, headerFormat, footerFormat); 
					//PrintPreview pp = new PrintPreview(printable, "Print Preview");
					derTag.print(JTable.PrintMode.FIT_WIDTH, headerFormat, footerFormat, true, null, true);
					//derTag.print(JTable.PrintMode.FIT_WIDTH, headerFormat, footerFormat, true, null, true);
					//derTag.print(JTable.PrintMode.NORMAL, headerFormat, footerFormat);
					setBounds(x,y,b,h);
					derTag.setModel(mttm);
					derTag.setDefaultRenderer(Object.class, mtcr);
					derTag.updateUI();
					derTag.getColumnModel().getColumn(0).setMaxWidth(60);
				} catch (java.awt.print.PrinterException pe){
					pe.printStackTrace();
				}
			} 
		} );
		
		
		dtcb.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				if((dtcb.getDate() != null) && ( dtcb.getDate() != altesTTagDatum)){
					if(!iupdate){
						iupdate=true;
						nochNicht("Noch nicht fertig: \n" + dtcb.getDate());
						altesTTagDatum = dtcb.getDate();
						dcb.setDate(dtcb.getDate());
						adcb.setDate(dtcb.getDate());
						kdcb.setDate(dtcb.getDate());
						testeZeitrahmen(dtcb.getDate());
						updateTag(dtcb.getDate());
						iupdate=false;
					}
				}
			} 
		} );
		
		ttcbox.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				if(!iupdate){
					//Nur aktualisieren, nichts benachrichtigen!
					update=true;
					iupdate=true;
					//Dinge erledigen, für neuen Therapeuten
					//Therapeuten bei tcbox auswählen:
					tcbox.setSelectedItem(ttcbox.getSelectedItem());
					logger.info("\n tcbox: "+tcbox.getSelectedItem()+"\nttcbox: "+ttcbox.getSelectedItem());
					aktuellerTherapeut = tcbox.getSelectedIndex();
					daten.setaktivenTherapeuten(aktuellerTherapeut);
					updateDaten();
					iupdate=false;
					update=false;
				}
			} 
		} );
		
		heuteTag.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				dtcb.setDate(new Date());
				Date d = dtcb.getDate();
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
				updateTag(cal.getTime());
			} 
		} );
		
		vorTag.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				Date d = dtcb.getDate();
				/*
				long ms = d.getTime()-86400000L;
				dtcb.setDate(new Date(ms));
				*/
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				cal.add(Calendar.DATE, -1);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
				updateTag(cal.getTime());
			} 
		} );
		
		nachTag.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				
				Date d = dtcb.getDate();
				//long ms = d.getTime()+86400000L;
				//System.out.println("Datum: " +ms);
				//dtcb.setDate(new Date(ms));
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				cal.add(Calendar.DATE, +1);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
				updateTag(cal.getTime());
			} 
		} );
		
		//Alle Therapeuten
		
		addComponent( aTherapeutTagPanel, gbl, aWochentag, 1, 0, 1, 1);
		addComponent( aTherapeutTagPanel, gbl, vorAlle, 2, 0, 1, 1);
		addComponent( aTherapeutTagPanel, gbl, adcb, 3, 0, 1, 1);
		addComponent( aTherapeutTagPanel, gbl, nachAlle, 4, 0, 1, 1);
		addComponent( aTherapeutTagPanel, gbl, aHeuteTag, 5, 0, 1, 1);
		
		aHeuteTag.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				adcb.setDate(new Date());
				Date d = adcb.getDate();
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
				updateTag(cal.getTime());
			} 
		} );
		
		nachAlle.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				
				Date d = adcb.getDate();
				//long ms = d.getTime()+86400000L;
				//System.out.println("Datum: " +ms);
				//dtcb.setDate(new Date(ms));
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				cal.add(Calendar.DATE, +1);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
				updateTag(cal.getTime());
			} 
		} );
		
		vorAlle.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				
				Date d = adcb.getDate();
				//long ms = d.getTime()+86400000L;
				//System.out.println("Datum: " +ms);
				//dtcb.setDate(new Date(ms));
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				cal.add(Calendar.DATE, -1);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
				updateTag(cal.getTime());
			} 
		} );
		
		adcb.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				if((adcb.getDate() != null) && ( adcb.getDate() != altesTTagDatum)){
					if(!iupdate){
						iupdate=true;
						nochNicht("Noch nicht fertig: \n" + adcb.getDate());
						altesTTagDatum = adcb.getDate();
						dcb.setDate(adcb.getDate());
						dtcb.setDate(adcb.getDate());
						kdcb.setDate(adcb.getDate());
						testeZeitrahmen(adcb.getDate());
						updateTag(adcb.getDate());
						iupdate=false;
					}
				}
			} 
		} );
		
		
		//Alle Kurse
		addComponent( kursWochenPanel, gbl3, wochenKursLabel, 0, 0, 5, 1);
		addComponent( kursWochenPanel, gbl3, vorKurs, 1, 1, 1, 1);
		addComponent( kursWochenPanel, gbl3, kdcb, 2, 1, 1, 1);
		addComponent( kursWochenPanel, gbl3, nachKurs, 3, 1, 1, 1);
		addComponent( kursWochenPanel, gbl3, kHeuteTag, 4, 1, 1, 1);
		
		kHeuteTag.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				kdcb.setDate(new Date());
				Date d = kdcb.getDate();
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				dcb.setDate(cal.getTime());
				dtcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
				updateTag(cal.getTime());
			} 
		} );
		
		nachKurs.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				
				Date d = kdcb.getDate();
				//long ms = d.getTime()+86400000L;
				//System.out.println("Datum: " +ms);
				//dtcb.setDate(new Date(ms));
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				cal.add(Calendar.DATE, +7);
				dtcb.setDate(cal.getTime());
				dcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
				updateTag(cal.getTime());
			} 
		} );
		
		vorKurs.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				
				Date d = kdcb.getDate();
				//long ms = d.getTime()+86400000L;
				//System.out.println("Datum: " +ms);
				//dtcb.setDate(new Date(ms));
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				cal.add(Calendar.DATE, -7);
				dtcb.setDate(cal.getTime());
				dcb.setDate(cal.getTime());
				adcb.setDate(cal.getTime());
				kdcb.setDate(cal.getTime());
				updateTag(cal.getTime());
			} 
		} );
		
		kdcb.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
				if((kdcb.getDate() != null) && ( kdcb.getDate() != altesTTagDatum)){
					if(!iupdate){
						iupdate=true;
						nochNicht("Noch nicht fertig: \n" + kdcb.getDate());
						altesTTagDatum = kdcb.getDate();
						dcb.setDate(kdcb.getDate());
						adcb.setDate(kdcb.getDate());
						dtcb.setDate(kdcb.getDate());
						testeZeitrahmen(kdcb.getDate());
						updateTag(kdcb.getDate());
						iupdate=false;
					}
				}
			} 
		} );
		
		therapeutWoche.add(new JScrollPane(therapeutWochenPanel));
		//therapeutWoche.add(scrollW);

		therapeutTag.add(therapeutTagPanel);
		therapeutTag.add(scrollT);
		twsp = new JSplitPane( JSplitPane.VERTICAL_SPLIT, therapeutWoche, scrollW);
		twsp.setOneTouchExpandable(true);
		twsp.setDividerLocation(80);
		
		ttsp = new JSplitPane( JSplitPane.VERTICAL_SPLIT, therapeutTag, scrollT);
		ttsp.setOneTouchExpandable(true);
		
		aTherapeutTag.add(aTherapeutTagPanel);
		aTherapeutTag.add(scrollA);
		
		atsp = new JSplitPane( JSplitPane.VERTICAL_SPLIT, aTherapeutTag, scrollA);
		atsp.setOneTouchExpandable(true);
		
		kursWoche.add(kursWochenPanel);
		kursWoche.add(scrollK);
		ktsp = new JSplitPane( JSplitPane.VERTICAL_SPLIT, kursWoche, scrollK);
		ktsp.setOneTouchExpandable(true);

		
		jt.addTab("Therapeut Woche", twsp);//Woche eines Therapeuten
		jt.addTab("Therapeut Tag", ttsp);//Tag eines Therapeuten
		jt.addTab("Alle Therapeuten", atsp);//Alle Therapeuten eines Tages auf einem Blick
		//jt.addTab("Patiententag Gesamtansicht", patientenTag);//Alle Patienten des Tages werden mit Uhrzeit aufgelistet
		jt.addTab("Kurse Gesamtansicht", ktsp);//Kurse der Woche
		//jt.addTab("Patientensicht", patientensicht);
		jt.setBounds(0,0,900,450);
		c.add(jt);
		updateWoche();
	}
	
	public void nochNicht(){
		//Noch nicht.
		//JOptionPane.showMessageDialog(this, "Noch nicht eingebaut.", "Fehlt.", JOptionPane.ERROR_MESSAGE, null);
	}
	
	public void nochNicht(String s){
		//Noch nicht.
		//JOptionPane.showMessageDialog(this, s, "Fehlt.", JOptionPane.ERROR_MESSAGE, null);
	}

	public void edit(int row, int column){
		//Von der Woche = Daten holen von MeinWTableModel
		//Nur, wenn Therapeuten überhaupt da sind!
		/*
		Erledigt: NOCH TESTEN, OB SPALTE AUSSERHALB DES TERMINKALENDERS IST!!!
		*/
		if(daten.getMaxTherapeuten()==0) column = 0;
		if(column != 0){
			/*
			JOptionPane.showMessageDialog(null,
				"Zeile "+row+" Spalte: "+column, 
				"Test Edit",
				JOptionPane.ERROR_MESSAGE, null);
			*/
			/*
				Eintrag muss anzeigen, wo raufgedrückt wurde, also Tag, Wochentag, Uhrzeit. 
				Wenn alles frei ist, dann Startzeit = Klickzeit. Warnung bei abweichender Taktung!
				Wenn auf Termin geklickt, dann Startzeit = Startzeit des geklickten 
				Wie muss die Verknüpfung aussehen?
				7:50 frei      frei
				8:00 PatientA  PatientB
				8:10 PatientA  PatientB
				8:20 PateintB  frei
				8:30 PatientB  frei
				8:40 PateintB  PatientC
				8:50 PatientB  PatientC
				9:00 PatientC  frei
				9:10 PatientC  frei
				
				7:50 frei      frei
				8:00 frei      frei
				8:10 frei      frei
				8:20 frei      frei
				8:30 frei      frei
				8:40 frei      frei
				8:50 frei      frei
				9:00 frei      frei
				9:10 frei      frei
			*/
			aktuellerTherapeut = tcbox.getSelectedIndex();
			vorAktuellerTherapeut = aktuellerTherapeut;
			daten.setaktivenTherapeuten(aktuellerTherapeut);
			logger.finest("Aktueller Therapeut: "+aktuellerTherapeut);
			if(daten.getWochenAnfang()!=-1)
				if(row != 0){
					//Wochenansicht. Da muss er selber das Datum aus der spalte berechnen.  
					Eintrag e = new Eintrag(physiomat, daten, tcbox.getSelectedIndex(), column, row);
				} else {
					Eintrag e = new Eintrag(physiomat, daten, tcbox.getSelectedIndex(), column, row, true);
				}
			tcbox.setSelectedIndex(vorAktuellerTherapeut);
			//tcbox.setSelectedIndex(aktuellerTherapeut);
			logger.finest("Aktueller Therapeut: "+aktuellerTherapeut);
		}
	}

	public void editTag(int row, int column){
		//Von dem Tag = Daten holen von MeinTTableModel
		//Nur, wenn Therapeuten überhaupt da sind!
		/*
		Erledigt: NOCH TESTEN, OB SPALTE AUSSERHALB DES TERMINKALENDERS IST!!!
		*/
		if(daten.getMaxTherapeuten()==0) column = 0;
		aktuellerTherapeut = tcbox.getSelectedIndex();
		vorAktuellerTherapeut = aktuellerTherapeut;
		daten.setaktivenTherapeuten(aktuellerTherapeut);
		logger.finest("Aktueller Therapeut: "+aktuellerTherapeut);
		if(daten.getSpalte(dtcb.getDate())==-1) column = 0;
		if(column != 0){
			/*
			JOptionPane.showMessageDialog(null,
				"Zeile "+row+" Spalte: "+column, 
				"Test Edit Tag",
				JOptionPane.ERROR_MESSAGE, null);
			*/
			if(row != 0){
				Eintrag e = new Eintrag(physiomat, daten, dtcb.getDate(), ttcbox.getSelectedIndex(), column, row);
				//Eintrag e = new Eintrag(physiomat, new Date(), new Termin(), ttcbox.getSelectedIndex(), column, row, false);
			} else {
				Eintrag e = new Eintrag(physiomat, daten, dtcb.getDate(), ttcbox.getSelectedIndex(), column, row, true);
			}
			tcbox.setSelectedIndex(vorAktuellerTherapeut);
			//tcbox.setSelectedIndex(aktuellerTherapeut);
			logger.finest("Aktueller Therapeut: "+aktuellerTherapeut);
		}
	}

	public void editAlle(int row, int column){
		/*
			Alle Therapeuten nebeneinander.
			Therapeut = Spalte -1
		*/
		int spalte = column -1;
		//daten.setAktivenTherapeuten(spalte);
		if(daten.getMaxTherapeuten()==0) column = 0;
		aktuellerTherapeut = spalte;
		vorAktuellerTherapeut = aktuellerTherapeut;
		if(daten.getSpalte(adcb.getDate())==-1) column = 0;
		if(column <= 0 || spalte < 0){
			;//nichts
			logger.warning("Hä??? Falsche Spalte gedrückt?!?\nSpalte: "+spalte+"\nZeile(row): "+row+"\nSpalte(column): "+column+"\nMaxTherapeuten: "+daten.getMaxTherapeuten());
		} else {
			if(row != 0){
				tcbox.setSelectedIndex(vorAktuellerTherapeut);
				Eintrag e = new Eintrag(true, physiomat, daten, adcb.getDate(), spalte, column, row);
				//Eintrag e = new Eintrag(physiomat, new Date(), new Termin(), ttcbox.getSelectedIndex(), column, row, false);
			} else {
				Eintrag e = new Eintrag(true, physiomat, daten, adcb.getDate(), spalte, column, row, true);
			}
			tcbox.setSelectedIndex(vorAktuellerTherapeut);
			alleTag.getColumnModel().getColumn(0).setMaxWidth(60);
		}
	}

	public void frame(Physiomat physiomat){
		this.physiomat = physiomat;
	}
	
	/*
	public void addTherapeuten(Therapeut t){
		tcbox.addItem(""+t.getVorname()+" "+t.getNachname());
		ttcbox.addItem(""+t.getVorname()+" "+t.getNachname());
	}
	*/
	
	public void setDaten(Daten daten){
		this.daten = daten;
	}
	
	public void update(){
		//Alle Therapeuten neu eintragen.
		update = true;
		tcbox.removeAllItems();
		ttcbox.removeAllItems();
		Therapeut t;
		for(int i = 0; i < daten.getMaxTherapeuten(); i++){
			t = daten.getTherapeut(i);
			tcbox.addItem(""+t.getVorname()+" "+t.getNachname());
			ttcbox.addItem(""+t.getVorname()+" "+t.getNachname());
		}
		//Tabellen neu füllen! (Erster Eintrag)
		update = false;
		tcbox.setSelectedIndex(aktuellerTherapeut);
		logger.finest("Aktueller Therapeut: "+aktuellerTherapeut);
		//if(daten.getMaxTherapeuten() > 0)
		//	tcbox.setSelectedIndex(0);
		mtm.fireTableDataChanged();
		mtm.fireTableStructureChanged();
		mktm.fireTableDataChanged();
		mktm.fireTableStructureChanged();
		mttm.fireTableDataChanged();
		mttm.fireTableStructureChanged();
		matm.fireTableDataChanged();
		matm.fireTableStructureChanged();
		alleTag.getColumnModel().getColumn(0).setMaxWidth(60);
		dieWoche.getColumnModel().getColumn(0).setMaxWidth(60);
		derTag.getColumnModel().getColumn(0).setMaxWidth(60);
		dieKurse.getColumnModel().getColumn(0).setMaxWidth(60);
	}

	/*public void mouseClicked(MouseEvent e){
		int row = dieWoche.rowAt(e.getPoint());
		int col = dieWoche.columnAt(e.hetPoint());
		//...
	}*/
	
	public void updateWoche(){
		Calendar cal = Calendar.getInstance();
		Calendar von = Calendar.getInstance();
		Calendar bis = Calendar.getInstance();
		cal.setTime(dcb.getDate());
		von.setTime(dcb.getDate());
		bis.setTime(dcb.getDate());
		int spalte = 0;
		
		String weekday = "";
		if (cal.get(Calendar.DAY_OF_WEEK) == cal.MONDAY){
			weekday ="Montag";
			//von.add(Calendar.DATE, );
			bis.add(Calendar.DATE, +5);
			spalte = 1;
		}else if(cal.get(Calendar.DAY_OF_WEEK) == cal.TUESDAY){
			weekday ="Dienstag";
			von.add(Calendar.DATE, -1);
			bis.add(Calendar.DATE, +4);
			spalte = 3;
		}else if(cal.get(Calendar.DAY_OF_WEEK) == cal.WEDNESDAY){
			weekday ="Mittwoch";
			von.add(Calendar.DATE, -2);
			bis.add(Calendar.DATE, +3);
			spalte = 5;
		}else if(cal.get(Calendar.DAY_OF_WEEK) == cal.THURSDAY){
			weekday ="Donnerstag";
			von.add(Calendar.DATE, -3);
			bis.add(Calendar.DATE, +2);
			spalte = 7;
		}else if(cal.get(Calendar.DAY_OF_WEEK) == cal.FRIDAY){
			weekday ="Freitag";
			von.add(Calendar.DATE, -4);
			bis.add(Calendar.DATE, +1);
			spalte = 9;
		}else if(cal.get(Calendar.DAY_OF_WEEK) == cal.SATURDAY){
			weekday ="Sonnabend";
			von.add(Calendar.DATE, -5);
			//bis.add(Calendar.DATE, 0);
			spalte = 11;
		}else if(cal.get(Calendar.DAY_OF_WEEK) == cal.SUNDAY){
			weekday ="Sonntag";
			von.add(Calendar.DATE, -6);
			bis.add(Calendar.DATE, -1);
			spalte = 13;
		}
			/*case cal.TUESDAY: weekday ="Dienstag";break;
			case cal.WEDNESDAY: weekday ="Mitwwoch";break;
			case cal.THURSDAY: weekday ="Donnerstag";break;
			case cal.FRIDAY: weekday ="Freitag";break;
			case cal.SATERDAY: weekday ="Sonnabend";break;
			case cal.SUNDAY: weekday ="Sonntag";*/
		
		int vyear = von.get(Calendar.YEAR);
		int vmonth = von.get(Calendar.MONTH);
		int vday = von.get(Calendar.DAY_OF_MONTH);
		
		int byear = bis.get(Calendar.YEAR);
		int bmonth = bis.get(Calendar.MONTH);
		int bday = bis.get(Calendar.DAY_OF_MONTH);
		//logger.finest("Zeitberechnung A:\n"+von.getTime()+"\n"+bis.getTime());
		
		/*
		mtm = new MeinWTableModel();
		mtm.setDaten(daten);
		dieWoche  = new JTable(mtm);
		dieWoche.getTableHeader().setReorderingAllowed( false ); 
		dieWoche.setColumnSelectionAllowed( false ); 
		dieWoche.setRowSelectionAllowed( false );
		dieWoche.setModel(mtm);
		*/
		//mtm.setDaten(daten);
		
		long vonm = von.getTime().getTime();
		long bism = bis.getTime().getTime();
		long nun = new Date().getTime();
		if((vonm <= nun) && (nun <= bism)){
			mtcr.setFarben(true, spalte);
		} else {
			mtcr.setFarben(false, spalte);
		}
		//mtcr.setFarben(von, bis);
		mtm.setSpaltenDatum(von);
		mtcr.setWochenDatum(von);
		mktm.setSpaltenDatum(von);
		mtcr2.setWochenDatum(von);
		daten.setWochenAnfang(von);
		wochenStundenLabel.setText("Wochenstunden: "+daten.getWochenStunden(tcbox.getSelectedIndex())+ "/"+daten.getMaxWochenStunden(tcbox.getSelectedIndex())+" ("+daten.getAlleWochenStunden(tcbox.getSelectedIndex())+")");
		dieWoche.updateUI();
		dieWoche.getColumnModel().getColumn(0).setMaxWidth(60);
		
		wochenLabel.setText("Woche: "+vday+"."+(vmonth+1)+". "+vyear+"  -  "+bday+"."+(bmonth+1)+". "+byear);
		wochenKursLabel.setText("Woche: "+vday+"."+(vmonth+1)+". "+vyear+"  -  "+bday+"."+(bmonth+1)+". "+byear);
		//logger.finest("Zeitberechnung B:\n"+von.getTime()+"\n"+bis.getTime());
		if(daten != null)
			logger.finest("Woche von Spalte: "+daten.getSpalte(von.getTime())+" bis "+daten.getSpalte(bis.getTime()));
			//wochenStundenLabel.setText("Wochenstunden: "+daten.getSpalte(von.getTime())+" "+daten.getSpalte(bis.getTime()));
		//logger.finest("Woche: "+day+"."+month+". "+year);
	}
	
	private void updateTag(Date datum){
		Calendar cal = Calendar.getInstance();
		cal.setTime(datum);
		mttm.setDatum(cal);
		matm.setDatum(cal);
		mttcr.setTagesSpalte(daten.getSpalte(cal.getTime()));
		matcr.setTagesSpalte(daten.getSpalte(cal.getTime()));
		daten.setWochenTag(cal);
		derTag.getColumnModel().getColumn(0).setMaxWidth(60);
		alleTag.getColumnModel().getColumn(0).setMaxWidth(60);
		String text = "";
		switch (cal.get(Calendar.DAY_OF_WEEK)){
			case Calendar.MONDAY : text = "Mo"; break;
			case Calendar.TUESDAY: text = "Di"; break;
			case Calendar.WEDNESDAY: text = "Mi"; break;
			case Calendar.THURSDAY:text = "Do"; break;
			case Calendar.FRIDAY: text = "Fr"; break;
			case Calendar.SATURDAY: text ="Sa"; break;
			case Calendar.SUNDAY: text = "So"; break;
		}
		aWochentag.setText(text);
		tagWochentag.setText(text);
	}
	

	
	private boolean testeZeitrahmen(Date d){
		boolean gut = true;
		
		int tag = daten.getSpalte(d);
		if( tag == -1){
			physiomat.setStatusBar("Zeitpunkt auserhalb des Terminkalenders!","");
			gut = false;
		} else 
			physiomat.setStatusBar("Spalte: "+tag,"");
		return gut;
	}
	
	public static int tage(Date von, Date bis) {
	//Zählt die Tage zwischen zwei Daten
		int tage = 0;
		Calendar start = new GregorianCalendar();
		start.setTime(von);
		Calendar ende = new GregorianCalendar();
		ende.setTime(bis);
		long diffMillis = ende.getTimeInMillis() - start.getTimeInMillis();
		long diffDays = diffMillis/(86400000);

		tage = (int)diffDays;

		
		return tage;
	}
	
	public void updateDaten(){
		daten.setaktivenTherapeuten(tcbox.getSelectedIndex());
		updateWoche();
		updateTag(dtcb.getDate());
		matm.updateKopf();
	}
	
	public void drueckeKnopf(){
		/*alt:
		dtcb.setDate(new Date());
		dcb.setDate(new Date());
		testeZeitrahmen(new Date());
		*/
		dcb.setDate(new Date());
		dtcb.setDate(new Date());
		adcb.setDate(new Date());
		kdcb.setDate(new Date());
		/*
		Date d = dcb.getDate();
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		dcb.setDate(cal.getTime());
		
		dtcb.setDate(new Date());
		d = dtcb.getDate();
		cal = Calendar.getInstance();
		cal.setTime(d);
		dtcb.setDate(cal.getTime());
		updateTag(cal.getTime());*/
	}

}

//public KalenderFensterMouseListener extends 
