import javax.swing.*;
import javax.swing.table.*;
import java.util.Calendar;
import java.util.logging.*;

public class MeinATableModel extends AbstractTableModel{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	private static int maxT = Daten.getMaximalTherapeuten();
	private Object[][] dataW = new Object[86][maxT+1];
	private String[] spalten = new String[maxT+1];
	private Termin[] termin = new Termin[maxT+1];
	private Daten daten;
	private boolean selected = false;
	private int x = 0;
	private int y = 0;
	

	public MeinATableModel(Daten daten){
		super();
		this.daten = daten;
		spalten[0] = "Zeit";
		Therapeut t;
		for(int i = 1; i < daten.maxTherapeuten+1; i++){
			t = daten.getTherapeut(i-1);
			spalten[i] = t.getVorname();
		}
		dataW[0][0] = "";//Notizzeile
		int j = 1;
		for(int i = 7; i < 10; i++){
			dataW[j++][0] = "0"+i+":00";
			dataW[j++][0] = "0"+i+":10";
			dataW[j++][0] = "0"+i+":20";
			dataW[j++][0] = "0"+i+":30";
			dataW[j++][0] = "0"+i+":40";
			dataW[j++][0] = "0"+i+":50";
		}
		for(int i = 10; i < 21; i++){
			dataW[j++][0] = ""+i+":00";
			dataW[j++][0] = ""+i+":10";
			dataW[j++][0] = ""+i+":20";
			dataW[j++][0] = ""+i+":30";
			dataW[j++][0] = ""+i+":40";
			dataW[j++][0] = ""+i+":50";
		}
		dataW[j++][0] = "21:00";
		for(int i = 0; i < 86; i++)
			for(j = 1; j < daten.maxTherapeuten+1; j++)
				dataW[i][j]= "";
	}

	public String getValueAt(int x, int y){
		String rwert = "";
		if((x >= 0)&&(x<86)&&(y>=0)&&(y<13))
			rwert = ""+dataW[x][y];
		return rwert;
	}

	public int getColumnCount(){
		return maxT+1;
	}

	public int getRowCount(){
		return 86;
	}

	public String getColumnName(int num){
		String rwert = "";
		if((num>=0)&&(num<(maxT+1)))
			rwert = ""+spalten[num];
		return rwert;
	}

	public boolean isCellEditable(int row, int cow){
		return false;/*
		if(!selected){
			JOptionPane.showMessageDialog(null,
				"Test",
				"Test", 
				JOptionPane.ERROR_MESSAGE, null);
			selected = true;
			x = row;
			y = cow;
		} else {
			if((row != x)||(cow !=y)){
				JOptionPane.showMessageDialog(null,
				"Test",
				"Test", 
				JOptionPane.ERROR_MESSAGE, null);
				selected = true;
				x = row;
				y = cow;
			} else {
				selected = false;
			}
		}
		return false;*/
	}

	public void setDaten(Daten daten){
		this.daten = daten;
	}
	
	public void setDatum(Calendar cal){
		Calendar meinC = Calendar.getInstance();
		meinC.setTime(cal.getTime());
		int anfang = 0;
		int thera = 0;
		Termin oldTermin = null;
		Termin neuTermin = null;
		Termin oldPTermin = null;//Packung
		if(null != daten){
			anfang = daten.getSpalte(meinC.getTime());
			//thera = daten.getAktivenTherapeuten();Unwichtig
		}
		int m = 0;
		int t = 0;
		//Übernahme der Einträge
		if(null != daten)
			for(int j=0; j < 86; j++){
				if(anfang != -1){
					for(thera = 0; thera < maxT; thera++){
						neuTermin = daten.getTermin(anfang, j, thera, 0);
						if(neuTermin != termin[thera]){
							dataW[j][thera+1]= neuTermin.toString();
						} else if(neuTermin.getArt() != Termin.FREI && neuTermin.getArt() != Termin.KEINEARBEITSZEIT){
							dataW[j][thera+1]= "\"\"";
						}
						termin[thera] = neuTermin;
					}
				} else {
					for(thera = 0; thera < maxT; thera++)
						dataW[j][thera+1]= "";
				}
				for(thera = 0; thera < maxT; thera++)
						fireTableCellUpdated(j,thera+1);
			}
		fireTableDataChanged();
		fireTableStructureChanged();
	}
	
	public void updateKopf(){
		Therapeut t;
		for(int i = 1; i < daten.maxTherapeuten+1; i++){
			t = daten.getTherapeut(i-1);
			spalten[i] = t.getVorname();
		}
		fireTableDataChanged();
		fireTableStructureChanged();
	}

	
}
