import javax.swing.table.*;
import javax.swing.*;
import java.awt.Color;
import java.awt.Component;
import java.util.*;
import java.awt.Font;

//import javax.swing.border.EtchedBorder;
//import javax.swing.border.LineBorder;

public class MyKursTableCellRenderer extends DefaultTableCellRenderer {
	public static final long serialVersionUID = 1L;
	Daten daten;
	private boolean farbig = false;
	private int spalte = 0;
	private final static Color heuteFA = new Color(255, 255, 200);//Aktiv
	private final static Color heuteFP = new Color(220, 220, 200);//Passiv
	private final static Color sonstFA = new Color(255, 255, 255);
	private final static Color sonstFP = new Color(200, 200, 200);
	private final static Color zeileFA = new Color(0, 200, 0);//Zeilenfarbe
	private final static Color zeitFP = new Color(220, 220, 200);//Passi
	private final static Color nichtsDa = new Color(255,0,0);//
	private int zeile = -1;
	private Color background = sonstFP;
	private final static Color weiss = new Color(255,255,255);//
	private final static Color schwarz = new Color(0,0,0);//
	private Color foreground = schwarz;
	private boolean[][] dataW = new boolean[86][13];
	private int anfang = 0;
	private int thera = 0;
	
	
	public MyKursTableCellRenderer(Daten daten){
		super();
		this.daten = daten;
		for(int i =0; i < 86; i++)
			for(int j = 0; j < 13; j++)
				dataW[i][j] = false;
	}
	
	
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
		foreground = schwarz;
		if((column == 0) || (row == 0))
			background = zeitFP;
		else if(row == zeile){
			background = zeileFA;
			setOpaque(true);
		} else if((farbig) && ((column == spalte) || (column == spalte+1))){
			/*
				Heutiger Tag
			*/
			if(dataW[row][column])
				background = heuteFA;
			else
				background = heuteFP;
			setOpaque(true);
		} else {
			/*
				Irgendein Tag
			*/
			if(dataW[row][column])
				background = sonstFA;
			else
				background = sonstFP;
		}
		//1+column*2
		//2+column*2
		int lspalte = ((column+1)/2-1);
		int art = daten.getTermin(anfang+lspalte, 0, thera, 0).getArt();
		if(hasFocus){
			setBackground(zeileFA);
			setForeground(schwarz);
		} else {
			setBackground(background);
			setForeground(foreground);
		}
		setHorizontalAlignment(SwingConstants.CENTER);
		setFont(this.getFont().deriveFont(Font.BOLD));
		return this;
	}
	
	/*
	public void setValue(Object value){
		setBackground(Color.RED);
		setText((value == null ? "" : value.toString()));
	}
	*/
	
	public void setFarben(boolean farbig, int spalte){
		this.farbig = farbig;
		this.spalte = spalte;
	}
	
	public void setZeile(int zeile){
		this.zeile = zeile;
	}
	
	//JLabel c = (JLabel) super.prepareRenderer(renderer, row, column);
	//c.setFont(c.getFont().deriveFont(Font.BOLD));
	
	
	public void setWochenDatum(Calendar cal){
		Calendar meinC = Calendar.getInstance();
		meinC.setTime(cal.getTime());
		if(null != daten){
			anfang = daten.getSpalte(meinC.getTime());
			thera = daten.getAktivenTherapeuten();
		}
		int m = 0;
		int t = 0;
		for(int i= 0; i < 6; i++){
			//Übernahme der Einträge
			if(null != daten)
				for(int j=1; j < 86; j++){
					if(anfang != -1){
						//dataW[j][1+i*2]= (daten.getTermin(anfang+i, j, thera, 0)).frei();
						//dataW[j][2+i*2]= (daten.getTermin(anfang+i, j, thera, 1)).frei();
						dataW[j][2+i*2]= false;
						dataW[j][1+i*2]= false;
					} else {
						dataW[j][2+i*2]= false;
						dataW[j][1+i*2]= false;
					}
					//table.fireTableCellUpdated(j,i);
				}
			//nächster:
			meinC.add(Calendar.DATE, +1);
		}
		//table.fireTableDataChanged();
		//table.fireTableStructureChanged();
	}
	


}
