import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;
import java.util.*;
import java.util.logging.*;

public class Statusbar extends JPanel { 
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
 
	// Array der Felder, um spaeter auf diese zugreifen zu koennen 
	private StatusbarField[] fields; 
	private JProgressBar progress = new JProgressBar();
	private int max = 0;
 
	public Statusbar(int numFields) { 
		fields = new StatusbarField[numFields]; 
 
		// Der Einfachheit halber verwende ich hier 
		// ein GridLayout. In der Praxis wuerde man 
		// eventuell einen anderen LayoutManager 
		// verwenden. 
		setLayout(new GridLayout(1,numFields)); 
 
		// Hinzufuegen der Felder 
		for(int i=0; i<numFields; i++) { 
		fields[i] = new StatusbarField(); 
		add(fields[i]); 
		} 
		progress.setMaximum(100);
		progress.setStringPainted(true);
		progress.setString("");
		progress.setBorder(new BevelBorder(BevelBorder.LOWERED));
		add(progress);
	} 
 
	// Methode, um den Text eines Feldes zu aendern 
	public void setText(int num, String text) { 
		fields[num].setText(text); 
	} 
 
	// Methode, um den Text eines Feldes auszulesen 
	public String getText(int num) { 
		return fields[num].getText(); 
	} 
	
	public void setValue(int value){
		//if(value >= 0 && value <= 100)
		progress.setValue(value);
		//if (logger.isLoggable(Level.FINEST)) { logger.finest("SStatusbar: "+value+"/"+max); }
	}
	
	public void setMax(int max){
		progress.setMaximum(max);
		this.max = max;
	}
	
	public void setBarText(String text){
		progress.setString(text);
	}
	
	public void absolute(){
		progress.setIndeterminate(false);
	}
	
	public void indeterminate(){
		progress.setIndeterminate(true);
	}
 
	// Das eigentlich Feld: ein einfaches JLabel 
	class StatusbarField extends JLabel { 
		public static final long serialVersionUID = 1L;
		public StatusbarField() { 
 
		// Der Rand, der das Ganze wie eine typische 
		// Statusleiste erscheinen laesst 
		setBorder(new BevelBorder(BevelBorder.LOWERED)); 
 
		// Wichtiger als die Breite ist die Hoehe (hier: 18), 
		// damit, ein leeres Feld genauso hoch ist wie eines 
		// mit Text 
		setPreferredSize(new Dimension(50,18)); 
 
		// Font-Zuweisung, damit nicht die beim 
		// Metal Look & Feel uebliche Fettschrift 
		// verwendet wird 
		setFont(new Font("Dialog", Font.PLAIN, 12)); 
		} 
	} 
} 
