import java.io.*;

public class Termin implements Serializable{
	public static final long serialVersionUID = 1L;

	//public final static int UNBENUTZT = -1;
	public final static int FREI             = 0;
	public final static int PATIENT          = 1;
	public final static int KURS             = 2;
	public final static int PAUSE            = 3;
	public final static int ANMELDUNG        = 4;
	public final static int NOTIZ            = 5; //Kommentarstring hinschreiben
	public final static int URLAUB           = 6;//g
	public final static int SCHULUNG         = 7;//g
	public final static int KRANK            = 8;//g
	public final static int FEIERTAG         = 9;//g
	public final static int TEAM             = 10;//alle Mittarbeiter
	public final static int KEINEARBEITSZEIT = 11;
	public final static int MAXFELD          = 12;//Immer eins höher als letztes
	//public final static String[] WERTE ={"E Frei (zum Eintragen)", "E Patient", "E Kurs", "E Pause", "E Anmeldung/ Bürokram", "E Notiz", "T Urlaub", "T Schulung", "T Krank", "T Feiertag", "Keine Arbeitszeit"};
	public final static String[] WERTE ={"Frei", "Patient", "Kurs", "Pause", "Anmeldung/ Bürokram", "Notiz", "Urlaub", "Schulung", "Krank", "Feiertag", "Teamsitzung", "Keine Arbeitszeit"};
	protected int art = FREI;
	protected int oldart = FREI;
	protected int taktung = 20;//10, immer, 20 = 0 20 40; 30 = 00 30; 60 = 00
	
	/*
	  TODO: 
	    Speichern, wann ein Raum und wann eine Packung/ Strom benutzt wird! Raum geht ganz einfach, einfach addieren.
	    Geräte oder Packung sind schwieriger, denn die sind Teil der Therapie und können an den Anfang oder zum Schluss
	    genommen werden.
	*/

	protected Patient patient = new Patient();
	protected int patientenNummer = -1;//Beim Einlesen benutzen, dann bei NAchbearbeitung direkt Verlinkung zum Patienten benutzen
	protected boolean packung = false;
	protected String kommentar = "";
	protected boolean kabine = false; //Belegt eine Kabine
	protected int raum = 0;//wenn eine Kabine belegt wird, dann wird daraus 1. Hat den Vorteil der schnelleren Berechnung.
	protected boolean strom = false; //Belegt Strom
	protected boolean ultraschall = false; //Belegt Ultraschall
	protected int gerat = 0;//Wenn Strom oder Ultraschall, dann 1. 
	protected boolean erinnerung = false; //Erinnerungen, wie Rechnung und so.
	protected String erinnerungstext = "";
	protected String ausgabetext = "";//Ausgabetext in der Tabelle
	protected String ausgabetherapie = "";//Ausgabetext in der TagesTabelle
	protected String kurstext = "";
	protected String notiz = "";//Text für Kalender
	protected String notizen = "";//Ausführliche Erweiterung
	protected int vonZeit = -1;
	protected int bisZeit = -1;
	
	protected int vonUrlaub;//Spalten, von denen bis wann der Urlaub geht.
	protected int bisUrlaub;
	
	protected long id = System.currentTimeMillis();

	public Termin(){
		//nichts, alles schon belegt.
		art = KEINEARBEITSZEIT;
		oldart = KEINEARBEITSZEIT;
	}

	public Termin(int art, Patient p, String kommentar, boolean kabine, boolean strom, boolean ultraschall, boolean erinnerung, String et){
		this.art = art;
		if(art == FREI || art == KEINEARBEITSZEIT)
			oldart = art;
		patient = p;
		this.kommentar = kommentar;
		this.kabine = kabine;
		if(kabine)
			raum = 1;
		this.strom = strom;
		this.ultraschall = ultraschall;
		if(strom || ultraschall)
			gerat = 1;
		this.erinnerung = erinnerung;
		erinnerungstext = et;
		id = System.currentTimeMillis();
	}

	public Termin(int art){
		//Kurse, Pause, Urlaub, Schulung, krank, Feiertag, KeineArbeitszeit
		if(art >= 0 && art < MAXFELD)
			this.art= art;
		if(art == FREI || art == KEINEARBEITSZEIT)
			oldart = art;
		id = System.currentTimeMillis();
	}
	
	public int getArt(){
		return art;
	}
	
	public void setArt(int art){
		if(art >= 0 && art < MAXFELD)
			this.art= art;
	}
	
	public String toString(){
		ausgabetext = "";
		switch(art){
			case KURS: ausgabetext = "K: "+kurstext; break;
			case KEINEARBEITSZEIT: ausgabetext = "";break;
			case FREI: ausgabetext = ""; break;
			case NOTIZ: ausgabetext = notiz; break;
			case PAUSE: ausgabetext = "Pause"; break;
			case KRANK: ausgabetext = "krank"; break;
			case SCHULUNG: ausgabetext = "Schulung"; break;
			case FEIERTAG: ausgabetext = "Feiertag"; break;
			case URLAUB: ausgabetext = "Urlaub";break;
			case ANMELDUNG: ausgabetext = "A/B";break;
			case TEAM: ausgabetext = "TEAM";break;
			case PATIENT: 
				ausgabetext = ""+patient.getNachname()+", "+patient.getVorname();
				//Wird schon gesetzt: ausgabetherapie = ; 
				break;
		}
		return ausgabetext;
	}
	
	public String therapie(){
		return ausgabetherapie;
	}
	
	public void setTherapie(String therapie){
		ausgabetherapie = therapie;
	}
	
	public int getRaume(){
		return raum;
	}
	
	public int getGeraet(){
		return gerat;
	}
	
	public void setRaum(int raum){
		if(raum == 0 || raum == 1)
			this.raum = raum;
	}
	
	public void setGeraet(int gerat){
		if(gerat == 0 || gerat == 1)
			this.gerat = gerat;
	}
	
	public boolean frei(){
		if(art == FREI)
			return true;
		else
			return false;
	}

	public void setKurs(String kurstext){
		if(art == KURS){
			this.kurstext = kurstext;
		}
	}

	public String getKurs(){
		return kurstext;
	}

	public void setZeit(int von, int bis){
		if(von > -1 && von < 86)
			vonZeit = von;
		if(bis > -1 && bis < 86)
			bisZeit = bis;
	}
	
	public void resetZeit(){
		vonZeit = -1;
		bisZeit = -1;
	}

	public int getVonZeit(){
		return vonZeit;
	}

	public int getBisZeit(){
		return bisZeit;
	}

	public int getOldArt(){
		/*
			Zum Löschen wichtig, da auf diesen Wert zurückgesetzt wird.
		*/
		return oldart;
	}

	public void setOldArt(int oldart){
		if(oldart >= 0 && oldart < MAXFELD)
			this.oldart= oldart;
	}

	public void setNotizen(String notiz, String notizen){
		this.notiz = notiz;
		this.notizen = notizen;
		this.ausgabetherapie = notizen;
	}

	public String getNotiz(){
		return notiz;
	}
	
	public String getNotizen(){
		return notizen;
	}
	
	public boolean equals(Termin t){
		boolean wert = true;
		/*
			Nur Equals, wenn gleiche Art und dann auch gleiche Inhalte.
		*/
		if(t.getArt() != art)
			wert = false;
		if(wert){
			wert = false;
			switch(art){
				case FREI : wert = true; break;
				case NOTIZ : if(t.getNotiz().equals(notiz) && t.getNotizen().equals(notizen)) wert = true; break;
				case KURS : if(t.getKurs().equals(kurstext)) wert = true; break;
			}
		}
		return wert;
	}
	
	public void setID(long id){
		if(id > 0)
			this.id = id;
	}
	
	public long getID(){
		return id;
	}
	
	public void setPatient(Patient patient, boolean packung){
		this.packung = packung;
		art = PATIENT;
		this.patient = patient;
		raum = 1;
	}
	
	public Patient getPatient(){
		return patient;
	}
	
	public boolean getPackung(){
		return packung;
	}
	
	public void setPackung(boolean packung){
		this.packung = packung;
	}
}
