import java.util.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.logging.*;

public class TerminDialog extends JDialog{
	public static final long serialVersionUID = 1L;
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");
	private Physiomat physiomat;
	private Daten daten;
	private Patient patient;
	private int therapeutIndex = 0;
	private JPanel mainPanel = new JPanel();
	private JPanel buttonPanel = new JPanel();
	private JPanel cbPanel = new JPanel();
	private JButton ok = new JButton("OK");
	private JButton cancel = new JButton("Abbrechen");
	private Container c = this.getContentPane(); 
	private	GridBagLayout gbl = new GridBagLayout(); 
	private	GridBagLayout gbl2 = new GridBagLayout(); 
	private	GridBagLayout gbl3 = new GridBagLayout(); 
	private	GridBagLayout gbl4 = new GridBagLayout();
	
	private JCheckBox packungCB = new JCheckBox("Packung");
	private JCheckBox geratCB = new JCheckBox("ET/US");
	private JLabel labelTherapie = new JLabel("Therapie und wo:");
	private JTextField therapie = new JTextField();
	private JRadioButton wahl1RB = new JRadioButton("so schnell wie möglich (alle Th.)");
	private JRadioButton wahl2RB = new JRadioButton("diese Woche, dieser Therapeut");
	private JRadioButton wahl3RB = new JRadioButton("nächste Woche, dieser Therapeut");
	private JRadioButton wahl4RB = new JRadioButton("in zwei Wochen, dieser Therapeut");
	private JRadioButton wahl5RB = new JRadioButton("in drei Wochen, dieser Therapeut");
	private JRadioButton wahl6RB = new JRadioButton("in vier Wochen, dieser Therapeut");
	private JLabel labelDauer = new JLabel("Dauer:");
	private JComboBox dauerCB = new JComboBox();
	private ButtonGroup wahlen = new ButtonGroup();
	private JComboBox theraTerminCB = new JComboBox();
	
	
	static void addComponent( Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty ) { 
		GridBagConstraints gbc = new GridBagConstraints(); 
		gbc.fill = GridBagConstraints.BOTH; 
		gbc.gridx = x; gbc.gridy = y; 
		gbc.gridwidth = width; gbc.gridheight = height; 
		gbc.weightx = weightx; gbc.weighty = weighty; 
		gbl.setConstraints( c, gbc ); 
		cont.add( c ); 
	} 
	
	static void addComponent( Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height) 
	{ 
		GridBagConstraints gbc = new GridBagConstraints(); 
		gbc.fill = GridBagConstraints.BOTH; 
		gbc.gridx = x; gbc.gridy = y; 
		gbc.gridwidth = width; gbc.gridheight = height; 
		gbc.weightx = 1.0; gbc.weighty = 1.0; 
		gbl.setConstraints( c, gbc ); 
		cont.add( c ); 
	}
	
	public TerminDialog(Physiomat physiomat, Daten daten, Patient patient, int thera){
		super(physiomat, "Neue Termine", true);
		this.physiomat = physiomat;
		this.daten = daten;
		this.patient = patient;
		if(thera != 0)
			therapeutIndex = thera -1;
		initGui();
	}
	
	private void initGui(){
		this.setBounds(0,0,400,450);
		setLocationRelativeTo(null);
		mainPanel.setLayout(new BorderLayout());
		cbPanel.setLayout(gbl);
		//cbPanel.setLayout(gbl);
		c.setLayout(gbl3);
		buttonPanel.setLayout(gbl4);
		
		ok.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					//ok();
					diesenTerminNeu();
				}
			} 
		);
		
		cancel.addActionListener( new ActionListener() { 
			public void actionPerformed( ActionEvent e ) { 
					dispose();
				}
			} 
		);
		
		addComponent( cbPanel, gbl, labelTherapie , 0, 0, 2, 1);
		addComponent( cbPanel, gbl, therapie , 0, 1, 2, 1);
		addComponent( cbPanel, gbl, labelDauer, 0, 2, 1, 1);
		addComponent( cbPanel, gbl, dauerCB, 1, 2, 1, 1);
		addComponent( cbPanel, gbl, packungCB, 0, 3, 1, 1);
		addComponent( cbPanel, gbl, geratCB, 1, 3, 1, 1);
		addComponent( cbPanel, gbl, theraTerminCB, 0, 6, 2, 1);
		addComponent( cbPanel, gbl, wahl1RB, 0, 7, 2, 1);
		addComponent( cbPanel, gbl, wahl2RB, 0, 8, 2, 1);
		addComponent( cbPanel, gbl, wahl3RB, 0, 9, 2, 1);
		addComponent( cbPanel, gbl, wahl4RB, 0, 10, 2, 1);
		addComponent( cbPanel, gbl, wahl5RB, 0, 11, 2, 1);
		addComponent( cbPanel, gbl, wahl6RB, 0, 12, 2, 1);
		
		wahlen.add(wahl1RB);
		wahlen.add(wahl2RB);
		wahlen.add(wahl3RB);
		wahlen.add(wahl4RB);
		wahlen.add(wahl5RB);
		wahlen.add(wahl6RB);
		
		Therapeut t;
		wahl3RB.setSelected(true);
		for(int i = 0; i < daten.getMaxTherapeuten(); i++){
			t = daten.getTherapeut(i);
			theraTerminCB.addItem(t.getVorname()+" "+t.getNachname());
		}
		for(int i = 1; i < 19; i++){
			dauerCB.addItem(""+i+"0 Minuten");
		}
		dauerCB.setSelectedIndex(1);
		theraTerminCB.setSelectedIndex(therapeutIndex);
		
		buttonPanel.add(ok);
		buttonPanel.add(cancel);
		//addComponent( buttonPanel, gbl2, ok, 0, 0 , 1, 1);
		//addComponent( buttonPanel, gbl2, cancel, 1, 0 , 1, 1);
		mainPanel.add(BorderLayout.CENTER, cbPanel);
		mainPanel.add(BorderLayout.SOUTH, buttonPanel);
		addComponent( c, gbl3, mainPanel, 0,0,1,1);
		//pack();
		setVisible(true);
	}
	
	private void diesenTerminNeu(){
		logger.info("Starte Suche nach neuen Terminen:");
		int von = 1;
		int bis = dauerCB.getSelectedIndex()+2;
		int index = 0;
		Termin vergleich;
		TerminTag neuT;
		Vector<Termin> termine = new Vector<Termin>(10,10);
		String woTag = "";
		if(wahl1RB.isSelected()) index = 1;//Sofort
		if(wahl2RB.isSelected()) index = 2;//diese Woche
		if(wahl3RB.isSelected()) index = 3;//nächste Woche
		if(wahl4RB.isSelected()) index = 4;//In zwei Wochen
		if(wahl5RB.isSelected()) index = 5;//In drei Wochen
		if(wahl6RB.isSelected()) index = 6;//in vier Wochen
		
		boolean geraete = geratCB.isSelected();
		boolean gefunden = false;//Falls kein Termin gefunden, dann natürlich ansagen.
		boolean packung = packungCB.isSelected();
		int aktSpalte = daten.getSpalte(new Date());
		int endSpalte = 0;
		int dauer = bis-von;
		int thera = theraTerminCB.getSelectedIndex();
		int anzahl = 0;//entspricht suchdauer
		boolean gut = false;
		//Wenn gut, dann muss der Termin die ganze Zeit über gut sein. Eine Stunde muss
		//auch eine komplette Stunde gut sein und nicht zwischendurch unterbrochen werden.
		int terminZeile = 0;//Zeile in den Terminen
		//Date datum;
		Calendar calR = Calendar.getInstance();
		int tag, monat, jahr = 0;
		String vorname, name = "";
		Therapeut th;
		switch (index){
			case 1: 
				/*
				Sofort alle passenden freien Termine finden. 
				Suchzeit bis zu zwei Wochen.
				*/
				endSpalte = aktSpalte+14;
				if(packung){
					//Hier zuerst Packungsspalte durchsuchen und dann nach geeigneten Kandidaten finden.
					for(int i = aktSpalte; i < endSpalte; i++){
						for(thera = 0; thera < daten.getMaxTherapeuten(); thera++){
							vergleich = daten.getTermin(i, 0, thera, 0);
							if(vergleich.getArt() != Termin.URLAUB && vergleich.getArt() != Termin.KRANK && vergleich.getArt() != Termin.SCHULUNG && vergleich.getArt() != Termin.FEIERTAG){
								for(int zeile = 1; zeile < 86; zeile++){
									vergleich = daten.getTermin(i, zeile, thera, 1);
									if(vergleich.getArt() == Termin.FREI){
										//Anfangstreffer. Nun müssen auch die anderen weiteren Treffer gut sein
										gut = true;
										anzahl = 0;
										terminZeile = zeile;
										while(anzahl < dauer && terminZeile < 86 && gut){
											if(anzahl == 1)
												vergleich = daten.getTermin(i, terminZeile, thera, 1);
											else
												vergleich = daten.getTermin(i, terminZeile, thera, 0);
											if(vergleich.getArt() != Termin.FREI)
												gut = false;
											else
												anzahl++;
											//int tt = 0;//therapeuten für die Geräte und Raumsuche
											int raum = 1;
											int gerat = 0;
											if(geraete)
												gerat = 1;
											for(int tt = 0; tt < daten.getMaxTherapeuten(); tt++){
												vergleich = daten.getTermin(i, terminZeile, tt, 0);
												raum = raum + daten.getTermin(i, terminZeile, tt, 0).getRaume();
												raum = raum + daten.getTermin(i, terminZeile, tt, 1).getRaume();
												gerat = gerat + daten.getTermin(i, terminZeile, tt, 0).getGeraet();
												gerat = gerat + daten.getTermin(i, terminZeile, tt, 1).getGeraet();
											}
											Date atag = daten.getDate(i);
											Date vtag = daten.getGeraete().getDatum();
											//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
											if(atag.getTime() < vtag.getTime()){//Vorher
												if(gerat > daten.getGeraete().getWert())
													gut = false;
											} else {
												if(gerat > daten.getGeraete().getZukunft())
													gut = false;
											}
											vtag = daten.getRaeume().getDatum();
											//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
											if(atag.getTime() < vtag.getTime()){//Vorher
												if(raum > daten.getRaeume().getWert())
													gut = false;
											} else {
												if(raum > daten.getRaeume().getZukunft())
													gut = false;
											}
											terminZeile++;
										}
										if(gut && anzahl >= dauer){
											//Wir haben einen Termin gefunden:
											calR.setTime(daten.getDate(i));
											jahr = calR.get(Calendar.YEAR);
											monat = calR.get(Calendar.MONTH)+1;
											tag = calR.get(Calendar.DAY_OF_MONTH);
											th = daten.getTherapeut(thera);
											vorname = th.getVorname();
											name = th.getNachname();
											switch (calR.get(Calendar.DAY_OF_WEEK)){
												case Calendar.MONDAY   : woTag = "Mo"; break;
												case Calendar.TUESDAY  : woTag = "Di"; break;
												case Calendar.WEDNESDAY: woTag = "Mi"; break;
												case Calendar.THURSDAY : woTag = "Do"; break;
												case Calendar.FRIDAY   : woTag = "Fr"; break;
												case Calendar.SATURDAY : woTag = "Sa"; break;
												case Calendar.SUNDAY   : woTag = "So"; break;
											}
											logger.fine("Termin gefunden:\n"+tag+"."+monat+"."+jahr+" "+daten.UHRZEIT[zeile-1]+" bei "+vorname+" "+name);
											gefunden = true;
											neuT = new TerminTag(tag, monat, jahr, i, zeile, packung, thera, woTag);
											if(geraete)
												neuT.setGeraet(1);
											termine.add(neuT);
										}
									}
								}
							}
						}
					}
				} else {
					for(int i = aktSpalte; i < endSpalte; i++){
						for(thera = 0; thera < daten.getMaxTherapeuten(); thera++){
							vergleich = daten.getTermin(i, 0, thera, 0);
							if(vergleich.getArt() != Termin.URLAUB && vergleich.getArt() != Termin.KRANK && vergleich.getArt() != Termin.SCHULUNG && vergleich.getArt() != Termin.FEIERTAG){
								for(int zeile = 1; zeile < 86; zeile++){
									vergleich = daten.getTermin(i, zeile, thera, 0);
									if(vergleich.getArt() == Termin.FREI){
										//Anfangstreffer. Nun müssen auch die anderen weiteren Treffer gut sein
										gut = true;
										anzahl = 0;
										terminZeile = zeile;
										while(anzahl < dauer && terminZeile < 86 && gut){
											vergleich = daten.getTermin(i, terminZeile, thera, 0);
											if(vergleich.getArt() != Termin.FREI)
												gut = false;
											else
												anzahl++;
											//int tt = 0;//therapeuten für die Geräte und Raumsuche
											int raum = 1;
											int gerat = 0;
											if(geraete)
												gerat = 1;
											for(int tt = 0; tt < daten.getMaxTherapeuten(); tt++){
												vergleich = daten.getTermin(i, terminZeile, tt, 0);
												raum = raum + daten.getTermin(i, terminZeile, tt, 0).getRaume();
												raum = raum + daten.getTermin(i, terminZeile, tt, 1).getRaume();
												gerat = gerat + daten.getTermin(i, terminZeile, tt, 0).getGeraet();
												gerat = gerat + daten.getTermin(i, terminZeile, tt, 1).getGeraet();
											}
											Date atag = daten.getDate(i);
											Date vtag = daten.getGeraete().getDatum();
											//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
											if(atag.getTime() < vtag.getTime()){//Vorher
												if(gerat > daten.getGeraete().getWert())
													gut = false;
											} else {
												if(gerat > daten.getGeraete().getZukunft())
													gut = false;
											}
											vtag = daten.getRaeume().getDatum();
											//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
											if(atag.getTime() < vtag.getTime()){//Vorher
												if(raum > daten.getRaeume().getWert())
													gut = false;
											} else {
												if(raum > daten.getRaeume().getZukunft())
													gut = false;
											}
											terminZeile++;
										}
										if(gut && anzahl >= dauer){
											//Wir haben einen Termin gefunden:
											calR.setTime(daten.getDate(i));
											jahr = calR.get(Calendar.YEAR);
											monat = calR.get(Calendar.MONTH)+1;
											tag = calR.get(Calendar.DAY_OF_MONTH);
											th = daten.getTherapeut(thera);
											vorname = th.getVorname();
											name = th.getNachname();
											switch (calR.get(Calendar.DAY_OF_WEEK)){
												case Calendar.MONDAY   : woTag = "Mo"; break;
												case Calendar.TUESDAY  : woTag = "Di"; break;
												case Calendar.WEDNESDAY: woTag = "Mi"; break;
												case Calendar.THURSDAY : woTag = "Do"; break;
												case Calendar.FRIDAY   : woTag = "Fr"; break;
												case Calendar.SATURDAY : woTag = "Sa"; break;
												case Calendar.SUNDAY   : woTag = "So"; break;
											}
											logger.fine("Termin gefunden:\n"+tag+"."+monat+"."+jahr+" "+daten.UHRZEIT[zeile-1]+" bei "+vorname+" "+name);
											gefunden = true;
											neuT = new TerminTag(tag, monat, jahr, i, zeile, packung, thera, woTag);
											if(geraete)
												neuT.setGeraet(1);
											termine.add(neuT);
										}
									}
								}
							}
						}
					}
				}
				break;
			case 2: 
				/*
					Ab diese Woche, aber nur dieser Therapeut; drei Wochen suchen
				*/
				endSpalte = aktSpalte+21;
				break;
			case 3: 
				/*
					Ab nächste Woche, aber nur dieser Therapeut; drei Wochen suchen
				*/
				calR.setTime(daten.getDate(aktSpalte));
				int dow = calR.get(Calendar.DAY_OF_WEEK);
				switch(dow){
					case Calendar.SUNDAY : aktSpalte = aktSpalte+1; break;
					case Calendar.MONDAY : aktSpalte = aktSpalte+7; break;
					case Calendar.TUESDAY : aktSpalte = aktSpalte+6; break;
					case Calendar.WEDNESDAY : aktSpalte = aktSpalte+5; break;
					case Calendar.THURSDAY : aktSpalte = aktSpalte+4; break;
					case Calendar.FRIDAY : aktSpalte = aktSpalte+3; break;
					case Calendar.SATURDAY : aktSpalte = aktSpalte+2; break;
				}
				endSpalte = aktSpalte+21;
				break;
			case 4: 
				/*
					In zwei Wochen, aber nur dieser Therapeut; drei Wochen suchen
				*/
				calR.setTime(daten.getDate(aktSpalte));
				dow = calR.get(Calendar.DAY_OF_WEEK);
				switch(dow){
					case Calendar.SUNDAY : aktSpalte = aktSpalte+8; break;
					case Calendar.MONDAY : aktSpalte = aktSpalte+14; break;
					case Calendar.TUESDAY : aktSpalte = aktSpalte+13; break;
					case Calendar.WEDNESDAY : aktSpalte = aktSpalte+12; break;
					case Calendar.THURSDAY : aktSpalte = aktSpalte+11; break;
					case Calendar.FRIDAY : aktSpalte = aktSpalte+10; break;
					case Calendar.SATURDAY : aktSpalte = aktSpalte+9; break;
				}
				endSpalte = aktSpalte+21;
				break;
			case 5: 
				/*
					In drei Wochen, aber nur dieser Therapeut; drei Wochen suchen
				*/
				calR.setTime(daten.getDate(aktSpalte));
				dow = calR.get(Calendar.DAY_OF_WEEK);
				switch(dow){
					case Calendar.SUNDAY : aktSpalte = aktSpalte+15; break;
					case Calendar.MONDAY : aktSpalte = aktSpalte+21; break;
					case Calendar.TUESDAY : aktSpalte = aktSpalte+20; break;
					case Calendar.WEDNESDAY : aktSpalte = aktSpalte+19; break;
					case Calendar.THURSDAY : aktSpalte = aktSpalte+18; break;
					case Calendar.FRIDAY : aktSpalte = aktSpalte+17; break;
					case Calendar.SATURDAY : aktSpalte = aktSpalte+16; break;
				}
				endSpalte = aktSpalte+21;
				break;
			case 6: 
				/*
					In drei Wochen, aber nur dieser Therapeut; drei Wochen suchen
				*/
				calR.setTime(daten.getDate(aktSpalte));
				dow = calR.get(Calendar.DAY_OF_WEEK);
				switch(dow){
					case Calendar.SUNDAY : aktSpalte = aktSpalte+22; break;
					case Calendar.MONDAY : aktSpalte = aktSpalte+28; break;
					case Calendar.TUESDAY : aktSpalte = aktSpalte+27; break;
					case Calendar.WEDNESDAY : aktSpalte = aktSpalte+26; break;
					case Calendar.THURSDAY : aktSpalte = aktSpalte+25; break;
					case Calendar.FRIDAY : aktSpalte = aktSpalte+24; break;
					case Calendar.SATURDAY : aktSpalte = aktSpalte+23; break;
				}
				endSpalte = aktSpalte+21;
				break;
		}
		if(index != 1){//Fall 1 wurde schon behandelt. Verschiedene Therapeuten. Nun nur noch einer.
			if(packung){
				//Hier zuerst Packungsspalte durchsuchen und dann nach geeigneten Kandidaten finden.
				for(int i = aktSpalte; i < endSpalte; i++){
					//thera = daten.getAktivenTherapeuten();
					vergleich = daten.getTermin(i, 0, thera, 0);
					if(vergleich.getArt() != Termin.URLAUB && vergleich.getArt() != Termin.KRANK && vergleich.getArt() != Termin.SCHULUNG && vergleich.getArt() != Termin.FEIERTAG){
						for(int zeile = 1; zeile < 86; zeile++){
							vergleich = daten.getTermin(i, zeile, thera, 1);
							if(vergleich.getArt() == Termin.FREI){
								//Anfangstreffer. Nun müssen auch die anderen weiteren Treffer gut sein
								gut = true;
								anzahl = 0;
								terminZeile = zeile;
								while(anzahl < dauer && terminZeile < 86 && gut){
									if(anzahl==1)
										vergleich = daten.getTermin(i, terminZeile, thera, 1);
									else
										vergleich = daten.getTermin(i, terminZeile, thera, 0);
									if(vergleich.getArt() != Termin.FREI)
										gut = false;
									else
										anzahl++;
									//int tt = 0;//therapeuten für die Geräte und Raumsuche
									int raum = 1;
									int gerat = 0;
									if(geraete)
										gerat = 1;
									for(int tt = 0; tt < daten.getMaxTherapeuten(); tt++){
										//vergleich = daten.getTermin(i, terminZeile, tt, 0);
										raum = raum + daten.getTermin(i, terminZeile, tt, 0).getRaume();
										raum = raum + daten.getTermin(i, terminZeile, tt, 1).getRaume();
										gerat = gerat + daten.getTermin(i, terminZeile, tt, 0).getGeraet();
										gerat = gerat + daten.getTermin(i, terminZeile, tt, 1).getGeraet();
									}
									Date atag = daten.getDate(i);
									Date vtag = daten.getGeraete().getDatum();
									//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
									if(atag.getTime() < vtag.getTime()){//Vorher
										if(gerat > daten.getGeraete().getWert())
											gut = false;
									} else {
										if(gerat > daten.getGeraete().getZukunft())
											gut = false;
									}
									vtag = daten.getRaeume().getDatum();
									//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
									if(atag.getTime() < vtag.getTime()){//Vorher
										if(raum > daten.getRaeume().getWert())
											gut = false;
									} else {
										if(raum > daten.getRaeume().getZukunft())
											gut = false;
									}
									terminZeile++;
								}
								if(gut && anzahl >= dauer){
									//Wir haben einen Termin gefunden:
									calR.setTime(daten.getDate(i));
									jahr = calR.get(Calendar.YEAR);
									monat = calR.get(Calendar.MONTH)+1;
									tag = calR.get(Calendar.DAY_OF_MONTH);
									th = daten.getTherapeut(thera);
									vorname = th.getVorname();
									name = th.getNachname();
									switch (calR.get(Calendar.DAY_OF_WEEK)){
										case Calendar.MONDAY   : woTag = "Mo"; break;
										case Calendar.TUESDAY  : woTag = "Di"; break;
										case Calendar.WEDNESDAY: woTag = "Mi"; break;
										case Calendar.THURSDAY : woTag = "Do"; break;
										case Calendar.FRIDAY   : woTag = "Fr"; break;
										case Calendar.SATURDAY : woTag = "Sa"; break;
										case Calendar.SUNDAY   : woTag = "So"; break;
									}
									logger.fine("Termin gefunden:\n"+tag+"."+monat+"."+jahr+" "+daten.UHRZEIT[zeile-1]+" bei "+vorname+" "+name);
									gefunden = true;
									neuT = new TerminTag(tag, monat, jahr, i, zeile, packung, thera, woTag);
									if(geraete)
										neuT.setGeraet(1);
									termine.add(neuT);
								}
							}
						}
					}
				}
			} else {
				for(int i = aktSpalte; i < endSpalte; i++){
					//thera = daten.getAktivenTherapeuten();
					vergleich = daten.getTermin(i, 0, thera, 0);
					if(vergleich.getArt() != Termin.URLAUB && vergleich.getArt() != Termin.KRANK && vergleich.getArt() != Termin.SCHULUNG && vergleich.getArt() != Termin.FEIERTAG){
						for(int zeile = 1; zeile < 86; zeile++){
							vergleich = daten.getTermin(i, zeile, thera, 0);
							if(vergleich.getArt() == Termin.FREI){
								//Anfangstreffer. Nun müssen auch die anderen weiteren Treffer gut sein
								gut = true;
								anzahl = 0;
								terminZeile = zeile;
								while(anzahl < dauer && terminZeile < 86 && gut){
									vergleich = daten.getTermin(i, terminZeile, thera, 0);
									if(vergleich.getArt() != Termin.FREI)
										gut = false;
									else
										anzahl++;
									//int tt = 0;//therapeuten für die Geräte und Raumsuche
									int raum = 1;
									int gerat = 0;
									if(geraete)
										gerat = 1;
									for(int tt = 0; tt < daten.getMaxTherapeuten(); tt++){
										//vergleich = daten.getTermin(i, terminZeile, tt, 0);
										raum = raum + daten.getTermin(i, terminZeile, tt, 0).getRaume();
										raum = raum + daten.getTermin(i, terminZeile, tt, 1).getRaume();
										gerat = gerat + daten.getTermin(i, terminZeile, tt, 0).getGeraet();
										gerat = gerat + daten.getTermin(i, terminZeile, tt, 1).getGeraet();
									}
									Date atag = daten.getDate(i);
									Date vtag = daten.getGeraete().getDatum();
									//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
									if(atag.getTime() < vtag.getTime()){//Vorher
										if(gerat > daten.getGeraete().getWert())
											gut = false;
									} else {
										if(gerat > daten.getGeraete().getZukunft())
											gut = false;
									}
									vtag = daten.getRaeume().getDatum();
									//logger.finest("Datumsvergleich:\n Tag:"+tag.getTime()+"\nVTag:"+daten.getRaeume().getDatum().getTime()+"\n Tag:"+tag+"\nVTag:"+vtag);
									if(atag.getTime() < vtag.getTime()){//Vorher
										if(raum > daten.getRaeume().getWert())
											gut = false;
									} else {
										if(raum > daten.getRaeume().getZukunft())
											gut = false;
									}
									terminZeile++;
								}
								if(gut && anzahl >= dauer){
									//Wir haben einen Termin gefunden:
									calR.setTime(daten.getDate(i));
									jahr = calR.get(Calendar.YEAR);
									monat = calR.get(Calendar.MONTH)+1;
									tag = calR.get(Calendar.DAY_OF_MONTH);
									th = daten.getTherapeut(thera);
									vorname = th.getVorname();
									name = th.getNachname();
									switch (calR.get(Calendar.DAY_OF_WEEK)){
										case Calendar.MONDAY   : woTag = "Mo"; break;
										case Calendar.TUESDAY  : woTag = "Di"; break;
										case Calendar.WEDNESDAY: woTag = "Mi"; break;
										case Calendar.THURSDAY : woTag = "Do"; break;
										case Calendar.FRIDAY   : woTag = "Fr"; break;
										case Calendar.SATURDAY : woTag = "Sa"; break;
										case Calendar.SUNDAY   : woTag = "So"; break;
									}
									logger.fine("Termin gefunden:\n"+tag+"."+monat+"."+jahr+" "+daten.UHRZEIT[zeile-1]+" bei "+vorname+" "+name);
									gefunden = true;
									neuT = new TerminTag(tag, monat, jahr, i, zeile, packung, thera, woTag);
									if(geraete)
										neuT.setGeraet(1);
									termine.add(neuT);
								}
							}
						}
					}
				}
			}
		}
		if(!gefunden){
			logger.info("Keinen passenden Termin gefunden!");
			JOptionPane.showMessageDialog(physiomat,
				"Es wurde leider kein passender Termin gefunden.",
				"Keine Termine!", 
				JOptionPane.ERROR_MESSAGE, null);
		} else {
			logger.finest("Therapietext: "+therapie.getText());
			TerminAuswahl ta = new TerminAuswahl(physiomat, daten, dauer, termine, patient, therapie.getText());
			daten.setUpdate();
			daten.setUnsave();
		}
	}
	
}
