import java.util.*;
//import java.util.zip.*;
//import javax.swing.*;
//import java.awt.event.*;
//import java.awt.*;
//import java.awt.image.*;
import java.io.*;
//import javax.imageio.*;
//import com.sun.image.codec.jpeg.*;
//import java.util.regex.*;
//import com.sun.org.apache.xml.internal.serializer.*;
import java.util.logging.*;

public class XMLExport{
	private static Logger logger = Logger.getLogger("de.sebamueller.Physiomat");

	private Daten daten;
	private File file;
	private final String VERSION = Start.showVersion();
	private final String xmlVersion = "1.0";
	private long dateiversion = 0;
	private String path;
	private String name;

	private FileOutputStream fos;
	private ObjectOutputStream oos;
	private FileInputStream fis;
	private ObjectInputStream ois;
	private BufferedWriter bw;

	private int z = 0;
	private int maxC = 1;
	private long id = 1L;//Termine, die über einen längeren Eintrag gehen, haben eine ID


	public XMLExport(Daten daten, File file, int z, int maxC) throws IOException{
		this.daten = daten;
		this.file = file;
		if(z > -1)
			this.z = z;
		if(maxC >= 1)
			this.maxC = maxC;
		dateiversion = daten.getDateiversion();
		logger.finest("Anfangs Wert: "+z+"/"+maxC);
		schreiben();
	}
	
	private void schreiben() throws IOException{
		Therapeut th;
		Patient p;
		Termin te;
		//Zuerst DOM, dann die Daten
		int maxVolleZeile = 0;
		fos = new FileOutputStream(file);
		bw = new BufferedWriter(new OutputStreamWriter(fos,"UTF-8"));
		logger.fine("XML schreiben");
		vorspann();

		bw.newLine();
		bw.write("<Physiomat version=\""+xmlVersion+"\" datei=\""+dateiversion+"\">");
		bw.newLine();
		
		bw.write("  <Ausruestung>");
		bw.newLine();
		bw.write("    <Raeume>");
		bw.newLine();
		bw.write("      <jetzt>"+daten.getRaeume().getWert()+"</jetzt>");
		bw.newLine();
		Date zDay = daten.getRaeume().getDatum();
		Calendar calR = Calendar.getInstance();
		calR.setTime(zDay);
		int year = calR.get(Calendar.YEAR);
		int month = calR.get(Calendar.MONTH)+1;
		int day = calR.get(Calendar.DAY_OF_MONTH);
		bw.write("      <Zukunft Tag=\""+day+"\" Monat=\""+month+"\" Jahr=\""+year+"\">"+daten.getRaeume().getZukunft()+"</Zukunft>");
		bw.newLine();
		bw.write("    </Raeume>");
		bw.newLine();
		bw.write("    <Geraete>");
		bw.newLine();
		bw.write("      <jetzt>"+daten.getGeraete().getWert()+"</jetzt>");
		bw.newLine();
		zDay = daten.getGeraete().getDatum();
		calR = Calendar.getInstance();
		calR.setTime(zDay);
		year = calR.get(Calendar.YEAR);
		month = calR.get(Calendar.MONTH)+1;
		day = calR.get(Calendar.DAY_OF_MONTH);
		bw.write("      <Zukunft Tag=\""+day+"\" Monat=\""+month+"\" Jahr=\""+year+"\">"+daten.getGeraete().getZukunft()+"</Zukunft>");
		bw.newLine();
		bw.write("    </Geraete>");
		bw.newLine();
		bw.write("  </Ausruestung>");
		bw.newLine();
		
		if(daten.getMaxTherapeuten() > 0){
			bw.write("  <Therapeuten>");
			bw.newLine();
			
			for(int i =0; i < daten.getMaxTherapeuten(); i++){
				daten.setStatusBar(z++, ""+z*100/maxC+"%");
				th = daten.getTherapeut(i);
				bw.write("    <Therapeut>");
				bw.newLine();
				bw.write("      <Name>");
				bw.write(entity(th.getNachname()));
				bw.write("</Name>");
				bw.newLine();
				bw.write("      <Vorname>");
				bw.write(entity(th.getVorname()));
				bw.write("</Vorname>");
				bw.newLine();

				if(th.getHerr()){
					bw.write("      <Herr/>");
					bw.newLine();
				}
				bw.write("      <Arbeitszeiten>");
				bw.newLine();
				bw.write("        <Montag von=\""+th.getVonZeiten(0)+"\" bis=\""+th.getBisZeiten(0)+"\" />");
				bw.newLine();
				bw.write("        <Dienstag von=\""+th.getVonZeiten(1)+"\" bis=\""+th.getBisZeiten(1)+"\" />");
				bw.newLine();
				bw.write("        <Mittwoch von=\""+th.getVonZeiten(2)+"\" bis=\""+th.getBisZeiten(2)+"\" />");
				bw.newLine();
				bw.write("        <Donnerstag von=\""+th.getVonZeiten(3)+"\" bis=\""+th.getBisZeiten(3)+"\" />");
				bw.newLine();
				bw.write("        <Freitag von=\""+th.getVonZeiten(4)+"\" bis=\""+th.getBisZeiten(4)+"\" />");
				bw.newLine();
				bw.write("        <Sonnabend von=\""+th.getVonZeiten(5)+"\" bis=\""+th.getBisZeiten(5)+"\" />");
				bw.newLine();
				bw.write("        <Sonntag von=\""+th.getVonZeiten(6)+"\" bis=\""+th.getBisZeiten(6)+"\" />");
				bw.newLine();
				bw.write("      </Arbeitszeiten>");
				bw.newLine();
				bw.write("      <Pause>"+th.getPausen()+"</Pause>");
				bw.newLine();
				bw.write("      <Kommentar>"+entity(th.getKommentar())+"</Kommentar>");
				bw.newLine();
				bw.write("      <PTermin>"+entity(th.getTermine())+"</PTermin>");
				bw.newLine();

				bw.write("    </Therapeut>");
				bw.newLine();
			}
			
			bw.write("  </Therapeuten>");
			bw.newLine();
		}
		
		if(daten.getMaxPatienten() > 0){
			bw.write("  <Patienten>");
			bw.newLine();
			
			for(int i =0; i < daten.getMaxPatienten(); i++){
				daten.setStatusBar(z++, ""+z*100/maxC+"%");
				p = daten.getPatient(i);
				p.setID(i);
				bw.write("    <Patient Therapeut=\""+p.getTherapeut()+"\" Kasse=\""+p.getKasse()+"\">");
				bw.newLine();
				
				if(p.getHerr()){
					bw.write("      <Herr/>");
					bw.newLine();
				}
				
				bw.write("      <Name>");
				bw.write(entity(p.getNachname()));
				bw.write("</Name>");
				bw.newLine();
				bw.write("      <Vorname>");
				bw.write(entity(p.getVorname()));
				bw.write("</Vorname>");
				bw.newLine();
				bw.write("      <Geburtstag>"+entity(p.getGeburtstag())+"</Geburtstag>");
				bw.newLine();
				bw.write("      <Telefon>"+entity(p.getTelefon())+"</Telefon>");
				bw.newLine();
				bw.write("      <Telefon2>"+entity(p.getTelefon2())+"</Telefon2>");
				bw.newLine();
				bw.write("      <Telefon3>"+entity(p.getTelefon3())+"</Telefon3>");
				bw.newLine();
				//bw.write("      <Kasse>"+p.getKasse()+"</Kasse>");
				//bw.newLine();
				bw.write("      <Kommentar>"+entity(p.getKommentar())+"</Kommentar>");
				bw.newLine();
				bw.write("      <PTermin>"+entity(p.getTermine())+"</PTermin>");
				bw.newLine();
				bw.write("    </Patient>");
				bw.newLine();
			}
			
			bw.write("  </Patienten>");
			bw.newLine();
		}
		
		Date firstDay = daten.getFirstDay();
		Calendar cal = Calendar.getInstance();
		cal.setTime(firstDay);
		year = cal.get(Calendar.YEAR);
		month = cal.get(Calendar.MONTH)+1;
		day = cal.get(Calendar.DAY_OF_MONTH);
		
		Calendar calStripped = Calendar.getInstance();
		calStripped.clear();
		calStripped.set(year, month-1, day);
		logger.finest("Datum: "+day+"."+month+"."+year+"\nSpalte: "+daten.getSpalte(calStripped.getTime()));
		
		bw.write("  <Termine Tag=\""+day+"\" Monat=\""+month+"\" Jahr=\""+year+"\">");
		bw.newLine();
		for(int ta = 0; ta < daten.getMaxTherapeuten(); ta++){
			//Zuerst die Therapeuten durchgehen
			bw.write("    <TherapeutenTermine Therapeut=\""+ta+"\">");
			bw.newLine();
			for(int tag = 0; tag < daten.getMaxTage(); tag++){
				//Dann die Tage
				daten.setStatusBar(z++, ""+z*100/maxC+"%");
				//Setze ID. Wenn Ein Termin mehrere IDs bekommt, dann bleibt die letzte gültig.
				for(int zeit = 0; zeit < 86; zeit++)
					for(int packung = 0; packung < 2; packung++)
						daten.getTermin(tag, zeit, ta, packung).setID(id++);
				for(int zeit = 0; zeit < 86; zeit++){
					/*Die Zeiten
						Es werden nur die Termine übernommen, die
						auch etwas enthalten, also konkret 
						alle Termine ausser KEINEARBEITSZEIT
					*/
					for(int packung = 0; packung < 2; packung++){
						te = daten.getTermin(tag, zeit, ta, packung);
						if(te.getArt() != Termin.KEINEARBEITSZEIT){
							id=te.getID();
							bw.write("        <Termin Spalte=\""+tag+"\" Zeile=\""+zeit+"\" art=\""+entity(Termin.WERTE[te.getArt()])+"\" Packung=\""+packung+"\" id=\""+id+"\">");
							switch(te.getArt()){
								case Termin.KURS: 
									bw.newLine();
									bw.write("          <Kursname>"+entity(te.getKurs())+"</Kursname>");
									bw.newLine();
									break;
								case Termin.NOTIZ: 
									bw.newLine();
									bw.write("          <Kurznotiz>"+entity(te.getNotiz())+"</Kurznotiz>");
									bw.newLine();
									bw.write("          <Langnotiz>"+entity(te.getNotizen())+"</Langnotiz>");
									bw.newLine();
									break;
								case Termin.PATIENT: //PatientenID Rezept? 
									bw.newLine();
									bw.write("          <Raum/>");
									bw.newLine();
									int gerat = te.getGeraet();
									if(gerat > 0){
										bw.write("          <Geraet>"+gerat+"</Geraet>");
									  bw.newLine();
									}
									bw.write("          <Therapie>"+entity(te.therapie())+"</Therapie>");
								  bw.newLine();
									bw.write("          <PatientenID>"+te.getPatient().getID()+"</PatientenID>");
									bw.newLine();
									break;
								default: 
									bw.newLine();
							}
							bw.write("        </Termin>");
							bw.newLine();
						}
					}
				}
			}
			bw.write("      </TherapeutenTermine>");
			bw.newLine();
		}
		bw.write("  </Termine>");
		bw.newLine();	

		bw.write("</Physiomat>");
		bw.newLine();

		logger.finest("Letzter Wert: "+z+"/"+maxC);
		//abspann();
		bw.flush();
		fos.flush();
		fos.close();
		logger.finest("Speicherwert: "+z);
		//liederfile.close();
	}




	private void vorspann() throws IOException{
		//bw.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"yes\"?>");
		bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
		bw.newLine();
		bw.write("<!-- Geschrieben von Physiomat " + VERSION + " -->");
		bw.newLine();
		bw.write("<!DOCTYPE Physiomat [");
		bw.newLine();
		bw.write("  <!ELEMENT Physiomat (Ausruestung, Therapeuten?, Patienten?, Termine?)>");bw.newLine();
		bw.write("    <!ATTLIST Physiomat version CDATA #REQUIRED datei CDATA #REQUIRED >");bw.newLine();
		bw.write("    <!ELEMENT Ausruestung (Raeume, Geraete)>");bw.newLine();
		bw.write("      <!ELEMENT Raeume (jetzt, Zukunft)>");bw.newLine();
		bw.write("      <!ELEMENT jetzt (#PCDATA)>");bw.newLine();
		bw.write("      <!ELEMENT Zukunft (#PCDATA)>");bw.newLine();
		bw.write("        <!ATTLIST Zukunft Tag CDATA #REQUIRED Monat CDATA #REQUIRED Jahr CDATA #REQUIRED>");bw.newLine();
		bw.write("      <!ELEMENT Geraete (jetzt, Zukunft)>");bw.newLine();
		bw.write("    <!ELEMENT Therapeuten (Therapeut*)>");bw.newLine();
		bw.write("      <!ELEMENT Therapeut (Name, Vorname, Herr?, Arbeitszeiten, Pause, Kommentar, PTermin)>");bw.newLine();
		bw.write("        <!ELEMENT Name (#PCDATA)>");bw.newLine();
		bw.write("        <!ELEMENT Vorname (#PCDATA)>");bw.newLine();
		bw.write("        <!ELEMENT Herr (#PCDATA)>");bw.newLine();
		bw.write("        <!ELEMENT Kommentar (#PCDATA)>");bw.newLine();
		bw.write("        <!ELEMENT PTermin (#PCDATA)>");bw.newLine();
		bw.write("        <!ELEMENT Arbeitszeiten (Montag, Dienstag, Mittwoch, Donnerstag, Freitag, Sonnabend, Sonntag)>");bw.newLine();
		bw.write("          <!ELEMENT Montag (#PCDATA)>");bw.newLine();
		bw.write("            <!ATTLIST Montag von CDATA #REQUIRED bis CDATA #REQUIRED>");bw.newLine();
		bw.write("          <!ELEMENT Dienstag (#PCDATA)>");bw.newLine();
		bw.write("            <!ATTLIST Dienstag von CDATA #REQUIRED bis CDATA #REQUIRED>");bw.newLine();
		bw.write("          <!ELEMENT Mittwoch (#PCDATA)>");bw.newLine();
		bw.write("            <!ATTLIST Mittwoch von CDATA #REQUIRED bis CDATA #REQUIRED>");bw.newLine();
		bw.write("          <!ELEMENT Donnerstag (#PCDATA)>");bw.newLine();
		bw.write("            <!ATTLIST Donnerstag von CDATA #REQUIRED bis CDATA #REQUIRED>");bw.newLine();
		bw.write("          <!ELEMENT Freitag (#PCDATA)>");bw.newLine();
		bw.write("            <!ATTLIST Freitag von CDATA #REQUIRED bis CDATA #REQUIRED>");bw.newLine();
		bw.write("          <!ELEMENT Sonnabend (#PCDATA)>");bw.newLine();
		bw.write("            <!ATTLIST Sonnabend von CDATA #REQUIRED bis CDATA #REQUIRED>");bw.newLine();
		bw.write("          <!ELEMENT Sonntag (#PCDATA)>");bw.newLine();
		bw.write("            <!ATTLIST Sonntag von CDATA #REQUIRED bis CDATA #REQUIRED>");bw.newLine();
		bw.write("          <!ELEMENT Pause (#PCDATA)>");bw.newLine();
		bw.write("    <!ELEMENT Patienten (Patient*)>");bw.newLine();
		bw.write("      <!ELEMENT Patient (Herr?, Name, Vorname, Geburtstag, Telefon, Telefon2, Telefon3, Kommentar, PTermin)>");bw.newLine();
		bw.write("        <!ATTLIST Patient Therapeut CDATA \"\" Kasse CDATA \"\">");bw.newLine();
		bw.write("        <!ELEMENT Geburtstag (#PCDATA)>");bw.newLine();
		bw.write("        <!ELEMENT Telefon (#PCDATA)>");bw.newLine();
		bw.write("        <!ELEMENT Telefon2 (#PCDATA)>");bw.newLine();
		bw.write("        <!ELEMENT Telefon3 (#PCDATA)>");bw.newLine();
		bw.write("    <!ELEMENT Termine (TherapeutenTermine*)>");bw.newLine();
		bw.write("      <!ATTLIST Termine Tag CDATA #REQUIRED Monat CDATA #REQUIRED Jahr CDATA #REQUIRED>");bw.newLine();
		bw.write("      <!ELEMENT TherapeutenTermine (Termin*)>");bw.newLine();
		bw.write("        <!ATTLIST TherapeutenTermine Therapeut CDATA #REQUIRED>");bw.newLine();
		bw.write("        <!ELEMENT Termin (Raum?, Geraet?, Therapie?, Kursname?, Kurznotiz?, Langnotiz?, PatientenID?)>");bw.newLine();
		bw.write("          <!ATTLIST Termin Spalte CDATA #REQUIRED Zeile CDATA #REQUIRED art CDATA #REQUIRED Packung CDATA #REQUIRED id CDATA #REQUIRED>");bw.newLine();
		bw.write("          <!ELEMENT Raum (#PCDATA)>");bw.newLine();
		bw.write("          <!ELEMENT Geraet (#PCDATA)>");bw.newLine();
		bw.write("          <!ELEMENT Therapie (#PCDATA)>");bw.newLine();
		bw.write("          <!ELEMENT Kursname (#PCDATA)>");bw.newLine();
		bw.write("          <!ELEMENT Kurznotiz (#PCDATA)>");bw.newLine();
		bw.write("          <!ELEMENT Langnotiz (#PCDATA)>");bw.newLine();
		bw.write("          <!ELEMENT PatientenID (#PCDATA)>");bw.newLine();
		bw.write("]>");
		bw.newLine();
	}
	
	private void pfadFinden(){
		int wo = path.lastIndexOf(file.separator);
		if(-1 != wo)
			path = path.substring(0, wo)+file.separator;
	}
	
	private String entity(String input){
		String output = "";
		char c;
		for(int i=0;i<input.length();i++){
			c = input.charAt(i);
			if(c == '<')
				output = output + "&lt;";
			else if(c == '>')
				output = output + "&gt;";
			else if(c == '&')
				output = output + "&amp;";
			else if(c == '\'')
				output = output + "&apos;";
			else if(c == '"')
				output = output + "&quot;";
			else output = output + c;
		}			
		return output;
	}

	public int getPos(){
		return z;
	}
}


